/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.ArrayCacheConst;
import com.sun.marlin.DoubleArrayCache;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinUtils;

final class DoubleArrayCache$Reference {
    final double[] initial;
    private final boolean clean;
    private final DoubleArrayCache cache;

    DoubleArrayCache$Reference(DoubleArrayCache doubleArrayCache, int n2) {
        this.cache = doubleArrayCache;
        this.clean = doubleArrayCache.clean;
        this.initial = DoubleArrayCache.createArray(n2);
        if (MarlinConst.DO_STATS) {
            doubleArrayCache.stats.totalInitial += (long)n2;
        }
    }

    double[] getArray(int n2) {
        if (n2 <= ArrayCacheConst.MAX_ARRAY_SIZE) {
            return this.cache.getCacheBucket(n2).getArray();
        }
        if (MarlinConst.DO_STATS) {
            ++this.cache.stats.oversize;
        }
        if (MarlinConst.DO_LOG_OVERSIZE) {
            MarlinUtils.logInfo(DoubleArrayCache.getLogPrefix(this.clean) + "DoubleArrayCache: getArray[oversize]: length=\t" + n2);
        }
        return DoubleArrayCache.createArray(n2);
    }

    double[] widenArray(double[] dArray, int n2, int n3) {
        int n4 = dArray.length;
        if (MarlinConst.DO_CHECKS && n4 >= n3) {
            return dArray;
        }
        if (MarlinConst.DO_STATS) {
            ++this.cache.stats.resize;
        }
        double[] dArray2 = this.getArray(ArrayCacheConst.getNewSize(n2, n3));
        System.arraycopy(dArray, 0, dArray2, 0, n2);
        this.putArray(dArray, 0, n2);
        if (MarlinConst.DO_LOG_WIDEN_ARRAY) {
            MarlinUtils.logInfo(DoubleArrayCache.getLogPrefix(this.clean) + "DoubleArrayCache: widenArray[" + dArray2.length + "]: usedSize=\t" + n2 + "\tlength=\t" + n4 + "\tneeded length=\t" + n3);
        }
        return dArray2;
    }

    double[] putArray(double[] dArray) {
        return this.putArray(dArray, 0, dArray.length);
    }

    double[] putArray(double[] dArray, int n2, int n3) {
        if (dArray.length <= ArrayCacheConst.MAX_ARRAY_SIZE) {
            if (this.clean && n3 != 0) {
                DoubleArrayCache.fill(dArray, n2, n3, 0.0);
            }
            if (dArray != this.initial) {
                this.cache.getCacheBucket(dArray.length).putArray(dArray);
            }
        }
        return this.initial;
    }
}

