/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.ArrayCacheConst$BucketStats;
import com.sun.marlin.DoubleArrayCache;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinUtils;

final class DoubleArrayCache$Bucket {
    private int tail = 0;
    private final int arraySize;
    private final boolean clean;
    private final double[][] arrays;
    private final ArrayCacheConst$BucketStats stats;

    DoubleArrayCache$Bucket(boolean bl2, int n2, int n3, ArrayCacheConst$BucketStats arrayCacheConst$BucketStats) {
        this.arraySize = n2;
        this.clean = bl2;
        this.stats = arrayCacheConst$BucketStats;
        this.arrays = new double[n3][];
    }

    double[] getArray() {
        if (MarlinConst.DO_STATS) {
            ++this.stats.getOp;
        }
        if (this.tail != 0) {
            double[] dArray = this.arrays[--this.tail];
            this.arrays[this.tail] = null;
            return dArray;
        }
        if (MarlinConst.DO_STATS) {
            ++this.stats.createOp;
        }
        return DoubleArrayCache.createArray(this.arraySize);
    }

    void putArray(double[] dArray) {
        if (MarlinConst.DO_CHECKS && dArray.length != this.arraySize) {
            MarlinUtils.logInfo(DoubleArrayCache.getLogPrefix(this.clean) + "DoubleArrayCache: bad length = " + dArray.length);
            return;
        }
        if (MarlinConst.DO_STATS) {
            ++this.stats.returnOp;
        }
        if (this.arrays.length > this.tail) {
            this.arrays[this.tail++] = dArray;
            if (MarlinConst.DO_STATS) {
                this.stats.updateMaxSize(this.tail);
            }
        } else if (MarlinConst.DO_CHECKS) {
            MarlinUtils.logInfo(DoubleArrayCache.getLogPrefix(this.clean) + "DoubleArrayCache: array capacity exceeded !");
        }
    }
}

