/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.ArrayCacheConst;
import com.sun.marlin.ByteArrayCache;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinUtils;

final class ByteArrayCache$Reference {
    final byte[] initial;
    private final boolean clean;
    private final ByteArrayCache cache;

    ByteArrayCache$Reference(ByteArrayCache byteArrayCache, int n2) {
        this.cache = byteArrayCache;
        this.clean = byteArrayCache.clean;
        this.initial = ByteArrayCache.createArray(n2);
        if (MarlinConst.DO_STATS) {
            byteArrayCache.stats.totalInitial += (long)n2;
        }
    }

    byte[] getArray(int n2) {
        if (n2 <= ArrayCacheConst.MAX_ARRAY_SIZE) {
            return this.cache.getCacheBucket(n2).getArray();
        }
        if (MarlinConst.DO_STATS) {
            ++this.cache.stats.oversize;
        }
        if (MarlinConst.DO_LOG_OVERSIZE) {
            MarlinUtils.logInfo(ByteArrayCache.getLogPrefix(this.clean) + "ByteArrayCache: getArray[oversize]: length=\t" + n2);
        }
        return ByteArrayCache.createArray(n2);
    }

    byte[] widenArray(byte[] byArray, int n2, int n3) {
        int n4 = byArray.length;
        if (MarlinConst.DO_CHECKS && n4 >= n3) {
            return byArray;
        }
        if (MarlinConst.DO_STATS) {
            ++this.cache.stats.resize;
        }
        byte[] byArray2 = this.getArray(ArrayCacheConst.getNewSize(n2, n3));
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        this.putArray(byArray, 0, n2);
        if (MarlinConst.DO_LOG_WIDEN_ARRAY) {
            MarlinUtils.logInfo(ByteArrayCache.getLogPrefix(this.clean) + "ByteArrayCache: widenArray[" + byArray2.length + "]: usedSize=\t" + n2 + "\tlength=\t" + n4 + "\tneeded length=\t" + n3);
        }
        return byArray2;
    }

    byte[] putArray(byte[] byArray) {
        return this.putArray(byArray, 0, byArray.length);
    }

    byte[] putArray(byte[] byArray, int n2, int n3) {
        if (byArray.length <= ArrayCacheConst.MAX_ARRAY_SIZE) {
            if (this.clean && n3 != 0) {
                ByteArrayCache.fill(byArray, n2, n3, (byte)0);
            }
            if (byArray != this.initial) {
                this.cache.getCacheBucket(byArray.length).putArray(byArray);
            }
        }
        return this.initial;
    }
}

