/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.ArrayCacheConst$BucketStats;
import com.sun.marlin.ByteArrayCache;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinUtils;

final class ByteArrayCache$Bucket {
    private int tail = 0;
    private final int arraySize;
    private final boolean clean;
    private final byte[][] arrays;
    private final ArrayCacheConst$BucketStats stats;

    ByteArrayCache$Bucket(boolean bl2, int n2, int n3, ArrayCacheConst$BucketStats arrayCacheConst$BucketStats) {
        this.arraySize = n2;
        this.clean = bl2;
        this.stats = arrayCacheConst$BucketStats;
        this.arrays = new byte[n3][];
    }

    byte[] getArray() {
        if (MarlinConst.DO_STATS) {
            ++this.stats.getOp;
        }
        if (this.tail != 0) {
            byte[] byArray = this.arrays[--this.tail];
            this.arrays[this.tail] = null;
            return byArray;
        }
        if (MarlinConst.DO_STATS) {
            ++this.stats.createOp;
        }
        return ByteArrayCache.createArray(this.arraySize);
    }

    void putArray(byte[] byArray) {
        if (MarlinConst.DO_CHECKS && byArray.length != this.arraySize) {
            MarlinUtils.logInfo(ByteArrayCache.getLogPrefix(this.clean) + "ByteArrayCache: bad length = " + byArray.length);
            return;
        }
        if (MarlinConst.DO_STATS) {
            ++this.stats.returnOp;
        }
        if (this.arrays.length > this.tail) {
            this.arrays[this.tail++] = byArray;
            if (MarlinConst.DO_STATS) {
                this.stats.updateMaxSize(this.tail);
            }
        } else if (MarlinConst.DO_CHECKS) {
            MarlinUtils.logInfo(ByteArrayCache.getLogPrefix(this.clean) + "ByteArrayCache: array capacity exceeded !");
        }
    }
}

