/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.W32Errors;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinDef$DWORD;
import com.sun.jna.platform.win32.WinNT$HRESULT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.util.ArrayList;

public abstract class Kernel32Util
implements WinDef {
    public static String getComputerName() {
        char[] cArray = new char[WinBase.MAX_COMPUTERNAME_LENGTH + 1];
        IntByReference intByReference = new IntByReference(cArray.length);
        if (!Kernel32.INSTANCE.GetComputerName(cArray, intByReference)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return Native.toString(cArray);
    }

    public static String formatMessageFromHR(WinNT$HRESULT winNT$HRESULT) {
        PointerByReference pointerByReference = new PointerByReference();
        if (0 == Kernel32.INSTANCE.FormatMessage(4864, null, winNT$HRESULT.intValue(), 0, pointerByReference, 0, null)) {
            throw new LastErrorException(Kernel32.INSTANCE.GetLastError());
        }
        String string = pointerByReference.getValue().getString(0L, !Boolean.getBoolean("w32.ascii"));
        Kernel32.INSTANCE.LocalFree(pointerByReference.getValue());
        return string.trim();
    }

    public static String formatMessageFromLastErrorCode(int n2) {
        return Kernel32Util.formatMessageFromHR(W32Errors.HRESULT_FROM_WIN32(n2));
    }

    public static String getTempPath() {
        WinDef$DWORD winDef$DWORD = new WinDef$DWORD(260L);
        char[] cArray = new char[winDef$DWORD.intValue()];
        if (Kernel32.INSTANCE.GetTempPath(winDef$DWORD, cArray).intValue() == 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return Native.toString(cArray);
    }

    public static void deleteFile(String string) {
        if (!Kernel32.INSTANCE.DeleteFile(string)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    public static String[] getLogicalDriveStrings() {
        WinDef$DWORD winDef$DWORD = Kernel32.INSTANCE.GetLogicalDriveStrings(new WinDef$DWORD(0L), null);
        if (winDef$DWORD.intValue() <= 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        char[] cArray = new char[winDef$DWORD.intValue()];
        if ((winDef$DWORD = Kernel32.INSTANCE.GetLogicalDriveStrings(winDef$DWORD, cArray)).intValue() <= 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "";
        for (int i2 = 0; i2 < cArray.length - 1; ++i2) {
            if (cArray[i2] == '\u0000') {
                arrayList.add(string);
                string = "";
                continue;
            }
            string = string + cArray[i2];
        }
        return arrayList.toArray(new String[0]);
    }

    public static int getFileAttributes(String string) {
        int n2 = Kernel32.INSTANCE.GetFileAttributes(string);
        if (n2 == -1) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return n2;
    }
}

