/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Advapi32Util$Account;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT$ACCESS_ACEStructure;
import com.sun.jna.platform.win32.WinNT$ACL;
import com.sun.jna.platform.win32.WinNT$HANDLE;
import com.sun.jna.platform.win32.WinNT$HANDLEByReference;
import com.sun.jna.platform.win32.WinNT$PSID;
import com.sun.jna.platform.win32.WinNT$PSIDByReference;
import com.sun.jna.platform.win32.WinNT$SECURITY_DESCRIPTOR_RELATIVE;
import com.sun.jna.platform.win32.WinNT$SID_AND_ATTRIBUTES;
import com.sun.jna.platform.win32.WinNT$TOKEN_GROUPS;
import com.sun.jna.platform.win32.WinNT$TOKEN_USER;
import com.sun.jna.platform.win32.WinReg;
import com.sun.jna.platform.win32.WinReg$HKEYByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.PointerByReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Advapi32Util {
    public static String getUserName() {
        char[] cArray = new char[128];
        IntByReference intByReference = new IntByReference(cArray.length);
        boolean bl2 = Advapi32.INSTANCE.GetUserNameW(cArray, intByReference);
        if (!bl2) {
            switch (Kernel32.INSTANCE.GetLastError()) {
                case 122: {
                    cArray = new char[intByReference.getValue()];
                    break;
                }
                default: {
                    throw new Win32Exception(Native.getLastError());
                }
            }
            bl2 = Advapi32.INSTANCE.GetUserNameW(cArray, intByReference);
        }
        if (!bl2) {
            throw new Win32Exception(Native.getLastError());
        }
        return Native.toString(cArray);
    }

    public static Advapi32Util$Account getAccountByName(String string) {
        return Advapi32Util.getAccountByName(null, string);
    }

    public static Advapi32Util$Account getAccountByName(String string, String string2) {
        char[] cArray;
        IntByReference intByReference = new IntByReference(0);
        IntByReference intByReference2 = new IntByReference(0);
        PointerByReference pointerByReference = new PointerByReference();
        if (Advapi32.INSTANCE.LookupAccountName(string, string2, null, intByReference, null, intByReference2, pointerByReference)) {
            throw new RuntimeException("LookupAccountNameW was expected to fail with ERROR_INSUFFICIENT_BUFFER");
        }
        int n2 = Kernel32.INSTANCE.GetLastError();
        if (intByReference.getValue() == 0 || n2 != 122) {
            throw new Win32Exception(n2);
        }
        Memory memory = new Memory(intByReference.getValue());
        WinNT$PSID winNT$PSID = new WinNT$PSID(memory);
        if (!Advapi32.INSTANCE.LookupAccountName(string, string2, winNT$PSID, intByReference, cArray = new char[intByReference2.getValue() + 1], intByReference2, pointerByReference)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        Advapi32Util$Account advapi32Util$Account = new Advapi32Util$Account();
        advapi32Util$Account.accountType = pointerByReference.getPointer().getInt(0L);
        advapi32Util$Account.name = string2;
        String[] stringArray = string2.split("\\\\", 2);
        String[] stringArray2 = string2.split("@", 2);
        advapi32Util$Account.name = stringArray.length == 2 ? stringArray[1] : (stringArray2.length == 2 ? stringArray2[0] : string2);
        if (intByReference2.getValue() > 0) {
            advapi32Util$Account.domain = Native.toString(cArray);
            advapi32Util$Account.fqn = advapi32Util$Account.domain + "\\" + advapi32Util$Account.name;
        } else {
            advapi32Util$Account.fqn = advapi32Util$Account.name;
        }
        advapi32Util$Account.sid = winNT$PSID.getBytes();
        advapi32Util$Account.sidString = Advapi32Util.convertSidToStringSid(new WinNT$PSID(advapi32Util$Account.sid));
        return advapi32Util$Account;
    }

    public static Advapi32Util$Account getAccountBySid(WinNT$PSID winNT$PSID) {
        return Advapi32Util.getAccountBySid(null, winNT$PSID);
    }

    public static Advapi32Util$Account getAccountBySid(String string, WinNT$PSID winNT$PSID) {
        IntByReference intByReference = new IntByReference();
        IntByReference intByReference2 = new IntByReference();
        PointerByReference pointerByReference = new PointerByReference();
        if (Advapi32.INSTANCE.LookupAccountSid(null, winNT$PSID, null, intByReference, null, intByReference2, pointerByReference)) {
            throw new RuntimeException("LookupAccountSidW was expected to fail with ERROR_INSUFFICIENT_BUFFER");
        }
        int n2 = Kernel32.INSTANCE.GetLastError();
        if (intByReference.getValue() == 0 || n2 != 122) {
            throw new Win32Exception(n2);
        }
        char[] cArray = new char[intByReference2.getValue()];
        char[] cArray2 = new char[intByReference.getValue()];
        if (!Advapi32.INSTANCE.LookupAccountSid(null, winNT$PSID, cArray2, intByReference, cArray, intByReference2, pointerByReference)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        Advapi32Util$Account advapi32Util$Account = new Advapi32Util$Account();
        advapi32Util$Account.accountType = pointerByReference.getPointer().getInt(0L);
        advapi32Util$Account.name = Native.toString(cArray2);
        if (intByReference2.getValue() > 0) {
            advapi32Util$Account.domain = Native.toString(cArray);
            advapi32Util$Account.fqn = advapi32Util$Account.domain + "\\" + advapi32Util$Account.name;
        } else {
            advapi32Util$Account.fqn = advapi32Util$Account.name;
        }
        advapi32Util$Account.sid = winNT$PSID.getBytes();
        advapi32Util$Account.sidString = Advapi32Util.convertSidToStringSid(winNT$PSID);
        return advapi32Util$Account;
    }

    public static String convertSidToStringSid(WinNT$PSID winNT$PSID) {
        PointerByReference pointerByReference = new PointerByReference();
        if (!Advapi32.INSTANCE.ConvertSidToStringSid(winNT$PSID, pointerByReference)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        String string = pointerByReference.getValue().getString(0L, true);
        Kernel32.INSTANCE.LocalFree(pointerByReference.getValue());
        return string;
    }

    public static byte[] convertStringSidToSid(String string) {
        WinNT$PSIDByReference winNT$PSIDByReference = new WinNT$PSIDByReference();
        if (!Advapi32.INSTANCE.ConvertStringSidToSid(string, winNT$PSIDByReference)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return winNT$PSIDByReference.getValue().getBytes();
    }

    public static boolean isWellKnownSid(String string, int n2) {
        WinNT$PSIDByReference winNT$PSIDByReference = new WinNT$PSIDByReference();
        if (!Advapi32.INSTANCE.ConvertStringSidToSid(string, winNT$PSIDByReference)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return Advapi32.INSTANCE.IsWellKnownSid(winNT$PSIDByReference.getValue(), n2);
    }

    public static boolean isWellKnownSid(byte[] byArray, int n2) {
        WinNT$PSID winNT$PSID = new WinNT$PSID(byArray);
        return Advapi32.INSTANCE.IsWellKnownSid(winNT$PSID, n2);
    }

    public static Advapi32Util$Account getAccountBySid(String string) {
        return Advapi32Util.getAccountBySid(null, string);
    }

    public static Advapi32Util$Account getAccountBySid(String string, String string2) {
        return Advapi32Util.getAccountBySid(string, new WinNT$PSID(Advapi32Util.convertStringSidToSid(string2)));
    }

    public static Advapi32Util$Account[] getTokenGroups(WinNT$HANDLE winNT$HANDLE) {
        IntByReference intByReference = new IntByReference();
        if (Advapi32.INSTANCE.GetTokenInformation(winNT$HANDLE, 2, null, 0, intByReference)) {
            throw new RuntimeException("Expected GetTokenInformation to fail with ERROR_INSUFFICIENT_BUFFER");
        }
        int n2 = Kernel32.INSTANCE.GetLastError();
        if (n2 != 122) {
            throw new Win32Exception(n2);
        }
        WinNT$TOKEN_GROUPS winNT$TOKEN_GROUPS = new WinNT$TOKEN_GROUPS(intByReference.getValue());
        if (!Advapi32.INSTANCE.GetTokenInformation(winNT$HANDLE, 2, winNT$TOKEN_GROUPS, intByReference.getValue(), intByReference)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        ArrayList<Advapi32Util$Account> arrayList = new ArrayList<Advapi32Util$Account>();
        for (WinNT$SID_AND_ATTRIBUTES winNT$SID_AND_ATTRIBUTES : winNT$TOKEN_GROUPS.getGroups()) {
            Advapi32Util$Account advapi32Util$Account = null;
            try {
                advapi32Util$Account = Advapi32Util.getAccountBySid(winNT$SID_AND_ATTRIBUTES.Sid);
            }
            catch (Exception exception) {
                advapi32Util$Account = new Advapi32Util$Account();
                advapi32Util$Account.sid = winNT$SID_AND_ATTRIBUTES.Sid.getBytes();
                advapi32Util$Account.name = advapi32Util$Account.sidString = Advapi32Util.convertSidToStringSid(winNT$SID_AND_ATTRIBUTES.Sid);
                advapi32Util$Account.fqn = advapi32Util$Account.sidString;
                advapi32Util$Account.accountType = 2;
            }
            arrayList.add(advapi32Util$Account);
        }
        return arrayList.toArray(new Advapi32Util$Account[0]);
    }

    public static Advapi32Util$Account getTokenAccount(WinNT$HANDLE winNT$HANDLE) {
        IntByReference intByReference = new IntByReference();
        if (Advapi32.INSTANCE.GetTokenInformation(winNT$HANDLE, 1, null, 0, intByReference)) {
            throw new RuntimeException("Expected GetTokenInformation to fail with ERROR_INSUFFICIENT_BUFFER");
        }
        int n2 = Kernel32.INSTANCE.GetLastError();
        if (n2 != 122) {
            throw new Win32Exception(n2);
        }
        WinNT$TOKEN_USER winNT$TOKEN_USER = new WinNT$TOKEN_USER(intByReference.getValue());
        if (!Advapi32.INSTANCE.GetTokenInformation(winNT$HANDLE, 1, winNT$TOKEN_USER, intByReference.getValue(), intByReference)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return Advapi32Util.getAccountBySid(winNT$TOKEN_USER.User.Sid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Advapi32Util$Account[] getCurrentUserGroups() {
        WinNT$HANDLEByReference winNT$HANDLEByReference = new WinNT$HANDLEByReference();
        try {
            Object object;
            WinNT$HANDLE winNT$HANDLE = Kernel32.INSTANCE.GetCurrentThread();
            if (!Advapi32.INSTANCE.OpenThreadToken(winNT$HANDLE, 10, true, winNT$HANDLEByReference)) {
                if (1008 != Kernel32.INSTANCE.GetLastError()) {
                    throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                }
                object = Kernel32.INSTANCE.GetCurrentProcess();
                if (!Advapi32.INSTANCE.OpenProcessToken((WinNT$HANDLE)object, 10, winNT$HANDLEByReference)) {
                    throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                }
            }
            object = Advapi32Util.getTokenGroups(winNT$HANDLEByReference.getValue());
            return object;
        }
        finally {
            if (winNT$HANDLEByReference.getValue() != WinBase.INVALID_HANDLE_VALUE && !Kernel32.INSTANCE.CloseHandle(winNT$HANDLEByReference.getValue())) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
        }
    }

    public static boolean registryKeyExists(WinReg.HKEY hKEY, String string) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n2 = Advapi32.INSTANCE.RegOpenKeyEx(hKEY, string, 0, 131097, winReg$HKEYByReference);
        switch (n2) {
            case 0: {
                Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new Win32Exception(n2);
    }

    public static boolean registryValueExists(WinReg.HKEY hKEY, String string, String string2) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n2 = Advapi32.INSTANCE.RegOpenKeyEx(hKEY, string, 0, 131097, winReg$HKEYByReference);
        try {
            switch (n2) {
                case 0: {
                    break;
                }
                case 2: {
                    boolean bl2 = false;
                    return bl2;
                }
                default: {
                    throw new Win32Exception(n2);
                }
            }
            IntByReference intByReference = new IntByReference();
            IntByReference intByReference2 = new IntByReference();
            n2 = Advapi32.INSTANCE.RegQueryValueEx(winReg$HKEYByReference.getValue(), string2, 0, intByReference2, (char[])null, intByReference);
            switch (n2) {
                case 0: 
                case 122: {
                    boolean bl3 = true;
                    return bl3;
                }
                case 2: {
                    boolean bl4 = false;
                    return bl4;
                }
            }
            throw new Win32Exception(n2);
        }
        finally {
            if (winReg$HKEYByReference.getValue() != WinBase.INVALID_HANDLE_VALUE && (n2 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue())) != 0) {
                throw new Win32Exception(n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String registryGetStringValue(WinReg.HKEY hKEY, String string, String string2) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n2 = Advapi32.INSTANCE.RegOpenKeyEx(hKEY, string, 0, 131097, winReg$HKEYByReference);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        try {
            IntByReference intByReference = new IntByReference();
            IntByReference intByReference2 = new IntByReference();
            n2 = Advapi32.INSTANCE.RegQueryValueEx(winReg$HKEYByReference.getValue(), string2, 0, intByReference2, (char[])null, intByReference);
            if (n2 != 0 && n2 != 122) {
                throw new Win32Exception(n2);
            }
            if (intByReference2.getValue() != 1 && intByReference2.getValue() != 2) {
                throw new RuntimeException("Unexpected registry type " + intByReference2.getValue() + ", expected REG_SZ or REG_EXPAND_SZ");
            }
            char[] cArray = new char[intByReference.getValue()];
            n2 = Advapi32.INSTANCE.RegQueryValueEx(winReg$HKEYByReference.getValue(), string2, 0, intByReference2, cArray, intByReference);
            if (n2 != 0 && n2 != 122) {
                throw new Win32Exception(n2);
            }
            String string3 = Native.toString(cArray);
            return string3;
        }
        finally {
            n2 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n2 != 0) {
                throw new Win32Exception(n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String registryGetExpandableStringValue(WinReg.HKEY hKEY, String string, String string2) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n2 = Advapi32.INSTANCE.RegOpenKeyEx(hKEY, string, 0, 131097, winReg$HKEYByReference);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        try {
            IntByReference intByReference = new IntByReference();
            IntByReference intByReference2 = new IntByReference();
            n2 = Advapi32.INSTANCE.RegQueryValueEx(winReg$HKEYByReference.getValue(), string2, 0, intByReference2, (char[])null, intByReference);
            if (n2 != 0 && n2 != 122) {
                throw new Win32Exception(n2);
            }
            if (intByReference2.getValue() != 2) {
                throw new RuntimeException("Unexpected registry type " + intByReference2.getValue() + ", expected REG_SZ");
            }
            char[] cArray = new char[intByReference.getValue()];
            n2 = Advapi32.INSTANCE.RegQueryValueEx(winReg$HKEYByReference.getValue(), string2, 0, intByReference2, cArray, intByReference);
            if (n2 != 0 && n2 != 122) {
                throw new Win32Exception(n2);
            }
            String string3 = Native.toString(cArray);
            return string3;
        }
        finally {
            n2 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n2 != 0) {
                throw new Win32Exception(n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] registryGetStringArray(WinReg.HKEY hKEY, String string, String string2) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n2 = Advapi32.INSTANCE.RegOpenKeyEx(hKEY, string, 0, 131097, winReg$HKEYByReference);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        try {
            String[] stringArray;
            IntByReference intByReference = new IntByReference();
            IntByReference intByReference2 = new IntByReference();
            n2 = Advapi32.INSTANCE.RegQueryValueEx(winReg$HKEYByReference.getValue(), string2, 0, intByReference2, (char[])null, intByReference);
            if (n2 != 0 && n2 != 122) {
                throw new Win32Exception(n2);
            }
            if (intByReference2.getValue() != 7) {
                throw new RuntimeException("Unexpected registry type " + intByReference2.getValue() + ", expected REG_SZ");
            }
            Memory memory = new Memory(intByReference.getValue());
            n2 = Advapi32.INSTANCE.RegQueryValueEx(winReg$HKEYByReference.getValue(), string2, 0, intByReference2, memory, intByReference);
            if (n2 != 0 && n2 != 122) {
                throw new Win32Exception(n2);
            }
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            int n3 = 0;
            while ((long)n3 < memory.size()) {
                stringArray = memory.getString((long)n3, true);
                n3 += stringArray.length() * Native.WCHAR_SIZE;
                n3 += Native.WCHAR_SIZE;
                arrayList.add(stringArray);
            }
            stringArray = arrayList.toArray(new String[0]);
            return stringArray;
        }
        finally {
            n2 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n2 != 0) {
                throw new Win32Exception(n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] registryGetBinaryValue(WinReg.HKEY hKEY, String string, String string2) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n2 = Advapi32.INSTANCE.RegOpenKeyEx(hKEY, string, 0, 131097, winReg$HKEYByReference);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        try {
            IntByReference intByReference = new IntByReference();
            IntByReference intByReference2 = new IntByReference();
            n2 = Advapi32.INSTANCE.RegQueryValueEx(winReg$HKEYByReference.getValue(), string2, 0, intByReference2, (char[])null, intByReference);
            if (n2 != 0 && n2 != 122) {
                throw new Win32Exception(n2);
            }
            if (intByReference2.getValue() != 3) {
                throw new RuntimeException("Unexpected registry type " + intByReference2.getValue() + ", expected REG_BINARY");
            }
            byte[] byArray = new byte[intByReference.getValue()];
            n2 = Advapi32.INSTANCE.RegQueryValueEx(winReg$HKEYByReference.getValue(), string2, 0, intByReference2, byArray, intByReference);
            if (n2 != 0 && n2 != 122) {
                throw new Win32Exception(n2);
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            n2 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n2 != 0) {
                throw new Win32Exception(n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int registryGetIntValue(WinReg.HKEY hKEY, String string, String string2) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n2 = Advapi32.INSTANCE.RegOpenKeyEx(hKEY, string, 0, 131097, winReg$HKEYByReference);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        try {
            IntByReference intByReference = new IntByReference();
            IntByReference intByReference2 = new IntByReference();
            n2 = Advapi32.INSTANCE.RegQueryValueEx(winReg$HKEYByReference.getValue(), string2, 0, intByReference2, (char[])null, intByReference);
            if (n2 != 0 && n2 != 122) {
                throw new Win32Exception(n2);
            }
            if (intByReference2.getValue() != 4) {
                throw new RuntimeException("Unexpected registry type " + intByReference2.getValue() + ", expected REG_DWORD");
            }
            IntByReference intByReference3 = new IntByReference();
            n2 = Advapi32.INSTANCE.RegQueryValueEx(winReg$HKEYByReference.getValue(), string2, 0, intByReference2, intByReference3, intByReference);
            if (n2 != 0 && n2 != 122) {
                throw new Win32Exception(n2);
            }
            int n3 = intByReference3.getValue();
            return n3;
        }
        finally {
            n2 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n2 != 0) {
                throw new Win32Exception(n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long registryGetLongValue(WinReg.HKEY hKEY, String string, String string2) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n2 = Advapi32.INSTANCE.RegOpenKeyEx(hKEY, string, 0, 131097, winReg$HKEYByReference);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        try {
            IntByReference intByReference = new IntByReference();
            IntByReference intByReference2 = new IntByReference();
            n2 = Advapi32.INSTANCE.RegQueryValueEx(winReg$HKEYByReference.getValue(), string2, 0, intByReference2, (char[])null, intByReference);
            if (n2 != 0 && n2 != 122) {
                throw new Win32Exception(n2);
            }
            if (intByReference2.getValue() != 11) {
                throw new RuntimeException("Unexpected registry type " + intByReference2.getValue() + ", expected REG_QWORD");
            }
            LongByReference longByReference = new LongByReference();
            n2 = Advapi32.INSTANCE.RegQueryValueEx(winReg$HKEYByReference.getValue(), string2, 0, intByReference2, longByReference, intByReference);
            if (n2 != 0 && n2 != 122) {
                throw new Win32Exception(n2);
            }
            long l2 = longByReference.getValue();
            return l2;
        }
        finally {
            n2 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n2 != 0) {
                throw new Win32Exception(n2);
            }
        }
    }

    public static boolean registryCreateKey(WinReg.HKEY hKEY, String string) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        IntByReference intByReference = new IntByReference();
        int n2 = Advapi32.INSTANCE.RegCreateKeyEx(hKEY, string, 0, null, 0, 131097, null, winReg$HKEYByReference, intByReference);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        n2 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        return 1 == intByReference.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean registryCreateKey(WinReg.HKEY hKEY, String string, String string2) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n2 = Advapi32.INSTANCE.RegOpenKeyEx(hKEY, string, 0, 4, winReg$HKEYByReference);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        try {
            boolean bl2 = Advapi32Util.registryCreateKey(winReg$HKEYByReference.getValue(), string2);
            return bl2;
        }
        finally {
            n2 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n2 != 0) {
                throw new Win32Exception(n2);
            }
        }
    }

    public static void registrySetIntValue(WinReg.HKEY hKEY, String string, int n2) {
        byte[] byArray = new byte[]{(byte)(n2 & 0xFF), (byte)(n2 >> 8 & 0xFF), (byte)(n2 >> 16 & 0xFF), (byte)(n2 >> 24 & 0xFF)};
        int n3 = Advapi32.INSTANCE.RegSetValueEx(hKEY, string, 0, 4, byArray, 4);
        if (n3 != 0) {
            throw new Win32Exception(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registrySetIntValue(WinReg.HKEY hKEY, String string, String string2, int n2) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n3 = Advapi32.INSTANCE.RegOpenKeyEx(hKEY, string, 0, 131103, winReg$HKEYByReference);
        if (n3 != 0) {
            throw new Win32Exception(n3);
        }
        try {
            Advapi32Util.registrySetIntValue(winReg$HKEYByReference.getValue(), string2, n2);
        }
        finally {
            n3 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n3 != 0) {
                throw new Win32Exception(n3);
            }
        }
    }

    public static void registrySetLongValue(WinReg.HKEY hKEY, String string, long l2) {
        byte[] byArray = new byte[]{(byte)(l2 & 0xFFL), (byte)(l2 >> 8 & 0xFFL), (byte)(l2 >> 16 & 0xFFL), (byte)(l2 >> 24 & 0xFFL), (byte)(l2 >> 32 & 0xFFL), (byte)(l2 >> 40 & 0xFFL), (byte)(l2 >> 48 & 0xFFL), (byte)(l2 >> 56 & 0xFFL)};
        int n2 = Advapi32.INSTANCE.RegSetValueEx(hKEY, string, 0, 11, byArray, 8);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registrySetLongValue(WinReg.HKEY hKEY, String string, String string2, long l2) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n2 = Advapi32.INSTANCE.RegOpenKeyEx(hKEY, string, 0, 131103, winReg$HKEYByReference);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        try {
            Advapi32Util.registrySetLongValue(winReg$HKEYByReference.getValue(), string2, l2);
        }
        finally {
            n2 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n2 != 0) {
                throw new Win32Exception(n2);
            }
        }
    }

    public static void registrySetStringValue(WinReg.HKEY hKEY, String string, String string2) {
        char[] cArray = Native.toCharArray(string2);
        int n2 = Advapi32.INSTANCE.RegSetValueEx(hKEY, string, 0, 1, cArray, cArray.length * Native.WCHAR_SIZE);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registrySetStringValue(WinReg.HKEY hKEY, String string, String string2, String string3) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n2 = Advapi32.INSTANCE.RegOpenKeyEx(hKEY, string, 0, 131103, winReg$HKEYByReference);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        try {
            Advapi32Util.registrySetStringValue(winReg$HKEYByReference.getValue(), string2, string3);
        }
        finally {
            n2 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n2 != 0) {
                throw new Win32Exception(n2);
            }
        }
    }

    public static void registrySetExpandableStringValue(WinReg.HKEY hKEY, String string, String string2) {
        char[] cArray = Native.toCharArray(string2);
        int n2 = Advapi32.INSTANCE.RegSetValueEx(hKEY, string, 0, 2, cArray, cArray.length * Native.WCHAR_SIZE);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registrySetExpandableStringValue(WinReg.HKEY hKEY, String string, String string2, String string3) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n2 = Advapi32.INSTANCE.RegOpenKeyEx(hKEY, string, 0, 131103, winReg$HKEYByReference);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        try {
            Advapi32Util.registrySetExpandableStringValue(winReg$HKEYByReference.getValue(), string2, string3);
        }
        finally {
            n2 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n2 != 0) {
                throw new Win32Exception(n2);
            }
        }
    }

    public static void registrySetStringArray(WinReg.HKEY hKEY, String string, String[] stringArray) {
        int n2 = 0;
        for (String string2 : stringArray) {
            n2 += string2.length() * Native.WCHAR_SIZE;
            n2 += Native.WCHAR_SIZE;
        }
        int n3 = 0;
        Memory memory = new Memory(n2);
        for (String string3 : stringArray) {
            memory.setString((long)n3, string3, true);
            n3 += string3.length() * Native.WCHAR_SIZE;
            n3 += Native.WCHAR_SIZE;
        }
        int n4 = Advapi32.INSTANCE.RegSetValueEx(hKEY, string, 0, 7, memory.getByteArray(0L, n2), n2);
        if (n4 != 0) {
            throw new Win32Exception(n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registrySetStringArray(WinReg.HKEY hKEY, String string, String string2, String[] stringArray) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n2 = Advapi32.INSTANCE.RegOpenKeyEx(hKEY, string, 0, 131103, winReg$HKEYByReference);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        try {
            Advapi32Util.registrySetStringArray(winReg$HKEYByReference.getValue(), string2, stringArray);
        }
        finally {
            n2 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n2 != 0) {
                throw new Win32Exception(n2);
            }
        }
    }

    public static void registrySetBinaryValue(WinReg.HKEY hKEY, String string, byte[] byArray) {
        int n2 = Advapi32.INSTANCE.RegSetValueEx(hKEY, string, 0, 3, byArray, byArray.length);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registrySetBinaryValue(WinReg.HKEY hKEY, String string, String string2, byte[] byArray) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n2 = Advapi32.INSTANCE.RegOpenKeyEx(hKEY, string, 0, 131103, winReg$HKEYByReference);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        try {
            Advapi32Util.registrySetBinaryValue(winReg$HKEYByReference.getValue(), string2, byArray);
        }
        finally {
            n2 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n2 != 0) {
                throw new Win32Exception(n2);
            }
        }
    }

    public static void registryDeleteKey(WinReg.HKEY hKEY, String string) {
        int n2 = Advapi32.INSTANCE.RegDeleteKey(hKEY, string);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registryDeleteKey(WinReg.HKEY hKEY, String string, String string2) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n2 = Advapi32.INSTANCE.RegOpenKeyEx(hKEY, string, 0, 131103, winReg$HKEYByReference);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        try {
            Advapi32Util.registryDeleteKey(winReg$HKEYByReference.getValue(), string2);
        }
        finally {
            n2 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n2 != 0) {
                throw new Win32Exception(n2);
            }
        }
    }

    public static void registryDeleteValue(WinReg.HKEY hKEY, String string) {
        int n2 = Advapi32.INSTANCE.RegDeleteValue(hKEY, string);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registryDeleteValue(WinReg.HKEY hKEY, String string, String string2) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n2 = Advapi32.INSTANCE.RegOpenKeyEx(hKEY, string, 0, 131103, winReg$HKEYByReference);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        try {
            Advapi32Util.registryDeleteValue(winReg$HKEYByReference.getValue(), string2);
        }
        finally {
            n2 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n2 != 0) {
                throw new Win32Exception(n2);
            }
        }
    }

    public static String[] registryGetKeys(WinReg.HKEY hKEY) {
        IntByReference intByReference = new IntByReference();
        IntByReference intByReference2 = new IntByReference();
        int n2 = Advapi32.INSTANCE.RegQueryInfoKey(hKEY, null, null, null, intByReference, intByReference2, null, null, null, null, null, null);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        ArrayList<String> arrayList = new ArrayList<String>(intByReference.getValue());
        char[] cArray = new char[intByReference2.getValue() + 1];
        for (int i2 = 0; i2 < intByReference.getValue(); ++i2) {
            IntByReference intByReference3 = new IntByReference(intByReference2.getValue() + 1);
            n2 = Advapi32.INSTANCE.RegEnumKeyEx(hKEY, i2, cArray, intByReference3, null, null, null, null);
            if (n2 != 0) {
                throw new Win32Exception(n2);
            }
            arrayList.add(Native.toString(cArray));
        }
        return arrayList.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] registryGetKeys(WinReg.HKEY hKEY, String string) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n2 = Advapi32.INSTANCE.RegOpenKeyEx(hKEY, string, 0, 131097, winReg$HKEYByReference);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        try {
            String[] stringArray = Advapi32Util.registryGetKeys(winReg$HKEYByReference.getValue());
            return stringArray;
        }
        finally {
            n2 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n2 != 0) {
                throw new Win32Exception(n2);
            }
        }
    }

    public static TreeMap<String, Object> registryGetValues(WinReg.HKEY hKEY) {
        IntByReference intByReference = new IntByReference();
        IntByReference intByReference2 = new IntByReference();
        IntByReference intByReference3 = new IntByReference();
        int n2 = Advapi32.INSTANCE.RegQueryInfoKey(hKEY, null, null, null, null, null, null, intByReference, intByReference2, intByReference3, null, null);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        char[] cArray = new char[intByReference2.getValue() + 1];
        byte[] byArray = new byte[intByReference3.getValue()];
        block7: for (int i2 = 0; i2 < intByReference.getValue(); ++i2) {
            IntByReference intByReference4;
            IntByReference intByReference5;
            IntByReference intByReference6 = new IntByReference(intByReference2.getValue() + 1);
            n2 = Advapi32.INSTANCE.RegEnumValue(hKEY, i2, cArray, intByReference6, null, intByReference5 = new IntByReference(), byArray, intByReference4 = new IntByReference(intByReference3.getValue()));
            if (n2 != 0) {
                throw new Win32Exception(n2);
            }
            String string = Native.toString(cArray);
            Memory memory = new Memory(intByReference4.getValue());
            memory.write(0L, byArray, 0, intByReference4.getValue());
            switch (intByReference5.getValue()) {
                case 11: {
                    treeMap.put(string, memory.getLong(0L));
                    continue block7;
                }
                case 4: {
                    treeMap.put(string, memory.getInt(0L));
                    continue block7;
                }
                case 1: 
                case 2: {
                    treeMap.put(string, memory.getString(0L, true));
                    continue block7;
                }
                case 3: {
                    treeMap.put(string, memory.getByteArray(0L, intByReference4.getValue()));
                    continue block7;
                }
                case 7: {
                    Memory memory2 = new Memory(intByReference4.getValue());
                    memory2.write(0L, byArray, 0, intByReference4.getValue());
                    ArrayList<String> arrayList = new ArrayList<String>();
                    int n3 = 0;
                    while ((long)n3 < memory2.size()) {
                        String string2 = memory2.getString((long)n3, true);
                        n3 += string2.length() * Native.WCHAR_SIZE;
                        n3 += Native.WCHAR_SIZE;
                        arrayList.add(string2);
                    }
                    treeMap.put(string, arrayList.toArray(new String[0]));
                    continue block7;
                }
                default: {
                    throw new RuntimeException("Unsupported type: " + intByReference5.getValue());
                }
            }
        }
        return treeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TreeMap<String, Object> registryGetValues(WinReg.HKEY hKEY, String string) {
        WinReg$HKEYByReference winReg$HKEYByReference = new WinReg$HKEYByReference();
        int n2 = Advapi32.INSTANCE.RegOpenKeyEx(hKEY, string, 0, 131097, winReg$HKEYByReference);
        if (n2 != 0) {
            throw new Win32Exception(n2);
        }
        try {
            TreeMap<String, Object> treeMap = Advapi32Util.registryGetValues(winReg$HKEYByReference.getValue());
            return treeMap;
        }
        finally {
            n2 = Advapi32.INSTANCE.RegCloseKey(winReg$HKEYByReference.getValue());
            if (n2 != 0) {
                throw new Win32Exception(n2);
            }
        }
    }

    public static String getEnvironmentBlock(Map<String, String> map) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            stringBuffer.append(entry.getKey() + "=" + entry.getValue() + "\u0000");
        }
        return stringBuffer.toString() + "\u0000";
    }

    public static WinNT$ACCESS_ACEStructure[] getFileSecurity(String string, boolean bl2) {
        Object object;
        int n2 = 4;
        int n3 = 1024;
        boolean bl3 = false;
        Memory memory = null;
        do {
            int n4;
            bl3 = false;
            memory = new Memory(n3);
            object = new IntByReference();
            boolean bl4 = Advapi32.INSTANCE.GetFileSecurity(new WString(string), n2, memory, n3, (IntByReference)object);
            if (!bl4) {
                n4 = Kernel32.INSTANCE.GetLastError();
                memory.clear();
                if (122 != n4) {
                    throw new Win32Exception(n4);
                }
            }
            if (n3 >= (n4 = ((IntByReference)object).getValue())) continue;
            bl3 = true;
            n3 = n4;
            memory.clear();
        } while (bl3);
        object = new WinNT$SECURITY_DESCRIPTOR_RELATIVE(memory);
        memory.clear();
        WinNT$ACL winNT$ACL = ((WinNT$SECURITY_DESCRIPTOR_RELATIVE)object).getDiscretionaryACL();
        WinNT$ACCESS_ACEStructure[] winNT$ACCESS_ACEStructureArray = winNT$ACL.getACEStructures();
        if (bl2) {
            HashMap<String, WinNT$ACCESS_ACEStructure> hashMap = new HashMap<String, WinNT$ACCESS_ACEStructure>();
            for (WinNT$ACCESS_ACEStructure winNT$ACCESS_ACEStructure : winNT$ACCESS_ACEStructureArray) {
                boolean bl5 = (winNT$ACCESS_ACEStructure.AceFlags & 0x1F) != 0;
                String string2 = winNT$ACCESS_ACEStructure.getSidString() + "/" + bl5 + "/" + winNT$ACCESS_ACEStructure.getClass().getName();
                WinNT$ACCESS_ACEStructure winNT$ACCESS_ACEStructure2 = (WinNT$ACCESS_ACEStructure)hashMap.get(string2);
                if (winNT$ACCESS_ACEStructure2 != null) {
                    int n5 = winNT$ACCESS_ACEStructure2.Mask;
                    winNT$ACCESS_ACEStructure2.Mask = n5 |= winNT$ACCESS_ACEStructure.Mask;
                    continue;
                }
                hashMap.put(string2, winNT$ACCESS_ACEStructure);
            }
            return hashMap.values().toArray(new WinNT$ACCESS_ACEStructure[hashMap.size()]);
        }
        return winNT$ACCESS_ACEStructureArray;
    }
}

