/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform;

import com.sun.jna.Native;
import com.sun.jna.platform.RasterRangesUtils;
import com.sun.jna.platform.WindowUtils$1;
import com.sun.jna.platform.WindowUtils$NativeWindowUtils;
import com.sun.jna.platform.WindowUtils$W32WindowUtils$1;
import com.sun.jna.platform.WindowUtils$W32WindowUtils$2;
import com.sun.jna.platform.WindowUtils$W32WindowUtils$3;
import com.sun.jna.platform.WindowUtils$W32WindowUtils$4;
import com.sun.jna.platform.win32.GDI32;
import com.sun.jna.platform.win32.WinDef$HRGN;
import com.sun.jna.platform.win32.WinDef$HWND;
import com.sun.jna.platform.win32.WinUser$POINT;
import java.awt.Component;
import java.awt.Shape;
import java.awt.Window;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.image.Raster;
import java.util.ArrayList;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;

class WindowUtils$W32WindowUtils
extends WindowUtils$NativeWindowUtils {
    private WindowUtils$W32WindowUtils() {
    }

    private WinDef$HWND getHWnd(Component component) {
        WinDef$HWND winDef$HWND = new WinDef$HWND();
        winDef$HWND.setPointer(Native.getComponentPointer(component));
        return winDef$HWND;
    }

    public boolean isWindowAlphaSupported() {
        return Boolean.getBoolean("sun.java2d.noddraw");
    }

    private boolean usingUpdateLayeredWindow(Window window) {
        if (window instanceof RootPaneContainer) {
            JRootPane jRootPane = ((RootPaneContainer)((Object)window)).getRootPane();
            return jRootPane.getClientProperty("transparent-old-bg") != null;
        }
        return false;
    }

    private void storeAlpha(Window window, byte by2) {
        if (window instanceof RootPaneContainer) {
            JRootPane jRootPane = ((RootPaneContainer)((Object)window)).getRootPane();
            Byte by3 = by2 == -1 ? null : new Byte(by2);
            jRootPane.putClientProperty("transparent-alpha", by3);
        }
    }

    private byte getAlpha(Window window) {
        JRootPane jRootPane;
        Byte by2;
        if (window instanceof RootPaneContainer && (by2 = (Byte)(jRootPane = ((RootPaneContainer)((Object)window)).getRootPane()).getClientProperty("transparent-alpha")) != null) {
            return by2;
        }
        return -1;
    }

    public void setWindowAlpha(Window window, float f2) {
        if (!this.isWindowAlphaSupported()) {
            throw new UnsupportedOperationException("Set sun.java2d.noddraw=true to enable transparent windows");
        }
        this.whenDisplayable(window, new WindowUtils$W32WindowUtils$1(this, window, f2));
    }

    public void setWindowTransparent(Window window, boolean bl2) {
        boolean bl3;
        if (!(window instanceof RootPaneContainer)) {
            throw new IllegalArgumentException("Window must be a RootPaneContainer");
        }
        if (!this.isWindowAlphaSupported()) {
            throw new UnsupportedOperationException("Set sun.java2d.noddraw=true to enable transparent windows");
        }
        boolean bl4 = bl3 = window.getBackground() != null && window.getBackground().getAlpha() == 0;
        if (bl2 == bl3) {
            return;
        }
        this.whenDisplayable(window, new WindowUtils$W32WindowUtils$2(this, window, bl2));
    }

    public void setWindowMask(Component component, Shape shape) {
        if (shape instanceof Area && ((Area)shape).isPolygonal()) {
            this.setMask(component, (Area)shape);
        } else {
            super.setWindowMask(component, shape);
        }
    }

    private void setWindowRegion(Component component, WinDef$HRGN winDef$HRGN) {
        this.whenDisplayable(component, new WindowUtils$W32WindowUtils$3(this, component, winDef$HRGN));
    }

    private void setMask(Component component, Area area) {
        GDI32 gDI32 = GDI32.INSTANCE;
        PathIterator pathIterator = area.getPathIterator(null);
        int n2 = pathIterator.getWindingRule() == 1 ? 2 : 1;
        float[] fArray = new float[6];
        ArrayList<WinUser$POINT> arrayList = new ArrayList<WinUser$POINT>();
        int n3 = 0;
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        while (!pathIterator.isDone()) {
            int n4 = pathIterator.currentSegment(fArray);
            if (n4 == 0) {
                n3 = 1;
                arrayList.add(new WinUser$POINT((int)fArray[0], (int)fArray[1]));
            } else if (n4 == 1) {
                ++n3;
                arrayList.add(new WinUser$POINT((int)fArray[0], (int)fArray[1]));
            } else if (n4 == 4) {
                arrayList2.add(new Integer(n3));
            } else {
                throw new RuntimeException("Area is not polygonal: " + area);
            }
            pathIterator.next();
        }
        WinUser$POINT[] winUser$POINTArray = (WinUser$POINT[])new WinUser$POINT().toArray(arrayList.size());
        WinUser$POINT[] winUser$POINTArray2 = arrayList.toArray(new WinUser$POINT[arrayList.size()]);
        for (int i2 = 0; i2 < winUser$POINTArray.length; ++i2) {
            winUser$POINTArray[i2].x = winUser$POINTArray2[i2].x;
            winUser$POINTArray[i2].y = winUser$POINTArray2[i2].y;
        }
        int[] nArray = new int[arrayList2.size()];
        for (int i3 = 0; i3 < nArray.length; ++i3) {
            nArray[i3] = (Integer)arrayList2.get(i3);
        }
        WinDef$HRGN winDef$HRGN = gDI32.CreatePolyPolygonRgn(winUser$POINTArray, nArray, nArray.length, n2);
        this.setWindowRegion(component, winDef$HRGN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMask(Component component, Raster raster) {
        WinDef$HRGN winDef$HRGN;
        GDI32 gDI32 = GDI32.INSTANCE;
        WinDef$HRGN winDef$HRGN2 = winDef$HRGN = raster != null ? gDI32.CreateRectRgn(0, 0, 0, 0) : null;
        if (winDef$HRGN != null) {
            WinDef$HRGN winDef$HRGN3 = gDI32.CreateRectRgn(0, 0, 0, 0);
            try {
                RasterRangesUtils.outputOccupiedRanges(raster, new WindowUtils$W32WindowUtils$4(this, winDef$HRGN3, winDef$HRGN));
            }
            finally {
                gDI32.DeleteObject(winDef$HRGN3);
            }
        }
        this.setWindowRegion(component, winDef$HRGN);
    }

    /* synthetic */ WindowUtils$W32WindowUtils(WindowUtils$1 windowUtils$1) {
        this();
    }

    static /* synthetic */ WinDef$HWND access$400(WindowUtils$W32WindowUtils windowUtils$W32WindowUtils, Component component) {
        return windowUtils$W32WindowUtils.getHWnd(component);
    }

    static /* synthetic */ boolean access$500(WindowUtils$W32WindowUtils windowUtils$W32WindowUtils, Window window) {
        return windowUtils$W32WindowUtils.usingUpdateLayeredWindow(window);
    }

    static /* synthetic */ void access$600(WindowUtils$W32WindowUtils windowUtils$W32WindowUtils, Window window, byte by2) {
        windowUtils$W32WindowUtils.storeAlpha(window, by2);
    }

    static /* synthetic */ byte access$700(WindowUtils$W32WindowUtils windowUtils$W32WindowUtils, Window window) {
        return windowUtils$W32WindowUtils.getAlpha(window);
    }
}

