/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.AltCallingConvention;
import com.sun.jna.Function;
import com.sun.jna.InvocationMapper;
import com.sun.jna.Library$Handler$FunctionInfo;
import com.sun.jna.NativeLibrary;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class Library$Handler
implements InvocationHandler {
    static final Method OBJECT_TOSTRING;
    static final Method OBJECT_HASHCODE;
    static final Method OBJECT_EQUALS;
    private final NativeLibrary nativeLibrary;
    private final Class<?> interfaceClass;
    private final Map<String, Object> options;
    private final InvocationMapper invocationMapper;
    private final Map<Method, Library$Handler$FunctionInfo> functions = new WeakHashMap<Method, Library$Handler$FunctionInfo>();

    public Library$Handler(String string, Class<?> clazz, Map<String, ?> map) {
        int n2;
        if (string != null && "".equals(string.trim())) {
            throw new IllegalArgumentException("Invalid library name \"" + string + "\"");
        }
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException(string + " does not implement an interface: " + clazz.getName());
        }
        this.interfaceClass = clazz;
        this.options = new HashMap(map);
        int n3 = n2 = AltCallingConvention.class.isAssignableFrom(clazz) ? 63 : 0;
        if (this.options.get("calling-convention") == null) {
            this.options.put("calling-convention", n2);
        }
        if (this.options.get("classloader") == null) {
            this.options.put("classloader", clazz.getClassLoader());
        }
        this.nativeLibrary = NativeLibrary.getInstance(string, this.options);
        this.invocationMapper = (InvocationMapper)this.options.get("invocation-mapper");
    }

    public NativeLibrary getNativeLibrary() {
        return this.nativeLibrary;
    }

    public String getLibraryName() {
        return this.nativeLibrary.getName();
    }

    public Class<?> getInterfaceClass() {
        return this.interfaceClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) {
        if (OBJECT_TOSTRING.equals(method)) {
            return "Proxy interface to " + this.nativeLibrary;
        }
        if (OBJECT_HASHCODE.equals(method)) {
            return this.hashCode();
        }
        if (OBJECT_EQUALS.equals(method)) {
            Object object2 = objectArray[0];
            if (object2 != null && Proxy.isProxyClass(object2.getClass())) {
                return Function.valueOf(Proxy.getInvocationHandler(object2) == this);
            }
            return Boolean.FALSE;
        }
        Library$Handler$FunctionInfo library$Handler$FunctionInfo = this.functions.get(method);
        if (library$Handler$FunctionInfo == null) {
            Map<Method, Library$Handler$FunctionInfo> map = this.functions;
            synchronized (map) {
                library$Handler$FunctionInfo = this.functions.get(method);
                if (library$Handler$FunctionInfo == null) {
                    boolean bl2 = Function.isVarArgs(method);
                    InvocationHandler invocationHandler = null;
                    if (this.invocationMapper != null) {
                        invocationHandler = this.invocationMapper.getInvocationHandler(this.nativeLibrary, method);
                    }
                    Function function = null;
                    Class<?>[] classArray = null;
                    HashMap<String, Object> hashMap = null;
                    if (invocationHandler == null) {
                        function = this.nativeLibrary.getFunction(method.getName(), method);
                        classArray = method.getParameterTypes();
                        hashMap = new HashMap<String, Object>(this.options);
                        hashMap.put("invoking-method", method);
                    }
                    library$Handler$FunctionInfo = new Library$Handler$FunctionInfo(invocationHandler, function, classArray, bl2, hashMap);
                    this.functions.put(method, library$Handler$FunctionInfo);
                }
            }
        }
        if (library$Handler$FunctionInfo.isVarArgs) {
            objectArray = Function.concatenateVarArgs(objectArray);
        }
        if (library$Handler$FunctionInfo.handler != null) {
            return library$Handler$FunctionInfo.handler.invoke(object, method, objectArray);
        }
        return library$Handler$FunctionInfo.function.invoke(method, library$Handler$FunctionInfo.parameterTypes, method.getReturnType(), objectArray, library$Handler$FunctionInfo.options);
    }

    static {
        try {
            OBJECT_TOSTRING = Object.class.getMethod("toString", new Class[0]);
            OBJECT_HASHCODE = Object.class.getMethod("hashCode", new Class[0]);
            OBJECT_EQUALS = Object.class.getMethod("equals", Object.class);
        }
        catch (Exception exception) {
            throw new Error("Error retrieving Object.toString() method");
        }
    }
}

