/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit.theme;

import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.webkit.Accessor;
import com.sun.javafx.webkit.theme.RenderThemeImpl$FormButton;
import com.sun.javafx.webkit.theme.RenderThemeImpl$FormCheckBox;
import com.sun.javafx.webkit.theme.RenderThemeImpl$FormControl;
import com.sun.javafx.webkit.theme.RenderThemeImpl$FormControlRef;
import com.sun.javafx.webkit.theme.RenderThemeImpl$FormMenuList;
import com.sun.javafx.webkit.theme.RenderThemeImpl$FormMenuListButton;
import com.sun.javafx.webkit.theme.RenderThemeImpl$FormProgressBar;
import com.sun.javafx.webkit.theme.RenderThemeImpl$FormRadioButton;
import com.sun.javafx.webkit.theme.RenderThemeImpl$FormSlider;
import com.sun.javafx.webkit.theme.RenderThemeImpl$FormTextField;
import com.sun.javafx.webkit.theme.RenderThemeImpl$Pool;
import com.sun.javafx.webkit.theme.RenderThemeImpl$ViewListener;
import com.sun.javafx.webkit.theme.RenderThemeImpl$WidgetType;
import com.sun.javafx.webkit.theme.Renderer;
import com.sun.webkit.graphics.Ref;
import com.sun.webkit.graphics.RenderTheme;
import com.sun.webkit.graphics.WCGraphicsContext;
import com.sun.webkit.graphics.WCSize;
import dev.protect.CU;
import dev.protect.Fq;
import dev.protect.Gq;
import dev.protect.pk;
import dev.protect.xn;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class RenderThemeImpl
extends RenderTheme {
    private static final PlatformLogger log = PlatformLogger.getLogger(RenderThemeImpl.class.getName());
    private Accessor accessor;
    private boolean isDefault;
    private RenderThemeImpl$Pool<RenderThemeImpl$FormControl> pool;

    public RenderThemeImpl(Accessor accessor) {
        this.accessor = accessor;
        this.pool = new RenderThemeImpl$Pool<RenderThemeImpl$FormControl>(renderThemeImpl$FormControl -> accessor.removeChild(renderThemeImpl$FormControl.asControl()), RenderThemeImpl$FormControl.class);
        accessor.addViewListener(new RenderThemeImpl$ViewListener(this.pool, accessor));
    }

    public RenderThemeImpl() {
        this.isDefault = true;
    }

    private void ensureNotDefault() {
        if (this.isDefault) {
            throw new IllegalStateException("the method should not be called in this context");
        }
    }

    @Override
    protected Ref createWidget(long l2, int n2, int n3, int n4, int n5, int n6, ByteBuffer byteBuffer) {
        this.ensureNotDefault();
        RenderThemeImpl$FormControl renderThemeImpl$FormControl = this.pool.get(l2);
        RenderThemeImpl$WidgetType renderThemeImpl$WidgetType = RenderThemeImpl$WidgetType.convert(n2);
        if (renderThemeImpl$FormControl == null || renderThemeImpl$FormControl.getType() != renderThemeImpl$WidgetType) {
            if (renderThemeImpl$FormControl != null) {
                this.accessor.removeChild(renderThemeImpl$FormControl.asControl());
            }
            switch (renderThemeImpl$WidgetType) {
                case TEXTFIELD: {
                    renderThemeImpl$FormControl = new RenderThemeImpl$FormTextField();
                    break;
                }
                case BUTTON: {
                    renderThemeImpl$FormControl = new RenderThemeImpl$FormButton();
                    break;
                }
                case CHECKBOX: {
                    renderThemeImpl$FormControl = new RenderThemeImpl$FormCheckBox();
                    break;
                }
                case RADIOBUTTON: {
                    renderThemeImpl$FormControl = new RenderThemeImpl$FormRadioButton();
                    break;
                }
                case MENULIST: {
                    renderThemeImpl$FormControl = new RenderThemeImpl$FormMenuList();
                    break;
                }
                case MENULISTBUTTON: {
                    renderThemeImpl$FormControl = new RenderThemeImpl$FormMenuListButton();
                    break;
                }
                case SLIDER: {
                    renderThemeImpl$FormControl = new RenderThemeImpl$FormSlider();
                    break;
                }
                case PROGRESSBAR: {
                    renderThemeImpl$FormControl = new RenderThemeImpl$FormProgressBar(RenderThemeImpl$WidgetType.PROGRESSBAR);
                    break;
                }
                case METER: {
                    renderThemeImpl$FormControl = new RenderThemeImpl$FormProgressBar(RenderThemeImpl$WidgetType.METER);
                    break;
                }
                default: {
                    log.severe("unknown widget index: {0}", n2);
                    return null;
                }
            }
            renderThemeImpl$FormControl.asControl().setFocusTraversable(false);
            this.pool.put(l2, renderThemeImpl$FormControl, this.accessor.getPage().getUpdateContentCycleID());
            this.accessor.addChild(renderThemeImpl$FormControl.asControl());
        }
        renderThemeImpl$FormControl.setState(n3);
        CU cU2 = renderThemeImpl$FormControl.asControl();
        if (cU2.getWidth() != (double)n4 || cU2.getHeight() != (double)n5) {
            cU2.resize(n4, n5);
        }
        if (cU2.isManaged()) {
            cU2.setManaged(false);
        }
        if (byteBuffer != null) {
            if (renderThemeImpl$WidgetType == RenderThemeImpl$WidgetType.SLIDER) {
                Gq gq2 = (Gq)cU2;
                byteBuffer.order(ByteOrder.nativeOrder());
                gq2.setOrientation(byteBuffer.getInt() == 0 ? xn.PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_ : xn.a);
                gq2.setMax(byteBuffer.getFloat());
                gq2.setMin(byteBuffer.getFloat());
                gq2.setValue(byteBuffer.getFloat());
            } else if (renderThemeImpl$WidgetType == RenderThemeImpl$WidgetType.PROGRESSBAR) {
                Fq fq2 = (Fq)cU2;
                byteBuffer.order(ByteOrder.nativeOrder());
                fq2.setProgress(byteBuffer.getInt() == 1 ? (double)byteBuffer.getFloat() : -1.0);
            } else if (renderThemeImpl$WidgetType == RenderThemeImpl$WidgetType.METER) {
                Fq fq3 = (Fq)cU2;
                byteBuffer.order(ByteOrder.nativeOrder());
                fq3.setProgress(byteBuffer.getFloat());
                fq3.setStyle(this.getMeterStyle(byteBuffer.getInt()));
            }
        }
        return new RenderThemeImpl$FormControlRef(renderThemeImpl$FormControl);
    }

    private String getMeterStyle(int n2) {
        switch (n2) {
            case 1: {
                return "-fx-accent: yellow";
            }
            case 2: {
                return "-fx-accent: red";
            }
        }
        return "-fx-accent: green";
    }

    @Override
    public void drawWidget(WCGraphicsContext wCGraphicsContext, Ref ref, int n2, int n3) {
        CU cU2;
        this.ensureNotDefault();
        RenderThemeImpl$FormControl renderThemeImpl$FormControl = ((RenderThemeImpl$FormControlRef)ref).asFormControl();
        if (renderThemeImpl$FormControl != null && (cU2 = renderThemeImpl$FormControl.asControl()) != null) {
            wCGraphicsContext.saveState();
            wCGraphicsContext.translate(n2, n3);
            Renderer.getRenderer().render(cU2, wCGraphicsContext);
            wCGraphicsContext.restoreState();
        }
    }

    @Override
    public WCSize getWidgetSize(Ref ref) {
        this.ensureNotDefault();
        RenderThemeImpl$FormControl renderThemeImpl$FormControl = ((RenderThemeImpl$FormControlRef)ref).asFormControl();
        if (renderThemeImpl$FormControl != null) {
            CU cU2 = renderThemeImpl$FormControl.asControl();
            return new WCSize((float)cU2.getWidth(), (float)cU2.getHeight());
        }
        return new WCSize(0.0f, 0.0f);
    }

    @Override
    protected int getRadioButtonSize() {
        String string = pk.getUserAgentStylesheet();
        if ("MODENA".equalsIgnoreCase(string)) {
            return 20;
        }
        if ("CASPIAN".equalsIgnoreCase(string)) {
            return 19;
        }
        return 20;
    }

    @Override
    protected int getSelectionColor(int n2) {
        switch (n2) {
            case 0: {
                return -16739329;
            }
            case 1: {
                return -1;
            }
        }
        return 0;
    }

    private static boolean hasState(int n2, int n3) {
        return (n2 & n3) != 0;
    }
}

