/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit.prism;

import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.media.PrismMediaFrameHandler;
import com.sun.javafx.webkit.prism.WCMediaPlayerImpl$1;
import com.sun.javafx.webkit.prism.WCMediaPlayerImpl$CreateThread;
import com.sun.javafx.webkit.prism.WCMediaPlayerImpl$MediaFrameListener;
import com.sun.media.jfxmedia.Media;
import com.sun.media.jfxmedia.MediaPlayer;
import com.sun.media.jfxmedia.control.VideoDataBuffer;
import com.sun.media.jfxmedia.events.BufferListener;
import com.sun.media.jfxmedia.events.BufferProgressEvent;
import com.sun.media.jfxmedia.events.MediaErrorListener;
import com.sun.media.jfxmedia.events.PlayerStateEvent;
import com.sun.media.jfxmedia.events.PlayerStateListener;
import com.sun.media.jfxmedia.events.PlayerTimeListener;
import com.sun.media.jfxmedia.events.VideoTrackSizeListener;
import com.sun.media.jfxmedia.track.AudioTrack;
import com.sun.media.jfxmedia.track.Track;
import com.sun.media.jfxmedia.track.VideoTrack;
import com.sun.prism.Graphics;
import com.sun.prism.Texture;
import com.sun.prism.paint.Color;
import com.sun.webkit.graphics.WCGraphicsContext;
import com.sun.webkit.graphics.WCMediaPlayer;
import java.util.List;

final class WCMediaPlayerImpl
extends WCMediaPlayer
implements BufferListener,
MediaErrorListener,
PlayerStateListener,
PlayerTimeListener,
VideoTrackSizeListener {
    private final Object lock = new Object();
    private volatile MediaPlayer player;
    private volatile WCMediaPlayerImpl$CreateThread createThread;
    private volatile PrismMediaFrameHandler frameHandler;
    private final WCMediaPlayerImpl$MediaFrameListener frameListener = new WCMediaPlayerImpl$MediaFrameListener(this);
    private boolean gotFirstFrame = false;
    private int finished = 0;
    private float bufferedStart = 0.0f;
    private float bufferedEnd = 0.0f;
    private boolean buffering = false;

    WCMediaPlayerImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MediaPlayer getPlayer() {
        Object object = this.lock;
        synchronized (object) {
            if (this.createThread != null) {
                return null;
            }
            return this.player;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPlayer(MediaPlayer mediaPlayer) {
        Object object = this.lock;
        synchronized (object) {
            this.player = mediaPlayer;
            this.installListeners();
            this.frameHandler = PrismMediaFrameHandler.getHandler(this.player);
        }
        this.finished = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void load(String string, String string2) {
        Object object = this.lock;
        synchronized (object) {
            if (this.createThread != null) {
                this.createThread.cancel();
            }
            this.disposePlayer();
            this.createThread = new WCMediaPlayerImpl$CreateThread(this, string, string2);
        }
        if (this.getPreload() != 0) {
            this.createThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancelLoad() {
        Object object = this.lock;
        synchronized (object) {
            if (this.createThread != null) {
                this.createThread.cancel();
            }
        }
        object = this.getPlayer();
        if (object != null) {
            object.stop();
        }
        this.notifyNetworkStateChanged(0);
        this.notifyReadyStateChanged(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void disposePlayer() {
        MediaPlayer mediaPlayer;
        Object object = this.lock;
        synchronized (object) {
            this.removeListeners();
            mediaPlayer = this.player;
            this.player = null;
            if (this.frameHandler != null) {
                this.frameHandler.releaseTextures();
                this.frameHandler = null;
            }
        }
        if (mediaPlayer != null) {
            mediaPlayer.stop();
            mediaPlayer.dispose();
            mediaPlayer = null;
            if (this.frameListener != null) {
                this.frameListener.releaseVideoFrames();
            }
        }
    }

    private void installListeners() {
        if (null != this.player) {
            this.player.addMediaPlayerListener(this);
            this.player.addMediaErrorListener(this);
            this.player.addVideoTrackSizeListener(this);
            this.player.addBufferListener(this);
            this.player.getVideoRenderControl().addVideoRendererListener(this.frameListener);
        }
    }

    private void removeListeners() {
        if (null != this.player) {
            this.player.removeMediaPlayerListener(this);
            this.player.removeMediaErrorListener(this);
            this.player.removeVideoTrackSizeListener(this);
            this.player.removeBufferListener(this);
            this.player.getVideoRenderControl().removeVideoRendererListener(this.frameListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void prepareToPlay() {
        Object object = this.lock;
        synchronized (object) {
            WCMediaPlayerImpl$CreateThread wCMediaPlayerImpl$CreateThread;
            if (this.player == null && (wCMediaPlayerImpl$CreateThread = this.createThread) != null && wCMediaPlayerImpl$CreateThread.getState() == Thread.State.NEW) {
                wCMediaPlayerImpl$CreateThread.start();
            }
        }
    }

    @Override
    protected void play() {
        MediaPlayer mediaPlayer = this.getPlayer();
        if (mediaPlayer != null) {
            mediaPlayer.play();
            this.notifyPaused(false);
        }
    }

    @Override
    protected void pause() {
        MediaPlayer mediaPlayer = this.getPlayer();
        if (mediaPlayer != null) {
            mediaPlayer.pause();
            this.notifyPaused(true);
        }
    }

    @Override
    protected float getCurrentTime() {
        MediaPlayer mediaPlayer = this.getPlayer();
        if (mediaPlayer == null) {
            return 0.0f;
        }
        return this.finished == 0 ? (float)mediaPlayer.getPresentationTime() : (this.finished > 0 ? (float)mediaPlayer.getDuration() : 0.0f);
    }

    @Override
    protected void seek(float f2) {
        MediaPlayer mediaPlayer = this.getPlayer();
        if (mediaPlayer != null) {
            this.finished = 0;
            if (this.getReadyState() >= 1) {
                this.notifySeeking(true, 1);
            } else {
                this.notifySeeking(true, 0);
            }
            mediaPlayer.seek(f2);
            float f3 = f2;
            Thread thread = new Thread(new WCMediaPlayerImpl$1(this, f3));
            thread.setDaemon(true);
            thread.start();
        }
    }

    @Override
    protected void setRate(float f2) {
        MediaPlayer mediaPlayer = this.getPlayer();
        if (mediaPlayer != null) {
            mediaPlayer.setRate(f2);
        }
    }

    @Override
    protected void setVolume(float f2) {
        MediaPlayer mediaPlayer = this.getPlayer();
        if (mediaPlayer != null) {
            mediaPlayer.setVolume(f2);
        }
    }

    @Override
    protected void setMute(boolean bl2) {
        MediaPlayer mediaPlayer = this.getPlayer();
        if (mediaPlayer != null) {
            mediaPlayer.setMute(bl2);
        }
    }

    @Override
    protected void setSize(int n2, int n3) {
    }

    @Override
    protected void setPreservesPitch(boolean bl2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void renderCurrentFrame(WCGraphicsContext wCGraphicsContext, int n2, int n3, int n4, int n5) {
        Object object = this.lock;
        synchronized (object) {
            this.renderImpl(wCGraphicsContext, n2, n3, n4, n5);
        }
    }

    private void renderImpl(WCGraphicsContext wCGraphicsContext, int n2, int n3, int n4, int n5) {
        log.finer(">>(Prism)renderImpl");
        Graphics graphics = (Graphics)wCGraphicsContext.getPlatformGraphics();
        Texture texture = null;
        VideoDataBuffer videoDataBuffer = this.frameListener.getLatestFrame();
        if (null != videoDataBuffer) {
            if (null != this.frameHandler) {
                texture = this.frameHandler.getTexture(graphics, videoDataBuffer);
            }
            videoDataBuffer.releaseFrame();
        }
        if (texture != null) {
            graphics.drawTexture(texture, n2, n3, n2 + n4, n3 + n5, 0.0f, 0.0f, texture.getContentWidth(), texture.getContentHeight());
            texture.unlock();
        } else {
            log.finest("  (Prism)renderImpl, texture is null, draw black rect");
            wCGraphicsContext.fillRect(n2, n3, n4, n5, Color.BLACK);
        }
        log.finer("<<(Prism)renderImpl");
    }

    @Override
    public void onReady(PlayerStateEvent playerStateEvent) {
        MediaPlayer mediaPlayer = this.getPlayer();
        log.fine("onReady");
        Media media = mediaPlayer.getMedia();
        boolean bl2 = false;
        boolean bl3 = false;
        if (media != null) {
            List<Track> list = media.getTracks();
            if (list != null) {
                log.fine("{0} track(s) detected:", list.size());
                for (Track track : list) {
                    if (track instanceof VideoTrack) {
                        bl2 = true;
                    } else if (track instanceof AudioTrack) {
                        bl3 = true;
                    }
                    log.fine("track: {0}", track);
                }
            } else {
                log.warning("onReady, tracks IS NULL");
            }
        } else {
            log.warning("onReady, media IS NULL");
        }
        log.fine("onReady, hasVideo:{0}, hasAudio: {1}", bl2, bl3);
        this.notifyReady(bl2, bl3, (float)mediaPlayer.getDuration());
        if (!bl2) {
            this.notifyReadyStateChanged(4);
        } else if (this.getReadyState() < 1) {
            if (this.gotFirstFrame) {
                this.notifyReadyStateChanged(4);
            } else {
                this.notifyReadyStateChanged(1);
            }
        }
    }

    @Override
    public void onPlaying(PlayerStateEvent playerStateEvent) {
        log.fine("onPlaying");
        this.notifyPaused(false);
    }

    @Override
    public void onPause(PlayerStateEvent playerStateEvent) {
        log.fine("onPause, time: {0}", playerStateEvent.getTime());
        this.notifyPaused(true);
    }

    @Override
    public void onStop(PlayerStateEvent playerStateEvent) {
        log.fine("onStop");
        this.notifyPaused(true);
    }

    @Override
    public void onStall(PlayerStateEvent playerStateEvent) {
        log.fine("onStall");
    }

    @Override
    public void onFinish(PlayerStateEvent playerStateEvent) {
        MediaPlayer mediaPlayer = this.getPlayer();
        if (mediaPlayer != null) {
            this.finished = mediaPlayer.getRate() > 0.0f ? 1 : -1;
            log.fine("onFinish, time: {0}", playerStateEvent.getTime());
            this.notifyFinished();
        }
    }

    @Override
    public void onHalt(PlayerStateEvent playerStateEvent) {
        log.fine("onHalt");
    }

    @Override
    public void onError(Object object, int n2, String string) {
        log.warning("onError, errCode={0}, msg={1}", n2, string);
        this.notifyNetworkStateChanged(5);
        this.notifyReadyStateChanged(0);
    }

    @Override
    public void onDurationChanged(double d2) {
        log.fine("onDurationChanged, duration={0}", d2);
        this.notifyDurationChanged((float)d2);
    }

    @Override
    public void onSizeChanged(int n2, int n3) {
        log.fine("onSizeChanged, new size = {0} x {1}", n2, n3);
        this.notifySizeChanged(n2, n3);
    }

    private void notifyFrameArrived() {
        if (!this.gotFirstFrame) {
            if (this.getReadyState() >= 1) {
                this.notifyReadyStateChanged(4);
            }
            this.gotFirstFrame = true;
        }
        if (this.finished != 0) {
            log.fine("notifyFrameArrived (after finished) time: {0}", this.getPlayer().getPresentationTime());
        }
        this.notifyNewFrame();
    }

    private void updateBufferingStatus() {
        int n2 = this.buffering ? 2 : (this.bufferedStart > 0.0f ? 1 : 3);
        log.fine("updateBufferingStatus, buffered: [{0} - {1}], buffering = {2}", Float.valueOf(this.bufferedStart), Float.valueOf(this.bufferedEnd), this.buffering);
        this.notifyNetworkStateChanged(n2);
    }

    @Override
    public void onBufferProgress(BufferProgressEvent bufferProgressEvent) {
        if (bufferProgressEvent.getDuration() < 0.0) {
            return;
        }
        double d2 = bufferProgressEvent.getDuration() / (double)bufferProgressEvent.getBufferStop();
        this.bufferedStart = (float)(d2 * (double)bufferProgressEvent.getBufferStart());
        this.bufferedEnd = (float)(d2 * (double)bufferProgressEvent.getBufferPosition());
        this.buffering = bufferProgressEvent.getBufferPosition() < bufferProgressEvent.getBufferStop();
        float[] fArray = new float[]{this.bufferedStart, this.bufferedEnd};
        int n2 = (int)(bufferProgressEvent.getBufferPosition() - bufferProgressEvent.getBufferStart());
        log.finer("onBufferProgress, bufferStart={0}, bufferStop={1}, bufferPos={2}, duration={3}; notify range [{4},[5]], bytesLoaded: {6}", bufferProgressEvent.getBufferStart(), bufferProgressEvent.getBufferStop(), bufferProgressEvent.getBufferPosition(), bufferProgressEvent.getDuration(), Float.valueOf(fArray[0]), Float.valueOf(fArray[1]), n2);
        this.notifyBufferChanged(fArray, n2);
        this.updateBufferingStatus();
    }

    static /* synthetic */ PlatformLogger access$000() {
        return log;
    }

    static /* synthetic */ void access$100(WCMediaPlayerImpl wCMediaPlayerImpl, int n2) {
        wCMediaPlayerImpl.notifyNetworkStateChanged(n2);
    }

    static /* synthetic */ void access$200(WCMediaPlayerImpl wCMediaPlayerImpl, int n2) {
        wCMediaPlayerImpl.notifyReadyStateChanged(n2);
    }

    static /* synthetic */ PlatformLogger access$300() {
        return log;
    }

    static /* synthetic */ PlatformLogger access$400() {
        return log;
    }

    static /* synthetic */ PlatformLogger access$500() {
        return log;
    }

    static /* synthetic */ PlatformLogger access$600() {
        return log;
    }

    static /* synthetic */ boolean access$700(WCMediaPlayerImpl wCMediaPlayerImpl) {
        return wCMediaPlayerImpl.isSeeking();
    }

    static /* synthetic */ void access$800(WCMediaPlayerImpl wCMediaPlayerImpl, boolean bl2, int n2) {
        wCMediaPlayerImpl.notifySeeking(bl2, n2);
    }
}

