/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit.prism;

import com.sun.javafx.iio.ImageFrame;
import com.sun.javafx.iio.ImageLoadListener;
import com.sun.javafx.iio.ImageMetadata;
import com.sun.javafx.iio.ImageStorage;
import com.sun.javafx.iio.ImageStorageException;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.logging.PlatformLogger$Level;
import com.sun.javafx.webkit.prism.PrismImage;
import com.sun.javafx.webkit.prism.WCImageDecoderImpl$1;
import com.sun.javafx.webkit.prism.WCImageDecoderImpl$2;
import com.sun.javafx.webkit.prism.WCImageDecoderImpl$3;
import com.sun.javafx.webkit.prism.WCImageDecoderImpl$Frame;
import com.sun.javafx.webkit.prism.WCImageImpl;
import com.sun.webkit.graphics.WCGraphicsManager;
import com.sun.webkit.graphics.WCImage;
import com.sun.webkit.graphics.WCImageDecoder;
import com.sun.webkit.graphics.WCImageFrame;
import dev.protect.uj;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

final class WCImageDecoderImpl
extends WCImageDecoder {
    private static final PlatformLogger log = PlatformLogger.getLogger(WCImageDecoderImpl.class.getName());
    private uj<ImageFrame[]> loader;
    private int imageWidth = 0;
    private int imageHeight = 0;
    private ImageFrame[] frames;
    private int frameCount = 0;
    private boolean fullDataReceived = false;
    private boolean framesDecoded = false;
    private PrismImage[] images;
    private volatile byte[] data;
    private volatile int dataSize = 0;
    private String fileNameExtension;
    private final ImageLoadListener readerListener = new WCImageDecoderImpl$2(this);
    private static final ThreadLocal<int[]> THREAD_LOCAL_SIZE_ARRAY = new WCImageDecoderImpl$3();

    WCImageDecoderImpl() {
    }

    @Override
    protected synchronized void destroy() {
        if (log.isLoggable(PlatformLogger$Level.FINE)) {
            log.fine(String.format("%X Destroy image decoder", this.hashCode()));
        }
        this.destroyLoader();
        this.frames = null;
        this.images = null;
        this.framesDecoded = false;
    }

    @Override
    protected String getFilenameExtension() {
        return "." + this.fileNameExtension;
    }

    private boolean imageSizeAvilable() {
        return this.imageWidth > 0 && this.imageHeight > 0;
    }

    @Override
    protected void addImageData(byte[] byArray) {
        if (byArray != null) {
            this.fullDataReceived = false;
            if (this.data == null) {
                this.data = Arrays.copyOf(byArray, byArray.length * 2);
                this.dataSize = byArray.length;
            } else {
                int n2 = this.dataSize + byArray.length;
                if (n2 > this.data.length) {
                    this.resizeDataArray(Math.max(n2, this.data.length * 2));
                }
                System.arraycopy(byArray, 0, this.data, this.dataSize, byArray.length);
                this.dataSize = n2;
            }
            if (!this.imageSizeAvilable()) {
                this.loadFrames();
            }
        } else if (this.data != null && !this.fullDataReceived) {
            if (this.data.length > this.dataSize) {
                this.resizeDataArray(this.dataSize);
            }
            this.fullDataReceived = true;
        }
    }

    private void destroyLoader() {
        if (this.loader != null) {
            this.loader.cancel();
            this.loader = null;
        }
    }

    private void startLoader() {
        if (this.loader == null) {
            this.loader = new WCImageDecoderImpl$1(this);
            this.loader.valueProperty().addListener((tb2, imageFrameArray, imageFrameArray2) -> {
                if (imageFrameArray2 != null && this.loader != null) {
                    this.setFrames((ImageFrame[])imageFrameArray2);
                }
            });
        }
        if (!this.loader.isRunning()) {
            this.loader.restart();
        }
    }

    private void resizeDataArray(int n2) {
        byte[] byArray = new byte[n2];
        System.arraycopy(this.data, 0, byArray, 0, this.dataSize);
        this.data = byArray;
    }

    @Override
    protected void loadFromResource(String string) {
        if (log.isLoggable(PlatformLogger$Level.FINE)) {
            log.fine(String.format("%X Load image from resource '%s'", this.hashCode(), string));
        }
        String string2 = WCGraphicsManager.getResourceName(string);
        InputStream inputStream = this.getClass().getResourceAsStream(string2);
        if (inputStream == null) {
            if (log.isLoggable(PlatformLogger$Level.FINE)) {
                log.fine(String.format("%X Unable to open resource '%s'", this.hashCode(), string2));
            }
            return;
        }
        this.setFrames(this.loadFrames(inputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ImageFrame[] loadFrames(InputStream inputStream) {
        if (log.isLoggable(PlatformLogger$Level.FINE)) {
            log.fine(String.format("%X Decoding frames", this.hashCode()));
        }
        try {
            ImageFrame[] imageFrameArray = ImageStorage.loadAll(inputStream, this.readerListener, 0.0, 0.0, true, 1.0f, false);
            return imageFrameArray;
        }
        catch (ImageStorageException imageStorageException) {
            ImageFrame[] imageFrameArray = null;
            return imageFrameArray;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private ImageFrame[] loadFrames() {
        return this.loadFrames(new ByteArrayInputStream(this.data, 0, this.dataSize));
    }

    @Override
    protected int[] getImageSize() {
        int[] nArray = THREAD_LOCAL_SIZE_ARRAY.get();
        nArray[0] = this.imageWidth;
        nArray[1] = this.imageHeight;
        if (log.isLoggable(PlatformLogger$Level.FINE)) {
            log.fine(String.format("%X image size = %dx%d", this.hashCode(), nArray[0], nArray[1]));
        }
        return nArray;
    }

    private synchronized void setFrames(ImageFrame[] imageFrameArray) {
        this.frames = imageFrameArray;
        this.images = null;
        this.frameCount = imageFrameArray == null ? 0 : imageFrameArray.length;
    }

    @Override
    protected int getFrameCount() {
        if (this.fullDataReceived) {
            this.getImageFrame(0);
        }
        return this.frameCount;
    }

    @Override
    protected synchronized WCImageFrame getFrame(int n2) {
        ImageFrame imageFrame = this.getImageFrame(n2);
        if (imageFrame != null) {
            Object object;
            if (log.isLoggable(PlatformLogger$Level.FINE)) {
                object = imageFrame.getImageType();
                log.fine(String.format("%X getFrame(%d): image type = %s", this.hashCode(), n2, object));
            }
            object = this.getPrismImage(n2, imageFrame);
            return new WCImageDecoderImpl$Frame((WCImage)object, this.fileNameExtension);
        }
        if (log.isLoggable(PlatformLogger$Level.FINE)) {
            log.fine(String.format("%X FAILED getFrame(%d)", this.hashCode(), n2));
        }
        return null;
    }

    private synchronized ImageMetadata getFrameMetadata(int n2) {
        return this.frames != null && this.frames.length > n2 && this.frames[n2] != null ? this.frames[n2].getMetadata() : null;
    }

    @Override
    protected int getFrameDuration(int n2) {
        int n3;
        ImageMetadata imageMetadata = this.getFrameMetadata(n2);
        int n4 = n3 = imageMetadata == null || imageMetadata.delayTime == null ? 0 : imageMetadata.delayTime;
        if (n3 < 11) {
            n3 = 100;
        }
        return n3;
    }

    @Override
    protected int[] getFrameSize(int n2) {
        ImageMetadata imageMetadata = this.getFrameMetadata(n2);
        if (imageMetadata == null) {
            return null;
        }
        int[] nArray = THREAD_LOCAL_SIZE_ARRAY.get();
        nArray[0] = imageMetadata.imageWidth;
        nArray[1] = imageMetadata.imageHeight;
        return nArray;
    }

    @Override
    protected synchronized boolean getFrameCompleteStatus(int n2) {
        return this.getFrameMetadata(n2) != null && this.framesDecoded;
    }

    private synchronized ImageFrame getImageFrame(int n2) {
        if (!this.fullDataReceived) {
            this.startLoader();
        } else if (this.fullDataReceived && !this.framesDecoded) {
            this.destroyLoader();
            this.setFrames(this.loadFrames());
            this.framesDecoded = true;
        }
        return n2 >= 0 && this.frames != null && this.frames.length > n2 ? this.frames[n2] : null;
    }

    private synchronized PrismImage getPrismImage(int n2, ImageFrame imageFrame) {
        if (this.images == null) {
            this.images = new PrismImage[this.frames.length];
        }
        if (this.images[n2] == null) {
            this.images[n2] = new WCImageImpl(imageFrame);
        }
        return this.images[n2];
    }
}

