/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit.prism;

import com.sun.glass.ui.Screen;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.Metrics;
import com.sun.javafx.font.PGFont;
import com.sun.javafx.geom.Arc2D;
import com.sun.javafx.geom.Line2D;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.GeneralTransform3D;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.logging.PlatformLogger$Level;
import com.sun.javafx.scene.text.GlyphList;
import com.sun.javafx.scene.text.TextLayout;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGShape;
import com.sun.javafx.sg.prism.NGShape$Mode;
import com.sun.javafx.text.TextRun;
import com.sun.javafx.webkit.prism.PrismImage;
import com.sun.javafx.webkit.prism.TextUtilities;
import com.sun.javafx.webkit.prism.WCGraphicsPrismContext$1;
import com.sun.javafx.webkit.prism.WCGraphicsPrismContext$10;
import com.sun.javafx.webkit.prism.WCGraphicsPrismContext$11;
import com.sun.javafx.webkit.prism.WCGraphicsPrismContext$12;
import com.sun.javafx.webkit.prism.WCGraphicsPrismContext$13;
import com.sun.javafx.webkit.prism.WCGraphicsPrismContext$14;
import com.sun.javafx.webkit.prism.WCGraphicsPrismContext$15;
import com.sun.javafx.webkit.prism.WCGraphicsPrismContext$16;
import com.sun.javafx.webkit.prism.WCGraphicsPrismContext$17;
import com.sun.javafx.webkit.prism.WCGraphicsPrismContext$18;
import com.sun.javafx.webkit.prism.WCGraphicsPrismContext$2;
import com.sun.javafx.webkit.prism.WCGraphicsPrismContext$3;
import com.sun.javafx.webkit.prism.WCGraphicsPrismContext$4;
import com.sun.javafx.webkit.prism.WCGraphicsPrismContext$5;
import com.sun.javafx.webkit.prism.WCGraphicsPrismContext$6;
import com.sun.javafx.webkit.prism.WCGraphicsPrismContext$7;
import com.sun.javafx.webkit.prism.WCGraphicsPrismContext$8;
import com.sun.javafx.webkit.prism.WCGraphicsPrismContext$9;
import com.sun.javafx.webkit.prism.WCGraphicsPrismContext$ClipLayer;
import com.sun.javafx.webkit.prism.WCGraphicsPrismContext$ContextState;
import com.sun.javafx.webkit.prism.WCGraphicsPrismContext$Layer;
import com.sun.javafx.webkit.prism.WCGraphicsPrismContext$TransparencyLayer;
import com.sun.javafx.webkit.prism.WCGraphicsPrismContext$Type;
import com.sun.javafx.webkit.prism.WCLinearGradient;
import com.sun.javafx.webkit.prism.WCPathImpl;
import com.sun.javafx.webkit.prism.WCRadialGradient;
import com.sun.prism.BasicStroke;
import com.sun.prism.Graphics;
import com.sun.prism.ResourceFactory;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Gradient;
import com.sun.prism.paint.Paint;
import com.sun.scenario.effect.Color4f;
import com.sun.scenario.effect.DropShadow;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.impl.prism.PrFilterContext;
import com.sun.webkit.graphics.Ref;
import com.sun.webkit.graphics.RenderTheme;
import com.sun.webkit.graphics.ScrollBarTheme;
import com.sun.webkit.graphics.WCFont;
import com.sun.webkit.graphics.WCGradient;
import com.sun.webkit.graphics.WCGraphicsContext;
import com.sun.webkit.graphics.WCIcon;
import com.sun.webkit.graphics.WCImage;
import com.sun.webkit.graphics.WCPath;
import com.sun.webkit.graphics.WCPoint;
import com.sun.webkit.graphics.WCRectangle;
import com.sun.webkit.graphics.WCSize;
import com.sun.webkit.graphics.WCTransform;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;

class WCGraphicsPrismContext
extends WCGraphicsContext {
    private static final PlatformLogger log = PlatformLogger.getLogger(WCGraphicsPrismContext.class.getName());
    private static final boolean DEBUG_DRAW_CLIP_SHAPE = Boolean.valueOf(AccessController.doPrivileged(() -> System.getProperty("com.sun.webkit.debugDrawClipShape", "false")));
    Graphics baseGraphics;
    private BaseTransform baseTransform;
    private final List<WCGraphicsPrismContext$ContextState> states = new ArrayList<WCGraphicsPrismContext$ContextState>();
    private WCGraphicsPrismContext$ContextState state = new WCGraphicsPrismContext$ContextState();
    private Graphics cachedGraphics = null;
    private int fontSmoothingType;
    private boolean isRootLayerValid = false;
    private static final BasicStroke focusRingStroke = new BasicStroke(1.1f, 0, 1, 0.0f, new float[]{1.0f}, 0.0f);

    WCGraphicsPrismContext(Graphics graphics) {
        this.state.setClip(graphics.getClipRect());
        this.state.setAlpha(graphics.getExtraAlpha());
        this.baseGraphics = graphics;
        this.initBaseTransform(graphics.getTransformNoClone());
    }

    WCGraphicsPrismContext() {
    }

    public WCGraphicsPrismContext$Type type() {
        return WCGraphicsPrismContext$Type.PRIMARY;
    }

    final void initBaseTransform(BaseTransform baseTransform) {
        this.baseTransform = new Affine3D(baseTransform);
        this.state.setTransform((Affine3D)this.baseTransform);
    }

    private void resetCachedGraphics() {
        this.cachedGraphics = null;
    }

    @Override
    public Object getPlatformGraphics() {
        return this.getGraphics(false);
    }

    @Override
    public boolean isValid() {
        Object object = this.getPlatformGraphics();
        if (!(object instanceof Graphics)) {
            return false;
        }
        Graphics graphics = (Graphics)object;
        return !graphics.getResourceFactory().isDisposed();
    }

    Graphics getGraphics(boolean bl2) {
        Object object;
        if (this.cachedGraphics == null) {
            object = this.state.getLayerNoClone();
            this.cachedGraphics = object != null ? ((WCGraphicsPrismContext$Layer)object).getGraphics() : this.baseGraphics;
            ResourceFactory resourceFactory = this.cachedGraphics.getResourceFactory();
            if (!resourceFactory.isDisposed()) {
                this.state.apply(this.cachedGraphics);
            }
            if (log.isLoggable(PlatformLogger$Level.FINE)) {
                log.fine("getPlatformGraphics for " + this + " : " + this.cachedGraphics);
            }
        }
        object = this.cachedGraphics.getClipRectNoClone();
        return bl2 && object != null && ((Rectangle)object).isEmpty() ? null : this.cachedGraphics;
    }

    @Override
    public void saveState() {
        this.state.markAsRestorePoint();
        this.saveStateInternal();
    }

    private void saveStateInternal() {
        this.states.add(this.state);
        this.state = this.state.clone();
    }

    private void startNewLayer(WCGraphicsPrismContext$Layer wCGraphicsPrismContext$Layer) {
        this.saveStateInternal();
        Rectangle rectangle = this.state.getClipNoClone();
        Affine3D affine3D = new Affine3D(BaseTransform.getTranslateInstance(-rectangle.x, -rectangle.y));
        affine3D.concatenate(this.state.getTransformNoClone());
        rectangle.x = 0;
        rectangle.y = 0;
        Graphics graphics = this.getGraphics(true);
        if (graphics != null && graphics != this.baseGraphics) {
            wCGraphicsPrismContext$Layer.init(graphics);
        }
        this.state.setTransform(affine3D);
        this.state.setLayer(wCGraphicsPrismContext$Layer);
        this.resetCachedGraphics();
    }

    private void renderLayer(WCGraphicsPrismContext$Layer wCGraphicsPrismContext$Layer) {
        WCTransform wCTransform = this.getTransform();
        this.setTransform(new WCTransform(1.0, 0.0, 0.0, 1.0, wCGraphicsPrismContext$Layer.getX(), wCGraphicsPrismContext$Layer.getY()));
        Graphics graphics = this.getGraphics(true);
        if (graphics != null) {
            wCGraphicsPrismContext$Layer.render(graphics);
        }
        this.setTransform(wCTransform);
    }

    private void restoreStateInternal() {
        int n2 = this.states.size();
        if (n2 == 0) {
            assert (false) : "Unbalanced restoreState";
            return;
        }
        WCGraphicsPrismContext$Layer wCGraphicsPrismContext$Layer = this.state.getLayerNoClone();
        this.state = this.states.remove(n2 - 1);
        if (wCGraphicsPrismContext$Layer != this.state.getLayerNoClone()) {
            this.renderLayer(wCGraphicsPrismContext$Layer);
            wCGraphicsPrismContext$Layer.dispose();
            if (log.isLoggable(PlatformLogger$Level.FINE)) {
                log.fine("Popped layer " + wCGraphicsPrismContext$Layer);
            }
        } else {
            this.resetCachedGraphics();
        }
    }

    @Override
    public void restoreState() {
        log.fine("restoring state");
        do {
            this.restoreStateInternal();
        } while (!this.state.isRestorePoint());
    }

    private void flushAllLayers() {
        if (this.state == null) {
            return;
        }
        if (this.isRootLayerValid) {
            log.fine("FlushAllLayers: root layer is valid, skipping");
            return;
        }
        if (log.isLoggable(PlatformLogger$Level.FINE)) {
            log.fine("FlushAllLayers");
        }
        WCGraphicsPrismContext$ContextState wCGraphicsPrismContext$ContextState = this.state;
        for (int i2 = this.states.size() - 1; i2 >= 0; --i2) {
            WCGraphicsPrismContext$Layer wCGraphicsPrismContext$Layer = this.state.getLayerNoClone();
            this.state = this.states.get(i2);
            if (wCGraphicsPrismContext$Layer != this.state.getLayerNoClone()) {
                this.renderLayer(wCGraphicsPrismContext$Layer);
                continue;
            }
            this.resetCachedGraphics();
        }
        WCGraphicsPrismContext$Layer wCGraphicsPrismContext$Layer = this.state.getLayerNoClone();
        if (wCGraphicsPrismContext$Layer != null) {
            this.renderLayer(wCGraphicsPrismContext$Layer);
        }
        this.state = wCGraphicsPrismContext$ContextState;
        this.isRootLayerValid = true;
    }

    @Override
    public void dispose() {
        if (!this.states.isEmpty()) {
            log.fine("Unbalanced saveState/restoreState");
        }
        for (WCGraphicsPrismContext$ContextState wCGraphicsPrismContext$ContextState : this.states) {
            if (wCGraphicsPrismContext$ContextState.getLayerNoClone() == null) continue;
            wCGraphicsPrismContext$ContextState.getLayerNoClone().dispose();
        }
        this.states.clear();
        if (this.state != null && this.state.getLayerNoClone() != null) {
            this.state.getLayerNoClone().dispose();
        }
        this.state = null;
    }

    @Override
    public void setClip(WCPath wCPath, boolean bl2) {
        Object object;
        Affine3D affine3D = new Affine3D(this.state.getTransformNoClone());
        wCPath.transform(affine3D.getMxx(), affine3D.getMyx(), affine3D.getMxy(), affine3D.getMyy(), affine3D.getMxt(), affine3D.getMyt());
        if (!bl2) {
            object = wCPath.getBounds();
            int n2 = (int)Math.floor(((WCRectangle)object).getX());
            int n3 = (int)Math.floor(((WCRectangle)object).getY());
            int n4 = (int)Math.ceil(((WCRectangle)object).getMaxX()) - n2;
            int n5 = (int)Math.ceil(((WCRectangle)object).getMaxY()) - n3;
            this.state.clip(new Rectangle(n2, n3, n4, n5));
        }
        object = this.state.getClipNoClone();
        if (bl2) {
            wCPath.addRect(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
        }
        wCPath.translate(-((Rectangle)object).x, -((Rectangle)object).y);
        WCGraphicsPrismContext$ClipLayer wCGraphicsPrismContext$ClipLayer = new WCGraphicsPrismContext$ClipLayer(this.getGraphics(false), (Rectangle)object, wCPath, this.type() == WCGraphicsPrismContext$Type.DEDICATED);
        this.startNewLayer(wCGraphicsPrismContext$ClipLayer);
        if (log.isLoggable(PlatformLogger$Level.FINE)) {
            log.fine("setClip(WCPath " + wCPath.getID() + ")");
            log.fine("Pushed layer " + wCGraphicsPrismContext$ClipLayer);
        }
    }

    private Rectangle transformClip(Rectangle rectangle) {
        if (rectangle == null) {
            return null;
        }
        float[] fArray = new float[]{rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y, rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y + rectangle.height};
        this.state.getTransformNoClone().transform(fArray, 0, fArray, 0, 4);
        float f2 = Math.min(fArray[0], Math.min(fArray[2], Math.min(fArray[4], fArray[6])));
        float f3 = Math.max(fArray[0], Math.max(fArray[2], Math.max(fArray[4], fArray[6])));
        float f4 = Math.min(fArray[1], Math.min(fArray[3], Math.min(fArray[5], fArray[7])));
        float f5 = Math.max(fArray[1], Math.max(fArray[3], Math.max(fArray[5], fArray[7])));
        return new Rectangle(new RectBounds(f2, f4, f3, f5));
    }

    private void setClip(Rectangle rectangle) {
        Affine3D affine3D = this.state.getTransformNoClone();
        if (affine3D.getMxy() == 0.0 && affine3D.getMxz() == 0.0 && affine3D.getMyx() == 0.0 && affine3D.getMyz() == 0.0 && affine3D.getMzx() == 0.0 && affine3D.getMzy() == 0.0) {
            Rectangle rectangle2;
            this.state.clip(this.transformClip(rectangle));
            if (log.isLoggable(PlatformLogger$Level.FINE)) {
                log.fine("setClip({0})", rectangle);
            }
            if (DEBUG_DRAW_CLIP_SHAPE && (rectangle2 = this.state.getClipNoClone()) != null && rectangle2.width >= 2 && rectangle2.height >= 2) {
                WCTransform wCTransform = this.getTransform();
                this.setTransform(new WCTransform(1.0, 0.0, 0.0, 1.0, 0.0, 0.0));
                Graphics graphics = this.getGraphics(true);
                if (graphics != null) {
                    float f2 = (float)Math.random();
                    graphics.setPaint(new Color(f2, 1.0f - f2, 0.5f, 0.1f));
                    graphics.setStroke(new BasicStroke());
                    graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    graphics.setPaint(new Color(1.0f - f2, f2, 0.5f, 1.0f));
                    graphics.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
                this.setTransform(wCTransform);
                this.state.clip(new Rectangle(rectangle2.x + 1, rectangle2.y + 1, rectangle2.width - 2, rectangle2.height - 2));
            }
            if (this.cachedGraphics != null) {
                this.cachedGraphics.setClipRect(this.state.getClipNoClone());
            }
        } else {
            WCPathImpl wCPathImpl = new WCPathImpl();
            ((WCPath)wCPathImpl).addRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.setClip(wCPathImpl, false);
        }
    }

    @Override
    public void setClip(int n2, int n3, int n4, int n5) {
        this.setClip(new Rectangle(n2, n3, n4, n5));
    }

    @Override
    public void setClip(WCRectangle wCRectangle) {
        this.setClip(new Rectangle((int)wCRectangle.getX(), (int)wCRectangle.getY(), (int)wCRectangle.getWidth(), (int)wCRectangle.getHeight()));
    }

    @Override
    public WCRectangle getClip() {
        Rectangle rectangle = this.state.getClipNoClone();
        return rectangle == null ? null : new WCRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    protected Rectangle getClipRectNoClone() {
        return this.state.getClipNoClone();
    }

    protected Affine3D getTransformNoClone() {
        return this.state.getTransformNoClone();
    }

    @Override
    public void translate(float f2, float f3) {
        if (log.isLoggable(PlatformLogger$Level.FINE)) {
            log.fine("translate({0},{1})", Float.valueOf(f2), Float.valueOf(f3));
        }
        this.state.translate(f2, f3);
        if (this.cachedGraphics != null) {
            this.cachedGraphics.translate(f2, f3);
        }
    }

    @Override
    public void scale(float f2, float f3) {
        if (log.isLoggable(PlatformLogger$Level.FINE)) {
            log.fine("scale(" + f2 + " " + f3 + ")");
        }
        this.state.scale(f2, f3);
        if (this.cachedGraphics != null) {
            this.cachedGraphics.scale(f2, f3);
        }
    }

    @Override
    public void rotate(float f2) {
        if (log.isLoggable(PlatformLogger$Level.FINE)) {
            log.fine("rotate(" + f2 + ")");
        }
        this.state.rotate(f2);
        if (this.cachedGraphics != null) {
            this.cachedGraphics.setTransform(this.state.getTransformNoClone());
        }
    }

    protected boolean shouldRenderRect(float f2, float f3, float f4, float f5, DropShadow dropShadow, BasicStroke basicStroke) {
        return true;
    }

    protected boolean shouldRenderShape(Shape shape, DropShadow dropShadow, BasicStroke basicStroke) {
        return true;
    }

    protected boolean shouldCalculateIntersection() {
        return false;
    }

    @Override
    public void fillRect(float f2, float f3, float f4, float f5, Color color) {
        if (log.isLoggable(PlatformLogger$Level.FINE)) {
            String string = "fillRect(%f, %f, %f, %f, %s)";
            log.fine(String.format(string, Float.valueOf(f2), Float.valueOf(f3), Float.valueOf(f4), Float.valueOf(f5), color));
        }
        if (!this.shouldRenderRect(f2, f3, f4, f5, this.state.getShadowNoClone(), null)) {
            return;
        }
        new WCGraphicsPrismContext$1(this, color, f2, f3, f4, f5).paint();
    }

    @Override
    public void fillRoundedRect(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, Color color) {
        if (log.isLoggable(PlatformLogger$Level.FINE)) {
            log.fine(String.format("fillRoundedRect(%f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %s)", Float.valueOf(f2), Float.valueOf(f3), Float.valueOf(f4), Float.valueOf(f5), Float.valueOf(f6), Float.valueOf(f7), Float.valueOf(f8), Float.valueOf(f9), Float.valueOf(f10), Float.valueOf(f11), Float.valueOf(f12), Float.valueOf(f13), color));
        }
        if (!this.shouldRenderRect(f2, f3, f4, f5, this.state.getShadowNoClone(), null)) {
            return;
        }
        new WCGraphicsPrismContext$2(this, f6, f8, f10, f12, f7, f9, f11, f13, f2, f3, f4, f5, color).paint();
    }

    @Override
    public void clearRect(float f2, float f3, float f4, float f5) {
        if (log.isLoggable(PlatformLogger$Level.FINE)) {
            log.fine(String.format("clearRect(%f, %f, %f, %f)", Float.valueOf(f2), Float.valueOf(f3), Float.valueOf(f4), Float.valueOf(f5)));
        }
        if (this.shouldCalculateIntersection()) {
            return;
        }
        new WCGraphicsPrismContext$3(this, f2, f3, f4, f5).paint();
    }

    @Override
    public void setFillColor(Color color) {
        if (log.isLoggable(PlatformLogger$Level.FINE)) {
            log.fine(String.format("setFillColor(%s)", color));
        }
        this.state.setPaint(color);
    }

    @Override
    public void setFillGradient(WCGradient wCGradient) {
        if (log.isLoggable(PlatformLogger$Level.FINE)) {
            log.fine("setFillGradient(" + wCGradient + ")");
        }
        this.state.setPaint((Gradient)wCGradient.getPlatformGradient());
    }

    @Override
    public void setTextMode(boolean bl2, boolean bl3, boolean bl4) {
        if (log.isLoggable(PlatformLogger$Level.FINE)) {
            log.fine("setTextMode(fill:" + bl2 + ",stroke:" + bl3 + ",clip:" + bl4 + ")");
        }
        this.state.setTextMode(bl2, bl3, bl4);
    }

    @Override
    public void setFontSmoothingType(int n2) {
        this.fontSmoothingType = n2;
    }

    @Override
    public int getFontSmoothingType() {
        return this.fontSmoothingType;
    }

    @Override
    public void setStrokeStyle(int n2) {
        if (log.isLoggable(PlatformLogger$Level.FINE)) {
            log.fine("setStrokeStyle({0})", n2);
        }
        this.state.getStrokeNoClone().setStyle(n2);
    }

    @Override
    public void setStrokeColor(Color color) {
        if (log.isLoggable(PlatformLogger$Level.FINE)) {
            log.fine(String.format("setStrokeColor(%s)", color));
        }
        this.state.getStrokeNoClone().setPaint(color);
    }

    @Override
    public void setStrokeWidth(float f2) {
        if (log.isLoggable(PlatformLogger$Level.FINE)) {
            log.fine("setStrokeWidth({0})", Float.valueOf(f2));
        }
        this.state.getStrokeNoClone().setThickness(f2);
    }

    @Override
    public void setStrokeGradient(WCGradient wCGradient) {
        if (log.isLoggable(PlatformLogger$Level.FINE)) {
            log.fine("setStrokeGradient(" + wCGradient + ")");
        }
        this.state.getStrokeNoClone().setPaint((Gradient)wCGradient.getPlatformGradient());
    }

    @Override
    public void setLineDash(float f2, float ... fArray) {
        int n2;
        if (log.isLoggable(PlatformLogger$Level.FINE)) {
            StringBuilder stringBuilder = new StringBuilder("[");
            for (n2 = 0; n2 < fArray.length; ++n2) {
                stringBuilder.append(fArray[n2]).append(',');
            }
            stringBuilder.append(']');
            log.fine("setLineDash({0},{1}", Float.valueOf(f2), stringBuilder);
        }
        this.state.getStrokeNoClone().setDashOffset(f2);
        if (fArray != null) {
            boolean bl2 = true;
            for (n2 = 0; n2 < fArray.length; ++n2) {
                if (fArray[n2] == 0.0f) continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                fArray = null;
            }
        }
        this.state.getStrokeNoClone().setDashSizes(fArray);
    }

    @Override
    public void setLineCap(int n2) {
        if (log.isLoggable(PlatformLogger$Level.FINE)) {
            log.fine("setLineCap(" + n2 + ")");
        }
        this.state.getStrokeNoClone().setLineCap(n2);
    }

    @Override
    public void setLineJoin(int n2) {
        if (log.isLoggable(PlatformLogger$Level.FINE)) {
            log.fine("setLineJoin(" + n2 + ")");
        }
        this.state.getStrokeNoClone().setLineJoin(n2);
    }

    @Override
    public void setMiterLimit(float f2) {
        if (log.isLoggable(PlatformLogger$Level.FINE)) {
            log.fine("setMiterLimit(" + f2 + ")");
        }
        this.state.getStrokeNoClone().setMiterLimit(f2);
    }

    @Override
    public void setShadow(float f2, float f3, float f4, Color color) {
        if (log.isLoggable(PlatformLogger$Level.FINE)) {
            String string = "setShadow(%f, %f, %f, %s)";
            log.fine(String.format(string, Float.valueOf(f2), Float.valueOf(f3), Float.valueOf(f4), color));
        }
        this.state.setShadow(this.createShadow(f2, f3, f4, color));
    }

    @Override
    public void drawPolygon(WCPath wCPath, boolean bl2) {
        if (log.isLoggable(PlatformLogger$Level.FINE)) {
            log.fine("drawPolygon({0})", bl2);
        }
        if (!this.shouldRenderShape(((WCPathImpl)wCPath).getPlatformPath(), null, this.state.getStrokeNoClone().getPlatformStroke())) {
            return;
        }
        new WCGraphicsPrismContext$4(this, wCPath).paint();
    }

    @Override
    public void drawLine(int n2, int n3, int n4, int n5) {
        Line2D line2D;
        if (log.isLoggable(PlatformLogger$Level.FINE)) {
            log.fine("drawLine({0}, {1}, {2}, {3})", n2, n3, n4, n5);
        }
        if (!this.shouldRenderShape(line2D = new Line2D(n2, n3, n4, n5), null, this.state.getStrokeNoClone().getPlatformStroke())) {
            return;
        }
        new WCGraphicsPrismContext$5(this, n2, n3, n4, n5).paint();
    }

    @Override
    public void drawPattern(WCImage wCImage, WCRectangle wCRectangle, WCTransform wCTransform, WCPoint wCPoint, WCRectangle wCRectangle2) {
        if (log.isLoggable(PlatformLogger$Level.FINE)) {
            log.fine("drawPattern({0}, {1}, {2}, {3})", wCRectangle2.getIntX(), wCRectangle2.getIntY(), wCRectangle2.getIntWidth(), wCRectangle2.getIntHeight());
        }
        if (!this.shouldRenderRect(wCRectangle2.getX(), wCRectangle2.getY(), wCRectangle2.getWidth(), wCRectangle2.getHeight(), null, null)) {
            return;
        }
        if (wCImage != null) {
            new WCGraphicsPrismContext$6(this, wCImage, wCRectangle, wCTransform, wCPoint, wCRectangle2).paint();
        }
    }

    @Override
    public void drawImage(WCImage wCImage, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        if (log.isLoggable(PlatformLogger$Level.FINE)) {
            log.fine("drawImage(img, dst({0},{1},{2},{3}), src({4},{5},{6},{7}))", Float.valueOf(f2), Float.valueOf(f3), Float.valueOf(f4), Float.valueOf(f5), Float.valueOf(f6), Float.valueOf(f7), Float.valueOf(f8), Float.valueOf(f9));
        }
        if (!this.shouldRenderRect(f2, f3, f4, f5, this.state.getShadowNoClone(), null)) {
            return;
        }
        if (wCImage instanceof PrismImage) {
            new WCGraphicsPrismContext$7(this, wCImage, f2, f3, f6, f7, f8, f9, f4, f5).paint();
        }
    }

    @Override
    public void drawBitmapImage(ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
        if (!this.shouldRenderRect(n2, n3, n4, n5, null, null)) {
            return;
        }
        new WCGraphicsPrismContext$8(this, byteBuffer, n4, n5, n2, n3).paint();
    }

    @Override
    public void drawIcon(WCIcon wCIcon, int n2, int n3) {
        if (log.isLoggable(PlatformLogger$Level.FINE)) {
            log.fine("UNIMPLEMENTED drawIcon ({0}, {1})", n2, n3);
        }
    }

    @Override
    public void drawRect(int n2, int n3, int n4, int n5) {
        if (log.isLoggable(PlatformLogger$Level.FINE)) {
            log.fine("drawRect({0}, {1}, {2}, {3})", n2, n3, n4, n5);
        }
        if (!this.shouldRenderRect(n2, n3, n4, n5, null, this.state.getStrokeNoClone().getPlatformStroke())) {
            return;
        }
        new WCGraphicsPrismContext$9(this, n2, n3, n4, n5).paint();
    }

    @Override
    public void drawString(WCFont wCFont, int[] nArray, float[] fArray, float f2, float f3) {
        if (log.isLoggable(PlatformLogger$Level.FINE)) {
            log.fine(String.format("Drawing %d glyphs @(%.1f, %.1f)", nArray.length, Float.valueOf(f2), Float.valueOf(f3)));
        }
        PGFont pGFont = (PGFont)wCFont.getPlatformFont();
        TextRun textRun = TextUtilities.createGlyphList(nArray, fArray, f2, f3);
        DropShadow dropShadow = this.state.getShadowNoClone();
        BasicStroke basicStroke = this.state.isTextStroke() ? this.state.getStrokeNoClone().getPlatformStroke() : null;
        FontStrike fontStrike = pGFont.getStrike(this.getTransformNoClone(), this.getFontSmoothingType());
        if (this.shouldCalculateIntersection()) {
            Metrics metrics = fontStrike.getMetrics();
            textRun.setMetrics(metrics.getAscent(), metrics.getDescent(), metrics.getLineGap());
            if (!this.shouldRenderRect(f2, f3, textRun.getWidth(), textRun.getHeight(), dropShadow, basicStroke)) {
                return;
            }
        }
        new WCGraphicsPrismContext$10(this, dropShadow, textRun, pGFont, basicStroke, fontStrike, f2, f3).paint();
    }

    @Override
    public void drawString(WCFont wCFont, String string, boolean bl2, int n2, int n3, float f2, float f3) {
        GlyphList[] glyphListArray;
        if (log.isLoggable(PlatformLogger$Level.FINE)) {
            log.fine(String.format("str='%s' (length=%d), from=%d, to=%d, rtl=%b, @(%.1f, %.1f)", string, string.length(), n2, n3, bl2, Float.valueOf(f2), Float.valueOf(f3)));
        }
        TextLayout textLayout = TextUtilities.createLayout(string.substring(n2, n3), wCFont.getPlatformFont());
        int n4 = 0;
        for (GlyphList glyphList : glyphListArray = textLayout.getRuns()) {
            n4 += glyphList.getGlyphCount();
        }
        int[] nArray = new int[n4];
        float[] fArray = new float[n4];
        n4 = 0;
        for (GlyphList glyphList : textLayout.getRuns()) {
            int n5 = glyphList.getGlyphCount();
            for (int i2 = 0; i2 < n5; ++i2) {
                nArray[n4] = glyphList.getGlyphCode(i2);
                fArray[n4] = glyphList.getPosX(i2 + 1) - glyphList.getPosX(i2);
                ++n4;
            }
        }
        f2 = bl2 ? (f2 += TextUtilities.getLayoutWidth(string.substring(n2), wCFont.getPlatformFont()) - textLayout.getBounds().getWidth()) : (f2 += TextUtilities.getLayoutWidth(string.substring(0, n2), wCFont.getPlatformFont()));
        this.drawString(wCFont, nArray, fArray, f2, f3);
    }

    @Override
    public void setComposite(int n2) {
        log.fine("setComposite({0})", n2);
        this.state.setCompositeOperation(n2);
    }

    @Override
    public void drawEllipse(int n2, int n3, int n4, int n5) {
        if (log.isLoggable(PlatformLogger$Level.FINE)) {
            log.fine("drawEllipse({0}, {1}, {2}, {3})", n2, n3, n4, n5);
        }
        if (!this.shouldRenderRect(n2, n3, n4, n5, null, this.state.getStrokeNoClone().getPlatformStroke())) {
            return;
        }
        new WCGraphicsPrismContext$11(this, n2, n3, n4, n5).paint();
    }

    @Override
    public void drawFocusRing(int n2, int n3, int n4, int n5, Color color) {
        if (log.isLoggable(PlatformLogger$Level.FINE)) {
            log.fine(String.format("drawFocusRing: %d, %d, %d, %d, %s", n2, n3, n4, n5, color));
        }
        if (!this.shouldRenderRect(n2, n3, n4, n5, null, focusRingStroke)) {
            return;
        }
        new WCGraphicsPrismContext$12(this, color, n2, n3, n4, n5).paint();
    }

    @Override
    public void setAlpha(float f2) {
        log.fine("setAlpha({0})", Float.valueOf(f2));
        this.state.setAlpha(f2);
        if (null != this.cachedGraphics) {
            this.cachedGraphics.setExtraAlpha(this.state.getAlpha());
        }
    }

    @Override
    public float getAlpha() {
        return this.state.getAlpha();
    }

    @Override
    public void beginTransparencyLayer(float f2) {
        WCGraphicsPrismContext$TransparencyLayer wCGraphicsPrismContext$TransparencyLayer = new WCGraphicsPrismContext$TransparencyLayer(this, this.getGraphics(false), this.state.getClipNoClone(), f2);
        if (log.isLoggable(PlatformLogger$Level.FINE)) {
            log.fine(String.format("beginTransparencyLayer(%s)", wCGraphicsPrismContext$TransparencyLayer));
        }
        this.state.markAsRestorePoint();
        this.startNewLayer(wCGraphicsPrismContext$TransparencyLayer);
    }

    @Override
    public void endTransparencyLayer() {
        if (log.isLoggable(PlatformLogger$Level.FINE)) {
            log.fine(String.format("endTransparencyLayer(%s)", this.state.getLayerNoClone()));
        }
        this.restoreState();
    }

    @Override
    public void drawWidget(RenderTheme renderTheme, Ref ref, int n2, int n3) {
        WCSize wCSize = renderTheme.getWidgetSize(ref);
        if (!this.shouldRenderRect(n2, n3, wCSize.getWidth(), wCSize.getHeight(), null, null)) {
            return;
        }
        new WCGraphicsPrismContext$13(this, renderTheme, ref, n2, n3).paint();
    }

    @Override
    public void drawScrollbar(ScrollBarTheme scrollBarTheme, Ref ref, int n2, int n3, int n4, int n5) {
        WCSize wCSize;
        if (log.isLoggable(PlatformLogger$Level.FINE)) {
            log.fine(String.format("drawScrollbar(%s, %s, x = %d, y = %d)", scrollBarTheme, ref, n2, n3));
        }
        if (!this.shouldRenderRect(n2, n3, (wCSize = scrollBarTheme.getWidgetSize(ref)).getWidth(), wCSize.getHeight(), null, null)) {
            return;
        }
        new WCGraphicsPrismContext$14(this, scrollBarTheme, ref, n2, n3, n4, n5).paint();
    }

    private static Rectangle intersect(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle == null) {
            return rectangle2;
        }
        RectBounds rectBounds = rectangle.toRectBounds();
        rectBounds.intersectWith(rectangle2);
        rectangle.setBounds(rectBounds);
        return rectangle;
    }

    private static Color4f createColor4f(Color color) {
        return new Color4f(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    private DropShadow createShadow(float f2, float f3, float f4, Color color) {
        if (f2 == 0.0f && f3 == 0.0f && f4 == 0.0f) {
            return null;
        }
        DropShadow dropShadow = new DropShadow();
        dropShadow.setOffsetX((int)f2);
        dropShadow.setOffsetY((int)f3);
        dropShadow.setRadius(f4 < 0.0f ? 0.0f : (f4 > 127.0f ? 127.0f : f4));
        dropShadow.setColor(WCGraphicsPrismContext.createColor4f(color));
        return dropShadow;
    }

    private void render(Graphics graphics, Effect effect, Paint paint, BasicStroke basicStroke, NGNode nGNode) {
        if (nGNode instanceof NGShape) {
            NGShape nGShape = (NGShape)nGNode;
            Shape shape = nGShape.getShape();
            Paint paint2 = (Paint)this.state.getStrokeNoClone().getPaint();
            if (basicStroke != null && paint2 != null) {
                shape = basicStroke.createStrokedShape(shape);
                nGShape.setDrawStroke(basicStroke);
                nGShape.setDrawPaint(paint2);
                nGShape.setMode(paint == null ? NGShape$Mode.STROKE : NGShape$Mode.STROKE_FILL);
            } else {
                nGShape.setMode(paint == null ? NGShape$Mode.EMPTY : NGShape$Mode.FILL);
            }
            nGShape.setFillPaint(paint);
            nGShape.setContentBounds(shape.getBounds());
        }
        boolean bl2 = graphics.hasPreCullingBits();
        graphics.setHasPreCullingBits(false);
        nGNode.setEffect(effect);
        nGNode.render(graphics);
        graphics.setHasPreCullingBits(bl2);
    }

    private static FilterContext getFilterContext(Graphics graphics) {
        Screen screen = graphics.getAssociatedScreen();
        if (screen == null) {
            ResourceFactory resourceFactory = graphics.getResourceFactory();
            return PrFilterContext.getPrinterContext(resourceFactory);
        }
        return PrFilterContext.getInstance(screen);
    }

    @Override
    public void strokeArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (log.isLoggable(PlatformLogger$Level.FINE)) {
            log.fine(String.format("strokeArc(%d, %d, %d, %d, %d, %d)", n2, n3, n4, n5, n6, n7));
        }
        Arc2D arc2D = new Arc2D(n2, n3, n4, n5, n6, n7, 0);
        if (this.state.getStrokeNoClone().isApplicable() && !this.shouldRenderShape(arc2D, null, this.state.getStrokeNoClone().getPlatformStroke())) {
            return;
        }
        new WCGraphicsPrismContext$15(this, arc2D).paint();
    }

    @Override
    public WCImage getImage() {
        return null;
    }

    @Override
    public void strokeRect(float f2, float f3, float f4, float f5, float f6) {
        BasicStroke basicStroke;
        if (log.isLoggable(PlatformLogger$Level.FINE)) {
            log.fine(String.format("strokeRect_FFFFF(%f, %f, %f, %f, %f)", Float.valueOf(f2), Float.valueOf(f3), Float.valueOf(f4), Float.valueOf(f5), Float.valueOf(f6)));
        }
        if (!this.shouldRenderRect(f2, f3, f4, f5, null, basicStroke = new BasicStroke(f6, 0, 0, Math.max(1.0f, f6), this.state.getStrokeNoClone().getDashSizes(), this.state.getStrokeNoClone().getDashOffset()))) {
            return;
        }
        new WCGraphicsPrismContext$16(this, basicStroke, f2, f3, f4, f5).paint();
    }

    @Override
    public void strokePath(WCPath wCPath) {
        log.fine("strokePath");
        if (wCPath != null) {
            BasicStroke basicStroke = this.state.getStrokeNoClone().getPlatformStroke();
            DropShadow dropShadow = this.state.getShadowNoClone();
            Path2D path2D = (Path2D)wCPath.getPlatformPath();
            if (basicStroke == null && dropShadow == null || !this.shouldRenderShape(path2D, dropShadow, basicStroke)) {
                return;
            }
            new WCGraphicsPrismContext$17(this, dropShadow, path2D, basicStroke).paint();
        }
    }

    @Override
    public void fillPath(WCPath wCPath) {
        log.fine("fillPath");
        if (wCPath != null) {
            if (!this.shouldRenderShape(((WCPathImpl)wCPath).getPlatformPath(), this.state.getShadowNoClone(), null)) {
                return;
            }
            new WCGraphicsPrismContext$18(this, wCPath).paint();
        }
    }

    @Override
    public void setPerspectiveTransform(WCTransform wCTransform) {
        GeneralTransform3D generalTransform3D = new GeneralTransform3D().set(wCTransform.getMatrix());
        this.state.setPerspectiveTransform(generalTransform3D);
        this.resetCachedGraphics();
    }

    @Override
    public void setTransform(WCTransform wCTransform) {
        double[] dArray = wCTransform.getMatrix();
        Affine3D affine3D = new Affine3D(new Affine2D(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]));
        if (this.state.getLayerNoClone() == null) {
            affine3D.preConcatenate(this.baseTransform);
        }
        this.state.setTransform(affine3D);
        this.resetCachedGraphics();
    }

    @Override
    public WCTransform getTransform() {
        Affine3D affine3D = this.state.getTransformNoClone();
        return new WCTransform(affine3D.getMxx(), affine3D.getMyx(), affine3D.getMxy(), affine3D.getMyy(), affine3D.getMxt(), affine3D.getMyt());
    }

    @Override
    public void concatTransform(WCTransform wCTransform) {
        double[] dArray = wCTransform.getMatrix();
        Affine3D affine3D = new Affine3D(new Affine2D(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]));
        this.state.concatTransform(affine3D);
        this.resetCachedGraphics();
    }

    @Override
    public void flush() {
        if (!this.isValid()) {
            log.fine("WCGraphicsPrismContext::flush : GC is invalid");
            return;
        }
        this.flushAllLayers();
    }

    @Override
    public WCGradient createLinearGradient(WCPoint wCPoint, WCPoint wCPoint2) {
        return new WCLinearGradient(wCPoint, wCPoint2);
    }

    @Override
    public WCGradient createRadialGradient(WCPoint wCPoint, float f2, WCPoint wCPoint2, float f3) {
        return new WCRadialGradient(wCPoint, f2, wCPoint2, f3);
    }
}

