/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit.prism;

import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.webkit.prism.WCGraphicsPrismContext;
import com.sun.prism.Graphics;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.RTTexture;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture$WrapMode;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.prism.PrDrawable;
import com.sun.scenario.effect.impl.prism.PrRenderer;

abstract class WCGraphicsPrismContext$Layer {
    FilterContext fctx;
    PrDrawable buffer;
    Graphics graphics;
    final Rectangle bounds;
    boolean permanent;

    WCGraphicsPrismContext$Layer(Graphics graphics, Rectangle rectangle, boolean bl2) {
        this.bounds = new Rectangle(rectangle);
        this.permanent = bl2;
        int n2 = Math.max(rectangle.width, 1);
        int n3 = Math.max(rectangle.height, 1);
        this.fctx = WCGraphicsPrismContext.getFilterContext(graphics);
        if (bl2) {
            ResourceFactory resourceFactory = GraphicsPipeline.getDefaultResourceFactory();
            if (resourceFactory != null && !resourceFactory.isDisposed()) {
                RTTexture rTTexture = resourceFactory.createRTTexture(n2, n3, Texture$WrapMode.CLAMP_NOT_NEEDED);
                rTTexture.makePermanent();
                this.buffer = ((PrRenderer)Renderer.getRenderer(this.fctx)).createDrawable(rTTexture);
            } else {
                WCGraphicsPrismContext.log.fine("Layer :: cannot construct RTT because device disposed or not ready");
                this.fctx = null;
                this.buffer = null;
            }
        } else {
            this.buffer = (PrDrawable)Effect.getCompatibleImage(this.fctx, n2, n3);
        }
    }

    Graphics getGraphics() {
        if (this.graphics == null && this.buffer != null) {
            this.graphics = this.buffer.createGraphics();
        }
        return this.graphics;
    }

    abstract void init(Graphics var1);

    abstract void render(Graphics var1);

    private void dispose() {
        if (this.buffer != null) {
            if (this.permanent) {
                this.buffer.flush();
            } else {
                Effect.releaseCompatibleImage(this.fctx, this.buffer);
            }
            this.fctx = null;
            this.buffer = null;
        }
    }

    private double getX() {
        return this.bounds.x;
    }

    private double getY() {
        return this.bounds.y;
    }
}

