/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit.prism;

import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.webkit.prism.PrismGraphicsManager;
import com.sun.javafx.webkit.prism.PrismImage;
import com.sun.javafx.webkit.prism.PrismInvoker;
import com.sun.javafx.webkit.prism.RTImage$1;
import com.sun.prism.CompositeMode;
import com.sun.prism.Graphics;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.Image;
import com.sun.prism.PixelFormat;
import com.sun.prism.PrinterGraphics;
import com.sun.prism.RTTexture;
import com.sun.prism.ResourceFactory;
import com.sun.prism.ResourceFactoryListener;
import com.sun.prism.Texture;
import com.sun.prism.Texture$Usage;
import com.sun.prism.Texture$WrapMode;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Paint;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

final class RTImage
extends PrismImage
implements ResourceFactoryListener {
    private RTTexture txt;
    private final int width;
    private final int height;
    private WeakReference<ResourceFactory> registeredWithFactory = null;
    private ByteBuffer pixelBuffer;
    private float pixelScale;
    private static final PlatformLogger log = PlatformLogger.getLogger(RTImage.class.getName());

    RTImage(int n2, int n3, float f2) {
        if (Float.isNaN(f2) || f2 <= 0.0f || Math.ceil(f2) >= 2.147483647E9) {
            throw new IllegalArgumentException("pixelScale out of range");
        }
        if (n2 <= 0 || n3 <= 0) {
            throw new IllegalArgumentException("image size must be positive");
        }
        int n4 = (int)Math.ceil(f2);
        int n5 = Math.max(n4, 4);
        int n6 = Integer.MAX_VALUE / n5;
        if (n6 / n2 <= n3) {
            throw new IllegalArgumentException("image size out of range");
        }
        this.width = n2;
        this.height = n3;
        this.pixelScale = f2;
    }

    @Override
    Image getImage() {
        return Image.fromByteBgraPreData(this.getPixelBuffer(), this.getWidth(), this.getHeight());
    }

    @Override
    Graphics getGraphics() {
        RTTexture rTTexture = this.getTexture();
        if (rTTexture == null) {
            return null;
        }
        Graphics graphics = rTTexture.createGraphics();
        graphics.transform(PrismGraphicsManager.getPixelScaleTransform());
        return graphics;
    }

    private RTTexture getTexture() {
        ResourceFactory resourceFactory;
        if (this.txt != null && this.txt.isSurfaceLost()) {
            log.fine("RTImage::getTexture : surface lost: " + this);
        }
        if ((resourceFactory = GraphicsPipeline.getDefaultResourceFactory()) == null || resourceFactory.isDisposed()) {
            log.fine("RTImage::getTexture : return null because device disposed or not ready");
            return null;
        }
        if (this.txt == null) {
            this.txt = resourceFactory.createRTTexture((int)Math.ceil((float)this.width * this.pixelScale), (int)Math.ceil((float)this.height * this.pixelScale), Texture$WrapMode.CLAMP_NOT_NEEDED);
            this.txt.contentsUseful();
            this.txt.makePermanent();
            if (this.registeredWithFactory == null || this.registeredWithFactory.get() != resourceFactory) {
                resourceFactory.addFactoryListener(this);
                this.registeredWithFactory = new WeakReference<ResourceFactory>(resourceFactory);
            }
        }
        return this.txt;
    }

    @Override
    void draw(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        if (this.txt == null && graphics.getCompositeMode() == CompositeMode.SRC_OVER) {
            return;
        }
        if (graphics.getResourceFactory().isDisposed()) {
            log.fine("RTImage::draw : skip because device has been disposed");
            return;
        }
        if (graphics instanceof PrinterGraphics) {
            int n10 = n8 - n6;
            int n11 = n9 - n7;
            IntBuffer intBuffer = IntBuffer.allocate(n10 * n11);
            PrismInvoker.runOnRenderThread(() -> this.getTexture().readPixels(intBuffer));
            Image image = Image.fromIntArgbPreData(intBuffer, n10, n11);
            Texture texture = graphics.getResourceFactory().createTexture(image, Texture$Usage.STATIC, Texture$WrapMode.CLAMP_NOT_NEEDED);
            graphics.drawTexture(texture, n2, n3, n4, n5, 0.0f, 0.0f, n10, n11);
            texture.dispose();
        } else if (this.txt == null) {
            Paint paint = graphics.getPaint();
            graphics.setPaint(Color.TRANSPARENT);
            graphics.fillQuad(n2, n3, n4, n5);
            graphics.setPaint(paint);
        } else {
            graphics.drawTexture(this.txt, n2, n3, n4, n5, (float)n6 * this.pixelScale, (float)n7 * this.pixelScale, (float)n8 * this.pixelScale, (float)n9 * this.pixelScale);
        }
    }

    @Override
    void dispose() {
        PrismInvoker.invokeOnRenderThread(() -> {
            if (this.txt != null) {
                this.txt.dispose();
                this.txt = null;
            }
        });
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public ByteBuffer getPixelBuffer() {
        boolean bl2 = false;
        if (this.pixelBuffer == null) {
            this.pixelBuffer = ByteBuffer.allocateDirect(this.width * this.height * 4);
            if (this.pixelBuffer != null) {
                this.pixelBuffer.order(ByteOrder.nativeOrder());
                bl2 = true;
            }
        }
        if (bl2 || this.isDirty()) {
            PrismInvoker.runOnRenderThread(() -> {
                ResourceFactory resourceFactory = GraphicsPipeline.getDefaultResourceFactory();
                if (resourceFactory == null || resourceFactory.isDisposed()) {
                    log.fine("RTImage::getPixelBuffer : skip because device disposed or not ready");
                    return;
                }
                this.flushRQ();
                if (this.txt != null && this.pixelBuffer != null) {
                    Object object;
                    PixelFormat pixelFormat = this.txt.getPixelFormat();
                    if (pixelFormat != PixelFormat.INT_ARGB_PRE && pixelFormat != PixelFormat.BYTE_BGRA_PRE) {
                        throw new AssertionError((Object)("Unexpected pixel format: " + pixelFormat));
                    }
                    RTTexture rTTexture = this.txt;
                    if (this.pixelScale != 1.0f) {
                        rTTexture = resourceFactory.createRTTexture(this.width, this.height, Texture$WrapMode.CLAMP_NOT_NEEDED);
                        object = rTTexture.createGraphics();
                        object.drawTexture(this.txt, 0.0f, 0.0f, this.width, this.height, 0.0f, 0.0f, (float)this.width * this.pixelScale, (float)this.height * this.pixelScale);
                    }
                    this.pixelBuffer.rewind();
                    object = rTTexture.getPixels();
                    if (object != null) {
                        this.pixelBuffer.asIntBuffer().put((int[])object);
                    } else {
                        rTTexture.readPixels(this.pixelBuffer);
                    }
                    if (rTTexture != this.txt) {
                        rTTexture.dispose();
                    }
                }
            });
        }
        return this.pixelBuffer;
    }

    @Override
    protected void drawPixelBuffer() {
        PrismInvoker.invokeOnRenderThread(new RTImage$1(this));
    }

    @Override
    public void factoryReset() {
        if (this.txt != null) {
            this.txt.dispose();
            this.txt = null;
        }
    }

    @Override
    public void factoryReleased() {
        if (this.txt != null) {
            this.txt.dispose();
            this.txt = null;
        }
    }

    @Override
    public float getPixelScale() {
        return this.pixelScale;
    }
}

