/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.events.KeyEvent;
import com.sun.glass.ui.Application;
import com.sun.glass.ui.ClipboardAssistance;
import com.sun.glass.ui.CommonDialogs;
import com.sun.glass.ui.CommonDialogs$ExtensionFilter;
import com.sun.glass.ui.CommonDialogs$FileChooserResult;
import com.sun.glass.ui.EventLoop;
import com.sun.glass.ui.GlassRobot;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.Timer;
import com.sun.glass.ui.View;
import com.sun.javafx.PlatformUtil;
import com.sun.javafx.embed.HostInterface;
import com.sun.javafx.font.PrismFontLoader;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.logging.PulseLogger;
import com.sun.javafx.perf.PerformanceTracker;
import com.sun.javafx.runtime.async.AbstractRemoteResource;
import com.sun.javafx.runtime.async.AsyncOperationListener;
import com.sun.javafx.scene.input.DragboardHelper;
import com.sun.javafx.scene.text.TextLayoutFactory;
import com.sun.javafx.text.PrismTextLayoutFactory;
import com.sun.javafx.tk.CompletionListener;
import com.sun.javafx.tk.FileChooserType;
import com.sun.javafx.tk.FontLoader;
import com.sun.javafx.tk.ImageLoader;
import com.sun.javafx.tk.PlatformImage;
import com.sun.javafx.tk.RenderJob;
import com.sun.javafx.tk.ScreenConfigurationAccessor;
import com.sun.javafx.tk.TKClipboard;
import com.sun.javafx.tk.TKDragGestureListener;
import com.sun.javafx.tk.TKDragSourceListener;
import com.sun.javafx.tk.TKDropTargetListener;
import com.sun.javafx.tk.TKScene;
import com.sun.javafx.tk.TKScreenConfigurationListener;
import com.sun.javafx.tk.TKStage;
import com.sun.javafx.tk.TKSystemMenu;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.tk.Toolkit$ImageRenderingContext;
import com.sun.javafx.tk.Toolkit$Task;
import com.sun.javafx.tk.quantum.CursorUtils;
import com.sun.javafx.tk.quantum.EmbeddedStage;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.GlassStage;
import com.sun.javafx.tk.quantum.GlassSystemMenu;
import com.sun.javafx.tk.quantum.PaintCollector;
import com.sun.javafx.tk.quantum.PaintRenderJob;
import com.sun.javafx.tk.quantum.PathIteratorHelper;
import com.sun.javafx.tk.quantum.PathIteratorHelper$Struct;
import com.sun.javafx.tk.quantum.PerformanceTrackerImpl;
import com.sun.javafx.tk.quantum.PrimaryTimer;
import com.sun.javafx.tk.quantum.PrismImageLoader2;
import com.sun.javafx.tk.quantum.PrismImageLoader2$AsyncImageLoader;
import com.sun.javafx.tk.quantum.QuantumClipboard;
import com.sun.javafx.tk.quantum.QuantumRenderer;
import com.sun.javafx.tk.quantum.QuantumToolkit$1;
import com.sun.javafx.tk.quantum.QuantumToolkit$2;
import com.sun.javafx.tk.quantum.QuantumToolkit$3;
import com.sun.javafx.tk.quantum.QuantumToolkit$4;
import com.sun.javafx.tk.quantum.QuantumToolkit$5;
import com.sun.javafx.tk.quantum.QuantumToolkit$PulseTask;
import com.sun.javafx.tk.quantum.QuantumToolkit$QuantumImage;
import com.sun.javafx.tk.quantum.ViewPainter;
import com.sun.javafx.tk.quantum.WindowStage;
import com.sun.prism.BasicStroke;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.Image;
import com.sun.prism.PixelFormat;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.ImagePattern;
import com.sun.prism.paint.LinearGradient;
import com.sun.prism.paint.Paint;
import com.sun.prism.paint.RadialGradient;
import com.sun.prism.paint.Stop;
import com.sun.scenario.DelayedRunnable;
import com.sun.scenario.animation.AbstractPrimaryTimer;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.Filterable;
import com.sun.scenario.effect.impl.prism.PrFilterContext;
import com.sun.scenario.effect.impl.prism.PrImage;
import dev.protect.QQ;
import dev.protect.RB;
import dev.protect.RI;
import dev.protect.RL;
import dev.protect.RT;
import dev.protect.Rf;
import dev.protect.Sl;
import dev.protect.UM;
import dev.protect.UO;
import dev.protect.UP;
import dev.protect.UQ;
import dev.protect.UZ;
import dev.protect.VC;
import dev.protect.VV;
import dev.protect.Vb;
import dev.protect.Vy;
import dev.protect.WN;
import dev.protect.Wf;
import dev.protect.Wn;
import dev.protect.Ww;
import dev.protect.XO;
import dev.protect.XP;
import dev.protect.XQ;
import dev.protect.Xe;
import dev.protect.aaS;
import dev.protect.aaT;
import dev.protect.abe;
import dev.protect.abo;
import dev.protect.abp;
import dev.protect.pm;
import dev.protect.xj;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

public final class QuantumToolkit
extends Toolkit {
    public static final boolean verbose = AccessController.doPrivileged(() -> Boolean.getBoolean("quantum.verbose"));
    public static final boolean pulseDebug = AccessController.doPrivileged(() -> Boolean.getBoolean("quantum.pulse"));
    private static final boolean multithreaded = AccessController.doPrivileged(() -> {
        String string = System.getProperty("quantum.multithreaded");
        if (string == null) {
            return true;
        }
        boolean bl2 = Boolean.parseBoolean(string);
        if (verbose) {
            System.out.println(bl2 ? "Multi-Threading Enabled" : "Multi-Threading Disabled");
        }
        return bl2;
    });
    private static boolean debug = AccessController.doPrivileged(() -> Boolean.getBoolean("quantum.debug"));
    private static Integer pulseHZ = AccessController.doPrivileged(() -> Integer.getInteger("javafx.animation.pulse"));
    static final boolean liveResize = AccessController.doPrivileged(() -> {
        boolean bl2 = "swt".equals(System.getProperty("glass.platform"));
        String string = (PlatformUtil.isMac() || PlatformUtil.isWindows()) && !bl2 ? "true" : "false";
        return "true".equals(System.getProperty("javafx.live.resize", string));
    });
    static final boolean drawInPaint = AccessController.doPrivileged(() -> {
        boolean bl2 = "swt".equals(System.getProperty("glass.platform"));
        String string = PlatformUtil.isMac() && bl2 ? "true" : "false";
        return "true".equals(System.getProperty("javafx.draw.in.paint", string));
    });
    private static boolean singleThreaded = AccessController.doPrivileged(() -> {
        Boolean bl2 = Boolean.getBoolean("quantum.singlethreaded");
        if (bl2.booleanValue()) {
            System.out.println("Warning: Single GUI Threadiong is enabled, FPS should be slower");
        }
        return bl2;
    });
    private static boolean noRenderJobs = AccessController.doPrivileged(() -> {
        Boolean bl2 = Boolean.getBoolean("quantum.norenderjobs");
        if (bl2.booleanValue()) {
            System.out.println("Warning: Quantum will not submit render jobs, nothing should draw");
        }
        return bl2;
    });
    private AtomicBoolean toolkitRunning = new AtomicBoolean(false);
    private QuantumToolkit$PulseTask animationRunning = new QuantumToolkit$PulseTask(this, false);
    private QuantumToolkit$PulseTask nextPulseRequested = new QuantumToolkit$PulseTask(this, false);
    private AtomicBoolean pulseRunning = new AtomicBoolean(false);
    private int inPulse = 0;
    private CountDownLatch launchLatch = new CountDownLatch(1);
    final int PULSE_INTERVAL = (int)(TimeUnit.SECONDS.toMillis(1L) / (long)this.getRefreshRate());
    final int FULLSPEED_INTERVAL = 1;
    boolean nativeSystemVsync = false;
    private long firstPauseRequestTime = 0L;
    private boolean pauseRequested = false;
    private static final long PAUSE_THRESHOLD_DURATION = 250L;
    private float _maxPixelScale;
    private Runnable pulseRunnable;
    private Runnable userRunnable;
    private Runnable timerRunnable;
    private Timer pulseTimer = null;
    private Thread shutdownHook = null;
    private PaintCollector collector;
    private QuantumRenderer renderer;
    private GraphicsPipeline pipeline;
    private ClassLoader ccl;
    private HashMap<Object, EventLoop> eventLoopMap = null;
    private final PerformanceTracker perfTracker = new PerformanceTrackerImpl();
    private static ScreenConfigurationAccessor screenAccessor = new QuantumToolkit$3();
    private Map<Object, Object> contextMap = Collections.synchronizedMap(new HashMap());
    private DelayedRunnable animationRunnable;
    static BasicStroke tmpStroke = new BasicStroke();
    private QuantumClipboard clipboard;
    private GlassSystemMenu systemMenu = new GlassSystemMenu();

    @Override
    public boolean init() {
        this.renderer = QuantumRenderer.getInstance();
        this.collector = PaintCollector.createInstance(this);
        this.pipeline = GraphicsPipeline.getPipeline();
        this.shutdownHook = new QuantumToolkit$1(this, "Glass/Prism Shutdown Hook");
        Void void_ = AccessController.doPrivileged(() -> {
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            return null;
        });
        return true;
    }

    @Override
    public void startup(Runnable runnable) {
        this.ccl = Thread.currentThread().getContextClassLoader();
        try {
            this.userRunnable = runnable;
            Application.run(() -> this.runToolkit());
        }
        catch (RuntimeException runtimeException) {
            if (verbose) {
                runtimeException.printStackTrace();
            }
            throw runtimeException;
        }
        catch (Throwable throwable) {
            if (verbose) {
                throwable.printStackTrace();
            }
            throw new RuntimeException(throwable);
        }
        try {
            this.launchLatch.await();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void assertToolkitRunning() {
    }

    boolean shouldWaitForRenderingToComplete() {
        return !multithreaded;
    }

    private static void initSceneGraph() {
        abe.PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_();
    }

    void runToolkit() {
        Thread thread = Thread.currentThread();
        if (!this.toolkitRunning.getAndSet(true)) {
            thread.setName("JavaFX Application Thread");
            thread.setContextClassLoader(this.ccl);
            QuantumToolkit.setFxUserThread(thread);
            QuantumToolkit.assignScreensAdapters();
            this.renderer.createResourceFactory();
            this.pulseRunnable = () -> this.pulseFromQueue();
            this.timerRunnable = () -> {
                try {
                    this.postPulse();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(System.err);
                }
            };
            this.pulseTimer = Application.GetApplication().createTimer(this.timerRunnable);
            Application.GetApplication().setEventHandler(new QuantumToolkit$2(this));
        }
        QuantumToolkit.initSceneGraph();
        this.launchLatch.countDown();
        try {
            Application.invokeAndWait(this.userRunnable);
            if (this.getPrimaryTimer().isFullspeed()) {
                this.pulseTimer.start(1);
            } else {
                boolean bl2 = this.nativeSystemVsync = Screen.getVideoRefreshPeriod() != 0.0;
                if (this.nativeSystemVsync) {
                    this.pulseTimer.start();
                } else {
                    this.pulseTimer.start(this.PULSE_INTERVAL);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
        }
        finally {
            if (PrismSettings.verbose) {
                System.err.println(" vsync: " + PrismSettings.isVsyncEnabled + " vpipe: " + this.pipeline.isVsyncSupported());
            }
            PerformanceTracker.logEvent("Toolkit.startup - finished");
        }
    }

    public static <T> T runWithoutRenderLock(Supplier<T> supplier) {
        boolean bl2 = ViewPainter.renderLock.isHeldByCurrentThread();
        try {
            if (bl2) {
                ViewPainter.renderLock.unlock();
            }
            T t2 = supplier.get();
            return t2;
        }
        finally {
            if (bl2) {
                ViewPainter.renderLock.lock();
            }
        }
    }

    public static <T> T runWithRenderLock(Supplier<T> supplier) {
        ViewPainter.renderLock.lock();
        try {
            T t2 = supplier.get();
            return t2;
        }
        finally {
            ViewPainter.renderLock.unlock();
        }
    }

    boolean hasNativeSystemVsync() {
        return this.nativeSystemVsync;
    }

    boolean isVsyncEnabled() {
        return PrismSettings.isVsyncEnabled && this.pipeline.isVsyncSupported();
    }

    @Override
    public void checkFxUserThread() {
        super.checkFxUserThread();
        this.renderer.checkRendererIdle();
    }

    protected static Thread getFxUserThread() {
        return Toolkit.getFxUserThread();
    }

    @Override
    public Future addRenderJob(RenderJob renderJob) {
        if (noRenderJobs) {
            CompletionListener completionListener = renderJob.getCompletionListener();
            if (renderJob instanceof PaintRenderJob) {
                ((PaintRenderJob)renderJob).getScene().setPainting(false);
            }
            if (completionListener != null) {
                try {
                    completionListener.done(renderJob);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            return null;
        }
        if (singleThreaded) {
            renderJob.run();
            return null;
        }
        return this.renderer.submitRenderJob(renderJob);
    }

    void postPulse() {
        if (this.toolkitRunning.get() && (this.animationRunning.get() || this.nextPulseRequested.get()) && !this.setPulseRunning()) {
            Application.invokeLater(this.pulseRunnable);
            if (debug) {
                System.err.println("QT.postPulse@(" + System.nanoTime() + "): " + this.pulseString());
            }
        } else if (!(this.animationRunning.get() || this.nextPulseRequested.get() || this.pulseRunning.get())) {
            this.pauseTimer();
        } else if (debug) {
            System.err.println("QT.postPulse#(" + System.nanoTime() + "): DROP : " + this.pulseString());
        }
    }

    private synchronized void pauseTimer() {
        if (!this.pauseRequested) {
            this.pauseRequested = true;
            this.firstPauseRequestTime = System.currentTimeMillis();
        }
        if (System.currentTimeMillis() - this.firstPauseRequestTime >= 250L) {
            this.pulseTimer.pause();
            if (debug) {
                System.err.println("QT.pauseTimer#(" + System.nanoTime() + "): Pausing Timer : " + this.pulseString());
            }
        } else if (debug) {
            System.err.println("QT.pauseTimer#(" + System.nanoTime() + "): Pause Timer : DROP : " + this.pulseString());
        }
    }

    private synchronized void resumeTimer() {
        this.pauseRequested = false;
        this.pulseTimer.resume();
    }

    private String pulseString() {
        return (this.toolkitRunning.get() ? "T" : "t") + (this.animationRunning.get() ? "A" : "a") + (this.pulseRunning.get() ? "P" : "p") + (this.nextPulseRequested.get() ? "N" : "n");
    }

    private boolean setPulseRunning() {
        return this.pulseRunning.getAndSet(true);
    }

    private void endPulseRunning() {
        this.pulseRunning.set(false);
        if (debug) {
            System.err.println("QT.endPulse: " + System.nanoTime());
        }
    }

    void pulseFromQueue() {
        try {
            this.pulse();
        }
        finally {
            this.endPulseRunning();
        }
    }

    protected void pulse() {
        this.pulse(true);
    }

    void pulse(boolean bl2) {
        try {
            ++this.inPulse;
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.pulseStart();
            }
            if (!this.toolkitRunning.get()) {
                return;
            }
            this.nextPulseRequested.set(false);
            if (this.animationRunnable != null) {
                this.animationRunning.set(true);
                this.animationRunnable.run();
            } else {
                this.animationRunning.set(false);
            }
            this.firePulse();
            if (bl2) {
                this.collector.renderAll();
            }
        }
        finally {
            --this.inPulse;
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.pulseEnd();
            }
        }
    }

    void vsyncHint() {
        if (this.isVsyncEnabled()) {
            if (debug) {
                System.err.println("QT.vsyncHint: postPulse: " + System.nanoTime());
            }
            this.postPulse();
        }
    }

    @Override
    public TKStage createTKStage(abp abp2, boolean bl2, abo abo2, boolean bl3, aaT aaT2, TKStage tKStage, boolean bl4, AccessControlContext accessControlContext) {
        this.assertToolkitRunning();
        WindowStage windowStage = new WindowStage(abp2, bl2, abo2, aaT2, tKStage);
        windowStage.setSecurityContext(accessControlContext);
        if (bl3) {
            windowStage.setIsPrimary();
        }
        windowStage.setRTL(bl4);
        windowStage.init(this.systemMenu);
        return windowStage;
    }

    @Override
    public boolean canStartNestedEventLoop() {
        return this.inPulse == 0;
    }

    @Override
    public Object enterNestedEventLoop(Object object) {
        this.checkFxUserThread();
        if (object == null) {
            throw new NullPointerException();
        }
        if (!this.canStartNestedEventLoop()) {
            throw new IllegalStateException("Cannot enter nested loop during animation or layout processing");
        }
        if (this.eventLoopMap == null) {
            this.eventLoopMap = new HashMap();
        }
        if (this.eventLoopMap.containsKey(object)) {
            throw new IllegalArgumentException("Key already associated with a running event loop: " + object);
        }
        EventLoop eventLoop = Application.GetApplication().createEventLoop();
        this.eventLoopMap.put(object, eventLoop);
        Object object2 = eventLoop.enter();
        if (!this.isNestedLoopRunning()) {
            this.notifyLastNestedLoopExited();
        }
        return object2;
    }

    @Override
    public void exitNestedEventLoop(Object object, Object object2) {
        this.checkFxUserThread();
        if (object == null) {
            throw new NullPointerException();
        }
        if (this.eventLoopMap == null || !this.eventLoopMap.containsKey(object)) {
            throw new IllegalArgumentException("Key not associated with a running event loop: " + object);
        }
        EventLoop eventLoop = this.eventLoopMap.get(object);
        this.eventLoopMap.remove(object);
        eventLoop.leave(object2);
    }

    @Override
    public void exitAllNestedEventLoops() {
        this.checkFxUserThread();
        for (EventLoop eventLoop : this.eventLoopMap.values()) {
            eventLoop.leave(null);
        }
        this.eventLoopMap.clear();
        this.eventLoopMap = null;
    }

    @Override
    public TKStage createTKPopupStage(abp abp2, abo abo2, TKStage tKStage, AccessControlContext accessControlContext) {
        this.assertToolkitRunning();
        boolean bl2 = tKStage instanceof WindowStage ? ((WindowStage)tKStage).isSecurityDialog() : false;
        WindowStage windowStage = new WindowStage(abp2, bl2, abo2, null, tKStage);
        windowStage.setSecurityContext(accessControlContext);
        windowStage.setIsPopup();
        windowStage.init(this.systemMenu);
        return windowStage;
    }

    @Override
    public TKStage createTKEmbeddedStage(HostInterface hostInterface, AccessControlContext accessControlContext) {
        this.assertToolkitRunning();
        EmbeddedStage embeddedStage = new EmbeddedStage(hostInterface);
        embeddedStage.setSecurityContext(accessControlContext);
        return embeddedStage;
    }

    @Override
    public ScreenConfigurationAccessor setScreenConfigurationListener(TKScreenConfigurationListener tKScreenConfigurationListener) {
        Screen.setEventHandler(new QuantumToolkit$4(this, tKScreenConfigurationListener));
        return screenAccessor;
    }

    private static void assignScreensAdapters() {
        GraphicsPipeline graphicsPipeline = GraphicsPipeline.getPipeline();
        for (Screen screen : Screen.getScreens()) {
            screen.setAdapterOrdinal(graphicsPipeline.getAdapterOrdinal(screen));
        }
    }

    private static void notifyScreenListener(TKScreenConfigurationListener tKScreenConfigurationListener) {
        QuantumToolkit.assignScreensAdapters();
        tKScreenConfigurationListener.screenConfigurationChanged();
    }

    @Override
    public Object getPrimaryScreen() {
        return Screen.getMainScreen();
    }

    @Override
    public List<?> getScreens() {
        return Screen.getScreens();
    }

    @Override
    public ScreenConfigurationAccessor getScreenConfigurationAccessor() {
        return screenAccessor;
    }

    @Override
    public PerformanceTracker getPerformanceTracker() {
        return this.perfTracker;
    }

    @Override
    public PerformanceTracker createPerformanceTracker() {
        return new PerformanceTrackerImpl();
    }

    private float getMaxRenderScale() {
        if (this._maxPixelScale == 0.0f) {
            for (Object obj : this.getScreens()) {
                this._maxPixelScale = Math.max(this._maxPixelScale, ((Screen)obj).getRecommendedOutputScaleX());
                this._maxPixelScale = Math.max(this._maxPixelScale, ((Screen)obj).getRecommendedOutputScaleY());
            }
        }
        return this._maxPixelScale;
    }

    @Override
    public ImageLoader loadImage(String string, double d2, double d3, boolean bl2, boolean bl3) {
        return new PrismImageLoader2(string, d2, d3, bl2, this.getMaxRenderScale(), bl3);
    }

    @Override
    public ImageLoader loadImage(InputStream inputStream, double d2, double d3, boolean bl2, boolean bl3) {
        return new PrismImageLoader2(inputStream, d2, d3, bl2, bl3);
    }

    public AbstractRemoteResource<? extends ImageLoader> loadImageAsync(AsyncOperationListener asyncOperationListener, String string, double d2, double d3, boolean bl2, boolean bl3) {
        return new PrismImageLoader2$AsyncImageLoader(asyncOperationListener, string, d2, d3, bl2, bl3);
    }

    @Override
    public void defer(Runnable runnable) {
        if (!this.toolkitRunning.get()) {
            return;
        }
        Application.invokeLater(runnable);
    }

    @Override
    public void exit() {
        this.checkFxUserThread();
        this.pulseTimer.stop();
        PaintCollector.getInstance().waitForRenderingToComplete();
        this.notifyShutdownHooks();
        QuantumToolkit.runWithRenderLock(() -> {
            Application application = Application.GetApplication();
            application.terminate();
            return null;
        });
        this.dispose();
        super.exit();
    }

    public void dispose() {
        if (this.toolkitRunning.compareAndSet(true, false)) {
            this.pulseTimer.stop();
            this.renderer.stopRenderer();
            try {
                AccessController.doPrivileged(() -> {
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                    return null;
                });
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isForwardTraversalKey(RT rT2) {
        return rT2.b() == RL.b && rT2.getEventType() == RT.as && !rT2.gV();
    }

    @Override
    public boolean isBackwardTraversalKey(RT rT2) {
        return rT2.b() == RL.b && rT2.getEventType() == RT.as && rT2.gV();
    }

    @Override
    public Map<Object, Object> getContextMap() {
        return this.contextMap;
    }

    @Override
    public int getRefreshRate() {
        if (pulseHZ == null) {
            return 60;
        }
        return pulseHZ;
    }

    @Override
    public void setAnimationRunnable(DelayedRunnable delayedRunnable) {
        if (delayedRunnable != null) {
            this.animationRunning.set(true);
        }
        this.animationRunnable = delayedRunnable;
    }

    @Override
    public void requestNextPulse() {
        this.nextPulseRequested.set(true);
    }

    @Override
    public void waitFor(Toolkit$Task toolkit$Task) {
        if (toolkit$Task.isFinished()) {
            return;
        }
    }

    @Override
    protected Object createColorPaint(UM uM2) {
        return new Color((float)uM2.ex(), (float)uM2.ey(), (float)uM2.ez(), (float)uM2.eA());
    }

    private Color toPrismColor(UM uM2) {
        return (Color)Toolkit.getPaintAccessor().getPlatformPaint(uM2);
    }

    private List<Stop> convertStops(List<Vb> list) {
        ArrayList<Stop> arrayList = new ArrayList<Stop>(list.size());
        for (Vb vb2 : list) {
            arrayList.add(new Stop(this.toPrismColor(vb2.f()), (float)vb2.eP()));
        }
        return arrayList;
    }

    @Override
    protected Object createLinearGradientPaint(UQ uQ2) {
        int n2 = 2;
        UO uO2 = uQ2.PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_();
        if (uO2 == UO.PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_) {
            n2 = 0;
        } else if (uO2 == UO.a) {
            n2 = 1;
        }
        List<Stop> list = this.convertStops(uQ2.ap());
        return new LinearGradient((float)uQ2.eF(), (float)uQ2.eG(), (float)uQ2.eH(), (float)uQ2.eI(), null, uQ2.hW(), n2, list);
    }

    @Override
    protected Object createRadialGradientPaint(UZ uZ2) {
        float f2 = (float)uZ2.eM();
        float f3 = (float)uZ2.eN();
        float f4 = (float)uZ2.eK();
        float f5 = (float)uZ2.eL();
        int n2 = 0;
        n2 = uZ2.a() == UO.PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_ ? 0 : (uZ2.a() == UO.a ? 1 : 2);
        List<Stop> list = this.convertStops(uZ2.aq());
        return new RadialGradient(f2, f3, f4, f5, (float)uZ2.eO(), null, uZ2.hZ(), n2, list);
    }

    @Override
    protected Object createImagePatternPaint(UP uP2) {
        if (uP2.d() == null) {
            return Color.TRANSPARENT;
        }
        return new ImagePattern((Image)Toolkit.getImageAccessor().getPlatformImage(uP2.d()), (float)uP2.eB(), (float)uP2.eC(), (float)uP2.eD(), (float)uP2.eE(), uP2.hU(), Toolkit.getPaintAccessor().isMutable(uP2));
    }

    private void initStroke(XQ xQ2, double d2, XO xO2, XP xP2, float f2, float[] fArray, float f3) {
        int n2 = xQ2 == XQ.c ? 0 : (xQ2 == XQ.a ? 1 : 2);
        int n3 = xO2 == XO.b ? 0 : (xO2 == XO.a ? 2 : 1);
        int n4 = xP2 == XP.b ? 2 : (xP2 == XP.a ? 0 : 1);
        tmpStroke.set(n2, (float)d2, n3, n4, f2);
        if (fArray != null && fArray.length > 0) {
            tmpStroke.set(fArray, f3);
        } else {
            tmpStroke.set((float[])null, 0.0f);
        }
    }

    @Override
    public void accumulateStrokeBounds(Shape shape, float[] fArray, XQ xQ2, double d2, XO xO2, XP xP2, float f2, BaseTransform baseTransform) {
        this.initStroke(xQ2, d2, xO2, xP2, f2, null, 0.0f);
        if (baseTransform.isTranslateOrIdentity()) {
            tmpStroke.accumulateShapeBounds(fArray, shape, baseTransform);
        } else {
            Shape.accumulate(fArray, tmpStroke.createStrokedShape(shape), baseTransform);
        }
    }

    @Override
    public boolean strokeContains(Shape shape, double d2, double d3, XQ xQ2, double d4, XO xO2, XP xP2, float f2) {
        this.initStroke(xQ2, d4, xO2, xP2, f2, null, 0.0f);
        return tmpStroke.createStrokedShape(shape).contains((float)d2, (float)d3);
    }

    @Override
    public Shape createStrokedShape(Shape shape, XQ xQ2, double d2, XO xO2, XP xP2, float f2, float[] fArray, float f3) {
        this.initStroke(xQ2, d2, xO2, xP2, f2, fArray, f3);
        return tmpStroke.createStrokedShape(shape);
    }

    @Override
    public xj getBestCursorSize(int n2, int n3) {
        return CursorUtils.getBestCursorSize(n2, n3);
    }

    @Override
    public int getMaximumCursorColors() {
        return 2;
    }

    @Override
    public int getKeyCodeForChar(String string) {
        return string.length() == 1 ? KeyEvent.getKeyCodeForChar(string.charAt(0)) : 0;
    }

    @Override
    public Ww[] convertShapeToFXPath(Object object) {
        if (object == null) {
            return new Ww[0];
        }
        ArrayList<Wn> arrayList = new ArrayList<Wn>();
        Shape shape = (Shape)object;
        PathIterator pathIterator = shape.getPathIterator(null);
        PathIteratorHelper pathIteratorHelper = new PathIteratorHelper(pathIterator);
        PathIteratorHelper$Struct pathIteratorHelper$Struct = new PathIteratorHelper$Struct();
        while (!pathIteratorHelper.isDone()) {
            Ww ww2;
            boolean bl2 = pathIteratorHelper.getWindingRule() == 0;
            int n2 = pathIteratorHelper.currentSegment(pathIteratorHelper$Struct);
            if (n2 == 0) {
                ww2 = new Wn(pathIteratorHelper$Struct.f0, pathIteratorHelper$Struct.f1);
            } else if (n2 == 1) {
                ww2 = new Wf(pathIteratorHelper$Struct.f0, pathIteratorHelper$Struct.f1);
            } else if (n2 == 2) {
                ww2 = new WN(pathIteratorHelper$Struct.f0, pathIteratorHelper$Struct.f1, pathIteratorHelper$Struct.f2, pathIteratorHelper$Struct.f3);
            } else if (n2 == 3) {
                ww2 = new VC(pathIteratorHelper$Struct.f0, pathIteratorHelper$Struct.f1, pathIteratorHelper$Struct.f2, pathIteratorHelper$Struct.f3, pathIteratorHelper$Struct.f4, pathIteratorHelper$Struct.f5);
            } else if (n2 == 4) {
                ww2 = new Vy();
            } else {
                throw new IllegalStateException("Invalid element type: " + n2);
            }
            pathIteratorHelper.next();
            arrayList.add((Wn)ww2);
        }
        return arrayList.toArray(new Ww[arrayList.size()]);
    }

    @Override
    public Filterable toFilterable(QQ qQ2) {
        return PrImage.create((Image)Toolkit.getImageAccessor().getPlatformImage(qQ2));
    }

    @Override
    public FilterContext getFilterContext(Object object) {
        if (object == null || !(object instanceof Screen)) {
            return PrFilterContext.getDefaultInstance();
        }
        Screen screen = (Screen)object;
        return PrFilterContext.getInstance(screen);
    }

    @Override
    public AbstractPrimaryTimer getPrimaryTimer() {
        return PrimaryTimer.getInstance();
    }

    @Override
    public FontLoader getFontLoader() {
        return PrismFontLoader.getInstance();
    }

    @Override
    public TextLayoutFactory getTextLayoutFactory() {
        return PrismTextLayoutFactory.getFactory();
    }

    @Override
    public Object createSVGPathObject(Xe xe2) {
        int n2 = xe2.a() == VV.a ? 1 : 0;
        Path2D path2D = new Path2D(n2);
        path2D.appendSVGPath(xe2.aC());
        return path2D;
    }

    @Override
    public Path2D createSVGPath2D(Xe xe2) {
        int n2 = xe2.a() == VV.a ? 1 : 0;
        Path2D path2D = new Path2D(n2);
        path2D.appendSVGPath(xe2.aC());
        return path2D;
    }

    @Override
    public boolean imageContains(Object object, float f2, float f3) {
        if (object == null) {
            return false;
        }
        Image image = (Image)object;
        int n2 = (int)f2 + image.getMinX();
        int n3 = (int)f3 + image.getMinY();
        if (image.isOpaque()) {
            return true;
        }
        if (image.getPixelFormat() == PixelFormat.INT_ARGB_PRE) {
            IntBuffer intBuffer = (IntBuffer)image.getPixelBuffer();
            int n4 = n2 + n3 * image.getRowLength();
            if (n4 >= intBuffer.limit()) {
                return false;
            }
            return (intBuffer.get(n4) & 0xFF000000) != 0;
        }
        if (image.getPixelFormat() == PixelFormat.BYTE_BGRA_PRE) {
            ByteBuffer byteBuffer = (ByteBuffer)image.getPixelBuffer();
            int n5 = n2 * image.getBytesPerPixelUnit() + n3 * image.getScanlineStride() + 3;
            if (n5 >= byteBuffer.limit()) {
                return false;
            }
            return (byteBuffer.get(n5) & 0xFF) != 0;
        }
        if (image.getPixelFormat() == PixelFormat.BYTE_ALPHA) {
            ByteBuffer byteBuffer = (ByteBuffer)image.getPixelBuffer();
            int n6 = n2 * image.getBytesPerPixelUnit() + n3 * image.getScanlineStride();
            if (n6 >= byteBuffer.limit()) {
                return false;
            }
            return (byteBuffer.get(n6) & 0xFF) != 0;
        }
        return true;
    }

    @Override
    public boolean isNestedLoopRunning() {
        return Application.isNestedLoopRunning();
    }

    @Override
    public boolean isSupported(pm pm2) {
        switch (pm2) {
            case g: {
                return GraphicsPipeline.getPipeline().is3DSupported();
            }
            case h: {
                return GraphicsPipeline.getPipeline().isEffectSupported();
            }
            case i: {
                return true;
            }
            case j: {
                return Application.GetApplication().supportsInputMethods();
            }
            case k: {
                return Application.GetApplication().supportsTransparentWindows();
            }
            case l: {
                return Application.GetApplication().supportsUnifiedWindows();
            }
            case m: {
                return Application.GetApplication().hasTwoLevelFocus();
            }
            case n: {
                return Application.GetApplication().hasVirtualKeyboard();
            }
            case o: {
                return Application.GetApplication().hasTouch();
            }
            case p: {
                return Application.GetApplication().hasMultiTouch();
            }
            case q: {
                return Application.GetApplication().hasPointer();
            }
        }
        return false;
    }

    @Override
    public boolean isMSAASupported() {
        return GraphicsPipeline.getPipeline().isMSAASupported();
    }

    private int toGlassKeyCode(RL rL2) {
        switch (rL2) {
            case i: {
                return 20;
            }
            case aD: {
                return 144;
            }
        }
        return 0;
    }

    @Override
    public Optional<Boolean> isKeyLocked(RL rL2) {
        return Application.GetApplication().isKeyLocked(this.toGlassKeyCode(rL2));
    }

    static Sl clipboardActionToTransferMode(int n2) {
        switch (n2) {
            case 0: {
                return null;
            }
            case 1: 
            case 0x40000001: {
                return Sl.b;
            }
            case 2: 
            case 0x40000002: {
                return Sl.c;
            }
            case 0x40000000: {
                return Sl.d;
            }
            case 0x4FFFFFFF: {
                return Sl.b;
            }
        }
        return null;
    }

    @Override
    public TKClipboard getSystemClipboard() {
        if (this.clipboard == null) {
            this.clipboard = QuantumClipboard.getClipboardInstance(new ClipboardAssistance("SYSTEM"));
        }
        return this.clipboard;
    }

    @Override
    public TKSystemMenu getSystemMenu() {
        return this.systemMenu;
    }

    @Override
    public TKClipboard getNamedClipboard(String string) {
        return null;
    }

    @Override
    public void startDrag(TKScene tKScene, Set<Sl> set, TKDragSourceListener tKDragSourceListener, RB rB2) {
        if (rB2 == null) {
            throw new IllegalArgumentException("dragboard should not be null");
        }
        GlassScene glassScene = (GlassScene)tKScene;
        glassScene.setTKDragSourceListener(tKDragSourceListener);
        QuantumClipboard quantumClipboard = (QuantumClipboard)DragboardHelper.getPeer(rB2);
        quantumClipboard.setSupportedTransferMode(set);
        quantumClipboard.flush();
        quantumClipboard.close();
    }

    @Override
    public void enableDrop(TKScene tKScene, TKDropTargetListener tKDropTargetListener) {
        assert (tKScene instanceof GlassScene);
        GlassScene glassScene = (GlassScene)tKScene;
        glassScene.setTKDropTargetListener(tKDropTargetListener);
    }

    @Override
    public void registerDragGestureListener(TKScene tKScene, Set<Sl> set, TKDragGestureListener tKDragGestureListener) {
        assert (tKScene instanceof GlassScene);
        GlassScene glassScene = (GlassScene)tKScene;
        glassScene.setTKDragGestureListener(tKDragGestureListener);
    }

    @Override
    public void installInputMethodRequests(TKScene tKScene, RI rI2) {
        assert (tKScene instanceof GlassScene);
        GlassScene glassScene = (GlassScene)tKScene;
        glassScene.setInputMethodRequests(rI2);
    }

    @Override
    public ImageLoader loadPlatformImage(Object object) {
        if (object instanceof QuantumToolkit$QuantumImage) {
            return (QuantumToolkit$QuantumImage)object;
        }
        if (object instanceof Image) {
            return new QuantumToolkit$QuantumImage((Image)object);
        }
        if (object instanceof Rf) {
            return new QuantumToolkit$QuantumImage((Rf)object);
        }
        throw new UnsupportedOperationException("unsupported class for loadPlatformImage");
    }

    @Override
    public PlatformImage createPlatformImage(int n2, int n3) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2 * n3 * 4);
        return Image.fromByteBgraPreData(byteBuffer, n2, n3);
    }

    @Override
    public Object renderToImage(Toolkit$ImageRenderingContext toolkit$ImageRenderingContext) {
        Object object = toolkit$ImageRenderingContext.platformImage;
        Toolkit$ImageRenderingContext toolkit$ImageRenderingContext2 = toolkit$ImageRenderingContext;
        Paint paint = toolkit$ImageRenderingContext.platformPaint instanceof Paint ? (Paint)toolkit$ImageRenderingContext.platformPaint : null;
        RenderJob renderJob2 = new RenderJob(new QuantumToolkit$5(this, paint, toolkit$ImageRenderingContext2));
        CountDownLatch countDownLatch = new CountDownLatch(1);
        renderJob2.setCompletionListener(renderJob -> countDownLatch.countDown());
        this.addRenderJob(renderJob2);
        while (true) {
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                continue;
            }
            break;
        }
        Object object2 = toolkit$ImageRenderingContext2.platformImage;
        toolkit$ImageRenderingContext2.platformImage = object;
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonDialogs$FileChooserResult showFileChooser(TKStage tKStage, String string, File file, String string2, FileChooserType fileChooserType, List<aaS> list, aaS aaS2) {
        WindowStage windowStage = null;
        try {
            windowStage = this.blockOwnerStage(tKStage);
            CommonDialogs$FileChooserResult commonDialogs$FileChooserResult = CommonDialogs.showFileChooser(tKStage instanceof WindowStage ? ((WindowStage)tKStage).getPlatformWindow() : null, file, string2, string, fileChooserType == FileChooserType.SAVE ? 1 : 0, fileChooserType == FileChooserType.OPEN_MULTIPLE, QuantumToolkit.convertExtensionFilters(list), list.indexOf(aaS2));
            return commonDialogs$FileChooserResult;
        }
        finally {
            if (windowStage != null) {
                windowStage.setEnabled(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File showDirectoryChooser(TKStage tKStage, String string, File file) {
        WindowStage windowStage = null;
        try {
            windowStage = this.blockOwnerStage(tKStage);
            File file2 = CommonDialogs.showFolderChooser(tKStage instanceof WindowStage ? ((WindowStage)tKStage).getPlatformWindow() : null, file, string);
            return file2;
        }
        finally {
            if (windowStage != null) {
                windowStage.setEnabled(true);
            }
        }
    }

    private WindowStage blockOwnerStage(TKStage tKStage) {
        GlassStage glassStage;
        if (tKStage instanceof WindowStage && (glassStage = ((WindowStage)tKStage).getOwner()) instanceof WindowStage) {
            WindowStage windowStage = (WindowStage)glassStage;
            windowStage.setEnabled(false);
            return windowStage;
        }
        return null;
    }

    private static List<CommonDialogs$ExtensionFilter> convertExtensionFilters(List<aaS> list) {
        CommonDialogs$ExtensionFilter[] commonDialogs$ExtensionFilterArray = new CommonDialogs$ExtensionFilter[list.size()];
        int n2 = 0;
        for (aaS aaS2 : list) {
            commonDialogs$ExtensionFilterArray[n2++] = new CommonDialogs$ExtensionFilter(aaS2.getDescription(), aaS2.getExtensions());
        }
        return Arrays.asList(commonDialogs$ExtensionFilterArray);
    }

    @Override
    public long getMultiClickTime() {
        return View.getMultiClickTime();
    }

    @Override
    public int getMultiClickMaxX() {
        return View.getMultiClickMaxX();
    }

    @Override
    public int getMultiClickMaxY() {
        return View.getMultiClickMaxY();
    }

    @Override
    public String getThemeName() {
        return Application.GetApplication().getHighContrastTheme();
    }

    @Override
    public GlassRobot createRobot() {
        return Application.GetApplication().createRobot();
    }
}

