/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.ClipboardAssistance;
import com.sun.glass.ui.Pixels;
import com.sun.javafx.tk.ImageLoader;
import com.sun.javafx.tk.PermissionHelper;
import com.sun.javafx.tk.TKClipboard;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.tk.quantum.PixelUtils;
import com.sun.javafx.tk.quantum.QuantumClipboard$1;
import com.sun.prism.Image;
import dev.protect.QQ;
import dev.protect.Rk;
import dev.protect.Rp;
import dev.protect.Ry;
import dev.protect.Sl;
import dev.protect.abJ;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class QuantumClipboard
implements TKClipboard {
    private ClipboardAssistance systemAssistant;
    private AccessControlContext accessContext = null;
    private boolean isCaching;
    private List<abJ<Ry, Object>> dataCache;
    private Set<Sl> transferModesCache;
    private QQ dragImage = null;
    private double dragOffsetX = 0.0;
    private double dragOffsetY = 0.0;
    private static ClipboardAssistance currentDragboard;
    private static final Pattern findTagIMG;

    private QuantumClipboard() {
    }

    @Override
    public void setSecurityContext(AccessControlContext accessControlContext) {
        if (this.accessContext != null) {
            throw new RuntimeException("Clipboard security context has been already set!");
        }
        this.accessContext = accessControlContext;
    }

    private AccessControlContext getAccessControlContext() {
        if (this.accessContext == null) {
            throw new RuntimeException("Clipboard security context has not been set!");
        }
        return this.accessContext;
    }

    public static QuantumClipboard getClipboardInstance(ClipboardAssistance clipboardAssistance) {
        QuantumClipboard quantumClipboard = new QuantumClipboard();
        quantumClipboard.systemAssistant = clipboardAssistance;
        quantumClipboard.isCaching = false;
        return quantumClipboard;
    }

    static ClipboardAssistance getCurrentDragboard() {
        return currentDragboard;
    }

    static void releaseCurrentDragboard() {
        currentDragboard = null;
    }

    public static QuantumClipboard getDragboardInstance(ClipboardAssistance clipboardAssistance, boolean bl2) {
        QuantumClipboard quantumClipboard = new QuantumClipboard();
        quantumClipboard.systemAssistant = clipboardAssistance;
        quantumClipboard.isCaching = true;
        if (bl2) {
            currentDragboard = clipboardAssistance;
        }
        return quantumClipboard;
    }

    public static int transferModesToClipboardActions(Set<Sl> set) {
        int n2 = 0;
        block5: for (Sl sl2 : set) {
            switch (sl2) {
                case b: {
                    n2 |= 1;
                    continue block5;
                }
                case c: {
                    n2 |= 2;
                    continue block5;
                }
                case d: {
                    n2 |= 0x40000000;
                    continue block5;
                }
            }
            throw new IllegalArgumentException("unsupported TransferMode " + set);
        }
        return n2;
    }

    public void setSupportedTransferMode(Set<Sl> set) {
        if (this.isCaching) {
            this.transferModesCache = set;
        }
        int n2 = QuantumClipboard.transferModesToClipboardActions(set);
        this.systemAssistant.setSupportedActions(n2);
    }

    public static Set<Sl> clipboardActionsToTransferModes(int n2) {
        EnumSet<Sl> enumSet = EnumSet.noneOf(Sl.class);
        if ((n2 & 1) != 0) {
            enumSet.add(Sl.b);
        }
        if ((n2 & 2) != 0) {
            enumSet.add(Sl.c);
        }
        if ((n2 & 0x40000000) != 0) {
            enumSet.add(Sl.d);
        }
        return enumSet;
    }

    @Override
    public Set<Sl> getTransferModes() {
        if (this.transferModesCache != null) {
            return EnumSet.copyOf(this.transferModesCache);
        }
        ClipboardAssistance clipboardAssistance = currentDragboard != null ? currentDragboard : this.systemAssistant;
        Set<Sl> set = QuantumClipboard.clipboardActionsToTransferModes(clipboardAssistance.getSupportedSourceActions());
        return set;
    }

    @Override
    public void setDragView(QQ qQ2) {
        this.dragImage = qQ2;
    }

    @Override
    public void setDragViewOffsetX(double d2) {
        this.dragOffsetX = d2;
    }

    @Override
    public void setDragViewOffsetY(double d2) {
        this.dragOffsetY = d2;
    }

    @Override
    public QQ getDragView() {
        return this.dragImage;
    }

    @Override
    public double getDragViewOffsetX() {
        return this.dragOffsetX;
    }

    @Override
    public double getDragViewOffsetY() {
        return this.dragOffsetY;
    }

    public void close() {
        this.systemAssistant.close();
    }

    public void flush() {
        if (this.isCaching) {
            this.putContentToPeer(this.dataCache.toArray(new abJ[0]));
        }
        this.clearCache();
        this.clearDragView();
        this.systemAssistant.flush();
    }

    @Override
    public Object getContent(Ry ry2) {
        ClipboardAssistance clipboardAssistance;
        if (this.dataCache != null) {
            for (abJ<Ry, Object> abJ2 : this.dataCache) {
                if (abJ2.getKey() != ry2) continue;
                return abJ2.getValue();
            }
            return null;
        }
        ClipboardAssistance clipboardAssistance2 = clipboardAssistance = currentDragboard != null ? currentDragboard : this.systemAssistant;
        if (ry2 == Ry.d) {
            return this.readImage();
        }
        if (ry2 == Ry.c) {
            return clipboardAssistance.getData("text/uri-list");
        }
        if (ry2 == Ry.e) {
            Object object = clipboardAssistance.getData("application/x-java-file-list");
            if (object == null) {
                return Collections.emptyList();
            }
            String[] stringArray = (String[])object;
            ArrayList<File> arrayList = new ArrayList<File>(stringArray.length);
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                arrayList.add(new File(stringArray[i2]));
            }
            return arrayList;
        }
        for (String string : ry2.y()) {
            Object object = clipboardAssistance.getData(string);
            if (object instanceof ByteBuffer) {
                try {
                    ByteBuffer byteBuffer = (ByteBuffer)object;
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteBuffer.array());
                    QuantumClipboard$1 quantumClipboard$1 = new QuantumClipboard$1(this, byteArrayInputStream);
                    object = quantumClipboard$1.readObject();
                }
                catch (IOException iOException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (object == null) continue;
            return object;
        }
        return null;
    }

    private static QQ convertObjectToImage(Object object) {
        Pixels pixels;
        Object object2;
        if (object instanceof QQ) {
            return (QQ)object;
        }
        if (object instanceof ByteBuffer) {
            object2 = (ByteBuffer)object;
            try {
                ((ByteBuffer)object2).rewind();
                int n2 = ((ByteBuffer)object2).getInt();
                int n3 = ((ByteBuffer)object2).getInt();
                pixels = Application.GetApplication().createPixels(n2, n3, ((ByteBuffer)object2).slice());
            }
            catch (Exception exception) {
                return null;
            }
        } else if (object instanceof Pixels) {
            pixels = (Pixels)object;
        } else {
            return null;
        }
        object2 = PixelUtils.pixelsToImage(pixels);
        ImageLoader imageLoader = Toolkit.getToolkit().loadPlatformImage(object2);
        return Toolkit.getImageAccessor().fromPlatformImage(imageLoader);
    }

    private QQ readImage() {
        ClipboardAssistance clipboardAssistance = currentDragboard != null ? currentDragboard : this.systemAssistant;
        Object object = clipboardAssistance.getData("application/x-java-rawimage");
        if (object == null) {
            String string;
            Object object2 = clipboardAssistance.getData("text/html");
            if (object2 != null && (string = this.parseIMG(object2)) != null) {
                try {
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        Object object3;
                        AccessControlContext accessControlContext = this.getAccessControlContext();
                        URL uRL = new URL(string);
                        String string2 = uRL.getProtocol();
                        if (string2.equalsIgnoreCase("jar")) {
                            object3 = uRL.getFile();
                            uRL = new URL((String)object3);
                            string2 = uRL.getProtocol();
                        }
                        if (string2.equalsIgnoreCase("file")) {
                            object3 = new FilePermission(uRL.getFile(), "read");
                            securityManager.checkPermission((Permission)object3, accessControlContext);
                        } else if (string2.equalsIgnoreCase("ftp") || string2.equalsIgnoreCase("http") || string2.equalsIgnoreCase("https")) {
                            int n2 = uRL.getPort();
                            String string3 = n2 == -1 ? uRL.getHost() : uRL.getHost() + ":" + n2;
                            SocketPermission socketPermission = new SocketPermission(string3, "connect");
                            securityManager.checkPermission(socketPermission, accessControlContext);
                        } else {
                            PermissionHelper.checkClipboardPermission(accessControlContext);
                        }
                    }
                    return new QQ(string);
                }
                catch (MalformedURLException malformedURLException) {
                    return null;
                }
                catch (SecurityException securityException) {
                    return null;
                }
            }
            return null;
        }
        return QuantumClipboard.convertObjectToImage(object);
    }

    private String parseIMG(Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof String)) {
            return null;
        }
        String string = (String)object;
        Matcher matcher = findTagIMG.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private boolean placeImage(QQ qQ2) {
        if (qQ2 == null) {
            return false;
        }
        String string = qQ2.as();
        if (string == null || PixelUtils.supportedFormatType(string)) {
            Image image = (Image)Toolkit.getImageAccessor().getPlatformImage(qQ2);
            Pixels pixels = PixelUtils.imageToPixels(image);
            if (pixels != null) {
                this.systemAssistant.setData("application/x-java-rawimage", pixels);
                return true;
            }
            return false;
        }
        this.systemAssistant.setData("text/uri-list", string);
        return true;
    }

    @Override
    public Set<Ry> getContentTypes() {
        HashSet<Ry> hashSet = new HashSet<Ry>();
        if (this.dataCache != null) {
            for (abJ<Ry, Object> abJ2 : this.dataCache) {
                hashSet.add(abJ2.getKey());
            }
            return hashSet;
        }
        ClipboardAssistance clipboardAssistance = currentDragboard != null ? currentDragboard : this.systemAssistant;
        String[] stringArray = clipboardAssistance.getMimeTypes();
        if (stringArray == null) {
            return hashSet;
        }
        for (String string : stringArray) {
            if (string.equalsIgnoreCase("application/x-java-rawimage")) {
                hashSet.add(Ry.d);
                continue;
            }
            if (string.equalsIgnoreCase("text/uri-list")) {
                hashSet.add(Ry.c);
                continue;
            }
            if (string.equalsIgnoreCase("application/x-java-file-list")) {
                hashSet.add(Ry.e);
                continue;
            }
            if (string.equalsIgnoreCase("text/html")) {
                hashSet.add(Ry.a);
                try {
                    if (this.parseIMG(clipboardAssistance.getData("text/html")) == null) continue;
                    hashSet.add(Ry.d);
                }
                catch (Exception exception) {}
                continue;
            }
            Ry ry2 = Ry.PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_(string);
            if (ry2 == null) {
                ry2 = new Ry(string);
            }
            hashSet.add(ry2);
        }
        return hashSet;
    }

    @Override
    public boolean hasContent(Ry ry2) {
        if (this.dataCache != null) {
            for (abJ<Ry, Object> abJ2 : this.dataCache) {
                if (abJ2.getKey() != ry2) continue;
                return true;
            }
            return false;
        }
        ClipboardAssistance clipboardAssistance = currentDragboard != null ? currentDragboard : this.systemAssistant;
        String[] stringArray = clipboardAssistance.getMimeTypes();
        if (stringArray == null) {
            return false;
        }
        for (String string : stringArray) {
            if (ry2 == Ry.d && string.equalsIgnoreCase("application/x-java-rawimage")) {
                return true;
            }
            if (ry2 == Ry.c && string.equalsIgnoreCase("text/uri-list")) {
                return true;
            }
            if (ry2 == Ry.d && string.equalsIgnoreCase("text/html") && this.parseIMG(clipboardAssistance.getData("text/html")) != null) {
                return true;
            }
            if (ry2 == Ry.e && string.equalsIgnoreCase("application/x-java-file-list")) {
                return true;
            }
            Ry ry3 = Ry.PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_(string);
            if (ry3 == null || !ry3.equals(ry2)) continue;
            return true;
        }
        return false;
    }

    private static ByteBuffer prepareImage(QQ qQ2) {
        Rk rk2 = qQ2.PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_();
        int n2 = (int)qQ2.cS();
        int n3 = (int)qQ2.cT();
        byte[] byArray = new byte[n2 * n3 * 4];
        rk2.getPixels(0, 0, n2, n3, Rp.b(), byArray, 0, n2 * 4);
        ByteBuffer byteBuffer = ByteBuffer.allocate(8 + n2 * n3 * 4);
        byteBuffer.putInt(n2);
        byteBuffer.putInt(n3);
        byteBuffer.put(byArray);
        return byteBuffer;
    }

    private static ByteBuffer prepareOffset(double d2, double d3) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.rewind();
        byteBuffer.putInt((int)d2);
        byteBuffer.putInt((int)d3);
        return byteBuffer;
    }

    private boolean putContentToPeer(abJ<Ry, Object> ... abJArray) {
        this.systemAssistant.emptyCache();
        boolean bl2 = false;
        for (abJ<Ry, Object> abJ2 : abJArray) {
            int n2;
            Object iOException;
            Ry ry2 = abJ2.getKey();
            Object object = abJ2.getValue();
            if (ry2 == Ry.d) {
                bl2 = this.placeImage(QuantumClipboard.convertObjectToImage(object));
                continue;
            }
            if (ry2 == Ry.c) {
                this.systemAssistant.setData("text/uri-list", object);
                bl2 = true;
                continue;
            }
            if (ry2 == Ry.b) {
                this.systemAssistant.setData("text/rtf", object);
                bl2 = true;
                continue;
            }
            if (ry2 == Ry.e) {
                iOException = (List)object;
                if (iOException.size() == 0) continue;
                String[] stringArray = new String[iOException.size()];
                n2 = 0;
                Iterator iterator = iOException.iterator();
                while (iterator.hasNext()) {
                    File file = (File)iterator.next();
                    stringArray[n2++] = file.getAbsolutePath();
                }
                this.systemAssistant.setData("application/x-java-file-list", stringArray);
                bl2 = true;
                continue;
            }
            if (object instanceof Serializable) {
                if (ry2 != Ry.PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_ && ry2 != Ry.a || !(object instanceof String)) {
                    try {
                        iOException = new ByteArrayOutputStream();
                        ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)iOException);
                        objectOutputStream.writeObject(object);
                        objectOutputStream.close();
                        object = ByteBuffer.wrap(((ByteArrayOutputStream)iOException).toByteArray());
                    }
                    catch (IOException iOException2) {
                        throw new IllegalArgumentException("Could not serialize the data", iOException2);
                    }
                }
            } else if (object instanceof InputStream) {
                iOException = new ByteArrayOutputStream();
                try (InputStream inputStream = (InputStream)object;){
                    n2 = inputStream.read();
                    while (n2 != -1) {
                        ((ByteArrayOutputStream)iOException).write(n2);
                        n2 = inputStream.read();
                    }
                }
                catch (IOException iOException3) {
                    throw new IllegalArgumentException("Could not serialize the data", iOException3);
                }
                object = ByteBuffer.wrap(((ByteArrayOutputStream)iOException).toByteArray());
            } else if (!(object instanceof ByteBuffer)) {
                throw new IllegalArgumentException("Only serializable objects or ByteBuffer can be used as data with data format " + ry2);
            }
            for (String string : ry2.y()) {
                this.systemAssistant.setData(string, object);
                bl2 = true;
            }
        }
        if (this.dragImage != null) {
            ByteBuffer byteBuffer = QuantumClipboard.prepareImage(this.dragImage);
            ByteBuffer byteBuffer2 = QuantumClipboard.prepareOffset(this.dragOffsetX, this.dragOffsetY);
            this.systemAssistant.setData("application/x-java-drag-image", byteBuffer);
            this.systemAssistant.setData("application/x-java-drag-image-offset", byteBuffer2);
        }
        return bl2;
    }

    @Override
    public boolean putContent(abJ<Ry, Object> ... abJArray) {
        for (abJ<Ry, Object> abJ2 : abJArray) {
            Ry object = abJ2.getKey();
            Object object2 = abJ2.getValue();
            if (object == null) {
                throw new NullPointerException("Clipboard.putContent: null data format");
            }
            if (object2 != null) continue;
            throw new NullPointerException("Clipboard.putContent: null data");
        }
        boolean bl2 = false;
        if (this.isCaching) {
            if (this.dataCache == null) {
                this.dataCache = new ArrayList<abJ<Ry, Object>>(abJArray.length);
            }
            for (abJ<Ry, Object> abJ2 : abJArray) {
                this.dataCache.add(abJ2);
                bl2 = true;
            }
        } else {
            bl2 = this.putContentToPeer(abJArray);
            this.systemAssistant.flush();
        }
        return bl2;
    }

    private void clearCache() {
        this.dataCache = null;
        this.transferModesCache = null;
    }

    private void clearDragView() {
        this.dragImage = null;
        this.dragOffsetY = 0.0;
        this.dragOffsetX = 0.0;
    }

    static {
        findTagIMG = Pattern.compile("IMG\\s+SRC=\\\"([^\\\"]+)\\\"", 34);
    }
}

