/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.javafx.tk.quantum.PerformanceLogger$1;
import com.sun.javafx.tk.quantum.PerformanceLogger$2;
import com.sun.javafx.tk.quantum.PerformanceLogger$3;
import com.sun.javafx.tk.quantum.PerformanceLogger$TimeData;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.AccessController;
import java.util.Vector;

public class PerformanceLogger {
    private static final int START_INDEX = 0;
    private static final int LAST_RESERVED = 0;
    private static boolean perfLoggingOn = false;
    private static boolean useNanoTime = false;
    private static Vector<PerformanceLogger$TimeData> times;
    private static String logFileName;
    private static Writer logWriter;
    private static long baseTime;

    public static boolean loggingEnabled() {
        return perfLoggingOn;
    }

    private static long getCurrentTime() {
        if (useNanoTime) {
            return System.nanoTime();
        }
        return System.currentTimeMillis();
    }

    public static void setStartTime(String string) {
        if (PerformanceLogger.loggingEnabled()) {
            long l2 = PerformanceLogger.getCurrentTime();
            PerformanceLogger.setStartTime(string, l2);
        }
    }

    public static void setBaseTime(long l2) {
        if (PerformanceLogger.loggingEnabled()) {
            baseTime = l2;
        }
    }

    public static void setStartTime(String string, long l2) {
        if (PerformanceLogger.loggingEnabled()) {
            times.set(0, new PerformanceLogger$TimeData(string, l2));
        }
    }

    public static long getStartTime() {
        if (PerformanceLogger.loggingEnabled()) {
            return times.get(0).getTime();
        }
        return 0L;
    }

    public static int setTime(String string) {
        if (PerformanceLogger.loggingEnabled()) {
            long l2 = PerformanceLogger.getCurrentTime();
            return PerformanceLogger.setTime(string, l2);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int setTime(String string, long l2) {
        if (PerformanceLogger.loggingEnabled()) {
            Vector<PerformanceLogger$TimeData> vector = times;
            synchronized (vector) {
                times.add(new PerformanceLogger$TimeData(string, l2));
                return times.size() - 1;
            }
        }
        return 0;
    }

    public static long getTimeAtIndex(int n2) {
        if (PerformanceLogger.loggingEnabled()) {
            return times.get(n2).getTime();
        }
        return 0L;
    }

    public static String getMessageAtIndex(int n2) {
        if (PerformanceLogger.loggingEnabled()) {
            return times.get(n2).getMessage();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void outputLog(Writer writer) {
        if (PerformanceLogger.loggingEnabled()) {
            try {
                Vector<PerformanceLogger$TimeData> vector = times;
                synchronized (vector) {
                    for (int i2 = 0; i2 < times.size(); ++i2) {
                        PerformanceLogger$TimeData performanceLogger$TimeData = times.get(i2);
                        if (performanceLogger$TimeData == null) continue;
                        writer.write(i2 + " " + performanceLogger$TimeData.getMessage() + ": " + (performanceLogger$TimeData.getTime() - baseTime) + "\n");
                    }
                }
                writer.flush();
            }
            catch (Exception exception) {
                System.out.println(exception + ": Writing performance log to " + writer);
            }
        }
    }

    public static void outputLog() {
        PerformanceLogger.outputLog(logWriter);
    }

    static {
        logFileName = null;
        logWriter = null;
        String string = AccessController.doPrivileged(new PerformanceLogger$1());
        if (string != null) {
            perfLoggingOn = true;
            String string2 = AccessController.doPrivileged(new PerformanceLogger$2());
            if (string2 != null) {
                useNanoTime = true;
            }
            if (string.regionMatches(true, 0, "file:", 0, 5)) {
                logFileName = string.substring(5);
            }
            if (logFileName != null && logWriter == null) {
                Void void_ = AccessController.doPrivileged(new PerformanceLogger$3());
            }
            if (logWriter == null) {
                logWriter = new OutputStreamWriter(System.out);
            }
        }
        times = new Vector(10);
        for (int i2 = 0; i2 <= 0; ++i2) {
            times.add(new PerformanceLogger$TimeData("Time " + i2 + " not set", 0L));
        }
    }
}

