/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.events.ViewEvent;
import com.sun.glass.ui.Accessible;
import com.sun.glass.ui.ClipboardAssistance;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.View;
import com.sun.glass.ui.View$EventHandler;
import com.sun.glass.ui.Window;
import com.sun.javafx.PlatformUtil;
import com.sun.javafx.logging.PulseLogger;
import com.sun.javafx.tk.quantum.GestureRecognizers;
import com.sun.javafx.tk.quantum.GlassSceneDnDEventHandler;
import com.sun.javafx.tk.quantum.GlassViewEventHandler$1;
import com.sun.javafx.tk.quantum.GlassViewEventHandler$KeyEventNotification;
import com.sun.javafx.tk.quantum.GlassViewEventHandler$MouseEventNotification;
import com.sun.javafx.tk.quantum.GlassViewEventHandler$ViewEventNotification;
import com.sun.javafx.tk.quantum.PaintCollector;
import com.sun.javafx.tk.quantum.QuantumToolkit;
import com.sun.javafx.tk.quantum.RotateGestureRecognizer;
import com.sun.javafx.tk.quantum.ScrollGestureRecognizer;
import com.sun.javafx.tk.quantum.SwipeGestureRecognizer;
import com.sun.javafx.tk.quantum.ViewScene;
import com.sun.javafx.tk.quantum.WindowStage;
import com.sun.javafx.tk.quantum.ZoomGestureRecognizer;
import dev.protect.RG;
import dev.protect.RH;
import dev.protect.RJ;
import dev.protect.RT;
import dev.protect.RW;
import dev.protect.RY;
import dev.protect.Sc;
import dev.protect.Sd;
import dev.protect.Sg;
import dev.protect.Sk;
import dev.protect.Sl;
import dev.protect.Sm;
import dev.protect.tM;
import dev.protect.wY;
import dev.protect.xo;
import java.security.AccessController;

class GlassViewEventHandler
extends View$EventHandler {
    static boolean zoomGestureEnabled;
    static boolean rotateGestureEnabled;
    static boolean scrollGestureEnabled;
    private ViewScene scene;
    private final GlassSceneDnDEventHandler dndHandler;
    private final GestureRecognizers gestures;
    private final PaintCollector collector = PaintCollector.getInstance();
    private final GlassViewEventHandler$KeyEventNotification keyNotification = new GlassViewEventHandler$KeyEventNotification(this);
    private int mouseButtonPressedMask = 0;
    private final GlassViewEventHandler$MouseEventNotification mouseNotification = new GlassViewEventHandler$MouseEventNotification(this);
    private ClipboardAssistance dropSourceAssistant;
    private final GlassViewEventHandler$ViewEventNotification viewNotification = new GlassViewEventHandler$ViewEventNotification(this);

    public GlassViewEventHandler(ViewScene viewScene) {
        this.scene = viewScene;
        this.dndHandler = new GlassSceneDnDEventHandler(viewScene);
        this.gestures = new GestureRecognizers();
        if (PlatformUtil.isWindows() || PlatformUtil.isIOS() || PlatformUtil.isEmbedded()) {
            this.gestures.add(new SwipeGestureRecognizer(viewScene));
        }
        if (zoomGestureEnabled) {
            this.gestures.add(new ZoomGestureRecognizer(viewScene));
        }
        if (rotateGestureEnabled) {
            this.gestures.add(new RotateGestureRecognizer(viewScene));
        }
        if (scrollGestureEnabled) {
            this.gestures.add(new ScrollGestureRecognizer(viewScene));
        }
    }

    private static boolean allowableFullScreenKeys(int n2) {
        switch (n2) {
            case 9: 
            case 10: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                return true;
            }
        }
        return false;
    }

    private boolean checkFullScreenKeyEvent(int n2, int n3, char[] cArray, int n4) {
        return this.scene.getWindowStage().isTrustedFullScreen() || GlassViewEventHandler.allowableFullScreenKeys(n3);
    }

    private static wY<RT> keyEventType(int n2) {
        switch (n2) {
            case 111: {
                return RT.as;
            }
            case 112: {
                return RT.at;
            }
            case 113: {
                return RT.au;
            }
        }
        if (QuantumToolkit.verbose) {
            System.err.println("Unknown Glass key event type: " + n2);
        }
        return null;
    }

    @Override
    public void handleKeyEvent(View view, long l2, int n2, int n3, char[] cArray, int n4) {
        this.keyNotification.view = view;
        this.keyNotification.time = l2;
        this.keyNotification.type = n2;
        this.keyNotification.key = n3;
        this.keyNotification.chars = cArray;
        this.keyNotification.modifiers = n4;
        QuantumToolkit.runWithoutRenderLock(() -> AccessController.doPrivileged(this.keyNotification, this.scene.getAccessControlContext()));
    }

    private static wY<RY> mouseEventType(int n2) {
        switch (n2) {
            case 221: {
                return RY.aD;
            }
            case 222: {
                return RY.aE;
            }
            case 225: {
                return RY.aH;
            }
            case 226: {
                return RY.aJ;
            }
            case 224: {
                return RY.aK;
            }
            case 223: {
                return RY.aL;
            }
            case 228: {
                throw new IllegalArgumentException("WHEEL event cannot be translated to MouseEvent, must be translated to ScrollEvent");
            }
        }
        if (QuantumToolkit.verbose) {
            System.err.println("Unknown Glass mouse event type: " + n2);
        }
        return null;
    }

    private static RW mouseEventButton(int n2) {
        switch (n2) {
            case 212: {
                return RW.a;
            }
            case 213: {
                return RW.c;
            }
            case 214: {
                return RW.b;
            }
            case 215: {
                return RW.d;
            }
            case 216: {
                return RW.e;
            }
        }
        return RW.PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_;
    }

    @Override
    public void handleMouseEvent(View view, long l2, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl2, boolean bl3) {
        this.mouseNotification.view = view;
        this.mouseNotification.time = l2;
        this.mouseNotification.type = n2;
        this.mouseNotification.button = n3;
        this.mouseNotification.x = n4;
        this.mouseNotification.y = n5;
        this.mouseNotification.xAbs = n6;
        this.mouseNotification.yAbs = n7;
        this.mouseNotification.modifiers = n8;
        this.mouseNotification.isPopupTrigger = bl2;
        this.mouseNotification.isSynthesized = bl3;
        QuantumToolkit.runWithoutRenderLock(() -> AccessController.doPrivileged(this.mouseNotification, this.scene.getAccessControlContext()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMenuEvent(View view, int n2, int n3, int n4, int n5, boolean bl2) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("MENU_EVENT");
        }
        WindowStage windowStage = this.scene.getWindowStage();
        try {
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(true);
            }
            QuantumToolkit.runWithoutRenderLock(() -> AccessController.doPrivileged(() -> {
                if (this.scene.sceneListener != null) {
                    double d2;
                    double d3;
                    double d4;
                    double d5;
                    double d6;
                    double d7;
                    Window window = view.getWindow();
                    if (window != null) {
                        d7 = window.getPlatformScaleX();
                        d6 = window.getPlatformScaleY();
                        Screen screen = window.getScreen();
                        if (screen != null) {
                            d5 = screen.getPlatformX();
                            d4 = screen.getPlatformY();
                            d3 = screen.getX();
                            d2 = screen.getY();
                        } else {
                            d2 = 0.0;
                            d3 = 0.0;
                            d4 = 0.0;
                            d5 = 0.0;
                        }
                    } else {
                        d6 = 1.0;
                        d7 = 1.0;
                        d2 = 0.0;
                        d3 = 0.0;
                        d4 = 0.0;
                        d5 = 0.0;
                    }
                    this.scene.sceneListener.menuEvent((double)n2 / d7, (double)n3 / d6, d3 + ((double)n4 - d5) / d7, d2 + ((double)n5 - d4) / d6, bl2);
                }
                return null;
            }, this.scene.getAccessControlContext()));
        }
        finally {
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(false);
            }
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newInput(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleScrollEvent(View view, long l2, int n2, int n3, int n4, int n5, double d2, double d3, int n6, int n7, int n8, int n9, int n10, double d4, double d5) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("SCROLL_EVENT");
        }
        WindowStage windowStage = this.scene.getWindowStage();
        try {
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(false);
            }
            QuantumToolkit.runWithoutRenderLock(() -> AccessController.doPrivileged(() -> {
                if (this.scene.sceneListener != null) {
                    double d6;
                    double d7;
                    double d8;
                    double d9;
                    double d10;
                    double d11;
                    Window window = view.getWindow();
                    if (window != null) {
                        d11 = window.getPlatformScaleX();
                        d10 = window.getPlatformScaleY();
                        Screen screen = window.getScreen();
                        if (screen != null) {
                            d9 = screen.getPlatformX();
                            d8 = screen.getPlatformY();
                            d7 = screen.getX();
                            d6 = screen.getY();
                        } else {
                            d6 = 0.0;
                            d7 = 0.0;
                            d8 = 0.0;
                            d9 = 0.0;
                        }
                    } else {
                        d10 = 1.0;
                        d11 = 1.0;
                        d6 = 0.0;
                        d7 = 0.0;
                        d8 = 0.0;
                        d9 = 0.0;
                    }
                    this.scene.sceneListener.scrollEvent(Sd.aS, d2 / d11, d3 / d10, 0.0, 0.0, d4, d5, 0, n8, n7, n10, n9, (double)n2 / d11, (double)n3 / d10, d7 + ((double)n4 - d9) / d11, d6 + ((double)n5 - d8) / d10, (n6 & 1) != 0, (n6 & 4) != 0, (n6 & 8) != 0, (n6 & 0x10) != 0, false, false);
                }
                return null;
            }, this.scene.getAccessControlContext()));
        }
        finally {
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(false);
            }
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newInput(null);
            }
        }
    }

    private static byte inputMethodEventAttrValue(int n2, int[] nArray, byte[] byArray) {
        if (nArray != null) {
            for (int i2 = 0; i2 < nArray.length - 1; ++i2) {
                if (n2 < nArray[i2] || n2 >= nArray[i2 + 1]) continue;
                return byArray[i2];
            }
        }
        return 4;
    }

    private static tM<RJ> inputMethodEventComposed(String string, int n2, int[] nArray, int[] nArray2, byte[] byArray) {
        GlassViewEventHandler$1 glassViewEventHandler$1 = new GlassViewEventHandler$1();
        if (n2 < string.length()) {
            if (nArray == null) {
                glassViewEventHandler$1.add(new RJ(string.substring(n2), RH.PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_));
            } else {
                for (int i2 = 0; i2 < nArray.length - 1; ++i2) {
                    RH rH2;
                    if (nArray[i2] < n2) continue;
                    switch (GlassViewEventHandler.inputMethodEventAttrValue(nArray[i2], nArray2, byArray)) {
                        case 1: {
                            rH2 = RH.c;
                            break;
                        }
                        case 2: {
                            rH2 = RH.b;
                            break;
                        }
                        case 3: {
                            rH2 = RH.a;
                            break;
                        }
                        default: {
                            rH2 = RH.PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_;
                        }
                    }
                    glassViewEventHandler$1.add(new RJ(string.substring(nArray[i2], nArray[i2 + 1]), rH2));
                }
            }
        }
        return glassViewEventHandler$1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleInputMethodEvent(long l2, String string, int[] nArray, int[] nArray2, byte[] byArray, int n2, int n3) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("INPUT_METHOD_EVENT");
        }
        WindowStage windowStage = this.scene.getWindowStage();
        try {
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(true);
            }
            QuantumToolkit.runWithoutRenderLock(() -> AccessController.doPrivileged(() -> {
                if (this.scene.sceneListener != null) {
                    String string2 = string != null ? string : "";
                    wY<RG> wY2 = RG.ap;
                    tM<RJ> tM2 = GlassViewEventHandler.inputMethodEventComposed(string2, n2, nArray, nArray2, byArray);
                    String string3 = string2.substring(0, n2);
                    this.scene.sceneListener.inputMethodEvent(wY2, tM2, string3, n3);
                }
                return null;
            }, this.scene.getAccessControlContext()));
        }
        finally {
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(false);
            }
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newInput(null);
            }
        }
    }

    @Override
    public double[] getInputMethodCandidatePos(int n2) {
        xo xo2 = this.scene.inputMethodRequests.getTextLocation(n2);
        double[] dArray = new double[]{xo2.aB(), xo2.aC()};
        return dArray;
    }

    private static Sl actionToTransferMode(int n2) {
        if (n2 == 0) {
            return null;
        }
        if (n2 == 1 || n2 == 0x40000001) {
            return Sl.b;
        }
        if (n2 == 2 || n2 == 0x40000002) {
            return Sl.c;
        }
        if (n2 == 0x40000000) {
            return Sl.d;
        }
        if (n2 == 3) {
            if (QuantumToolkit.verbose) {
                System.err.println("Ambiguous drop action: " + Integer.toHexString(n2));
            }
        } else if (QuantumToolkit.verbose) {
            System.err.println("Unknown drop action: " + Integer.toHexString(n2));
        }
        return null;
    }

    private static int transferModeToAction(Sl sl2) {
        if (sl2 == null) {
            return 0;
        }
        switch (sl2) {
            case b: {
                return 1;
            }
            case c: {
                return 2;
            }
            case d: {
                return 0x40000000;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int handleDragEnter(View view, int n2, int n3, int n4, int n5, int n6, ClipboardAssistance clipboardAssistance) {
        Sl sl2;
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("DRAG_ENTER");
        }
        try {
            sl2 = QuantumToolkit.runWithoutRenderLock(() -> this.dndHandler.handleDragEnter(n2, n3, n4, n5, GlassViewEventHandler.actionToTransferMode(n6), clipboardAssistance));
        }
        finally {
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newInput(null);
            }
        }
        return GlassViewEventHandler.transferModeToAction(sl2);
    }

    @Override
    public void handleDragLeave(View view, ClipboardAssistance clipboardAssistance) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("DRAG_LEAVE");
        }
        try {
            QuantumToolkit.runWithoutRenderLock(() -> {
                this.dndHandler.handleDragLeave(clipboardAssistance);
                return null;
            });
        }
        finally {
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newInput(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int handleDragDrop(View view, int n2, int n3, int n4, int n5, int n6, ClipboardAssistance clipboardAssistance) {
        Sl sl2;
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("DRAG_DROP");
        }
        try {
            sl2 = QuantumToolkit.runWithoutRenderLock(() -> this.dndHandler.handleDragDrop(n2, n3, n4, n5, GlassViewEventHandler.actionToTransferMode(n6), clipboardAssistance));
        }
        finally {
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newInput(null);
            }
        }
        return GlassViewEventHandler.transferModeToAction(sl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int handleDragOver(View view, int n2, int n3, int n4, int n5, int n6, ClipboardAssistance clipboardAssistance) {
        Sl sl2;
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("DRAG_OVER");
        }
        try {
            sl2 = QuantumToolkit.runWithoutRenderLock(() -> this.dndHandler.handleDragOver(n2, n3, n4, n5, GlassViewEventHandler.actionToTransferMode(n6), clipboardAssistance));
        }
        finally {
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newInput(null);
            }
        }
        return GlassViewEventHandler.transferModeToAction(sl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleDragStart(View view, int n2, int n3, int n4, int n5, int n6, ClipboardAssistance clipboardAssistance) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("DRAG_START");
        }
        this.dropSourceAssistant = clipboardAssistance;
        try {
            QuantumToolkit.runWithoutRenderLock(() -> {
                this.dndHandler.handleDragStart(n2, n3, n4, n5, n6, clipboardAssistance);
                return null;
            });
        }
        finally {
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newInput(null);
            }
        }
    }

    @Override
    public void handleDragEnd(View view, int n2) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("DRAG_END");
        }
        try {
            QuantumToolkit.runWithoutRenderLock(() -> {
                this.dndHandler.handleDragEnd(GlassViewEventHandler.actionToTransferMode(n2), this.dropSourceAssistant);
                return null;
            });
        }
        finally {
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newInput(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleViewEvent(View view, long l2, int n2) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("VIEW_EVENT: " + ViewEvent.getTypeString(n2));
        }
        this.viewNotification.view = view;
        this.viewNotification.time = l2;
        this.viewNotification.type = n2;
        try {
            QuantumToolkit.runWithoutRenderLock(() -> AccessController.doPrivileged(this.viewNotification, this.scene.getAccessControlContext()));
        }
        finally {
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newInput(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleScrollGestureEvent(View view, long l2, int n2, int n3, boolean bl2, boolean bl3, int n4, int n5, int n6, int n7, int n8, double d2, double d3, double d4, double d5, double d6, double d7) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("SCROLL_GESTURE_EVENT");
        }
        WindowStage windowStage = this.scene.getWindowStage();
        try {
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(false);
            }
            QuantumToolkit.runWithoutRenderLock(() -> AccessController.doPrivileged(() -> {
                if (this.scene.sceneListener != null) {
                    double d8;
                    double d9;
                    double d10;
                    double d11;
                    double d12;
                    double d13;
                    wY<Sd> wY2;
                    switch (n2) {
                        case 1: {
                            wY2 = Sd.aT;
                            break;
                        }
                        case 2: {
                            wY2 = Sd.aS;
                            break;
                        }
                        case 3: {
                            wY2 = Sd.aU;
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unknown scroll event type: " + n2);
                        }
                    }
                    Window window = view.getWindow();
                    if (window != null) {
                        d13 = window.getPlatformScaleX();
                        d12 = window.getPlatformScaleY();
                        Screen screen = window.getScreen();
                        if (screen != null) {
                            d11 = screen.getPlatformX();
                            d10 = screen.getPlatformY();
                            d9 = screen.getX();
                            d8 = screen.getY();
                        } else {
                            d8 = 0.0;
                            d9 = 0.0;
                            d10 = 0.0;
                            d11 = 0.0;
                        }
                    } else {
                        d12 = 1.0;
                        d13 = 1.0;
                        d8 = 0.0;
                        d9 = 0.0;
                        d10 = 0.0;
                        d11 = 0.0;
                    }
                    this.scene.sceneListener.scrollEvent(wY2, d2 / d13, d3 / d12, d4 / d13, d5 / d12, d6, d7, n4, 0, 0, 0, 0, n5 == Integer.MAX_VALUE ? Double.NaN : (double)n5 / d13, n6 == Integer.MAX_VALUE ? Double.NaN : (double)n6 / d12, n7 == Integer.MAX_VALUE ? Double.NaN : d9 + ((double)n7 - d11) / d13, n8 == Integer.MAX_VALUE ? Double.NaN : d8 + ((double)n8 - d10) / d12, (n3 & 1) != 0, (n3 & 4) != 0, (n3 & 8) != 0, (n3 & 0x10) != 0, bl2, bl3);
                }
                return null;
            }, this.scene.getAccessControlContext()));
        }
        finally {
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(false);
            }
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newInput(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleZoomGestureEvent(View view, long l2, int n2, int n3, boolean bl2, boolean bl3, int n4, int n5, int n6, int n7, double d2, double d3, double d4, double d5) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("ZOOM_GESTURE_EVENT");
        }
        WindowStage windowStage = this.scene.getWindowStage();
        try {
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(false);
            }
            QuantumToolkit.runWithoutRenderLock(() -> AccessController.doPrivileged(() -> {
                if (this.scene.sceneListener != null) {
                    double d4;
                    double d5;
                    double d6;
                    double d7;
                    double d8;
                    double d9;
                    wY<Sm> wY2;
                    switch (n2) {
                        case 1: {
                            wY2 = Sm.bh;
                            break;
                        }
                        case 2: {
                            wY2 = Sm.bg;
                            break;
                        }
                        case 3: {
                            wY2 = Sm.bi;
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unknown scroll event type: " + n2);
                        }
                    }
                    Window window = view.getWindow();
                    if (window != null) {
                        d9 = window.getPlatformScaleX();
                        d8 = window.getPlatformScaleY();
                        Screen screen = window.getScreen();
                        if (screen != null) {
                            d7 = screen.getPlatformX();
                            d6 = screen.getPlatformY();
                            d5 = screen.getX();
                            d4 = screen.getY();
                        } else {
                            d4 = 0.0;
                            d5 = 0.0;
                            d6 = 0.0;
                            d7 = 0.0;
                        }
                    } else {
                        d8 = 1.0;
                        d9 = 1.0;
                        d4 = 0.0;
                        d5 = 0.0;
                        d6 = 0.0;
                        d7 = 0.0;
                    }
                    this.scene.sceneListener.zoomEvent(wY2, d2, d4, n4 == Integer.MAX_VALUE ? Double.NaN : (double)n4 / d9, n5 == Integer.MAX_VALUE ? Double.NaN : (double)n5 / d8, n6 == Integer.MAX_VALUE ? Double.NaN : d5 + ((double)n6 - d7) / d9, n7 == Integer.MAX_VALUE ? Double.NaN : d4 + ((double)n7 - d6) / d8, (n3 & 1) != 0, (n3 & 4) != 0, (n3 & 8) != 0, (n3 & 0x10) != 0, bl2, bl3);
                }
                return null;
            }, this.scene.getAccessControlContext()));
        }
        finally {
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(false);
            }
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newInput(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRotateGestureEvent(View view, long l2, int n2, int n3, boolean bl2, boolean bl3, int n4, int n5, int n6, int n7, double d2, double d3) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("ROTATE_GESTURE_EVENT");
        }
        WindowStage windowStage = this.scene.getWindowStage();
        try {
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(false);
            }
            QuantumToolkit.runWithoutRenderLock(() -> AccessController.doPrivileged(() -> {
                if (this.scene.sceneListener != null) {
                    double d4;
                    double d5;
                    double d6;
                    double d7;
                    double d8;
                    double d9;
                    wY<Sc> wY2;
                    switch (n2) {
                        case 1: {
                            wY2 = Sc.aP;
                            break;
                        }
                        case 2: {
                            wY2 = Sc.aO;
                            break;
                        }
                        case 3: {
                            wY2 = Sc.aQ;
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unknown scroll event type: " + n2);
                        }
                    }
                    Window window = view.getWindow();
                    if (window != null) {
                        d9 = window.getPlatformScaleX();
                        d8 = window.getPlatformScaleY();
                        Screen screen = window.getScreen();
                        if (screen != null) {
                            d7 = screen.getPlatformX();
                            d6 = screen.getPlatformY();
                            d5 = screen.getX();
                            d4 = screen.getY();
                        } else {
                            d4 = 0.0;
                            d5 = 0.0;
                            d6 = 0.0;
                            d7 = 0.0;
                        }
                    } else {
                        d8 = 1.0;
                        d9 = 1.0;
                        d4 = 0.0;
                        d5 = 0.0;
                        d6 = 0.0;
                        d7 = 0.0;
                    }
                    this.scene.sceneListener.rotateEvent(wY2, d2, d3, n4 == Integer.MAX_VALUE ? Double.NaN : (double)n4 / d9, n5 == Integer.MAX_VALUE ? Double.NaN : (double)n5 / d8, n6 == Integer.MAX_VALUE ? Double.NaN : d5 + ((double)n6 - d7) / d9, n7 == Integer.MAX_VALUE ? Double.NaN : d4 + ((double)n7 - d6) / d8, (n3 & 1) != 0, (n3 & 4) != 0, (n3 & 8) != 0, (n3 & 0x10) != 0, bl2, bl3);
                }
                return null;
            }, this.scene.getAccessControlContext()));
        }
        finally {
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(false);
            }
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newInput(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleSwipeGestureEvent(View view, long l2, int n2, int n3, boolean bl2, boolean bl3, int n4, int n5, int n6, int n7, int n8, int n9) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("SWIPE_EVENT");
        }
        WindowStage windowStage = this.scene.getWindowStage();
        try {
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(false);
            }
            QuantumToolkit.runWithoutRenderLock(() -> AccessController.doPrivileged(() -> {
                if (this.scene.sceneListener != null) {
                    double d2;
                    double d3;
                    double d4;
                    double d5;
                    double d6;
                    double d7;
                    wY<Sg> wY2;
                    switch (n5) {
                        case 1: {
                            wY2 = Sg.aY;
                            break;
                        }
                        case 2: {
                            wY2 = Sg.aZ;
                            break;
                        }
                        case 3: {
                            wY2 = Sg.aW;
                            break;
                        }
                        case 4: {
                            wY2 = Sg.aX;
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unknown swipe event direction: " + n5);
                        }
                    }
                    Window window = view.getWindow();
                    if (window != null) {
                        d7 = window.getPlatformScaleX();
                        d6 = window.getPlatformScaleY();
                        Screen screen = window.getScreen();
                        if (screen != null) {
                            d5 = screen.getPlatformX();
                            d4 = screen.getPlatformY();
                            d3 = screen.getX();
                            d2 = screen.getY();
                        } else {
                            d2 = 0.0;
                            d3 = 0.0;
                            d4 = 0.0;
                            d5 = 0.0;
                        }
                    } else {
                        d6 = 1.0;
                        d7 = 1.0;
                        d2 = 0.0;
                        d3 = 0.0;
                        d4 = 0.0;
                        d5 = 0.0;
                    }
                    this.scene.sceneListener.swipeEvent(wY2, n4, n6 == Integer.MAX_VALUE ? Double.NaN : (double)n6 / d7, n7 == Integer.MAX_VALUE ? Double.NaN : (double)n7 / d6, n8 == Integer.MAX_VALUE ? Double.NaN : d3 + ((double)n8 - d5) / d7, n9 == Integer.MAX_VALUE ? Double.NaN : d2 + ((double)n9 - d4) / d6, (n3 & 1) != 0, (n3 & 4) != 0, (n3 & 8) != 0, (n3 & 0x10) != 0, bl2);
                }
                return null;
            }, this.scene.getAccessControlContext()));
        }
        finally {
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(false);
            }
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newInput(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleBeginTouchEvent(View view, long l2, int n2, boolean bl2, int n3) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("BEGIN_TOUCH_EVENT");
        }
        WindowStage windowStage = this.scene.getWindowStage();
        try {
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(true);
            }
            QuantumToolkit.runWithoutRenderLock(() -> AccessController.doPrivileged(() -> {
                if (this.scene.sceneListener != null) {
                    this.scene.sceneListener.touchEventBegin(l2, n3, bl2, (n2 & 1) != 0, (n2 & 4) != 0, (n2 & 8) != 0, (n2 & 0x10) != 0);
                }
                return null;
            }, this.scene.getAccessControlContext()));
        }
        finally {
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(false);
            }
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newInput(null);
            }
        }
        this.gestures.notifyBeginTouchEvent(l2, n2, bl2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNextTouchEvent(View view, long l2, int n2, long l3, int n3, int n4, int n5, int n6) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("NEXT_TOUCH_EVENT");
        }
        WindowStage windowStage = this.scene.getWindowStage();
        try {
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(true);
            }
            QuantumToolkit.runWithoutRenderLock(() -> AccessController.doPrivileged(() -> {
                if (this.scene.sceneListener != null) {
                    double d2;
                    double d3;
                    double d4;
                    double d5;
                    double d6;
                    double d7;
                    Sk sk2;
                    switch (n2) {
                        case 811: {
                            sk2 = Sk.a;
                            break;
                        }
                        case 812: {
                            sk2 = Sk.b;
                            break;
                        }
                        case 814: {
                            sk2 = Sk.c;
                            break;
                        }
                        case 813: {
                            sk2 = Sk.d;
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unknown touch state: " + n2);
                        }
                    }
                    Window window = view.getWindow();
                    if (window != null) {
                        d7 = window.getPlatformScaleX();
                        d6 = window.getPlatformScaleY();
                        Screen screen = window.getScreen();
                        if (screen != null) {
                            d5 = screen.getPlatformX();
                            d4 = screen.getPlatformY();
                            d3 = screen.getX();
                            d2 = screen.getY();
                        } else {
                            d2 = 0.0;
                            d3 = 0.0;
                            d4 = 0.0;
                            d5 = 0.0;
                        }
                    } else {
                        d6 = 1.0;
                        d7 = 1.0;
                        d2 = 0.0;
                        d3 = 0.0;
                        d4 = 0.0;
                        d5 = 0.0;
                    }
                    this.scene.sceneListener.touchEventNext(sk2, l3, (double)n3 / d7, (double)n4 / d6, d3 + ((double)n5 - d5) / d7, d2 + ((double)n6 - d4) / d6);
                }
                return null;
            }, this.scene.getAccessControlContext()));
        }
        finally {
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(false);
            }
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newInput(null);
            }
        }
        this.gestures.notifyNextTouchEvent(l2, n2, l3, n3, n4, n5, n6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleEndTouchEvent(View view, long l2) {
        if (PulseLogger.PULSE_LOGGING_ENABLED) {
            PulseLogger.newInput("END_TOUCH_EVENT");
        }
        WindowStage windowStage = this.scene.getWindowStage();
        try {
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(true);
            }
            QuantumToolkit.runWithoutRenderLock(() -> AccessController.doPrivileged(() -> {
                if (this.scene.sceneListener != null) {
                    this.scene.sceneListener.touchEventEnd();
                }
                return null;
            }, this.scene.getAccessControlContext()));
        }
        finally {
            if (windowStage != null) {
                windowStage.setInAllowedEventHandler(false);
            }
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newInput(null);
            }
        }
        this.gestures.notifyEndTouchEvent(l2);
    }

    @Override
    public Accessible getSceneAccessible() {
        if (this.scene != null && this.scene.sceneListener != null) {
            return this.scene.sceneListener.getSceneAccessible();
        }
        return null;
    }

    static {
        Void void_ = AccessController.doPrivileged(() -> {
            zoomGestureEnabled = Boolean.valueOf(System.getProperty("com.sun.javafx.gestures.zoom", "false"));
            rotateGestureEnabled = Boolean.valueOf(System.getProperty("com.sun.javafx.gestures.rotate", "false"));
            scrollGestureEnabled = Boolean.valueOf(System.getProperty("com.sun.javafx.gestures.scroll", "false"));
            return null;
        });
    }
}

