/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Menu;
import com.sun.glass.ui.MenuBar;
import com.sun.glass.ui.MenuItem;
import com.sun.glass.ui.Pixels;
import com.sun.javafx.PlatformUtil;
import com.sun.javafx.menu.CheckMenuItemBase;
import com.sun.javafx.menu.MenuBase;
import com.sun.javafx.menu.MenuItemBase;
import com.sun.javafx.menu.RadioMenuItemBase;
import com.sun.javafx.menu.SeparatorMenuItemBase;
import com.sun.javafx.tk.TKSystemMenu;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.tk.quantum.GlassMenuEventHandler;
import com.sun.javafx.tk.quantum.GlassSystemMenu$1;
import com.sun.javafx.tk.quantum.PixelUtils;
import com.sun.prism.Image;
import dev.protect.QQ;
import dev.protect.QY;
import dev.protect.RK;
import dev.protect.RL;
import dev.protect.RM;
import dev.protect.RO;
import dev.protect.RS;
import dev.protect.pv;
import dev.protect.tM;
import java.util.List;

class GlassSystemMenu
implements TKSystemMenu {
    private List<MenuBase> systemMenus = null;
    private MenuBar glassSystemMenuBar = null;
    private pv visibilityListener = px2 -> {
        if (this.systemMenus != null) {
            this.setMenus(this.systemMenus);
        }
    };

    GlassSystemMenu() {
    }

    protected void createMenuBar() {
        if (this.glassSystemMenuBar == null) {
            Application application = Application.GetApplication();
            this.glassSystemMenuBar = application.createMenuBar();
            application.installDefaultMenus(this.glassSystemMenuBar);
            if (this.systemMenus != null) {
                this.setMenus(this.systemMenus);
            }
        }
    }

    protected MenuBar getMenuBar() {
        return this.glassSystemMenuBar;
    }

    @Override
    public boolean isSupported() {
        return Application.GetApplication().supportsSystemMenu();
    }

    @Override
    public void setMenus(List<MenuBase> list) {
        this.systemMenus = list;
        if (this.glassSystemMenuBar != null) {
            List<Menu> list2 = this.glassSystemMenuBar.getMenus();
            int n2 = list2.size();
            for (int i2 = n2 - 1; i2 >= 1; --i2) {
                Menu object = list2.get(i2);
                this.clearMenu(object);
                this.glassSystemMenuBar.remove(i2);
            }
            for (MenuBase menuBase : list) {
                this.addMenu(null, menuBase);
            }
        }
    }

    private void clearMenu(Menu menu) {
        for (int i2 = menu.getItems().size() - 1; i2 >= 0; --i2) {
            Object object = menu.getItems().get(i2);
            if (object instanceof MenuItem) {
                ((MenuItem)object).setCallback(null);
                continue;
            }
            if (!(object instanceof Menu)) continue;
            this.clearMenu((Menu)object);
        }
        menu.setEventHandler(null);
    }

    private void addMenu(Menu menu, MenuBase menuBase) {
        if (menu != null) {
            this.insertMenu(menu, menuBase, menu.getItems().size());
        } else {
            this.insertMenu(menu, menuBase, this.glassSystemMenuBar.getMenus().size());
        }
    }

    private void insertMenu(Menu menu, MenuBase menuBase, int n2) {
        Application application = Application.GetApplication();
        Menu menu2 = application.createMenu(this.parseText(menuBase), !menuBase.isDisable());
        menu2.setEventHandler(new GlassMenuEventHandler(menuBase));
        menuBase.visibleProperty().removeListener(this.visibilityListener);
        menuBase.visibleProperty().addListener(this.visibilityListener);
        if (!menuBase.isVisible()) {
            return;
        }
        tM<MenuItemBase> tM2 = menuBase.getItemsBase();
        tM2.addListener(tD2 -> {
            while (tD2.next()) {
                Object object;
                int n2;
                int n3 = tD2.getFrom();
                int n4 = tD2.getTo();
                List list = tD2.getRemoved();
                for (n2 = n3 + list.size() - 1; n2 >= n3; --n2) {
                    object = menu2.getItems();
                    if (n2 < 0 || object.size() <= n2) continue;
                    menu2.remove(n2);
                }
                for (n2 = n3; n2 < n4; ++n2) {
                    object = (MenuItemBase)tD2.getList().get(n2);
                    if (object instanceof MenuBase) {
                        this.insertMenu(menu2, (MenuBase)object, n2);
                        continue;
                    }
                    this.insertMenuItem(menu2, (MenuItemBase)object, n2);
                }
            }
        });
        for (MenuItemBase menuItemBase : tM2) {
            if (menuItemBase instanceof MenuBase) {
                this.addMenu(menu2, (MenuBase)menuItemBase);
                continue;
            }
            this.addMenuItem(menu2, menuItemBase);
        }
        menu2.setPixels(this.getPixels(menuBase));
        this.setMenuBindings(menu2, menuBase);
        if (menu != null) {
            menu.insert(menu2, n2);
        } else {
            this.glassSystemMenuBar.insert(menu2, n2);
        }
    }

    private void setMenuBindings(Menu menu, MenuBase menuBase) {
        menuBase.textProperty().addListener(px2 -> menu.setTitle(this.parseText(menuBase)));
        menuBase.disableProperty().addListener(px2 -> menu.setEnabled(!menuBase.isDisable()));
        menuBase.mnemonicParsingProperty().addListener(px2 -> menu.setTitle(this.parseText(menuBase)));
    }

    private void addMenuItem(Menu menu, MenuItemBase menuItemBase) {
        this.insertMenuItem(menu, menuItemBase, menu.getItems().size());
    }

    private void insertMenuItem(Menu menu, MenuItemBase menuItemBase, int n2) {
        Application application = Application.GetApplication();
        menuItemBase.visibleProperty().removeListener(this.visibilityListener);
        menuItemBase.visibleProperty().addListener(this.visibilityListener);
        if (!menuItemBase.isVisible()) {
            return;
        }
        if (menuItemBase instanceof SeparatorMenuItemBase) {
            if (menuItemBase.isVisible()) {
                menu.insert(MenuItem.Separator, n2);
            }
        } else {
            GlassSystemMenu$1 glassSystemMenu$1 = new GlassSystemMenu$1(this, menuItemBase, menu);
            MenuItem menuItem = application.createMenuItem(this.parseText(menuItemBase), glassSystemMenu$1);
            menuItemBase.textProperty().addListener(px2 -> menuItem.setTitle(this.parseText(menuItemBase)));
            menuItem.setPixels(this.getPixels(menuItemBase));
            menuItemBase.graphicProperty().addListener(px2 -> menuItem.setPixels(this.getPixels(menuItemBase)));
            menuItem.setEnabled(!menuItemBase.isDisable());
            menuItemBase.disableProperty().addListener(px2 -> menuItem.setEnabled(!menuItemBase.isDisable()));
            this.setShortcut(menuItem, menuItemBase);
            menuItemBase.acceleratorProperty().addListener(px2 -> this.setShortcut(menuItem, menuItemBase));
            menuItemBase.mnemonicParsingProperty().addListener(px2 -> menuItem.setTitle(this.parseText(menuItemBase)));
            if (menuItemBase instanceof CheckMenuItemBase) {
                CheckMenuItemBase checkMenuItemBase = (CheckMenuItemBase)menuItemBase;
                menuItem.setChecked(checkMenuItemBase.isSelected());
                checkMenuItemBase.selectedProperty().addListener(px2 -> menuItem.setChecked(checkMenuItemBase.isSelected()));
            } else if (menuItemBase instanceof RadioMenuItemBase) {
                RadioMenuItemBase radioMenuItemBase = (RadioMenuItemBase)menuItemBase;
                menuItem.setChecked(radioMenuItemBase.isSelected());
                radioMenuItemBase.selectedProperty().addListener(px2 -> menuItem.setChecked(radioMenuItemBase.isSelected()));
            }
            menu.insert(menuItem, n2);
        }
    }

    private String parseText(MenuItemBase menuItemBase) {
        String string = menuItemBase.getText();
        if (string == null) {
            return "";
        }
        if (!string.isEmpty() && menuItemBase.isMnemonicParsing()) {
            return string.replaceFirst("_([^_])", "$1");
        }
        return string;
    }

    private Pixels getPixels(MenuItemBase menuItemBase) {
        if (menuItemBase.getGraphic() instanceof QY) {
            QY qY2 = (QY)menuItemBase.getGraphic();
            QQ qQ2 = qY2.a();
            if (qQ2 == null) {
                return null;
            }
            String string = qQ2.as();
            if (string == null || PixelUtils.supportedFormatType(string)) {
                Image image = (Image)Toolkit.getImageAccessor().getPlatformImage(qQ2);
                return image == null ? null : PixelUtils.imageToPixels(image);
            }
        }
        return null;
    }

    private void setShortcut(MenuItem menuItem, MenuItemBase menuItemBase) {
        RO rO2 = menuItemBase.getAccelerator();
        if (rO2 == null) {
            menuItem.setShortcut(0, 0);
        } else if (rO2 instanceof RM) {
            RM rM2 = (RM)rO2;
            RL rL2 = rM2.PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_();
            assert (PlatformUtil.isMac() || PlatformUtil.isLinux());
            int n2 = this.glassModifiers(rM2);
            if (PlatformUtil.isMac()) {
                int n3 = rL2.gU() ? (int)rL2.az().toUpperCase().charAt(0) : rL2.dl();
                menuItem.setShortcut(n3, n2);
            } else if (PlatformUtil.isLinux()) {
                String string = rL2.az().toLowerCase();
                if ((n2 & 4) != 0) {
                    menuItem.setShortcut(string.charAt(0), n2);
                } else {
                    menuItem.setShortcut(0, 0);
                }
            } else {
                menuItem.setShortcut(0, 0);
            }
        } else if (rO2 instanceof RK) {
            RK rK2 = (RK)rO2;
            String string = rK2.ax();
            menuItem.setShortcut(string.charAt(0), this.glassModifiers(rK2));
        }
    }

    private int glassModifiers(RO rO2) {
        RL rL2;
        int n2;
        int n3 = 0;
        if (rO2.getShift() == RS.a) {
            ++n3;
        }
        if (rO2.getControl() == RS.a) {
            n3 += 4;
        }
        if (rO2.getAlt() == RS.a) {
            n3 += 8;
        }
        if (rO2.getShortcut() == RS.a) {
            if (PlatformUtil.isLinux()) {
                n3 += 4;
            } else if (PlatformUtil.isMac()) {
                n3 += 16;
            }
        }
        if (rO2.getMeta() == RS.a) {
            if (PlatformUtil.isLinux()) {
                n3 += 16;
            } else if (PlatformUtil.isMac()) {
                n3 += 16;
            }
        }
        if (rO2 instanceof RM && ((n2 = (rL2 = ((RM)rO2).PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_()).dl()) >= RL.aF.dl() && n2 <= RL.aQ.dl() || n2 >= RL.aR.dl() && n2 <= RL.bc.dl())) {
            n3 += 2;
        }
        return n3;
    }
}

