/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk;

import com.sun.glass.ui.CommonDialogs$FileChooserResult;
import com.sun.glass.ui.GlassRobot;
import com.sun.glass.utils.NativeLibLoader;
import com.sun.javafx.PlatformUtil;
import com.sun.javafx.embed.HostInterface;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.perf.PerformanceTracker;
import com.sun.javafx.runtime.VersionInfo;
import com.sun.javafx.runtime.async.AsyncOperation;
import com.sun.javafx.runtime.async.AsyncOperationListener;
import com.sun.javafx.scene.text.TextLayoutFactory;
import com.sun.javafx.tk.FileChooserType;
import com.sun.javafx.tk.FontLoader;
import com.sun.javafx.tk.ImageLoader;
import com.sun.javafx.tk.LocalClipboard;
import com.sun.javafx.tk.PlatformImage;
import com.sun.javafx.tk.RenderJob;
import com.sun.javafx.tk.ScreenConfigurationAccessor;
import com.sun.javafx.tk.TKClipboard;
import com.sun.javafx.tk.TKDragGestureListener;
import com.sun.javafx.tk.TKDragSourceListener;
import com.sun.javafx.tk.TKDropTargetListener;
import com.sun.javafx.tk.TKListener;
import com.sun.javafx.tk.TKPulseListener;
import com.sun.javafx.tk.TKScene;
import com.sun.javafx.tk.TKScreenConfigurationListener;
import com.sun.javafx.tk.TKStage;
import com.sun.javafx.tk.TKSystemMenu;
import com.sun.javafx.tk.Toolkit$ImageAccessor;
import com.sun.javafx.tk.Toolkit$ImageRenderingContext;
import com.sun.javafx.tk.Toolkit$PaintAccessor;
import com.sun.javafx.tk.Toolkit$Task;
import com.sun.javafx.tk.Toolkit$WritableImageAccessor;
import com.sun.javafx.util.Utils;
import com.sun.scenario.DelayedRunnable;
import com.sun.scenario.animation.AbstractPrimaryTimer;
import com.sun.scenario.effect.AbstractShadow$ShadowMode;
import com.sun.scenario.effect.Color4f;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.Filterable;
import dev.protect.QQ;
import dev.protect.Qr;
import dev.protect.RB;
import dev.protect.RI;
import dev.protect.RL;
import dev.protect.RT;
import dev.protect.Sl;
import dev.protect.UM;
import dev.protect.UP;
import dev.protect.UQ;
import dev.protect.UU;
import dev.protect.UZ;
import dev.protect.Vb;
import dev.protect.Ww;
import dev.protect.XO;
import dev.protect.XP;
import dev.protect.XQ;
import dev.protect.Xe;
import dev.protect.aaS;
import dev.protect.aaT;
import dev.protect.abo;
import dev.protect.abp;
import dev.protect.pm;
import dev.protect.xj;
import java.io.File;
import java.io.InputStream;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;

public abstract class Toolkit {
    private static String tk;
    private static Toolkit TOOLKIT;
    private static Thread fxUserThread;
    private static final String QUANTUM_TOOLKIT = "com.sun.javafx.tk.quantum.QuantumToolkit";
    private static final String DEFAULT_TOOLKIT = "com.sun.javafx.tk.quantum.QuantumToolkit";
    private static final Map gradientMap;
    private static final boolean verbose;
    private static final String[] msLibNames;
    private final Map<TKPulseListener, AccessControlContext> stagePulseListeners = new WeakHashMap<TKPulseListener, AccessControlContext>();
    private final Map<TKPulseListener, AccessControlContext> scenePulseListeners = new WeakHashMap<TKPulseListener, AccessControlContext>();
    private final Map<TKPulseListener, AccessControlContext> postScenePulseListeners = new WeakHashMap<TKPulseListener, AccessControlContext>();
    private final Map<TKListener, AccessControlContext> toolkitListeners = new WeakHashMap<TKListener, AccessControlContext>();
    private final Set<Runnable> shutdownHooks = new HashSet<Runnable>();
    private TKPulseListener lastTkPulseListener = null;
    private AccessControlContext lastTkPulseAcc = null;
    private CountDownLatch pauseScenesLatch = null;
    private static Toolkit$WritableImageAccessor writableImageAccessor;
    private static Toolkit$PaintAccessor paintAccessor;
    private static Toolkit$ImageAccessor imageAccessor;

    private static String lookupToolkitClass(String string) {
        if ("prism".equalsIgnoreCase(string)) {
            return "com.sun.javafx.tk.quantum.QuantumToolkit";
        }
        if ("quantum".equalsIgnoreCase(string)) {
            return "com.sun.javafx.tk.quantum.QuantumToolkit";
        }
        return string;
    }

    public static synchronized void loadMSWindowsLibraries() {
        for (String string : msLibNames) {
            try {
                NativeLibLoader.loadLibrary(string);
            }
            catch (Throwable throwable) {
                if (!verbose) continue;
                System.err.println("Error: failed to load " + string + ".dll : " + throwable);
            }
        }
    }

    private static String getDefaultToolkit() {
        if (PlatformUtil.isWindows()) {
            return "com.sun.javafx.tk.quantum.QuantumToolkit";
        }
        if (PlatformUtil.isMac()) {
            return "com.sun.javafx.tk.quantum.QuantumToolkit";
        }
        if (PlatformUtil.isLinux()) {
            return "com.sun.javafx.tk.quantum.QuantumToolkit";
        }
        if (PlatformUtil.isIOS()) {
            return "com.sun.javafx.tk.quantum.QuantumToolkit";
        }
        if (PlatformUtil.isAndroid()) {
            return "com.sun.javafx.tk.quantum.QuantumToolkit";
        }
        throw new UnsupportedOperationException(System.getProperty("os.name") + " is not supported");
    }

    public static synchronized Toolkit getToolkit() {
        if (TOOLKIT != null) {
            return TOOLKIT;
        }
        Object object = AccessController.doPrivileged(() -> {
            VersionInfo.setupSystemProperties();
            return null;
        });
        if (PlatformUtil.isWindows()) {
            Toolkit.loadMSWindowsLibraries();
        }
        boolean bl2 = true;
        String string = null;
        try {
            string = System.getProperty("javafx.toolkit");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (string == null) {
            string = tk;
        }
        if (string == null) {
            bl2 = false;
            string = Toolkit.getDefaultToolkit();
        }
        if (string.indexOf(46) == -1) {
            string = Toolkit.lookupToolkitClass(string);
        }
        boolean bl3 = verbose || bl2 && !string.endsWith("StubToolkit");
        try {
            Class<?> clazz = null;
            try {
                ClassLoader classLoader = Toolkit.class.getClassLoader();
                clazz = Class.forName(string, false, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                clazz = Class.forName(string, false, classLoader);
            }
            if (!Toolkit.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Unrecognized FX Toolkit class: " + string);
            }
            TOOLKIT = (Toolkit)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (TOOLKIT.init()) {
                if (bl3) {
                    System.err.println("JavaFX: using " + string);
                }
                return TOOLKIT;
            }
            TOOLKIT = null;
        }
        catch (Exception exception) {
            TOOLKIT = null;
            exception.printStackTrace();
        }
        throw new RuntimeException("No toolkit found");
    }

    protected static Thread getFxUserThread() {
        return fxUserThread;
    }

    protected static void setFxUserThread(Thread thread) {
        if (fxUserThread != null) {
            throw new IllegalStateException("Error: FX User Thread already initialized");
        }
        fxUserThread = thread;
    }

    public void checkFxUserThread() {
        if (!this.isFxUserThread()) {
            throw new IllegalStateException("Not on FX application thread; currentThread = " + Thread.currentThread().getName());
        }
    }

    public boolean isFxUserThread() {
        return Thread.currentThread() == fxUserThread;
    }

    protected Toolkit() {
    }

    public abstract boolean init();

    public abstract boolean canStartNestedEventLoop();

    public abstract Object enterNestedEventLoop(Object var1);

    public abstract void exitNestedEventLoop(Object var1, Object var2);

    public abstract void exitAllNestedEventLoops();

    public abstract boolean isNestedLoopRunning();

    public abstract TKStage createTKStage(abp var1, boolean var2, abo var3, boolean var4, aaT var5, TKStage var6, boolean var7, AccessControlContext var8);

    public abstract TKStage createTKPopupStage(abp var1, abo var2, TKStage var3, AccessControlContext var4);

    public abstract TKStage createTKEmbeddedStage(HostInterface var1, AccessControlContext var2);

    private void runPulse(TKPulseListener tKPulseListener, AccessControlContext accessControlContext) {
        if (accessControlContext == null) {
            throw new IllegalStateException("Invalid AccessControlContext");
        }
        AccessController.doPrivileged(() -> {
            tKPulseListener.pulse();
            return null;
        }, accessControlContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePulse() {
        WeakHashMap<TKPulseListener, AccessControlContext> weakHashMap = new WeakHashMap<TKPulseListener, AccessControlContext>();
        WeakHashMap<TKPulseListener, AccessControlContext> weakHashMap2 = new WeakHashMap<TKPulseListener, AccessControlContext>();
        WeakHashMap<TKPulseListener, AccessControlContext> weakHashMap3 = new WeakHashMap<TKPulseListener, AccessControlContext>();
        Iterator iterator = this;
        synchronized (iterator) {
            weakHashMap.putAll(this.stagePulseListeners);
            weakHashMap2.putAll(this.scenePulseListeners);
            weakHashMap3.putAll(this.postScenePulseListeners);
        }
        for (Map.Entry entry : weakHashMap.entrySet()) {
            this.runPulse((TKPulseListener)entry.getKey(), (AccessControlContext)entry.getValue());
        }
        for (Map.Entry entry : weakHashMap2.entrySet()) {
            this.runPulse((TKPulseListener)entry.getKey(), (AccessControlContext)entry.getValue());
        }
        for (Map.Entry entry : weakHashMap3.entrySet()) {
            this.runPulse((TKPulseListener)entry.getKey(), (AccessControlContext)entry.getValue());
        }
        if (this.lastTkPulseListener != null) {
            this.runPulse(this.lastTkPulseListener, this.lastTkPulseAcc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStageTkPulseListener(TKPulseListener tKPulseListener) {
        if (tKPulseListener == null) {
            return;
        }
        Toolkit toolkit = this;
        synchronized (toolkit) {
            AccessControlContext accessControlContext = AccessController.getContext();
            this.stagePulseListeners.put(tKPulseListener, accessControlContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStageTkPulseListener(TKPulseListener tKPulseListener) {
        Toolkit toolkit = this;
        synchronized (toolkit) {
            this.stagePulseListeners.remove(tKPulseListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSceneTkPulseListener(TKPulseListener tKPulseListener) {
        if (tKPulseListener == null) {
            return;
        }
        Toolkit toolkit = this;
        synchronized (toolkit) {
            AccessControlContext accessControlContext = AccessController.getContext();
            this.scenePulseListeners.put(tKPulseListener, accessControlContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSceneTkPulseListener(TKPulseListener tKPulseListener) {
        Toolkit toolkit = this;
        synchronized (toolkit) {
            this.scenePulseListeners.remove(tKPulseListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPostSceneTkPulseListener(TKPulseListener tKPulseListener) {
        if (tKPulseListener == null) {
            return;
        }
        Toolkit toolkit = this;
        synchronized (toolkit) {
            AccessControlContext accessControlContext = AccessController.getContext();
            this.postScenePulseListeners.put(tKPulseListener, accessControlContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePostSceneTkPulseListener(TKPulseListener tKPulseListener) {
        Toolkit toolkit = this;
        synchronized (toolkit) {
            this.postScenePulseListeners.remove(tKPulseListener);
        }
    }

    public void addTkListener(TKListener tKListener) {
        if (tKListener == null) {
            return;
        }
        AccessControlContext accessControlContext = AccessController.getContext();
        this.toolkitListeners.put(tKListener, accessControlContext);
    }

    public void removeTkListener(TKListener tKListener) {
        this.toolkitListeners.remove(tKListener);
    }

    public void setLastTkPulseListener(TKPulseListener tKPulseListener) {
        this.lastTkPulseAcc = AccessController.getContext();
        this.lastTkPulseListener = tKPulseListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShutdownHook(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        Set<Runnable> set = this.shutdownHooks;
        synchronized (set) {
            this.shutdownHooks.add(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeShutdownHook(Runnable runnable) {
        Set<Runnable> set = this.shutdownHooks;
        synchronized (set) {
            this.shutdownHooks.remove(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyShutdownHooks() {
        ArrayList<Runnable> arrayList;
        Set<Runnable> set = this.shutdownHooks;
        synchronized (set) {
            arrayList = new ArrayList<Runnable>(this.shutdownHooks);
            this.shutdownHooks.clear();
        }
        for (Runnable runnable : arrayList) {
            runnable.run();
        }
    }

    public void notifyWindowListeners(List<TKStage> list) {
        for (Map.Entry<TKListener, AccessControlContext> entry : this.toolkitListeners.entrySet()) {
            TKListener tKListener = entry.getKey();
            AccessControlContext accessControlContext = entry.getValue();
            if (accessControlContext == null) {
                throw new IllegalStateException("Invalid AccessControlContext");
            }
            AccessController.doPrivileged(() -> {
                tKListener.changedTopLevelWindows(list);
                return null;
            }, accessControlContext);
        }
    }

    public void notifyLastNestedLoopExited() {
        for (TKListener tKListener : this.toolkitListeners.keySet()) {
            tKListener.exitedLastNestedLoop();
        }
    }

    public abstract void requestNextPulse();

    public abstract Future addRenderJob(RenderJob var1);

    public abstract ImageLoader loadImage(String var1, double var2, double var4, boolean var6, boolean var7);

    public abstract ImageLoader loadImage(InputStream var1, double var2, double var4, boolean var6, boolean var7);

    public abstract AsyncOperation loadImageAsync(AsyncOperationListener<? extends ImageLoader> var1, String var2, double var3, double var5, boolean var7, boolean var8);

    public abstract ImageLoader loadPlatformImage(Object var1);

    public abstract PlatformImage createPlatformImage(int var1, int var2);

    public boolean getDefaultImageSmooth() {
        return true;
    }

    public abstract void startup(Runnable var1);

    public abstract void defer(Runnable var1);

    public void exit() {
        fxUserThread = null;
    }

    public abstract Map<Object, Object> getContextMap();

    public abstract int getRefreshRate();

    public abstract void setAnimationRunnable(DelayedRunnable var1);

    public abstract PerformanceTracker getPerformanceTracker();

    public abstract PerformanceTracker createPerformanceTracker();

    public abstract void waitFor(Toolkit$Task var1);

    private Object checkSingleColor(List<Vb> list) {
        UM uM2;
        if (list.size() == 2 && (uM2 = list.get(0).f()).equals(list.get(1).f())) {
            return Toolkit.getPaintAccessor().getPlatformPaint(uM2);
        }
        return null;
    }

    private Object getPaint(UQ uQ2) {
        Object object = gradientMap.get(uQ2);
        if (object != null) {
            return object;
        }
        object = this.checkSingleColor(uQ2.ap());
        if (object == null) {
            object = this.createLinearGradientPaint(uQ2);
        }
        gradientMap.put(uQ2, object);
        return object;
    }

    private Object getPaint(UZ uZ2) {
        Object object = gradientMap.get(uZ2);
        if (object != null) {
            return object;
        }
        object = this.checkSingleColor(uZ2.aq());
        if (object == null) {
            object = this.createRadialGradientPaint(uZ2);
        }
        gradientMap.put(uZ2, object);
        return object;
    }

    public Object getPaint(UU uU2) {
        if (uU2 instanceof UM) {
            return this.createColorPaint((UM)uU2);
        }
        if (uU2 instanceof UQ) {
            return this.getPaint((UQ)uU2);
        }
        if (uU2 instanceof UZ) {
            return this.getPaint((UZ)uU2);
        }
        if (uU2 instanceof UP) {
            return this.createImagePatternPaint((UP)uU2);
        }
        return null;
    }

    protected static final double clampStopOffset(double d2) {
        return d2 > 1.0 ? 1.0 : (d2 < 0.0 ? 0.0 : d2);
    }

    protected abstract Object createColorPaint(UM var1);

    protected abstract Object createLinearGradientPaint(UQ var1);

    protected abstract Object createRadialGradientPaint(UZ var1);

    protected abstract Object createImagePatternPaint(UP var1);

    public abstract void accumulateStrokeBounds(Shape var1, float[] var2, XQ var3, double var4, XO var6, XP var7, float var8, BaseTransform var9);

    public abstract boolean strokeContains(Shape var1, double var2, double var4, XQ var6, double var7, XO var9, XP var10, float var11);

    public abstract Shape createStrokedShape(Shape var1, XQ var2, double var3, XO var5, XP var6, float var7, float[] var8, float var9);

    public abstract int getKeyCodeForChar(String var1);

    public abstract xj getBestCursorSize(int var1, int var2);

    public abstract int getMaximumCursorColors();

    public abstract Ww[] convertShapeToFXPath(Object var1);

    public abstract Filterable toFilterable(QQ var1);

    public abstract FilterContext getFilterContext(Object var1);

    public abstract boolean isForwardTraversalKey(RT var1);

    public abstract boolean isBackwardTraversalKey(RT var1);

    public abstract AbstractPrimaryTimer getPrimaryTimer();

    public abstract FontLoader getFontLoader();

    public abstract TextLayoutFactory getTextLayoutFactory();

    public abstract Object createSVGPathObject(Xe var1);

    public abstract Path2D createSVGPath2D(Xe var1);

    public abstract boolean imageContains(Object var1, float var2, float var3);

    public abstract TKClipboard getSystemClipboard();

    public TKClipboard createLocalClipboard() {
        return new LocalClipboard();
    }

    public abstract TKSystemMenu getSystemMenu();

    public abstract TKClipboard getNamedClipboard(String var1);

    public boolean isSupported(pm pm2) {
        return false;
    }

    public boolean isMSAASupported() {
        return false;
    }

    public abstract ScreenConfigurationAccessor setScreenConfigurationListener(TKScreenConfigurationListener var1);

    public abstract Object getPrimaryScreen();

    public abstract List<?> getScreens();

    public abstract ScreenConfigurationAccessor getScreenConfigurationAccessor();

    public abstract void registerDragGestureListener(TKScene var1, Set<Sl> var2, TKDragGestureListener var3);

    public abstract void startDrag(TKScene var1, Set<Sl> var2, TKDragSourceListener var3, RB var4);

    public void stopDrag(RB rB2) {
    }

    public abstract void enableDrop(TKScene var1, TKDropTargetListener var2);

    public Color4f toColor4f(UM uM2) {
        return new Color4f((float)uM2.ex(), (float)uM2.ey(), (float)uM2.ez(), (float)uM2.eA());
    }

    public AbstractShadow$ShadowMode toShadowMode(Qr qr2) {
        switch (qr2) {
            case PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_: {
                return AbstractShadow$ShadowMode.ONE_PASS_BOX;
            }
            case a: {
                return AbstractShadow$ShadowMode.TWO_PASS_BOX;
            }
            case b: {
                return AbstractShadow$ShadowMode.THREE_PASS_BOX;
            }
        }
        return AbstractShadow$ShadowMode.GAUSSIAN;
    }

    public abstract void installInputMethodRequests(TKScene var1, RI var2);

    public abstract Object renderToImage(Toolkit$ImageRenderingContext var1);

    public RL getPlatformShortcutKey() {
        return PlatformUtil.isMac() ? RL.bg : RL.f;
    }

    public abstract Optional<Boolean> isKeyLocked(RL var1);

    public abstract CommonDialogs$FileChooserResult showFileChooser(TKStage var1, String var2, File var3, String var4, FileChooserType var5, List<aaS> var6, aaS var7);

    public abstract File showDirectoryChooser(TKStage var1, String var2, File var3);

    public abstract long getMultiClickTime();

    public abstract int getMultiClickMaxX();

    public abstract int getMultiClickMaxY();

    public static void setWritableImageAccessor(Toolkit$WritableImageAccessor toolkit$WritableImageAccessor) {
        writableImageAccessor = toolkit$WritableImageAccessor;
    }

    public static Toolkit$WritableImageAccessor getWritableImageAccessor() {
        return writableImageAccessor;
    }

    public static void setPaintAccessor(Toolkit$PaintAccessor toolkit$PaintAccessor) {
        paintAccessor = toolkit$PaintAccessor;
    }

    public static Toolkit$PaintAccessor getPaintAccessor() {
        return paintAccessor;
    }

    public static void setImageAccessor(Toolkit$ImageAccessor toolkit$ImageAccessor) {
        imageAccessor = toolkit$ImageAccessor;
    }

    public static Toolkit$ImageAccessor getImageAccessor() {
        return imageAccessor;
    }

    public String getThemeName() {
        return null;
    }

    public abstract GlassRobot createRobot();

    static {
        fxUserThread = null;
        gradientMap = new WeakHashMap();
        verbose = AccessController.doPrivileged(() -> Boolean.getBoolean("javafx.verbose"));
        msLibNames = new String[]{"api-ms-win-core-console-l1-1-0", "api-ms-win-core-console-l1-2-0", "api-ms-win-core-datetime-l1-1-0", "api-ms-win-core-debug-l1-1-0", "api-ms-win-core-errorhandling-l1-1-0", "api-ms-win-core-file-l1-1-0", "api-ms-win-core-file-l1-2-0", "api-ms-win-core-file-l2-1-0", "api-ms-win-core-handle-l1-1-0", "api-ms-win-core-heap-l1-1-0", "api-ms-win-core-interlocked-l1-1-0", "api-ms-win-core-libraryloader-l1-1-0", "api-ms-win-core-localization-l1-2-0", "api-ms-win-core-memory-l1-1-0", "api-ms-win-core-namedpipe-l1-1-0", "api-ms-win-core-processenvironment-l1-1-0", "api-ms-win-core-processthreads-l1-1-0", "api-ms-win-core-processthreads-l1-1-1", "api-ms-win-core-profile-l1-1-0", "api-ms-win-core-rtlsupport-l1-1-0", "api-ms-win-core-string-l1-1-0", "api-ms-win-core-synch-l1-1-0", "api-ms-win-core-synch-l1-2-0", "api-ms-win-core-sysinfo-l1-1-0", "api-ms-win-core-timezone-l1-1-0", "api-ms-win-core-util-l1-1-0", "api-ms-win-crt-conio-l1-1-0", "api-ms-win-crt-convert-l1-1-0", "api-ms-win-crt-environment-l1-1-0", "api-ms-win-crt-filesystem-l1-1-0", "api-ms-win-crt-heap-l1-1-0", "api-ms-win-crt-locale-l1-1-0", "api-ms-win-crt-math-l1-1-0", "api-ms-win-crt-multibyte-l1-1-0", "api-ms-win-crt-private-l1-1-0", "api-ms-win-crt-process-l1-1-0", "api-ms-win-crt-runtime-l1-1-0", "api-ms-win-crt-stdio-l1-1-0", "api-ms-win-crt-string-l1-1-0", "api-ms-win-crt-time-l1-1-0", "api-ms-win-crt-utility-l1-1-0", "ucrtbase", "vcruntime140", "vcruntime140_1", "msvcp140", "msvcp140_1", "msvcp140_2"};
        writableImageAccessor = null;
        paintAccessor = null;
        Utils.forceInit(QQ.class);
    }
}

