/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg.prism;

import com.sun.javafx.geom.IllegalPathStateException;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.sg.prism.ShapeEvaluator;
import java.util.Vector;

class ShapeEvaluator$Geometry {
    static final float THIRD = 0.33333334f;
    static final float MIN_LEN = 0.001f;
    float[] bezierCoords = new float[20];
    int numCoords;
    int windingrule;
    float[] myTvals;

    public ShapeEvaluator$Geometry(Shape shape) {
        int n2;
        int n3;
        float f2;
        float f3;
        float f4;
        float f5;
        PathIterator pathIterator = shape.getPathIterator(null);
        this.windingrule = pathIterator.getWindingRule();
        if (pathIterator.isDone()) {
            this.numCoords = 8;
        }
        float[] fArray = new float[6];
        int n4 = pathIterator.currentSegment(fArray);
        pathIterator.next();
        if (n4 != 0) {
            throw new IllegalPathStateException("missing initial moveto");
        }
        float f6 = f5 = fArray[0];
        this.bezierCoords[0] = f5;
        float f7 = f4 = fArray[1];
        this.bezierCoords[1] = f4;
        Vector<Point2D> vector = new Vector<Point2D>();
        this.numCoords = 2;
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    if (f6 != f5 || f7 != f4) {
                        this.appendLineTo(f6, f7, f5, f4);
                        f6 = f5;
                        f7 = f4;
                    }
                    f3 = fArray[0];
                    f2 = fArray[1];
                    if (f6 == f3 && f7 == f2) break;
                    vector.add(new Point2D(f5, f4));
                    this.appendLineTo(f6, f7, f3, f2);
                    f6 = f5 = f3;
                    f7 = f4 = f2;
                    break;
                }
                case 4: {
                    if (f6 == f5 && f7 == f4) break;
                    this.appendLineTo(f6, f7, f5, f4);
                    f6 = f5;
                    f7 = f4;
                    break;
                }
                case 1: {
                    f3 = fArray[0];
                    f2 = fArray[1];
                    this.appendLineTo(f6, f7, f3, f2);
                    f6 = f3;
                    f7 = f2;
                    break;
                }
                case 2: {
                    float f8 = fArray[0];
                    float f9 = fArray[1];
                    f3 = fArray[2];
                    f2 = fArray[3];
                    this.appendQuadTo(f6, f7, f8, f9, f3, f2);
                    f6 = f3;
                    f7 = f2;
                    break;
                }
                case 3: {
                    f6 = fArray[4];
                    f7 = fArray[5];
                    this.appendCubicTo(fArray[0], fArray[1], fArray[2], fArray[3], f6, f7);
                }
            }
            pathIterator.next();
        }
        if (this.numCoords < 8 || f6 != f5 || f7 != f4) {
            this.appendLineTo(f6, f7, f5, f4);
            f6 = f5;
            f7 = f4;
        }
        for (n3 = vector.size() - 1; n3 >= 0; --n3) {
            Point2D point2D = (Point2D)vector.get(n3);
            f3 = point2D.x;
            f2 = point2D.y;
            if (f6 == f3 && f7 == f2) continue;
            this.appendLineTo(f6, f7, f3, f2);
            f6 = f3;
            f7 = f2;
        }
        n3 = 0;
        float f10 = this.bezierCoords[0];
        float f11 = this.bezierCoords[1];
        for (int i2 = 6; i2 < this.numCoords; i2 += 6) {
            float f12 = this.bezierCoords[i2];
            float f13 = this.bezierCoords[i2 + 1];
            if (!(f13 < f11) && (f13 != f11 || !(f12 < f10))) continue;
            n3 = i2;
            f10 = f12;
            f11 = f13;
        }
        if (n3 > 0) {
            float[] fArray2 = new float[this.numCoords];
            System.arraycopy(this.bezierCoords, n3, fArray2, 0, this.numCoords - n3);
            System.arraycopy(this.bezierCoords, 2, fArray2, this.numCoords - n3, n3);
            this.bezierCoords = fArray2;
        }
        float f14 = 0.0f;
        f6 = this.bezierCoords[0];
        f7 = this.bezierCoords[1];
        for (n2 = 2; n2 < this.numCoords; n2 += 2) {
            f3 = this.bezierCoords[n2];
            f2 = this.bezierCoords[n2 + 1];
            f14 += f6 * f2 - f3 * f7;
            f6 = f3;
            f7 = f2;
        }
        if (f14 < 0.0f) {
            n2 = 2;
            for (int i3 = this.numCoords - 4; n2 < i3; n2 += 2, i3 -= 2) {
                f6 = this.bezierCoords[n2];
                f7 = this.bezierCoords[n2 + 1];
                this.bezierCoords[n2] = this.bezierCoords[i3];
                this.bezierCoords[n2 + 1] = this.bezierCoords[i3 + 1];
                this.bezierCoords[i3] = f6;
                this.bezierCoords[i3 + 1] = f7;
            }
        }
    }

    private void appendLineTo(float f2, float f3, float f4, float f5) {
        this.appendCubicTo(ShapeEvaluator.interp(f2, f4, 0.33333334f), ShapeEvaluator.interp(f3, f5, 0.33333334f), ShapeEvaluator.interp(f4, f2, 0.33333334f), ShapeEvaluator.interp(f5, f3, 0.33333334f), f4, f5);
    }

    private void appendQuadTo(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.appendCubicTo(ShapeEvaluator.interp(f4, f2, 0.33333334f), ShapeEvaluator.interp(f5, f3, 0.33333334f), ShapeEvaluator.interp(f4, f6, 0.33333334f), ShapeEvaluator.interp(f5, f7, 0.33333334f), f6, f7);
    }

    private void appendCubicTo(float f2, float f3, float f4, float f5, float f6, float f7) {
        if (this.numCoords + 6 > this.bezierCoords.length) {
            int n2 = (this.numCoords - 2) * 2 + 2;
            float[] fArray = new float[n2];
            System.arraycopy(this.bezierCoords, 0, fArray, 0, this.numCoords);
            this.bezierCoords = fArray;
        }
        this.bezierCoords[this.numCoords++] = f2;
        this.bezierCoords[this.numCoords++] = f3;
        this.bezierCoords[this.numCoords++] = f4;
        this.bezierCoords[this.numCoords++] = f5;
        this.bezierCoords[this.numCoords++] = f6;
        this.bezierCoords[this.numCoords++] = f7;
    }

    public int getWindingRule() {
        return this.windingrule;
    }

    public int getNumCoords() {
        return this.numCoords;
    }

    public float getCoord(int n2) {
        return this.bezierCoords[n2];
    }

    public float[] getTvals() {
        float f2;
        float f3;
        if (this.myTvals != null) {
            return this.myTvals;
        }
        float[] fArray = new float[(this.numCoords - 2) / 6 + 1];
        float f4 = this.bezierCoords[0];
        float f5 = this.bezierCoords[1];
        float f6 = 0.0f;
        int n2 = 2;
        int n3 = 0;
        while (n2 < this.numCoords) {
            f3 = f4;
            f2 = f5;
            float f7 = this.bezierCoords[n2++];
            float f8 = this.bezierCoords[n2++];
            float f9 = (float)Math.sqrt((f3 -= f7) * f3 + (f2 -= f8) * f2);
            f3 = f7;
            f2 = f8;
            f7 = this.bezierCoords[n2++];
            f8 = this.bezierCoords[n2++];
            f9 += (float)Math.sqrt((f3 -= f7) * f3 + (f2 -= f8) * f2);
            f3 = f7;
            f2 = f8;
            f7 = this.bezierCoords[n2++];
            f8 = this.bezierCoords[n2++];
            f9 += (float)Math.sqrt((f3 -= f7) * f3 + (f2 -= f8) * f2);
            f9 += (float)Math.sqrt((f4 -= f7) * f4 + (f5 -= f8) * f5);
            if ((f9 /= 2.0f) < 0.001f) {
                f9 = 0.001f;
            }
            fArray[n3++] = f6 += f9;
            f4 = f7;
            f5 = f8;
        }
        f3 = fArray[0];
        fArray[0] = 0.0f;
        for (n3 = 1; n3 < fArray.length - 1; ++n3) {
            f2 = fArray[n3];
            fArray[n3] = f3 / f6;
            f3 = f2;
        }
        fArray[n3] = 1.0f;
        this.myTvals = fArray;
        return fArray;
    }

    public void setTvals(float[] fArray) {
        float f2;
        float f3;
        float[] fArray2 = this.bezierCoords;
        float[] fArray3 = new float[2 + (fArray.length - 1) * 6];
        float[] fArray4 = this.getTvals();
        int n2 = 0;
        float f4 = f3 = fArray2[n2++];
        float f5 = f3;
        float f6 = f3;
        float f7 = f2 = fArray2[n2++];
        float f8 = f2;
        float f9 = f2;
        int n3 = 0;
        fArray3[n3++] = f6;
        fArray3[n3++] = f9;
        float f10 = 0.0f;
        float f11 = 0.0f;
        int n4 = 1;
        int n5 = 1;
        while (n5 < fArray.length) {
            if (f10 >= f11) {
                f6 = f3;
                f9 = f2;
                f5 = fArray2[n2++];
                f8 = fArray2[n2++];
                f4 = fArray2[n2++];
                f7 = fArray2[n2++];
                f3 = fArray2[n2++];
                f2 = fArray2[n2++];
                f11 = fArray4[n4++];
            }
            int n6 = n5++;
            float f12 = fArray[n6];
            if (f12 < f11) {
                float f13 = (f12 - f10) / (f11 - f10);
                fArray3[n3++] = f6 = ShapeEvaluator.interp(f6, f5, f13);
                fArray3[n3++] = f9 = ShapeEvaluator.interp(f9, f8, f13);
                f5 = ShapeEvaluator.interp(f5, f4, f13);
                f8 = ShapeEvaluator.interp(f8, f7, f13);
                f4 = ShapeEvaluator.interp(f4, f3, f13);
                f7 = ShapeEvaluator.interp(f7, f2, f13);
                fArray3[n3++] = f6 = ShapeEvaluator.interp(f6, f5, f13);
                fArray3[n3++] = f9 = ShapeEvaluator.interp(f9, f8, f13);
                f5 = ShapeEvaluator.interp(f5, f4, f13);
                f8 = ShapeEvaluator.interp(f8, f7, f13);
                fArray3[n3++] = f6 = ShapeEvaluator.interp(f6, f5, f13);
                fArray3[n3++] = f9 = ShapeEvaluator.interp(f9, f8, f13);
            } else {
                fArray3[n3++] = f5;
                fArray3[n3++] = f8;
                fArray3[n3++] = f4;
                fArray3[n3++] = f7;
                fArray3[n3++] = f3;
                fArray3[n3++] = f2;
            }
            f10 = f12;
        }
        this.bezierCoords = fArray3;
        this.numCoords = fArray3.length;
        this.myTvals = fArray;
    }
}

