/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg.prism;

import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.logging.PulseLogger;
import com.sun.javafx.sg.prism.RegionImageCache$CachedImage;
import com.sun.prism.Graphics;
import com.sun.prism.RTTexture;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture$WrapMode;
import com.sun.prism.impl.packrect.RectanglePacker;
import dev.protect.Sn;
import java.util.HashMap;

class RegionImageCache {
    private static final int MAX_SIZE = 90000;
    private static final int WIDTH = 1024;
    private static final int HEIGHT = 1024;
    private HashMap<Integer, RegionImageCache$CachedImage> imageMap = new HashMap();
    private RTTexture backingStore;
    private RectanglePacker hPacker;
    private RectanglePacker vPacker;

    RegionImageCache(ResourceFactory resourceFactory) {
        int n2;
        Texture$WrapMode texture$WrapMode;
        if (resourceFactory.isWrapModeSupported(Texture$WrapMode.CLAMP_TO_ZERO)) {
            texture$WrapMode = Texture$WrapMode.CLAMP_TO_ZERO;
            n2 = 0;
        } else {
            texture$WrapMode = Texture$WrapMode.CLAMP_NOT_NEEDED;
            n2 = 1;
        }
        this.backingStore = resourceFactory.createRTTexture(2048, 1024, texture$WrapMode);
        this.backingStore.contentsUseful();
        this.backingStore.makePermanent();
        resourceFactory.setRegionTexture(this.backingStore);
        this.hPacker = new RectanglePacker(this.backingStore, n2, n2, 1024 - n2, 1024 - n2, false);
        this.vPacker = new RectanglePacker(this.backingStore, 1024, n2, 1024, 1024 - n2, true);
    }

    boolean isImageCachable(int n2, int n3) {
        return 0 < n2 && n2 < 1024 && 0 < n3 && n3 < 1024 && n2 * n3 < 90000;
    }

    RTTexture getBackingStore() {
        return this.backingStore;
    }

    boolean getImageLocation(Integer n2, Rectangle rectangle, Sn sn2, Shape shape, Graphics graphics) {
        RectanglePacker rectanglePacker;
        RegionImageCache$CachedImage regionImageCache$CachedImage = this.imageMap.get(n2);
        if (regionImageCache$CachedImage != null) {
            if (regionImageCache$CachedImage.equals(rectangle.width, rectangle.height, sn2, shape)) {
                rectangle.x = regionImageCache$CachedImage.x;
                rectangle.y = regionImageCache$CachedImage.y;
                return false;
            }
            rectangle.height = -1;
            rectangle.width = -1;
            return false;
        }
        boolean bl2 = rectangle.height > 64;
        RectanglePacker rectanglePacker2 = rectanglePacker = bl2 ? this.vPacker : this.hPacker;
        if (!rectanglePacker.add(rectangle)) {
            graphics.sync();
            this.vPacker.clear();
            this.hPacker.clear();
            this.imageMap.clear();
            rectanglePacker.add(rectangle);
            this.backingStore.createGraphics().clear();
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.incrementCounter("Region image cache flushed");
            }
        }
        this.imageMap.put(n2, new RegionImageCache$CachedImage(rectangle, sn2, shape));
        return true;
    }
}

