/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.traversal;

import com.sun.javafx.scene.traversal.Algorithm;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.TraversalContext;
import dev.protect.xi;
import dev.protect.xo;
import dev.protect.yD;
import java.util.List;

public class WeightedClosestCorner
implements Algorithm {
    WeightedClosestCorner() {
    }

    private boolean isOnAxis(Direction direction, xi xi2, xi xi3) {
        double d2;
        double d3;
        double d4;
        double d5;
        if (direction == Direction.UP || direction == Direction.DOWN) {
            d5 = xi2.am();
            d4 = xi2.as();
            d3 = xi3.am();
            d2 = xi3.as();
        } else {
            d5 = xi2.an();
            d4 = xi2.at();
            d3 = xi3.an();
            d2 = xi3.at();
        }
        return d3 <= d4 && d2 >= d5;
    }

    private double outDistance(Direction direction, xi xi2, xi xi3) {
        double d2 = direction == Direction.UP ? xi2.an() - xi3.at() : (direction == Direction.DOWN ? xi3.an() - xi2.at() : (direction == Direction.LEFT ? xi2.am() - xi3.as() : xi3.am() - xi2.as()));
        return d2;
    }

    private double centerSideDistance(Direction direction, xi xi2, xi xi3) {
        double d2;
        double d3;
        if (direction == Direction.UP || direction == Direction.DOWN) {
            d3 = xi2.am() + xi2.ap() / 2.0;
            d2 = xi3.am() + xi3.ap() / 2.0;
        } else {
            d3 = xi2.an() + xi2.aq() / 2.0;
            d2 = xi3.an() + xi3.aq() / 2.0;
        }
        return Math.abs(d2 - d3);
    }

    private double cornerSideDistance(Direction direction, xi xi2, xi xi3) {
        double d2 = direction == Direction.UP || direction == Direction.DOWN ? (xi3.am() > xi2.as() ? xi3.am() - xi2.as() : xi2.am() - xi3.as()) : (xi3.an() > xi2.at() ? xi3.an() - xi2.at() : xi2.an() - xi3.at());
        return d2;
    }

    @Override
    public yD select(yD yD2, Direction direction, TraversalContext traversalContext) {
        yD yD3 = null;
        List<yD> list = traversalContext.getAllTargetNodes();
        int n2 = this.traverse(traversalContext.getSceneLayoutBounds(yD2), direction, list, traversalContext);
        if (n2 != -1) {
            yD3 = list.get(n2);
        }
        return yD3;
    }

    @Override
    public yD selectFirst(TraversalContext traversalContext) {
        List<yD> list = traversalContext.getAllTargetNodes();
        xo xo2 = new xo(0.0, 0.0);
        if (list.size() > 0) {
            yD yD2 = list.get(0);
            double d2 = xo2.distance(traversalContext.getSceneLayoutBounds(list.get(0)).am(), traversalContext.getSceneLayoutBounds(list.get(0)).an());
            for (int i2 = 1; i2 < list.size(); ++i2) {
                double d3 = xo2.distance(traversalContext.getSceneLayoutBounds(list.get(i2)).am(), traversalContext.getSceneLayoutBounds(list.get(i2)).an());
                if (!(d2 > d3)) continue;
                d2 = d3;
                yD2 = list.get(i2);
            }
            return yD2;
        }
        return null;
    }

    @Override
    public yD selectLast(TraversalContext traversalContext) {
        return null;
    }

    public int traverse(xi xi2, Direction direction, List<yD> list, TraversalContext traversalContext) {
        int n2 = direction == Direction.NEXT || direction == Direction.NEXT_IN_LINE || direction == Direction.PREVIOUS ? this.trav1D(xi2, direction, list, traversalContext) : this.trav2D(xi2, direction, list, traversalContext);
        return n2;
    }

    private int trav2D(xi xi2, Direction direction, List<yD> list, TraversalContext traversalContext) {
        xi xi3 = null;
        double d2 = 0.0;
        int n2 = -1;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            double d3;
            xi xi4 = traversalContext.getSceneLayoutBounds(list.get(i2));
            double d4 = this.outDistance(direction, xi2, xi4);
            if (this.isOnAxis(direction, xi2, xi4)) {
                d3 = d4 + this.centerSideDistance(direction, xi2, xi4) / 100.0;
            } else {
                double d5 = this.cornerSideDistance(direction, xi2, xi4);
                d3 = 100000.0 + d4 * d4 + 9.0 * d5 * d5;
            }
            if (d4 < 0.0 || xi3 != null && !(d3 < d2)) continue;
            xi3 = xi4;
            d2 = d3;
            n2 = i2;
        }
        return n2;
    }

    private int compare1D(xi xi2, xi xi3) {
        int n2 = 0;
        double d2 = (xi2.an() + xi2.at()) / 2.0;
        double d3 = (xi3.an() + xi3.at()) / 2.0;
        double d4 = (xi2.am() + xi2.as()) / 2.0;
        double d5 = (xi3.am() + xi3.as()) / 2.0;
        double d6 = xi2.hashCode();
        double d7 = xi3.hashCode();
        if (d2 < d3) {
            n2 = -1;
        } else if (d2 > d3) {
            n2 = 1;
        } else if (d4 < d5) {
            n2 = -1;
        } else if (d4 > d5) {
            n2 = 1;
        } else if (d6 < d7) {
            n2 = -1;
        } else if (d6 > d7) {
            n2 = 1;
        }
        return n2;
    }

    private int compare1D(xi xi2, xi xi3, Direction direction) {
        return direction != Direction.PREVIOUS ? -this.compare1D(xi2, xi3) : this.compare1D(xi2, xi3);
    }

    private int trav1D(xi xi2, Direction direction, List<yD> list, TraversalContext traversalContext) {
        int n2 = -1;
        int n3 = -1;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (n3 == -1 || this.compare1D(traversalContext.getSceneLayoutBounds(list.get(i2)), traversalContext.getSceneLayoutBounds(list.get(n3)), direction) < 0) {
                n3 = i2;
            }
            if (this.compare1D(traversalContext.getSceneLayoutBounds(list.get(i2)), xi2, direction) < 0 || n2 != -1 && this.compare1D(traversalContext.getSceneLayoutBounds(list.get(i2)), traversalContext.getSceneLayoutBounds(list.get(n2)), direction) >= 0) continue;
            n2 = i2;
        }
        return n2 == -1 ? n3 : n2;
    }
}

