/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.traversal;

import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.scene.traversal.Algorithm;
import com.sun.javafx.scene.traversal.ContainerTabOrder;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.Hueristic2D;
import com.sun.javafx.scene.traversal.TraversalContext;
import com.sun.javafx.scene.traversal.TraversalEngine$EngineContext;
import com.sun.javafx.scene.traversal.TraversalEngine$TempEngineContext;
import com.sun.javafx.scene.traversal.TraverseListener;
import dev.protect.xh;
import dev.protect.xi;
import dev.protect.yD;
import dev.protect.zV;
import java.util.ArrayList;

public abstract class TraversalEngine {
    static final Algorithm DEFAULT_ALGORITHM = PlatformImpl.isContextual2DNavigation() ? new Hueristic2D() : new ContainerTabOrder();
    private final TraversalContext context = new TraversalEngine$EngineContext(this);
    private final TraversalEngine$TempEngineContext tempEngineContext = new TraversalEngine$TempEngineContext(this);
    protected final Algorithm algorithm;
    private final xi initialBounds = new xh(0.0, 0.0, 1.0, 1.0);
    private final ArrayList<TraverseListener> listeners = new ArrayList();

    protected TraversalEngine(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    protected TraversalEngine() {
        this.algorithm = null;
    }

    public final void addTraverseListener(TraverseListener traverseListener) {
        this.listeners.add(traverseListener);
    }

    final void notifyTraversedTo(yD yD2) {
        for (TraverseListener traverseListener : this.listeners) {
            traverseListener.onTraverse(yD2, this.getLayoutBounds(yD2, this.getRoot()));
        }
    }

    public final yD select(yD yD2, Direction direction) {
        return this.algorithm.select(yD2, direction, this.context);
    }

    public final yD selectFirst() {
        return this.algorithm.selectFirst(this.context);
    }

    public final yD selectLast() {
        return this.algorithm.selectLast(this.context);
    }

    protected abstract zV getRoot();

    public final boolean canTraverse() {
        return this.algorithm != null;
    }

    private xi getLayoutBounds(yD yD2, zV zV2) {
        xi xi2 = yD2 != null ? (zV2 == null ? yD2.localToScene(yD2.getLayoutBounds()) : zV2.sceneToLocal(yD2.localToScene(yD2.getLayoutBounds()))) : this.initialBounds;
        return xi2;
    }
}

