/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.traversal;

import com.sun.javafx.scene.ParentHelper;
import com.sun.javafx.scene.traversal.Algorithm;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.ParentTraversalEngine;
import com.sun.javafx.scene.traversal.TraversalEngine;
import dev.protect.yD;
import dev.protect.zV;

public abstract class TopMostTraversalEngine
extends TraversalEngine {
    protected TopMostTraversalEngine() {
        super(DEFAULT_ALGORITHM);
    }

    TopMostTraversalEngine(Algorithm algorithm) {
        super(algorithm);
    }

    public final yD trav(yD yD2, Direction direction) {
        yD yD3 = null;
        yD yD4 = yD2;
        for (zV zV2 = yD2.getParent(); zV2 != null; zV2 = zV2.getParent()) {
            ParentTraversalEngine parentTraversalEngine = ParentHelper.getTraversalEngine(zV2);
            if (parentTraversalEngine == null || !parentTraversalEngine.canTraverse()) continue;
            yD3 = parentTraversalEngine.select(yD2, direction);
            if (yD3 != null) break;
            yD4 = zV2;
            if (direction != Direction.NEXT) continue;
            direction = Direction.NEXT_IN_LINE;
        }
        if (yD3 == null) {
            yD3 = this.select(yD4, direction);
        }
        if (yD3 == null) {
            if (direction == Direction.NEXT || direction == Direction.NEXT_IN_LINE) {
                yD3 = this.selectFirst();
            } else if (direction == Direction.PREVIOUS) {
                yD3 = this.selectLast();
            }
        }
        if (yD3 != null) {
            this.focusAndNotify(yD3);
        }
        return yD3;
    }

    private void focusAndNotify(yD yD2) {
        yD2.requestFocus();
        this.notifyTreeTraversedTo(yD2);
    }

    private void notifyTreeTraversedTo(yD yD2) {
        for (zV zV2 = yD2.getParent(); zV2 != null; zV2 = zV2.getParent()) {
            ParentTraversalEngine parentTraversalEngine = ParentHelper.getTraversalEngine(zV2);
            if (parentTraversalEngine == null) continue;
            parentTraversalEngine.notifyTraversedTo(yD2);
        }
        this.notifyTraversedTo(yD2);
    }

    public final yD traverseToFirst() {
        yD yD2 = this.selectFirst();
        if (yD2 != null) {
            this.focusAndNotify(yD2);
        }
        return yD2;
    }

    public final yD traverseToLast() {
        yD yD2 = this.selectLast();
        if (yD2 != null) {
            this.focusAndNotify(yD2);
        }
        return yD2;
    }
}

