/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.traversal;

import com.sun.javafx.scene.traversal.Algorithm;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.Hueristic2D$TargetNode;
import com.sun.javafx.scene.traversal.TabOrderHelper;
import com.sun.javafx.scene.traversal.TraversalContext;
import dev.protect.xh;
import dev.protect.xi;
import dev.protect.xo;
import dev.protect.yD;
import java.util.List;
import java.util.Stack;
import java.util.function.Function;

public class Hueristic2D
implements Algorithm {
    protected yD cacheStartTraversalNode = null;
    protected Direction cacheStartTraversalDirection = null;
    protected boolean reverseDirection = false;
    protected yD cacheLastTraversalNode = null;
    protected Stack<yD> traversalNodeStack = new Stack();
    private static final Function<xi, Double> BOUNDS_TOP_SIDE = xi2 -> xi2.an();
    private static final Function<xi, Double> BOUNDS_BOTTOM_SIDE = xi2 -> xi2.at();
    private static final Function<xi, Double> BOUNDS_LEFT_SIDE = xi2 -> xi2.am();
    private static final Function<xi, Double> BOUNDS_RIGHT_SIDE = xi2 -> xi2.as();

    Hueristic2D() {
    }

    @Override
    public yD select(yD yD2, Direction direction, TraversalContext traversalContext) {
        yD yD3 = null;
        this.cacheTraversal(yD2, direction);
        if (Direction.NEXT.equals((Object)direction) || Direction.NEXT_IN_LINE.equals((Object)direction)) {
            yD3 = TabOrderHelper.findNextFocusablePeer(yD2, traversalContext.getRoot(), direction == Direction.NEXT);
        } else if (Direction.PREVIOUS.equals((Object)direction)) {
            yD3 = TabOrderHelper.findPreviousFocusablePeer(yD2, traversalContext.getRoot());
        } else if (Direction.UP.equals((Object)direction) || Direction.DOWN.equals((Object)direction) || Direction.LEFT.equals((Object)direction) || Direction.RIGHT.equals((Object)direction)) {
            if (this.reverseDirection && !this.traversalNodeStack.empty()) {
                if (!this.traversalNodeStack.peek().isFocusTraversable()) {
                    this.traversalNodeStack.clear();
                } else {
                    yD3 = this.traversalNodeStack.pop();
                }
            }
            if (yD3 == null) {
                xi xi2 = yD2.localToScene(yD2.getLayoutBounds());
                if (this.cacheStartTraversalNode != null) {
                    xi xi3 = this.cacheStartTraversalNode.localToScene(this.cacheStartTraversalNode.getLayoutBounds());
                    switch (direction) {
                        case UP: 
                        case DOWN: {
                            yD3 = this.getNearestNodeUpOrDown(xi2, xi3, traversalContext, direction);
                            break;
                        }
                        case LEFT: 
                        case RIGHT: {
                            yD3 = this.getNearestNodeLeftOrRight(xi2, xi3, traversalContext, direction);
                            break;
                        }
                    }
                }
            }
        }
        if (yD3 != null) {
            this.cacheLastTraversalNode = yD3;
            if (!this.reverseDirection) {
                this.traversalNodeStack.push(yD2);
            }
        }
        return yD3;
    }

    @Override
    public yD selectFirst(TraversalContext traversalContext) {
        return TabOrderHelper.getFirstTargetNode(traversalContext.getRoot());
    }

    @Override
    public yD selectLast(TraversalContext traversalContext) {
        return TabOrderHelper.getLastTargetNode(traversalContext.getRoot());
    }

    private boolean isOnAxis(Direction direction, xi xi2, xi xi3) {
        double d2;
        double d3;
        double d4;
        double d5;
        if (direction == Direction.UP || direction == Direction.DOWN) {
            d5 = xi2.am();
            d4 = xi2.as();
            d3 = xi3.am();
            d2 = xi3.as();
        } else {
            d5 = xi2.an();
            d4 = xi2.at();
            d3 = xi3.an();
            d2 = xi3.at();
        }
        return d3 <= d4 && d2 >= d5;
    }

    private double outDistance(Direction direction, xi xi2, xi xi3) {
        double d2 = direction == Direction.UP ? xi2.an() - xi3.at() : (direction == Direction.DOWN ? xi3.an() - xi2.at() : (direction == Direction.LEFT ? xi2.am() - xi3.as() : xi3.am() - xi2.as()));
        return d2;
    }

    private double centerSideDistance(Direction direction, xi xi2, xi xi3) {
        double d2;
        double d3;
        if (direction == Direction.UP || direction == Direction.DOWN) {
            d3 = xi2.am() + xi2.ap() / 2.0;
            d2 = xi3.am() + xi3.ap() / 2.0;
        } else {
            d3 = xi2.an() + xi2.aq() / 2.0;
            d2 = xi3.an() + xi3.aq() / 2.0;
        }
        return Math.abs(d2 - d3);
    }

    private double cornerSideDistance(Direction direction, xi xi2, xi xi3) {
        double d2 = direction == Direction.UP || direction == Direction.DOWN ? (xi3.am() > xi2.as() ? xi3.am() - xi2.as() : xi2.am() - xi3.as()) : (xi3.an() > xi2.at() ? xi3.an() - xi2.at() : xi2.an() - xi3.at());
        return d2;
    }

    private void cacheTraversal(yD yD2, Direction direction) {
        if (!this.traversalNodeStack.empty() && yD2 != this.cacheLastTraversalNode) {
            this.traversalNodeStack.clear();
        }
        if (direction == Direction.NEXT || direction == Direction.PREVIOUS) {
            this.traversalNodeStack.clear();
            this.reverseDirection = false;
        } else if (this.cacheStartTraversalNode == null || direction != this.cacheStartTraversalDirection) {
            if (direction == Direction.UP && this.cacheStartTraversalDirection == Direction.DOWN || direction == Direction.DOWN && this.cacheStartTraversalDirection == Direction.UP || direction == Direction.LEFT && this.cacheStartTraversalDirection == Direction.RIGHT || direction == Direction.RIGHT && this.cacheStartTraversalDirection == Direction.LEFT && !this.traversalNodeStack.empty()) {
                this.reverseDirection = true;
            } else {
                this.cacheStartTraversalNode = yD2;
                this.cacheStartTraversalDirection = direction;
                this.reverseDirection = false;
                this.traversalNodeStack.clear();
            }
        } else {
            this.reverseDirection = false;
        }
    }

    protected yD getNearestNodeUpOrDown(xi xi2, xi xi3, TraversalContext traversalContext, Direction direction) {
        List<yD> list = traversalContext.getAllTargetNodes();
        Function<xi, Double> function = direction == Direction.DOWN ? BOUNDS_BOTTOM_SIDE : BOUNDS_TOP_SIDE;
        Function<xi, Double> function2 = direction == Direction.DOWN ? BOUNDS_TOP_SIDE : BOUNDS_BOTTOM_SIDE;
        xh xh2 = new xh(xi3.am(), xi2.an(), xi3.ap(), xi2.aq());
        xo xo2 = new xo(xi2.am() + xi2.ap() / 2.0, function.apply(xi2));
        xo xo3 = new xo(xi3.am() + xi3.ap() / 2.0, function.apply(xi2));
        xo xo4 = new xo(xi2.am(), function.apply(xi2));
        xo xo5 = new xo(xi3.am(), function.apply(xi2));
        xo xo6 = new xo(xi2.as(), function.apply(xi2));
        xo xo7 = new xo(xi3.as(), function.apply(xi2));
        xo xo8 = new xo(xi3.am(), function.apply(xi3));
        Hueristic2D$TargetNode hueristic2D$TargetNode = new Hueristic2D$TargetNode();
        Hueristic2D$TargetNode hueristic2D$TargetNode2 = null;
        Hueristic2D$TargetNode hueristic2D$TargetNode3 = null;
        Hueristic2D$TargetNode hueristic2D$TargetNode4 = null;
        Hueristic2D$TargetNode hueristic2D$TargetNode5 = null;
        Hueristic2D$TargetNode hueristic2D$TargetNode6 = null;
        Hueristic2D$TargetNode hueristic2D$TargetNode7 = null;
        Hueristic2D$TargetNode hueristic2D$TargetNode8 = null;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            double d2;
            double d3;
            yD yD2 = list.get(i2);
            xi xi4 = yD2.localToScene(yD2.getLayoutBounds());
            if (!(direction == Direction.UP ? xi2.an() > xi4.at() : xi2.at() < xi4.an())) continue;
            hueristic2D$TargetNode.node = yD2;
            hueristic2D$TargetNode.bounds = xi4;
            double d4 = Math.max(0.0, this.outDistance(direction, xh2, xi4));
            if (this.isOnAxis(direction, xh2, xi4)) {
                hueristic2D$TargetNode.biased2DMetric = d4 + this.centerSideDistance(direction, xh2, xi4) / 100.0;
            } else {
                d3 = this.cornerSideDistance(direction, xh2, xi4);
                hueristic2D$TargetNode.biased2DMetric = 100000.0 + d4 * d4 + 9.0 * d3 * d3;
            }
            d3 = Math.max(0.0, this.outDistance(direction, xi2, xi4));
            if (this.isOnAxis(direction, xi2, xi4)) {
                hueristic2D$TargetNode.current2DMetric = d3 + this.centerSideDistance(direction, xi2, xi4) / 100.0;
            } else {
                d2 = this.cornerSideDistance(direction, xi2, xi4);
                hueristic2D$TargetNode.current2DMetric = 100000.0 + d3 * d3 + 9.0 * d2 * d2;
            }
            hueristic2D$TargetNode.leftCornerDistance = xo4.distance(xi4.am(), function2.apply(xi4));
            hueristic2D$TargetNode.rightCornerDistance = xo6.distance(xi4.as(), function2.apply(xi4));
            d2 = xo2.distance(xi4.am() + xi4.ap() / 2.0, function2.apply(xi4));
            double d5 = xo4.distance(xi4.am() + xi4.ap() / 2.0, function2.apply(xi4));
            double d6 = xo4.distance(xi4.as(), function2.apply(xi4));
            double d7 = xo6.distance(xi4.am(), function2.apply(xi4));
            double d8 = xo6.distance(xi4.am() + xi4.ap() / 2.0, function2.apply(xi4));
            double d9 = xo6.distance(xi4.as(), function2.apply(xi4));
            double d10 = xo2.distance(xi4.am(), function2.apply(xi4));
            double d11 = xo2.distance(xi4.am() + xi4.ap() / 2.0, function2.apply(xi4));
            double d12 = xo2.distance(xi4.as(), function2.apply(xi4));
            double d13 = xo5.distance(xi4.am() + xi4.ap() / 2.0, function2.apply(xi4));
            double d14 = xo5.distance(xi4.as(), function2.apply(xi4));
            double d15 = xo7.distance(xi4.am() + xi4.ap() / 2.0, function2.apply(xi4));
            double d16 = xo3.distance(xi4.as(), function2.apply(xi4));
            hueristic2D$TargetNode.averageDistance = (hueristic2D$TargetNode.leftCornerDistance + d13 + d14 + d7 + hueristic2D$TargetNode.rightCornerDistance + d15 + d2) / 7.0;
            hueristic2D$TargetNode.biasShortestDistance = Hueristic2D.findMin(hueristic2D$TargetNode.leftCornerDistance, d13, d14, d7, d15, hueristic2D$TargetNode.rightCornerDistance, d10, d2, d16);
            hueristic2D$TargetNode.shortestDistance = Hueristic2D.findMin(hueristic2D$TargetNode.leftCornerDistance, d5, d6, d7, d8, d9, d10, d11, d12);
            if (d4 >= 0.0 && (hueristic2D$TargetNode3 == null || hueristic2D$TargetNode.biased2DMetric < hueristic2D$TargetNode3.biased2DMetric)) {
                if (hueristic2D$TargetNode3 == null) {
                    hueristic2D$TargetNode3 = new Hueristic2D$TargetNode();
                }
                hueristic2D$TargetNode3.copy(hueristic2D$TargetNode);
            }
            if (d3 >= 0.0 && (hueristic2D$TargetNode2 == null || hueristic2D$TargetNode.current2DMetric < hueristic2D$TargetNode2.current2DMetric)) {
                if (hueristic2D$TargetNode2 == null) {
                    hueristic2D$TargetNode2 = new Hueristic2D$TargetNode();
                }
                hueristic2D$TargetNode2.copy(hueristic2D$TargetNode);
            }
            if (xi3.as() > xi4.am() && xi4.as() > xi3.am() && (hueristic2D$TargetNode5 == null || hueristic2D$TargetNode5.biasShortestDistance > hueristic2D$TargetNode.biasShortestDistance)) {
                if (hueristic2D$TargetNode5 == null) {
                    hueristic2D$TargetNode5 = new Hueristic2D$TargetNode();
                }
                hueristic2D$TargetNode5.copy(hueristic2D$TargetNode);
            }
            if (xi2.as() > xi4.am() && xi4.as() > xi2.am() && (hueristic2D$TargetNode6 == null || hueristic2D$TargetNode6.biasShortestDistance > hueristic2D$TargetNode.biasShortestDistance)) {
                if (hueristic2D$TargetNode6 == null) {
                    hueristic2D$TargetNode6 = new Hueristic2D$TargetNode();
                }
                hueristic2D$TargetNode6.copy(hueristic2D$TargetNode);
            }
            if ((hueristic2D$TargetNode7 == null || hueristic2D$TargetNode7.leftCornerDistance > hueristic2D$TargetNode.leftCornerDistance) && (xi3.am() >= xi2.am() && xi4.am() >= xi2.am() || xi3.am() <= xi2.am() && xi4.am() <= xi2.am())) {
                if (hueristic2D$TargetNode7 == null) {
                    hueristic2D$TargetNode7 = new Hueristic2D$TargetNode();
                }
                hueristic2D$TargetNode7.copy(hueristic2D$TargetNode);
            }
            if ((hueristic2D$TargetNode4 == null || hueristic2D$TargetNode4.averageDistance > hueristic2D$TargetNode.averageDistance) && (xi3.am() >= xi2.am() && xi4.am() >= xi2.am() || xi3.am() <= xi2.am() && xi4.am() <= xi2.am())) {
                if (hueristic2D$TargetNode4 == null) {
                    hueristic2D$TargetNode4 = new Hueristic2D$TargetNode();
                }
                hueristic2D$TargetNode4.copy(hueristic2D$TargetNode);
            }
            if (hueristic2D$TargetNode8 != null && !(hueristic2D$TargetNode8.shortestDistance > hueristic2D$TargetNode.shortestDistance)) continue;
            if (hueristic2D$TargetNode8 == null) {
                hueristic2D$TargetNode8 = new Hueristic2D$TargetNode();
            }
            hueristic2D$TargetNode8.copy(hueristic2D$TargetNode);
        }
        list.clear();
        if (hueristic2D$TargetNode5 != null) {
            hueristic2D$TargetNode5.originLeftCornerDistance = xo8.distance(hueristic2D$TargetNode5.bounds.am(), function2.apply(hueristic2D$TargetNode5.bounds));
        }
        if (hueristic2D$TargetNode6 != null) {
            hueristic2D$TargetNode6.originLeftCornerDistance = xo8.distance(hueristic2D$TargetNode6.bounds.am(), function2.apply(hueristic2D$TargetNode6.bounds));
        }
        if (hueristic2D$TargetNode4 != null) {
            hueristic2D$TargetNode4.originLeftCornerDistance = xo8.distance(hueristic2D$TargetNode4.bounds.am(), function2.apply(hueristic2D$TargetNode4.bounds));
        }
        if (hueristic2D$TargetNode5 != null) {
            if (hueristic2D$TargetNode6 != null && hueristic2D$TargetNode5.node == hueristic2D$TargetNode6.node && (hueristic2D$TargetNode4 != null && hueristic2D$TargetNode5.node == hueristic2D$TargetNode4.node || hueristic2D$TargetNode3 != null && hueristic2D$TargetNode5.node == hueristic2D$TargetNode3.node || hueristic2D$TargetNode7 != null && hueristic2D$TargetNode5.node == hueristic2D$TargetNode7.node || hueristic2D$TargetNode8 != null && hueristic2D$TargetNode5.node == hueristic2D$TargetNode8.node)) {
                return hueristic2D$TargetNode5.node;
            }
            if (hueristic2D$TargetNode4 != null && hueristic2D$TargetNode5.node == hueristic2D$TargetNode4.node) {
                return hueristic2D$TargetNode5.node;
            }
            if (hueristic2D$TargetNode6 != null) {
                if (hueristic2D$TargetNode6.leftCornerDistance < hueristic2D$TargetNode5.leftCornerDistance && hueristic2D$TargetNode6.originLeftCornerDistance < hueristic2D$TargetNode5.originLeftCornerDistance && hueristic2D$TargetNode6.bounds.am() - xo4.aB() < hueristic2D$TargetNode5.bounds.am() - xo4.aB()) {
                    return hueristic2D$TargetNode6.node;
                }
                if (hueristic2D$TargetNode4 == null || hueristic2D$TargetNode5.averageDistance < hueristic2D$TargetNode4.averageDistance) {
                    return hueristic2D$TargetNode5.node;
                }
            }
        } else {
            if (hueristic2D$TargetNode6 == null && hueristic2D$TargetNode2 != null) {
                if (hueristic2D$TargetNode4 != null && hueristic2D$TargetNode7 != null && hueristic2D$TargetNode4.node == hueristic2D$TargetNode7.node && hueristic2D$TargetNode4.node == hueristic2D$TargetNode8.node) {
                    return hueristic2D$TargetNode4.node;
                }
                return hueristic2D$TargetNode2.node;
            }
            if (hueristic2D$TargetNode4 != null && hueristic2D$TargetNode7 != null && hueristic2D$TargetNode8 != null && hueristic2D$TargetNode4.biasShortestDistance == hueristic2D$TargetNode7.biasShortestDistance && hueristic2D$TargetNode4.biasShortestDistance == hueristic2D$TargetNode8.biasShortestDistance && hueristic2D$TargetNode4.biasShortestDistance < Double.MAX_VALUE) {
                return hueristic2D$TargetNode4.node;
            }
        }
        if (hueristic2D$TargetNode4 != null && (hueristic2D$TargetNode5 == null || hueristic2D$TargetNode4.biasShortestDistance < hueristic2D$TargetNode5.biasShortestDistance)) {
            if (hueristic2D$TargetNode5 != null && function2.apply(hueristic2D$TargetNode5.bounds) >= function2.apply(hueristic2D$TargetNode4.bounds)) {
                return hueristic2D$TargetNode5.node;
            }
            if (hueristic2D$TargetNode3 != null) {
                if (hueristic2D$TargetNode3.current2DMetric <= hueristic2D$TargetNode4.current2DMetric) {
                    return hueristic2D$TargetNode3.node;
                }
                if (function2.apply(hueristic2D$TargetNode3.bounds) >= function2.apply(hueristic2D$TargetNode4.bounds)) {
                    return hueristic2D$TargetNode3.node;
                }
            }
            return hueristic2D$TargetNode4.node;
        }
        if (hueristic2D$TargetNode2 != null && hueristic2D$TargetNode6 != null && hueristic2D$TargetNode4 != null && hueristic2D$TargetNode7 != null && hueristic2D$TargetNode8 != null && hueristic2D$TargetNode2.node == hueristic2D$TargetNode6.node && hueristic2D$TargetNode2.node == hueristic2D$TargetNode4.node && hueristic2D$TargetNode2.node == hueristic2D$TargetNode7.node && hueristic2D$TargetNode2.node == hueristic2D$TargetNode8.node) {
            return hueristic2D$TargetNode2.node;
        }
        if (hueristic2D$TargetNode5 != null && (hueristic2D$TargetNode6 == null || hueristic2D$TargetNode5.rightCornerDistance < hueristic2D$TargetNode6.rightCornerDistance)) {
            return hueristic2D$TargetNode5.node;
        }
        if (hueristic2D$TargetNode5 != null) {
            return hueristic2D$TargetNode5.node;
        }
        if (hueristic2D$TargetNode3 != null) {
            return hueristic2D$TargetNode3.node;
        }
        if (hueristic2D$TargetNode6 != null) {
            return hueristic2D$TargetNode6.node;
        }
        if (hueristic2D$TargetNode4 != null) {
            return hueristic2D$TargetNode4.node;
        }
        if (hueristic2D$TargetNode7 != null) {
            return hueristic2D$TargetNode7.node;
        }
        if (hueristic2D$TargetNode8 != null) {
            return hueristic2D$TargetNode8.node;
        }
        return null;
    }

    protected yD getNearestNodeLeftOrRight(xi xi2, xi xi3, TraversalContext traversalContext, Direction direction) {
        List<yD> list = traversalContext.getAllTargetNodes();
        Function<xi, Double> function = direction == Direction.LEFT ? BOUNDS_LEFT_SIDE : BOUNDS_RIGHT_SIDE;
        Function<xi, Double> function2 = direction == Direction.LEFT ? BOUNDS_RIGHT_SIDE : BOUNDS_LEFT_SIDE;
        xh xh2 = new xh(xi2.am(), xi3.an(), xi2.ap(), xi3.aq());
        xo xo2 = new xo(function.apply(xi2), xi2.an() + xi2.aq() / 2.0);
        xo xo3 = new xo(function.apply(xi2), xi3.an() + xi3.aq() / 2.0);
        xo xo4 = new xo(function.apply(xi2), xi2.an());
        xo xo5 = new xo(function.apply(xi2), xi3.an());
        xo xo6 = new xo(function.apply(xi2), xi2.at());
        xo xo7 = new xo(function.apply(xi2), xi3.at());
        xo xo8 = new xo(function.apply(xi3), xi3.an());
        Hueristic2D$TargetNode hueristic2D$TargetNode = new Hueristic2D$TargetNode();
        Hueristic2D$TargetNode hueristic2D$TargetNode2 = null;
        Hueristic2D$TargetNode hueristic2D$TargetNode3 = null;
        Hueristic2D$TargetNode hueristic2D$TargetNode4 = null;
        Hueristic2D$TargetNode hueristic2D$TargetNode5 = null;
        Hueristic2D$TargetNode hueristic2D$TargetNode6 = null;
        Hueristic2D$TargetNode hueristic2D$TargetNode7 = null;
        Hueristic2D$TargetNode hueristic2D$TargetNode8 = null;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            double d2;
            double d3;
            yD yD2 = list.get(i2);
            xi xi4 = yD2.localToScene(yD2.getLayoutBounds());
            if (!(direction == Direction.LEFT ? xi2.am() > xi4.am() : xi2.as() < xi4.as())) continue;
            hueristic2D$TargetNode.node = yD2;
            hueristic2D$TargetNode.bounds = xi4;
            double d4 = Math.max(0.0, this.outDistance(direction, xh2, xi4));
            if (this.isOnAxis(direction, xh2, xi4)) {
                hueristic2D$TargetNode.biased2DMetric = d4 + this.centerSideDistance(direction, xh2, xi4) / 100.0;
            } else {
                d3 = this.cornerSideDistance(direction, xh2, xi4);
                hueristic2D$TargetNode.biased2DMetric = 100000.0 + d4 * d4 + 9.0 * d3 * d3;
            }
            d3 = Math.max(0.0, this.outDistance(direction, xi2, xi4));
            if (this.isOnAxis(direction, xi2, xi4)) {
                hueristic2D$TargetNode.current2DMetric = d3 + this.centerSideDistance(direction, xi2, xi4) / 100.0;
            } else {
                d2 = this.cornerSideDistance(direction, xi2, xi4);
                hueristic2D$TargetNode.current2DMetric = 100000.0 + d3 * d3 + 9.0 * d2 * d2;
            }
            hueristic2D$TargetNode.topCornerDistance = xo4.distance(function2.apply(xi4), xi4.an());
            hueristic2D$TargetNode.bottomCornerDistance = xo6.distance(function2.apply(xi4), xi4.at());
            d2 = xo2.distance(function2.apply(xi4), xi4.an() + xi4.aq() / 2.0);
            double d5 = xo4.distance(function2.apply(xi4), xi4.at());
            double d6 = xo4.distance(function2.apply(xi4), xi4.an() + xi4.aq() / 2.0);
            double d7 = xo6.distance(function2.apply(xi4), xi4.an());
            double d8 = xo6.distance(function2.apply(xi4), xi4.at());
            double d9 = xo6.distance(function2.apply(xi4), xi4.an() + xi4.aq() / 2.0);
            double d10 = xo2.distance(function2.apply(xi4), xi4.an());
            double d11 = xo2.distance(function2.apply(xi4), xi4.at());
            double d12 = xo2.distance(function2.apply(xi4), xi4.an() + xi4.aq() / 2.0);
            double d13 = xo5.distance(function2.apply(xi4), xi4.at());
            double d14 = xo5.distance(function2.apply(xi4), xi4.an() + xi4.aq() / 2.0);
            double d15 = xo7.distance(function2.apply(xi4), xi4.an() + xi4.aq() / 2.0);
            double d16 = xo3.distance(function2.apply(xi4), xi4.at());
            hueristic2D$TargetNode.averageDistance = (hueristic2D$TargetNode.topCornerDistance + d13 + d14 + d7 + hueristic2D$TargetNode.bottomCornerDistance + d15 + d2) / 7.0;
            hueristic2D$TargetNode.biasShortestDistance = Hueristic2D.findMin(hueristic2D$TargetNode.topCornerDistance, d13, d14, d7, hueristic2D$TargetNode.bottomCornerDistance, d15, d10, d16, d2);
            hueristic2D$TargetNode.shortestDistance = Hueristic2D.findMin(hueristic2D$TargetNode.topCornerDistance, d5, d6, d7, d8, d9, d10, d11, d12);
            if (d4 >= 0.0 && (hueristic2D$TargetNode3 == null || hueristic2D$TargetNode.biased2DMetric < hueristic2D$TargetNode3.biased2DMetric)) {
                if (hueristic2D$TargetNode3 == null) {
                    hueristic2D$TargetNode3 = new Hueristic2D$TargetNode();
                }
                hueristic2D$TargetNode3.copy(hueristic2D$TargetNode);
            }
            if (d3 >= 0.0 && (hueristic2D$TargetNode2 == null || hueristic2D$TargetNode.current2DMetric < hueristic2D$TargetNode2.current2DMetric)) {
                if (hueristic2D$TargetNode2 == null) {
                    hueristic2D$TargetNode2 = new Hueristic2D$TargetNode();
                }
                hueristic2D$TargetNode2.copy(hueristic2D$TargetNode);
            }
            if (xi3.at() > xi4.an() && xi4.at() > xi3.an() && (hueristic2D$TargetNode5 == null || hueristic2D$TargetNode5.topCornerDistance > hueristic2D$TargetNode.topCornerDistance)) {
                if (hueristic2D$TargetNode5 == null) {
                    hueristic2D$TargetNode5 = new Hueristic2D$TargetNode();
                }
                hueristic2D$TargetNode5.copy(hueristic2D$TargetNode);
            }
            if (xi2.at() > xi4.an() && xi4.at() > xi2.an() && (hueristic2D$TargetNode6 == null || hueristic2D$TargetNode6.topCornerDistance > hueristic2D$TargetNode.topCornerDistance)) {
                if (hueristic2D$TargetNode6 == null) {
                    hueristic2D$TargetNode6 = new Hueristic2D$TargetNode();
                }
                hueristic2D$TargetNode6.copy(hueristic2D$TargetNode);
            }
            if (hueristic2D$TargetNode7 == null || hueristic2D$TargetNode7.topCornerDistance > hueristic2D$TargetNode.topCornerDistance) {
                if (hueristic2D$TargetNode7 == null) {
                    hueristic2D$TargetNode7 = new Hueristic2D$TargetNode();
                }
                hueristic2D$TargetNode7.copy(hueristic2D$TargetNode);
            }
            if (hueristic2D$TargetNode4 == null || hueristic2D$TargetNode4.averageDistance > hueristic2D$TargetNode.averageDistance) {
                if (hueristic2D$TargetNode4 == null) {
                    hueristic2D$TargetNode4 = new Hueristic2D$TargetNode();
                }
                hueristic2D$TargetNode4.copy(hueristic2D$TargetNode);
            }
            if (hueristic2D$TargetNode8 != null && !(hueristic2D$TargetNode8.shortestDistance > hueristic2D$TargetNode.shortestDistance)) continue;
            if (hueristic2D$TargetNode8 == null) {
                hueristic2D$TargetNode8 = new Hueristic2D$TargetNode();
            }
            hueristic2D$TargetNode8.copy(hueristic2D$TargetNode);
        }
        list.clear();
        if (hueristic2D$TargetNode5 != null) {
            hueristic2D$TargetNode5.originTopCornerDistance = xo8.distance(function2.apply(hueristic2D$TargetNode5.bounds), hueristic2D$TargetNode5.bounds.an());
        }
        if (hueristic2D$TargetNode6 != null) {
            hueristic2D$TargetNode6.originTopCornerDistance = xo8.distance(function2.apply(hueristic2D$TargetNode6.bounds), hueristic2D$TargetNode6.bounds.an());
        }
        if (hueristic2D$TargetNode4 != null) {
            hueristic2D$TargetNode4.originTopCornerDistance = xo8.distance(function2.apply(hueristic2D$TargetNode4.bounds), hueristic2D$TargetNode4.bounds.an());
        }
        if (hueristic2D$TargetNode6 == null && hueristic2D$TargetNode5 == null) {
            this.cacheStartTraversalNode = null;
            this.cacheStartTraversalDirection = null;
            this.reverseDirection = false;
            this.traversalNodeStack.clear();
        }
        if (hueristic2D$TargetNode5 != null) {
            if (hueristic2D$TargetNode6 != null && hueristic2D$TargetNode5.node == hueristic2D$TargetNode6.node && (hueristic2D$TargetNode4 != null && hueristic2D$TargetNode5.node == hueristic2D$TargetNode4.node || hueristic2D$TargetNode7 != null && hueristic2D$TargetNode5.node == hueristic2D$TargetNode7.node || hueristic2D$TargetNode8 != null && hueristic2D$TargetNode5.node == hueristic2D$TargetNode8.node)) {
                return hueristic2D$TargetNode5.node;
            }
            if (hueristic2D$TargetNode4 != null && hueristic2D$TargetNode5.node == hueristic2D$TargetNode4.node) {
                return hueristic2D$TargetNode5.node;
            }
            if (hueristic2D$TargetNode6 != null) {
                if (hueristic2D$TargetNode6.bottomCornerDistance < hueristic2D$TargetNode5.bottomCornerDistance && hueristic2D$TargetNode6.originTopCornerDistance < hueristic2D$TargetNode5.originTopCornerDistance && hueristic2D$TargetNode6.bounds.an() - xo4.aC() < hueristic2D$TargetNode5.bounds.an() - xo4.aC()) {
                    return hueristic2D$TargetNode6.node;
                }
                if (hueristic2D$TargetNode4 == null || hueristic2D$TargetNode5.averageDistance < hueristic2D$TargetNode4.averageDistance) {
                    return hueristic2D$TargetNode5.node;
                }
            }
        } else {
            if (hueristic2D$TargetNode6 == null && hueristic2D$TargetNode2 != null) {
                if (hueristic2D$TargetNode4 != null && hueristic2D$TargetNode7 != null && hueristic2D$TargetNode4.node == hueristic2D$TargetNode7.node && hueristic2D$TargetNode4.node == hueristic2D$TargetNode8.node) {
                    return hueristic2D$TargetNode4.node;
                }
                return hueristic2D$TargetNode2.node;
            }
            if (hueristic2D$TargetNode4 != null && hueristic2D$TargetNode7 != null && hueristic2D$TargetNode8 != null && hueristic2D$TargetNode4.biasShortestDistance == hueristic2D$TargetNode7.biasShortestDistance && hueristic2D$TargetNode4.biasShortestDistance == hueristic2D$TargetNode8.biasShortestDistance && hueristic2D$TargetNode4.biasShortestDistance < Double.MAX_VALUE) {
                return hueristic2D$TargetNode4.node;
            }
        }
        if (hueristic2D$TargetNode4 != null && (hueristic2D$TargetNode5 == null || hueristic2D$TargetNode4.biasShortestDistance < hueristic2D$TargetNode5.biasShortestDistance)) {
            if (hueristic2D$TargetNode5 != null && function2.apply(hueristic2D$TargetNode5.bounds) >= function2.apply(hueristic2D$TargetNode4.bounds)) {
                return hueristic2D$TargetNode5.node;
            }
            if (hueristic2D$TargetNode5 != null && hueristic2D$TargetNode6 != null && hueristic2D$TargetNode5.biasShortestDistance < Double.MAX_VALUE && hueristic2D$TargetNode5.node == hueristic2D$TargetNode6.node) {
                return hueristic2D$TargetNode5.node;
            }
            if (hueristic2D$TargetNode6 != null && hueristic2D$TargetNode5 != null && hueristic2D$TargetNode6.biasShortestDistance < Double.MAX_VALUE && hueristic2D$TargetNode6.biasShortestDistance < hueristic2D$TargetNode5.biasShortestDistance) {
                return hueristic2D$TargetNode6.node;
            }
            if (hueristic2D$TargetNode5 != null && hueristic2D$TargetNode5.biasShortestDistance < Double.MAX_VALUE && hueristic2D$TargetNode5.originTopCornerDistance < hueristic2D$TargetNode4.originTopCornerDistance) {
                return hueristic2D$TargetNode5.node;
            }
            return hueristic2D$TargetNode4.node;
        }
        if (hueristic2D$TargetNode5 != null && hueristic2D$TargetNode6 != null && hueristic2D$TargetNode5.bottomCornerDistance < hueristic2D$TargetNode6.bottomCornerDistance) {
            return hueristic2D$TargetNode5.node;
        }
        if (hueristic2D$TargetNode6 != null && hueristic2D$TargetNode7 != null && hueristic2D$TargetNode6.biasShortestDistance < Double.MAX_VALUE && hueristic2D$TargetNode6.node == hueristic2D$TargetNode7.node) {
            return hueristic2D$TargetNode6.node;
        }
        if (hueristic2D$TargetNode5 != null) {
            return hueristic2D$TargetNode5.node;
        }
        if (hueristic2D$TargetNode3 != null) {
            return hueristic2D$TargetNode3.node;
        }
        if (hueristic2D$TargetNode6 != null) {
            return hueristic2D$TargetNode6.node;
        }
        if (hueristic2D$TargetNode4 != null) {
            return hueristic2D$TargetNode4.node;
        }
        if (hueristic2D$TargetNode7 != null) {
            return hueristic2D$TargetNode7.node;
        }
        if (hueristic2D$TargetNode8 != null) {
            return hueristic2D$TargetNode8.node;
        }
        return null;
    }

    public static double findMin(double ... dArray) {
        double d2 = Double.MAX_VALUE;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            d2 = d2 < dArray[i2] ? d2 : dArray[i2];
        }
        return d2;
    }
}

