/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.traversal;

import com.sun.javafx.scene.traversal.Algorithm;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.TabOrderHelper;
import com.sun.javafx.scene.traversal.TraversalContext;
import dev.protect.xi;
import dev.protect.yD;
import java.util.List;

public class ContainerTabOrder
implements Algorithm {
    ContainerTabOrder() {
    }

    @Override
    public yD select(yD yD2, Direction direction, TraversalContext traversalContext) {
        switch (direction) {
            case NEXT: 
            case NEXT_IN_LINE: {
                return TabOrderHelper.findNextFocusablePeer(yD2, traversalContext.getRoot(), direction == Direction.NEXT);
            }
            case PREVIOUS: {
                return TabOrderHelper.findPreviousFocusablePeer(yD2, traversalContext.getRoot());
            }
            case UP: 
            case DOWN: 
            case LEFT: 
            case RIGHT: {
                List<yD> list = traversalContext.getAllTargetNodes();
                int n2 = this.trav2D(traversalContext.getSceneLayoutBounds(yD2), direction, list, traversalContext);
                if (n2 == -1) break;
                return list.get(n2);
            }
        }
        return null;
    }

    @Override
    public yD selectFirst(TraversalContext traversalContext) {
        return TabOrderHelper.getFirstTargetNode(traversalContext.getRoot());
    }

    @Override
    public yD selectLast(TraversalContext traversalContext) {
        return TabOrderHelper.getLastTargetNode(traversalContext.getRoot());
    }

    private int trav2D(xi xi2, Direction direction, List<yD> list, TraversalContext traversalContext) {
        xi xi3 = null;
        double d2 = 0.0;
        int n2 = -1;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            double d3;
            xi xi4 = traversalContext.getSceneLayoutBounds(list.get(i2));
            double d4 = this.outDistance(direction, xi2, xi4);
            if (this.isOnAxis(direction, xi2, xi4)) {
                d3 = d4 + this.centerSideDistance(direction, xi2, xi4) / 100.0;
            } else {
                double d5 = this.cornerSideDistance(direction, xi2, xi4);
                d3 = 100000.0 + d4 * d4 + 9.0 * d5 * d5;
            }
            if (d4 < 0.0 || xi3 != null && !(d3 < d2)) continue;
            xi3 = xi4;
            d2 = d3;
            n2 = i2;
        }
        return n2;
    }

    private boolean isOnAxis(Direction direction, xi xi2, xi xi3) {
        double d2;
        double d3;
        double d4;
        double d5;
        if (direction == Direction.UP || direction == Direction.DOWN) {
            d5 = xi2.am();
            d4 = xi2.as();
            d3 = xi3.am();
            d2 = xi3.as();
        } else {
            d5 = xi2.an();
            d4 = xi2.at();
            d3 = xi3.an();
            d2 = xi3.at();
        }
        return d3 <= d4 && d2 >= d5;
    }

    private double outDistance(Direction direction, xi xi2, xi xi3) {
        double d2 = direction == Direction.UP ? xi2.an() - xi3.at() : (direction == Direction.DOWN ? xi3.an() - xi2.at() : (direction == Direction.LEFT ? xi2.am() - xi3.as() : xi3.am() - xi2.as()));
        return d2;
    }

    private double centerSideDistance(Direction direction, xi xi2, xi xi3) {
        double d2;
        double d3;
        if (direction == Direction.UP || direction == Direction.DOWN) {
            d3 = xi2.am() + xi2.ap() / 2.0;
            d2 = xi3.am() + xi3.ap() / 2.0;
        } else {
            d3 = xi2.an() + xi2.aq() / 2.0;
            d2 = xi3.an() + xi3.aq() / 2.0;
        }
        return Math.abs(d2 - d3);
    }

    private double cornerSideDistance(Direction direction, xi xi2, xi xi3) {
        double d2 = direction == Direction.UP || direction == Direction.DOWN ? (xi3.am() > xi2.as() ? xi3.am() - xi2.as() : xi2.am() - xi3.as()) : (xi3.an() > xi2.at() ? xi3.an() - xi2.at() : xi2.an() - xi3.at());
        return d2;
    }
}

