/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.paint;

import com.sun.javafx.scene.paint.GradientUtils$Parser$Delimiter;
import com.sun.javafx.scene.paint.GradientUtils$Point;
import dev.protect.UM;
import dev.protect.Vb;
import java.util.LinkedList;

public class GradientUtils$Parser {
    private int index;
    private String[] tokens;
    private boolean proportional;
    private boolean proportionalSet = false;

    private String[] splitString(String string, GradientUtils$Parser$Delimiter gradientUtils$Parser$Delimiter, boolean bl2) {
        LinkedList<String> linkedList = new LinkedList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = string.toCharArray();
        block0: for (int i2 = 0; i2 < cArray.length; ++i2) {
            char c2 = cArray[i2];
            if (gradientUtils$Parser$Delimiter.isDelimiter(c2)) {
                if (!bl2 || stringBuilder.length() > 0) {
                    linkedList.add(stringBuilder.toString());
                }
                stringBuilder.setLength(0);
                continue;
            }
            if (c2 == '(') {
                while (i2 < cArray.length) {
                    stringBuilder.append(cArray[i2]);
                    if (cArray[i2] == ')') continue block0;
                    ++i2;
                }
                continue;
            }
            stringBuilder.append(cArray[i2]);
        }
        if (!bl2 || stringBuilder.length() > 0) {
            linkedList.add(stringBuilder.toString());
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public GradientUtils$Parser(String string) {
        this.tokens = this.splitString(string, c2 -> c2 == ',', false);
        this.index = 0;
    }

    public int getSize() {
        return this.tokens.length;
    }

    public void shift() {
        ++this.index;
    }

    public String getCurrentToken() {
        String string = this.tokens[this.index].trim();
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Invalid gradient specification: found empty token.");
        }
        return string;
    }

    public String[] splitCurrentToken() {
        return this.getCurrentToken().split("\\s");
    }

    public static void checkNumberOfArguments(String[] stringArray, int n2) {
        if (stringArray.length < n2 + 1) {
            throw new IllegalArgumentException("Invalid gradient specification: parameter '" + stringArray[0] + "' needs " + n2 + " argument(s).");
        }
    }

    public static double parseAngle(String string) {
        double d2 = 0.0;
        if (string.endsWith("deg")) {
            string = string.substring(0, string.length() - 3);
            d2 = Double.parseDouble(string);
        } else if (string.endsWith("grad")) {
            string = string.substring(0, string.length() - 4);
            d2 = Double.parseDouble(string);
            d2 = d2 * 9.0 / 10.0;
        } else if (string.endsWith("rad")) {
            string = string.substring(0, string.length() - 3);
            d2 = Double.parseDouble(string);
            d2 = d2 * 180.0 / Math.PI;
        } else if (string.endsWith("turn")) {
            string = string.substring(0, string.length() - 4);
            d2 = Double.parseDouble(string);
            d2 *= 360.0;
        } else {
            throw new IllegalArgumentException("Invalid gradient specification:angle must end in deg, rad, grad, or turn");
        }
        return d2;
    }

    public static double parsePercentage(String string) {
        if (!string.endsWith("%")) {
            throw new IllegalArgumentException("Invalid gradient specification: focus-distance must be specified as percentage");
        }
        string = string.substring(0, string.length() - 1);
        double d2 = Double.parseDouble(string) / 100.0;
        return d2;
    }

    public GradientUtils$Point parsePoint(String string) {
        GradientUtils$Point gradientUtils$Point = new GradientUtils$Point();
        if (string.endsWith("%")) {
            gradientUtils$Point.proportional = true;
            string = string.substring(0, string.length() - 1);
        } else if (string.endsWith("px")) {
            string = string.substring(0, string.length() - 2);
        }
        gradientUtils$Point.value = Double.parseDouble(string);
        if (gradientUtils$Point.proportional) {
            gradientUtils$Point.value /= 100.0;
        }
        if (this.proportionalSet && this.proportional != gradientUtils$Point.proportional) {
            throw new IllegalArgumentException("Invalid gradient specification:cannot mix proportional and non-proportional values");
        }
        this.proportionalSet = true;
        this.proportional = gradientUtils$Point.proportional;
        return gradientUtils$Point;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vb[] parseStops(boolean bl2, double d2) {
        int n2;
        int n3;
        double d3;
        int n4 = this.tokens.length - this.index;
        UM[] uMArray = new UM[n4];
        double[] dArray = new double[n4];
        Vb[] vbArray = new Vb[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            String string = this.tokens[i2 + this.index].trim();
            String[] stringArray = this.splitString(string, c2 -> Character.isWhitespace(c2), true);
            if (stringArray.length == 0) {
                throw new IllegalArgumentException("Invalid gradient specification, empty stop found");
            }
            String string2 = stringArray[0];
            d3 = -1.0;
            UM uM2 = UM.PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_(string2);
            if (stringArray.length == 2) {
                String string3 = stringArray[1];
                if (string3.endsWith("%")) {
                    string3 = string3.substring(0, string3.length() - 1);
                    d3 = Double.parseDouble(string3) / 100.0;
                } else {
                    if (bl2) throw new IllegalArgumentException("Invalid gradient specification, non-proportional stops not permited in proportional gradient: " + string3);
                    if (string3.endsWith("px")) {
                        string3 = string3.substring(0, string3.length() - 2);
                    }
                    d3 = Double.parseDouble(string3) / d2;
                }
            } else if (stringArray.length > 2) {
                throw new IllegalArgumentException("Invalid gradient specification, unexpected content in stop specification: " + stringArray[2]);
            }
            uMArray[i2] = uM2;
            dArray[i2] = d3;
        }
        if (dArray[0] < 0.0) {
            dArray[0] = 0.0;
        }
        if (dArray[dArray.length - 1] < 0.0) {
            dArray[dArray.length - 1] = 1.0;
        }
        double d4 = dArray[0];
        for (n3 = 1; n3 < dArray.length; ++n3) {
            if (dArray[n3] < d4 && dArray[n3] > 0.0) {
                dArray[n3] = d4;
                continue;
            }
            d4 = dArray[n3];
        }
        n3 = -1;
        for (n2 = 1; n2 < dArray.length; ++n2) {
            d3 = dArray[n2];
            if (d3 < 0.0 && n3 < 0) {
                n3 = n2;
                continue;
            }
            if (!(d3 >= 0.0) || n3 <= 0) continue;
            int n5 = n2 - n3 + 1;
            double d5 = (dArray[n2] - dArray[n3 - 1]) / (double)n5;
            for (int i3 = 0; i3 < n5 - 1; ++i3) {
                dArray[n3 + i3] = dArray[n3 - 1] + d5 * (double)(i3 + 1);
            }
        }
        for (n2 = 0; n2 < vbArray.length; ++n2) {
            Vb vb2;
            vbArray[n2] = vb2 = new Vb(dArray[n2], uMArray[n2]);
        }
        return vbArray;
    }
}

