/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.input;

import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.Vec3d;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.SubSceneHelper;
import dev.protect.AU;
import dev.protect.Sb;
import dev.protect.pm;
import dev.protect.po;
import dev.protect.xo;
import dev.protect.xp;
import dev.protect.yD;

public class PickResultChooser {
    private double distance = Double.POSITIVE_INFINITY;
    private yD node;
    private int face = -1;
    private xp point;
    private xp normal;
    private xo texCoord;
    private boolean empty = true;
    private boolean closed = false;

    public static xp computePoint(PickRay pickRay, double d2) {
        Vec3d vec3d = pickRay.getOriginNoClone();
        Vec3d vec3d2 = pickRay.getDirectionNoClone();
        return new xp(vec3d.x + vec3d2.x * d2, vec3d.y + vec3d2.y * d2, vec3d.z + vec3d2.z * d2);
    }

    public Sb toPickResult() {
        if (this.empty) {
            return null;
        }
        return new Sb(this.node, this.point, this.distance, this.face, this.normal, this.texCoord);
    }

    public boolean isCloser(double d2) {
        return d2 < this.distance || this.empty;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean offer(yD yD2, double d2, int n2, xp xp2, xo xo2) {
        return this.processOffer(yD2, yD2, d2, xp2, n2, this.normal, xo2);
    }

    public boolean offer(yD yD2, double d2, xp xp2) {
        return this.processOffer(yD2, yD2, d2, xp2, -1, null, null);
    }

    public boolean offerSubScenePickResult(AU aU2, Sb sb2, double d2) {
        if (sb2 == null) {
            return false;
        }
        return this.processOffer(sb2.s(), aU2, d2, sb2.a(), sb2.dn(), sb2.b(), sb2.b());
    }

    private boolean processOffer(yD yD2, yD yD3, double d2, xp xp2, int n2, xp xp3, xo xo2) {
        AU aU2 = NodeHelper.getSubScene(yD3);
        boolean bl2 = po.isSupported(pm.g) ? (aU2 != null ? SubSceneHelper.isDepthBuffer(aU2) : yD3.getScene().eO()) : false;
        boolean bl3 = bl2 && NodeHelper.isDerivedDepthTest(yD3);
        boolean bl4 = false;
        if ((this.empty || bl3 && d2 < this.distance) && !this.closed) {
            this.node = yD2;
            this.distance = d2;
            this.face = n2;
            this.point = xp2;
            this.normal = xp3;
            this.texCoord = xo2;
            this.empty = false;
            bl4 = true;
        }
        if (!bl3) {
            this.closed = true;
        }
        return bl4;
    }

    public final yD getIntersectedNode() {
        return this.node;
    }

    public final double getIntersectedDistance() {
        return this.distance;
    }

    public final int getIntersectedFace() {
        return this.face;
    }

    public final xp getIntersectedPoint() {
        return this.point;
    }

    public final xp getIntersectedNormal() {
        return this.normal;
    }

    public final xo getIntersectedTexCoord() {
        return this.texCoord;
    }
}

