/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.DoubleField;
import com.sun.javafx.scene.control.skin.InputFieldSkin;
import dev.protect.po;
import dev.protect.pv;
import dev.protect.yD;

public class DoubleFieldSkin
extends InputFieldSkin {
    private pv doubleFieldValueListener = px2 -> this.updateText();

    public DoubleFieldSkin(DoubleField doubleField) {
        super(doubleField);
        doubleField.valueProperty().addListener(this.doubleFieldValueListener);
    }

    @Override
    public DoubleField getSkinnable() {
        return (DoubleField)this.control;
    }

    @Override
    public yD getNode() {
        return this.getTextField();
    }

    @Override
    public void dispose() {
        ((DoubleField)this.control).valueProperty().removeListener(this.doubleFieldValueListener);
        super.dispose();
    }

    @Override
    protected boolean accept(String string) {
        if (string.length() == 0) {
            return true;
        }
        if (string.matches("[0-9\\.]*")) {
            try {
                Double.parseDouble(string);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    protected void updateText() {
        this.getTextField().setText("" + ((DoubleField)this.control).getValue());
    }

    @Override
    protected void updateValue() {
        double d2 = ((DoubleField)this.control).getValue();
        String string = this.getTextField().getText() == null ? "" : this.getTextField().getText().trim();
        try {
            double d3 = Double.parseDouble(string);
            if (d3 != d2) {
                ((DoubleField)this.control).setValue(d3);
            }
        }
        catch (NumberFormatException numberFormatException) {
            ((DoubleField)this.control).setValue(0.0);
            po.runLater(() -> this.getTextField().positionCaret(1));
        }
    }
}

