/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.inputmap;

import com.sun.javafx.scene.control.inputmap.InputMap$1;
import com.sun.javafx.scene.control.inputmap.InputMap$Mapping;
import dev.protect.abJ;
import dev.protect.rU;
import dev.protect.sG;
import dev.protect.su;
import dev.protect.sw;
import dev.protect.tM;
import dev.protect.to;
import dev.protect.wT;
import dev.protect.wW;
import dev.protect.wY;
import dev.protect.yD;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class InputMap<N extends yD>
implements wW<wT> {
    private final N node;
    private final tM<InputMap<N>> childInputMaps;
    private final tM<InputMap$Mapping<?>> mappings;
    private final Map<wY<?>, List<wW<? super wT>>> installedEventHandlers;
    private final Map<wY, List<InputMap$Mapping>> eventTypeMappings;
    private sw<InputMap<N>> parentInputMap = new InputMap$1(this, this, "parentInputMap");
    private rU<Predicate<? extends wT>> interceptor = new sG<Predicate<? extends wT>>(this, "interceptor");

    public InputMap(N n2) {
        if (n2 == null) {
            throw new IllegalArgumentException("Node can not be null");
        }
        this.node = n2;
        this.eventTypeMappings = new HashMap<wY, List<InputMap$Mapping>>();
        this.installedEventHandlers = new HashMap();
        this.mappings = to.a();
        this.mappings.addListener(tD2 -> {
            while (tD2.next()) {
                Object object2;
                if (tD2.wasRemoved()) {
                    for (Object object2 : tD2.getRemoved()) {
                        this.removeMapping((InputMap$Mapping<?>)object2);
                    }
                }
                if (!tD2.wasAdded()) continue;
                ArrayList arrayList = new ArrayList();
                object2 = tD2.getAddedSubList().iterator();
                while (object2.hasNext()) {
                    InputMap$Mapping inputMap$Mapping = (InputMap$Mapping)object2.next();
                    if (inputMap$Mapping == null) {
                        arrayList.add(null);
                        continue;
                    }
                    this.addMapping(inputMap$Mapping);
                }
                if (arrayList.isEmpty()) continue;
                this.getMappings().removeAll(arrayList);
                throw new IllegalArgumentException("Null mappings not permitted");
            }
        });
        this.childInputMaps = to.a();
        this.childInputMaps.addListener(tD2 -> {
            while (tD2.next()) {
                Object object2;
                if (tD2.wasRemoved()) {
                    for (Object object2 : tD2.getRemoved()) {
                        ((InputMap)object2).setParentInputMap(null);
                    }
                }
                if (!tD2.wasAdded()) continue;
                ArrayList arrayList = new ArrayList();
                object2 = tD2.getAddedSubList().iterator();
                while (object2.hasNext()) {
                    InputMap inputMap = (InputMap)object2.next();
                    if (inputMap.getNode() != this.getNode()) {
                        arrayList.add(inputMap);
                        continue;
                    }
                    inputMap.setParentInputMap(this);
                }
                if (arrayList.isEmpty()) continue;
                this.getChildInputMaps().removeAll(arrayList);
                throw new IllegalArgumentException("Child InputMap intances need to share a common Node object");
            }
        });
    }

    private final void setParentInputMap(InputMap<N> inputMap) {
        this.parentInputMap.set(inputMap);
    }

    private final InputMap<N> getParentInputMap() {
        return (InputMap)this.parentInputMap.get();
    }

    private final su<InputMap<N>> parentInputMapProperty() {
        return this.parentInputMap.getReadOnlyProperty();
    }

    public final Predicate<? extends wT> getInterceptor() {
        return (Predicate)this.interceptor.get();
    }

    public final void setInterceptor(Predicate<? extends wT> predicate) {
        this.interceptor.set(predicate);
    }

    public final rU<Predicate<? extends wT>> interceptorProperty() {
        return this.interceptor;
    }

    public final N getNode() {
        return this.node;
    }

    public tM<InputMap$Mapping<?>> getMappings() {
        return this.mappings;
    }

    public tM<InputMap<N>> getChildInputMaps() {
        return this.childInputMaps;
    }

    public void dispose() {
        for (InputMap inputMap : this.getChildInputMaps()) {
            inputMap.dispose();
        }
        this.removeAllEventHandlers();
        this.getMappings().clear();
    }

    @Override
    public void handle(wT wT2) {
        if (wT2 == null || wT2.isConsumed()) {
            return;
        }
        List<InputMap$Mapping<?>> list = this.lookup(wT2, true);
        for (InputMap$Mapping<?> inputMap$Mapping : list) {
            wW<?> wW2 = inputMap$Mapping.getEventHandler();
            if (wW2 != null) {
                wW2.handle(wT2);
            }
            if (inputMap$Mapping.isAutoConsume()) {
                wT2.consume();
            }
            if (!wT2.isConsumed()) continue;
            break;
        }
    }

    public Optional<InputMap$Mapping<?>> lookupMapping(Object object) {
        if (object == null) {
            return Optional.empty();
        }
        List<InputMap$Mapping<?>> list = this.lookupMappingKey(object);
        for (int i2 = 0; i2 < this.getChildInputMaps().size(); ++i2) {
            InputMap inputMap = (InputMap)this.getChildInputMaps().get(i2);
            List<InputMap$Mapping<?>> list2 = inputMap.lookupMappingKey(object);
            list.addAll(0, list2);
        }
        return list.size() > 0 ? Optional.of(list.get(0)) : Optional.empty();
    }

    private List<InputMap$Mapping<?>> lookupMappingKey(Object object) {
        return this.getMappings().stream().filter(inputMap$Mapping -> !inputMap$Mapping.isDisabled()).filter(inputMap$Mapping -> object.equals(inputMap$Mapping.getMappingKey())).collect(Collectors.toList());
    }

    private List<InputMap$Mapping<?>> lookup(wT wT2, boolean bl2) {
        boolean bl3;
        if (bl2 && (bl3 = this.testInterceptor(wT2, this.getInterceptor()))) {
            return Collections.emptyList();
        }
        ArrayList arrayList = new ArrayList();
        int n2 = 0;
        List<abJ<Integer, InputMap$Mapping<?>>> list = this.lookupMappingAndSpecificity(wT2, n2);
        if (!list.isEmpty()) {
            n2 = list.get(0).getKey();
            arrayList.addAll(list.stream().map(abJ2 -> (InputMap$Mapping)abJ2.getValue()).collect(Collectors.toList()));
        }
        for (int i2 = 0; i2 < this.getChildInputMaps().size(); ++i2) {
            InputMap inputMap = (InputMap)this.getChildInputMaps().get(i2);
            n2 = this.scanRecursively(inputMap, wT2, bl2, n2, arrayList);
        }
        return arrayList;
    }

    private int scanRecursively(InputMap<?> inputMap, wT wT2, boolean bl2, int n2, List<InputMap$Mapping<?>> list) {
        int n3;
        boolean bl3;
        if (bl2 && (bl3 = this.testInterceptor(wT2, inputMap.getInterceptor()))) {
            return n2;
        }
        List<abJ<Integer, InputMap$Mapping<?>>> list2 = inputMap.lookupMappingAndSpecificity(wT2, n2);
        if (!list2.isEmpty()) {
            n3 = list2.get(0).getKey();
            List list3 = list2.stream().map(abJ2 -> (InputMap$Mapping)abJ2.getValue()).collect(Collectors.toList());
            if (n3 == n2) {
                list.addAll(0, list3);
            } else if (n3 > n2) {
                list.clear();
                n2 = n3;
                list.addAll(list3);
            }
        }
        for (n3 = 0; n3 < inputMap.getChildInputMaps().size(); ++n3) {
            n2 = this.scanRecursively((InputMap)inputMap.getChildInputMaps().get(n3), wT2, bl2, n2, list);
        }
        return n2;
    }

    private InputMap<N> getRootInputMap() {
        InputMap<N> inputMap;
        InputMap<N> inputMap2 = this;
        while (inputMap2 != null && (inputMap = inputMap2.getParentInputMap()) != null) {
            inputMap2 = inputMap;
        }
        return inputMap2;
    }

    private void addMapping(InputMap$Mapping<?> inputMap$Mapping) {
        InputMap<N> inputMap = this.getRootInputMap();
        inputMap.addEventHandler(inputMap$Mapping.eventType);
        wY<?> wY3 = inputMap$Mapping.getEventType();
        List list = this.eventTypeMappings.computeIfAbsent(wY3, wY2 -> new ArrayList());
        list.add(inputMap$Mapping);
    }

    private void removeMapping(InputMap$Mapping<?> inputMap$Mapping) {
        wY<?> wY2 = inputMap$Mapping.getEventType();
        if (this.eventTypeMappings.containsKey(wY2)) {
            List<InputMap$Mapping> list = this.eventTypeMappings.get(wY2);
            list.remove(inputMap$Mapping);
        }
    }

    private void addEventHandler(wY wY3) {
        List list = this.installedEventHandlers.computeIfAbsent(wY3, wY2 -> new ArrayList());
        wW<wT> wW2 = this::handle;
        if (list.isEmpty()) {
            ((yD)this.node).addEventHandler(wY3, wW2);
        }
        list.add(wW2);
    }

    private void removeAllEventHandlers() {
        for (wY<?> wY2 : this.installedEventHandlers.keySet()) {
            List<wW<? super wT>> list = this.installedEventHandlers.get(wY2);
            for (wW<? super wT> wW2 : list) {
                ((yD)this.node).removeEventHandler(wY2, wW2);
            }
        }
    }

    private void reprocessAllMappings() {
        this.removeAllEventHandlers();
        this.mappings.stream().forEach(this::addMapping);
        for (InputMap inputMap : this.getChildInputMaps()) {
            inputMap.reprocessAllMappings();
        }
    }

    private List<abJ<Integer, InputMap$Mapping<?>>> lookupMappingAndSpecificity(wT wT2, int n2) {
        int n3 = n2;
        List list = this.eventTypeMappings.getOrDefault(wT2.getEventType(), Collections.emptyList());
        ArrayList arrayList = new ArrayList();
        for (InputMap$Mapping inputMap$Mapping : list) {
            boolean bl2;
            if (inputMap$Mapping.isDisabled() || (bl2 = this.testInterceptor(wT2, inputMap$Mapping.getInterceptor()))) continue;
            int n4 = inputMap$Mapping.getSpecificity(wT2);
            if (n4 > 0 && n4 == n3) {
                arrayList.add(new abJ<Integer, InputMap$Mapping>(n4, inputMap$Mapping));
                continue;
            }
            if (n4 <= n3) continue;
            arrayList.clear();
            arrayList.add(new abJ<Integer, InputMap$Mapping>(n4, inputMap$Mapping));
            n3 = n4;
        }
        return arrayList;
    }

    private boolean testInterceptor(wT wT2, Predicate predicate) {
        return predicate != null && predicate.test(wT2);
    }
}

