/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.scene.control.Properties;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.FocusTraversalInputMap;
import com.sun.javafx.scene.control.behavior.TextInputControlBehavior$1;
import com.sun.javafx.scene.control.behavior.TextInputControlBehavior$ContextMenuItem;
import com.sun.javafx.scene.control.inputmap.InputMap;
import com.sun.javafx.scene.control.inputmap.InputMap$KeyMapping;
import com.sun.javafx.scene.control.inputmap.InputMap$Mapping;
import com.sun.javafx.scene.control.inputmap.InputMap$MouseMapping;
import com.sun.javafx.scene.control.inputmap.KeyBinding;
import com.sun.javafx.scene.control.inputmap.KeyBinding$OptionalBoolean;
import com.sun.javafx.scene.control.skin.FXVK;
import dev.protect.CR;
import dev.protect.CU;
import dev.protect.Dr;
import dev.protect.EM;
import dev.protect.Fc;
import dev.protect.Gk;
import dev.protect.II;
import dev.protect.OY;
import dev.protect.Pm;
import dev.protect.Pt;
import dev.protect.RL;
import dev.protect.RT;
import dev.protect.RY;
import dev.protect.Ru;
import dev.protect.Rx;
import dev.protect.pm;
import dev.protect.pv;
import dev.protect.tM;
import dev.protect.wW;
import dev.protect.xm;
import dev.protect.yD;
import java.text.Bidi;
import java.util.function.Predicate;

public abstract class TextInputControlBehavior<T extends II>
extends BehaviorBase<T> {
    static final boolean SHOW_HANDLES = Properties.IS_TOUCH_SUPPORTED;
    public static final String DISABLE_FORWARD_TO_PARENT = "TextInputControlBehavior.disableForwardToParent";
    final T textInputControl;
    protected CR contextMenu;
    private pv textListener = px2 -> this.invalidateBidi();
    private final InputMap<T> inputMap;
    private Bidi bidi = null;
    private Boolean mixed = null;
    private Boolean rtlText = null;
    private boolean editing = false;
    private final EM undoMI = new TextInputControlBehavior$ContextMenuItem("Undo", wS2 -> this.undo());
    private final EM redoMI = new TextInputControlBehavior$ContextMenuItem("Redo", wS2 -> this.redo());
    private final EM cutMI = new TextInputControlBehavior$ContextMenuItem("Cut", wS2 -> this.cut());
    private final EM copyMI = new TextInputControlBehavior$ContextMenuItem("Copy", wS2 -> ((II)this.getNode()).copy());
    private final EM pasteMI = new TextInputControlBehavior$ContextMenuItem("Paste", wS2 -> this.paste());
    private final EM deleteMI = new TextInputControlBehavior$ContextMenuItem("DeleteSelection", wS2 -> this.deleteSelection());
    private final EM selectWordMI = new TextInputControlBehavior$ContextMenuItem("SelectWord", wS2 -> this.selectWord());
    private final EM selectAllMI = new TextInputControlBehavior$ContextMenuItem("SelectAll", wS2 -> this.selectAll());
    private final EM separatorMI = new Gk();

    public TextInputControlBehavior(T t2) {
        super(t2);
        this.textInputControl = t2;
        ((II)this.textInputControl).textProperty().addListener(this.textListener);
        this.inputMap = this.createInputMap();
        Predicate<RT> predicate = rT2 -> !t2.isEditable();
        Predicate<RT> predicate2 = rT2 -> !PlatformUtil.isWindows();
        Predicate<RT> predicate3 = rT2 -> !PlatformUtil.isLinux();
        InputMap$Mapping[] inputMap$MappingArray = new InputMap$Mapping[40];
        inputMap$MappingArray[0] = this.keyMapping(RL.r, (RT rT2) -> this.nextCharacterVisually(true));
        inputMap$MappingArray[1] = this.keyMapping(RL.p, (RT rT2) -> this.nextCharacterVisually(false));
        inputMap$MappingArray[2] = this.keyMapping(RL.q, (RT rT2) -> t2.home());
        inputMap$MappingArray[3] = this.keyMapping(RL.o, (RT rT2) -> t2.home());
        inputMap$MappingArray[4] = this.keyMapping(RL.s, (RT rT2) -> t2.end());
        inputMap$MappingArray[5] = this.keyMapping(RL.n, (RT rT2) -> t2.end());
        InputMap$KeyMapping inputMap$KeyMapping = this.keyMapping(RL.PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_, this::fire);
        inputMap$MappingArray[6] = inputMap$KeyMapping;
        inputMap$MappingArray[7] = this.keyMapping(new KeyBinding(RL.o).shortcut(), (RT rT2) -> t2.home());
        inputMap$MappingArray[8] = this.keyMapping(new KeyBinding(RL.n).shortcut(), (RT rT2) -> t2.end());
        inputMap$MappingArray[9] = this.keyMapping(new KeyBinding(RL.a), rT2 -> this.deletePreviousChar(), predicate);
        inputMap$MappingArray[10] = this.keyMapping(new KeyBinding(RL.a).shift(), rT2 -> this.deletePreviousChar(), predicate);
        inputMap$MappingArray[11] = this.keyMapping(new KeyBinding(RL.aC), rT2 -> this.deleteNextChar(), predicate);
        inputMap$MappingArray[12] = this.keyMapping(new KeyBinding(RL.ag).shortcut(), rT2 -> this.cut(), predicate);
        inputMap$MappingArray[13] = this.keyMapping(new KeyBinding(RL.ct), rT2 -> this.cut(), predicate);
        inputMap$MappingArray[14] = this.keyMapping(new KeyBinding(RL.L).shortcut(), (RT rT2) -> t2.copy());
        inputMap$MappingArray[15] = this.keyMapping(new KeyBinding(RL.be).shortcut(), (RT rT2) -> t2.copy());
        inputMap$MappingArray[16] = this.keyMapping(RL.cu, (RT rT2) -> t2.copy());
        inputMap$MappingArray[17] = this.keyMapping(new KeyBinding(RL.ae).shortcut(), rT2 -> this.paste(), predicate);
        inputMap$MappingArray[18] = this.keyMapping(new KeyBinding(RL.cv), rT2 -> this.paste(), predicate);
        inputMap$MappingArray[19] = this.keyMapping(new KeyBinding(RL.be).shift(), rT2 -> this.paste(), predicate);
        inputMap$MappingArray[20] = this.keyMapping(new KeyBinding(RL.r).shift(), (RT rT2) -> this.selectRight());
        inputMap$MappingArray[21] = this.keyMapping(new KeyBinding(RL.p).shift(), (RT rT2) -> this.selectLeft());
        inputMap$MappingArray[22] = this.keyMapping(new KeyBinding(RL.q).shift(), (RT rT2) -> this.selectHome());
        inputMap$MappingArray[23] = this.keyMapping(new KeyBinding(RL.s).shift(), (RT rT2) -> this.selectEnd());
        inputMap$MappingArray[24] = this.keyMapping(new KeyBinding(RL.o).shortcut().shift(), (RT rT2) -> this.selectHome());
        inputMap$MappingArray[25] = this.keyMapping(new KeyBinding(RL.n).shortcut().shift(), (RT rT2) -> this.selectEnd());
        inputMap$MappingArray[26] = this.keyMapping(new KeyBinding(RL.J).shortcut(), (RT rT2) -> t2.selectAll());
        inputMap$MappingArray[27] = new InputMap$KeyMapping(new KeyBinding(RL.b), FocusTraversalInputMap::traverseNext);
        inputMap$MappingArray[28] = new InputMap$KeyMapping(new KeyBinding(RL.b).shift(), FocusTraversalInputMap::traversePrevious);
        inputMap$MappingArray[29] = new InputMap$KeyMapping(new KeyBinding(RL.b).ctrl(), FocusTraversalInputMap::traverseNext);
        inputMap$MappingArray[30] = new InputMap$KeyMapping(new KeyBinding(RL.b).ctrl().shift(), FocusTraversalInputMap::traversePrevious);
        InputMap$KeyMapping inputMap$KeyMapping2 = new InputMap$KeyMapping(RL.j, this::cancelEdit);
        inputMap$MappingArray[31] = inputMap$KeyMapping2;
        inputMap$MappingArray[32] = this.keyMapping(new KeyBinding(RL.ai).shortcut(), (RT rT2) -> this.undo());
        inputMap$MappingArray[33] = this.keyMapping(new KeyBinding(null, RT.au).alt(KeyBinding$OptionalBoolean.ANY).shift(KeyBinding$OptionalBoolean.ANY).ctrl(KeyBinding$OptionalBoolean.ANY).meta(KeyBinding$OptionalBoolean.ANY), this::defaultKeyTyped);
        InputMap$KeyMapping inputMap$KeyMapping3 = this.keyMapping(new KeyBinding(null, RT.as).shift(KeyBinding$OptionalBoolean.ANY), (RT rT2) -> {
            if (!rT2.b().gT()) {
                rT2.consume();
            }
        });
        inputMap$MappingArray[34] = inputMap$KeyMapping3;
        inputMap$MappingArray[35] = new InputMap$KeyMapping(new KeyBinding(RL.G).ctrl().shift(), rT2 -> FXVK.toggleUseVK(this.textInputControl), rT2 -> !PlatformImpl.isSupported(pm.n));
        inputMap$MappingArray[36] = new InputMap$MouseMapping(RY.aD, this::mousePressed);
        inputMap$MappingArray[37] = new InputMap$MouseMapping(RY.aL, this::mouseDragged);
        inputMap$MappingArray[38] = new InputMap$MouseMapping(RY.aE, this::mouseReleased);
        inputMap$MappingArray[39] = new TextInputControlBehavior$1(this, Rx.ad, this::contextMenuRequested);
        this.addDefaultMapping(this.inputMap, inputMap$MappingArray);
        inputMap$KeyMapping2.setAutoConsume(false);
        inputMap$KeyMapping.setAutoConsume(false);
        inputMap$KeyMapping3.setAutoConsume(false);
        InputMap<T> inputMap = new InputMap<T>(t2);
        inputMap.setInterceptor(wT2 -> !PlatformUtil.isMac());
        inputMap.getMappings().addAll(this.keyMapping(new KeyBinding(RL.o).shift(), (RT rT2) -> this.selectHomeExtend()), this.keyMapping(new KeyBinding(RL.n).shift(), (RT rT2) -> this.selectEndExtend()), this.keyMapping(new KeyBinding(RL.p).shortcut(), (RT rT2) -> t2.home()), this.keyMapping(new KeyBinding(RL.r).shortcut(), (RT rT2) -> t2.end()), this.keyMapping(new KeyBinding(RL.p).alt(), (RT rT2) -> this.leftWord()), this.keyMapping(new KeyBinding(RL.r).alt(), (RT rT2) -> this.rightWord()), this.keyMapping(new KeyBinding(RL.aC).alt(), (RT rT2) -> this.deleteNextWord()), this.keyMapping(new KeyBinding(RL.a).alt(), (RT rT2) -> this.deletePreviousWord()), this.keyMapping(new KeyBinding(RL.a).shortcut(), (RT rT2) -> this.deleteFromLineStart()), this.keyMapping(new KeyBinding(RL.ai).shortcut().shift(), (RT rT2) -> this.redo()), this.keyMapping(new KeyBinding(RL.p).shortcut().shift(), (RT rT2) -> this.selectHomeExtend()), this.keyMapping(new KeyBinding(RL.r).shortcut().shift(), (RT rT2) -> this.selectEndExtend()), this.keyMapping(new KeyBinding(RL.p).shift().alt(), (RT rT2) -> this.selectLeftWord()), this.keyMapping(new KeyBinding(RL.r).shift().alt(), (RT rT2) -> this.selectRightWord()));
        this.addDefaultChildMap(this.inputMap, inputMap);
        InputMap<T> inputMap2 = new InputMap<T>(t2);
        inputMap2.setInterceptor(wT2 -> PlatformUtil.isMac());
        inputMap2.getMappings().addAll(this.keyMapping(new KeyBinding(RL.o).shift(), (RT rT2) -> this.selectHome()), this.keyMapping(new KeyBinding(RL.n).shift(), (RT rT2) -> this.selectEnd()), this.keyMapping(new KeyBinding(RL.p).ctrl(), (RT rT2) -> this.leftWord()), this.keyMapping(new KeyBinding(RL.r).ctrl(), (RT rT2) -> this.rightWord()), this.keyMapping(new KeyBinding(RL.Q).ctrl(), (RT rT2) -> this.deletePreviousChar()), this.keyMapping(new KeyBinding(RL.aC).ctrl(), (RT rT2) -> this.deleteNextWord()), this.keyMapping(new KeyBinding(RL.a).ctrl(), (RT rT2) -> this.deletePreviousWord()), this.keyMapping(new KeyBinding(RL.ak).ctrl(), (RT rT2) -> t2.deselect()), this.keyMapping(new KeyBinding(RL.ah).ctrl(), rT2 -> this.redo(), predicate2), this.keyMapping(new KeyBinding(RL.ai).ctrl().shift(), rT2 -> this.redo(), predicate3), this.keyMapping(new KeyBinding(RL.p).ctrl().shift(), (RT rT2) -> this.selectLeftWord()), this.keyMapping(new KeyBinding(RL.r).ctrl().shift(), (RT rT2) -> this.selectRightWord()));
        this.addDefaultChildMap(this.inputMap, inputMap2);
        this.addKeyPadMappings(this.inputMap);
        ((II)this.textInputControl).textProperty().addListener(this.textListener);
        this.contextMenu = new CR();
    }

    @Override
    public InputMap<T> getInputMap() {
        return this.inputMap;
    }

    protected void addKeyPadMappings(InputMap<T> inputMap) {
        InputMap<II> inputMap2 = new InputMap<II>((II)this.getNode());
        for (Object e2 : inputMap.getMappings()) {
            InputMap$KeyMapping inputMap$KeyMapping;
            KeyBinding keyBinding;
            if (!(e2 instanceof InputMap$KeyMapping) || (keyBinding = (KeyBinding)(inputMap$KeyMapping = (InputMap$KeyMapping)e2).getMappingKey()).getCode() == null) continue;
            RL rL2 = null;
            switch (keyBinding.getCode()) {
                case p: {
                    rL2 = RL.bl;
                    break;
                }
                case r: {
                    rL2 = RL.bm;
                    break;
                }
                case q: {
                    rL2 = RL.bj;
                    break;
                }
                case s: {
                    rL2 = RL.bk;
                    break;
                }
            }
            if (rL2 == null) continue;
            KeyBinding keyBinding2 = new KeyBinding(rL2).shift(keyBinding.getShift()).ctrl(keyBinding.getCtrl()).alt(keyBinding.getAlt()).meta(keyBinding.getMeta());
            inputMap2.getMappings().add(new InputMap$KeyMapping(keyBinding2, inputMap$KeyMapping.getEventHandler()));
        }
        for (Object e2 : inputMap2.getMappings()) {
            inputMap.getMappings().add((InputMap$KeyMapping)e2);
        }
        for (Object e3 : inputMap.getChildInputMaps()) {
            this.addKeyPadMappings((InputMap)e3);
        }
    }

    protected InputMap$KeyMapping keyMapping(RL rL2, wW<RT> wW2) {
        return this.keyMapping(new KeyBinding(rL2), wW2);
    }

    protected InputMap$KeyMapping keyMapping(KeyBinding keyBinding, wW<RT> wW2) {
        return this.keyMapping(keyBinding, wW2, null);
    }

    protected InputMap$KeyMapping keyMapping(KeyBinding keyBinding, wW<RT> wW2, Predicate<RT> predicate) {
        return new InputMap$KeyMapping(keyBinding, rT2 -> {
            this.setCaretAnimating(false);
            wW2.handle((RT)rT2);
            this.setCaretAnimating(true);
        }, predicate);
    }

    @Override
    public void dispose() {
        ((II)this.textInputControl).textProperty().removeListener(this.textListener);
        super.dispose();
    }

    protected abstract void deleteChar(boolean var1);

    protected abstract void replaceText(int var1, int var2, String var3);

    protected abstract void setCaretAnimating(boolean var1);

    protected abstract void deleteFromLineStart();

    protected abstract void mousePressed(RY var1);

    protected abstract void mouseDragged(RY var1);

    protected abstract void mouseReleased(RY var1);

    protected abstract void contextMenuRequested(Rx var1);

    private void defaultKeyTyped(RT rT2) {
        II iI2 = (II)this.getNode();
        if (!iI2.isEditable() || iI2.isDisabled()) {
            return;
        }
        String string = rT2.aA();
        if (string.length() == 0) {
            return;
        }
        if ((rT2.gW() || rT2.gX() || PlatformUtil.isMac() && rT2.gY()) && (!rT2.gW() && !PlatformUtil.isMac() || !rT2.gX())) {
            return;
        }
        this.setEditing(true);
        if (string.charAt(0) > '\u001f' && string.charAt(0) != '\u007f' && !rT2.gY()) {
            Dr dr2 = iI2.getSelection();
            int n2 = dr2.getStart();
            int n3 = dr2.getEnd();
            this.replaceText(n2, n3, string);
        }
        this.setEditing(false);
    }

    private void invalidateBidi() {
        this.bidi = null;
        this.mixed = null;
        this.rtlText = null;
    }

    private Bidi getBidi() {
        if (this.bidi == null) {
            this.bidi = new Bidi(((II)this.textInputControl).textProperty().getValueSafe(), ((yD)this.textInputControl).getEffectiveNodeOrientation() == xm.b ? 1 : 0);
        }
        return this.bidi;
    }

    protected boolean isMixed() {
        if (this.mixed == null) {
            this.mixed = this.getBidi().isMixed();
        }
        return this.mixed;
    }

    protected boolean isRTLText() {
        if (this.rtlText == null) {
            Bidi bidi = this.getBidi();
            this.rtlText = bidi.isRightToLeft() || this.isMixed() && ((yD)this.textInputControl).getEffectiveNodeOrientation() == xm.b;
        }
        return this.rtlText;
    }

    private void nextCharacterVisually(boolean bl2) {
        if (this.isMixed()) {
            OY oY2 = (OY)((CU)this.textInputControl).getSkin();
            oY2.PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_(Pt.PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_, bl2 ? Pm.a : Pm.PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_, false);
        } else if (bl2 != this.isRTLText()) {
            ((II)this.textInputControl).forward();
        } else {
            ((II)this.textInputControl).backward();
        }
    }

    private void selectLeft() {
        if (this.isRTLText()) {
            ((II)this.textInputControl).selectForward();
        } else {
            ((II)this.textInputControl).selectBackward();
        }
    }

    private void selectRight() {
        if (this.isRTLText()) {
            ((II)this.textInputControl).selectBackward();
        } else {
            ((II)this.textInputControl).selectForward();
        }
    }

    private void deletePreviousChar() {
        this.setEditing(true);
        this.deleteChar(true);
        this.setEditing(false);
    }

    private void deleteNextChar() {
        this.setEditing(true);
        this.deleteChar(false);
        this.setEditing(false);
    }

    protected void deletePreviousWord() {
        this.setEditing(true);
        II iI2 = (II)this.getNode();
        int n2 = iI2.getCaretPosition();
        if (n2 > 0) {
            iI2.previousWord();
            int n3 = iI2.getCaretPosition();
            this.replaceText(n3, n2, "");
        }
        this.setEditing(false);
    }

    protected void deleteNextWord() {
        this.setEditing(true);
        II iI2 = (II)this.getNode();
        int n2 = iI2.getCaretPosition();
        if (n2 < iI2.getLength()) {
            this.nextWord();
            int n3 = iI2.getCaretPosition();
            this.replaceText(n2, n3, "");
        }
        this.setEditing(false);
    }

    public void deleteSelection() {
        this.setEditing(true);
        II iI2 = (II)this.getNode();
        Dr dr2 = iI2.getSelection();
        if (dr2.getLength() > 0) {
            this.deleteChar(false);
        }
        this.setEditing(false);
    }

    public void cut() {
        this.setEditing(true);
        ((II)this.getNode()).cut();
        this.setEditing(false);
    }

    public void paste() {
        this.setEditing(true);
        ((II)this.getNode()).paste();
        this.setEditing(false);
    }

    public void undo() {
        this.setEditing(true);
        ((II)this.getNode()).undo();
        this.setEditing(false);
    }

    public void redo() {
        this.setEditing(true);
        ((II)this.getNode()).redo();
        this.setEditing(false);
    }

    protected void selectPreviousWord() {
        ((II)this.getNode()).selectPreviousWord();
    }

    public void selectNextWord() {
        II iI2 = (II)this.getNode();
        if (PlatformUtil.isMac() || PlatformUtil.isLinux()) {
            iI2.selectEndOfNextWord();
        } else {
            iI2.selectNextWord();
        }
    }

    private void selectLeftWord() {
        if (this.isRTLText()) {
            this.selectNextWord();
        } else {
            this.selectPreviousWord();
        }
    }

    private void selectRightWord() {
        if (this.isRTLText()) {
            this.selectPreviousWord();
        } else {
            this.selectNextWord();
        }
    }

    protected void selectWord() {
        II iI2 = (II)this.getNode();
        iI2.previousWord();
        if (PlatformUtil.isWindows()) {
            iI2.selectNextWord();
        } else {
            iI2.selectEndOfNextWord();
        }
        if (SHOW_HANDLES && this.contextMenu.isShowing()) {
            this.populateContextMenu();
        }
    }

    protected void selectAll() {
        ((II)this.getNode()).selectAll();
        if (SHOW_HANDLES && this.contextMenu.isShowing()) {
            this.populateContextMenu();
        }
    }

    protected void previousWord() {
        ((II)this.getNode()).previousWord();
    }

    protected void nextWord() {
        II iI2 = (II)this.getNode();
        if (PlatformUtil.isMac() || PlatformUtil.isLinux()) {
            iI2.endOfNextWord();
        } else {
            iI2.nextWord();
        }
    }

    private void leftWord() {
        if (this.isRTLText()) {
            this.nextWord();
        } else {
            this.previousWord();
        }
    }

    private void rightWord() {
        if (this.isRTLText()) {
            this.previousWord();
        } else {
            this.nextWord();
        }
    }

    protected void fire(RT rT2) {
    }

    protected void cancelEdit(RT rT2) {
    }

    protected void selectHome() {
        ((II)this.getNode()).selectHome();
    }

    protected void selectEnd() {
        ((II)this.getNode()).selectEnd();
    }

    protected void selectHomeExtend() {
        ((II)this.getNode()).extendSelection(0);
    }

    protected void selectEndExtend() {
        II iI2 = (II)this.getNode();
        iI2.extendSelection(iI2.getLength());
    }

    protected void setEditing(boolean bl2) {
        this.editing = bl2;
    }

    public boolean isEditing() {
        return this.editing;
    }

    protected void populateContextMenu() {
        II iI2 = (II)this.getNode();
        boolean bl2 = iI2.isEditable();
        boolean bl3 = iI2.getLength() > 0;
        boolean bl4 = iI2.getSelection().getLength() > 0;
        boolean bl5 = iI2.getSelection().getLength() == iI2.getLength();
        boolean bl6 = iI2 instanceof Fc;
        tM<EM> tM2 = this.contextMenu.m();
        if (SHOW_HANDLES) {
            tM2.clear();
            if (!bl6 && bl4) {
                if (bl2) {
                    tM2.add(this.cutMI);
                }
                tM2.add(this.copyMI);
            }
            if (bl2 && Ru.PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_().gJ()) {
                tM2.add(this.pasteMI);
            }
            if (bl3 && !bl5) {
                if (!bl4 && !(iI2 instanceof Fc)) {
                    tM2.add(this.selectWordMI);
                }
                tM2.add(this.selectAllMI);
            }
            this.selectWordMI.getProperties().put("refreshMenu", Boolean.TRUE);
            this.selectAllMI.getProperties().put("refreshMenu", Boolean.TRUE);
        } else {
            if (bl2) {
                tM2.setAll((EM[])new EM[]{this.undoMI, this.redoMI, this.cutMI, this.copyMI, this.pasteMI, this.deleteMI, this.separatorMI, this.selectAllMI});
            } else {
                tM2.setAll((EM[])new EM[]{this.copyMI, this.separatorMI, this.selectAllMI});
            }
            this.undoMI.setDisable(!((II)this.getNode()).isUndoable());
            this.redoMI.setDisable(!((II)this.getNode()).isRedoable());
            this.cutMI.setDisable(bl6 || !bl4);
            this.copyMI.setDisable(bl6 || !bl4);
            this.pasteMI.setDisable(!Ru.PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_().gJ());
            this.deleteMI.setDisable(!bl4);
        }
    }
}

