/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.inputmap.InputMap;
import com.sun.javafx.scene.control.inputmap.InputMap$Mapping;
import dev.protect.yD;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public abstract class BehaviorBase<N extends yD> {
    private final N node;
    private final List<InputMap$Mapping<?>> installedDefaultMappings;
    private final List<Runnable> childInputMapDisposalHandlers;

    public BehaviorBase(N n2) {
        this.node = n2;
        this.installedDefaultMappings = new ArrayList();
        this.childInputMapDisposalHandlers = new ArrayList<Runnable>();
    }

    public abstract InputMap<N> getInputMap();

    public final N getNode() {
        return this.node;
    }

    public void dispose() {
        for (InputMap$Mapping<?> object : this.installedDefaultMappings) {
            this.getInputMap().getMappings().remove(object);
        }
        for (Runnable runnable : this.childInputMapDisposalHandlers) {
            runnable.run();
        }
    }

    protected void addDefaultMapping(List<InputMap$Mapping<?>> list) {
        this.addDefaultMapping(this.getInputMap(), list.toArray(new InputMap$Mapping[list.size()]));
    }

    protected void addDefaultMapping(InputMap$Mapping<?> ... inputMap$MappingArray) {
        this.addDefaultMapping(this.getInputMap(), inputMap$MappingArray);
    }

    protected void addDefaultMapping(InputMap<N> inputMap, InputMap$Mapping<?> ... inputMap$MappingArray) {
        ArrayList arrayList = new ArrayList(inputMap.getMappings());
        for (InputMap$Mapping<?> inputMap$Mapping : inputMap$MappingArray) {
            if (arrayList.contains(inputMap$Mapping)) continue;
            inputMap.getMappings().add(inputMap$Mapping);
            this.installedDefaultMappings.add(inputMap$Mapping);
        }
    }

    protected <T extends yD> void addDefaultChildMap(InputMap<T> inputMap, InputMap<T> inputMap2) {
        inputMap.getChildInputMaps().add(inputMap2);
        this.childInputMapDisposalHandlers.add(() -> inputMap.getChildInputMaps().remove(inputMap2));
    }

    protected InputMap<N> createInputMap() {
        return new InputMap<N>(this.node);
    }

    protected void removeMapping(Object object) {
        InputMap<N> inputMap = this.getInputMap();
        inputMap.lookupMapping(object).ifPresent(inputMap$Mapping -> {
            inputMap.getMappings().remove(inputMap$Mapping);
            this.installedDefaultMappings.remove(inputMap$Mapping);
        });
    }

    void rtl(yD yD2, Runnable runnable, Runnable runnable2) {
        switch (yD2.getEffectiveNodeOrientation()) {
            case b: {
                runnable.run();
                break;
            }
            default: {
                runnable2.run();
            }
        }
    }

    <T> void rtl(yD yD2, T t2, Consumer<T> consumer, Consumer<T> consumer2) {
        switch (yD2.getEffectiveNodeOrientation()) {
            case b: {
                consumer.accept(t2);
                break;
            }
            default: {
                consumer2.accept(t2);
            }
        }
    }

    boolean isRTL(yD yD2) {
        switch (yD2.getEffectiveNodeOrientation()) {
            case b: {
                return true;
            }
        }
        return false;
    }
}

