/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control;

import dev.protect.tD;
import dev.protect.tM;
import dev.protect.tN;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;

public abstract class SelectedItemsReadOnlyObservableList<E>
extends tN<E> {
    private final tM<Integer> selectedIndices;
    private final Supplier<Integer> modelSizeSupplier;
    private final List<WeakReference<E>> itemsRefList;

    public SelectedItemsReadOnlyObservableList(tM<Integer> tM2, Supplier<Integer> supplier) {
        this.modelSizeSupplier = supplier;
        this.selectedIndices = tM2;
        this.itemsRefList = new ArrayList<WeakReference<E>>();
        tM2.addListener((tD<? super E> tD2) -> {
            int n2 = 0;
            this.beginChange();
            while (tD2.next()) {
                if (tD2.wasReplaced()) {
                    List<E> list;
                    List<E> list2 = this.getRemovedElements(tD2, n2);
                    if (list2.equals(list = this.getAddedElements(tD2))) continue;
                    this.nextReplace(tD2.getFrom(), tD2.getTo(), list2);
                    continue;
                }
                if (tD2.wasAdded()) {
                    this.nextAdd(tD2.getFrom(), tD2.getTo());
                    continue;
                }
                if (tD2.wasRemoved()) {
                    int n3 = tD2.getRemovedSize();
                    if (n3 == 1) {
                        this.nextRemove(tD2.getFrom(), this.getRemovedModelItem(n2 + tD2.getFrom()));
                    } else {
                        this.nextRemove(tD2.getFrom(), this.getRemovedElements(tD2, n2));
                    }
                    n2 += n3;
                    continue;
                }
                if (tD2.wasPermutated()) {
                    int[] nArray = new int[this.size()];
                    for (int i2 = 0; i2 < this.size(); ++i2) {
                        nArray[i2] = tD2.getPermutation(i2);
                    }
                    this.nextPermutation(tD2.getFrom(), tD2.getTo(), nArray);
                    continue;
                }
                if (!tD2.wasUpdated()) continue;
                for (int i3 = tD2.getFrom(); i3 < tD2.getTo(); ++i3) {
                    this.nextUpdate(i3);
                }
            }
            this.itemsRefList.clear();
            Iterator iterator = tM2.iterator();
            while (iterator.hasNext()) {
                int n4 = (Integer)iterator.next();
                this.itemsRefList.add(new WeakReference<E>(this.getModelItem(n4)));
            }
            this.endChange();
        });
    }

    protected abstract E getModelItem(int var1);

    @Override
    public E get(int n2) {
        int n3 = (Integer)this.selectedIndices.get(n2);
        return this.getModelItem(n3);
    }

    @Override
    public int size() {
        return this.selectedIndices.size();
    }

    private E _getModelItem(int n2) {
        if (n2 >= this.modelSizeSupplier.get()) {
            return this.getRemovedModelItem(n2);
        }
        return this.getModelItem(n2);
    }

    private E getRemovedModelItem(int n2) {
        return n2 < 0 || n2 >= this.itemsRefList.size() ? null : (E)this.itemsRefList.get(n2).get();
    }

    private List<E> getRemovedElements(tD<? extends Integer> tD2, int n2) {
        int n3;
        ArrayList<E> arrayList = new ArrayList<E>(tD2.getRemovedSize());
        int n4 = n3 + tD2.getRemovedSize();
        for (int i2 = n3 = tD2.getFrom(); i2 < n4; ++i2) {
            arrayList.add(this.getRemovedModelItem(i2 + n2));
        }
        return arrayList;
    }

    private List<E> getAddedElements(tD<? extends Integer> tD2) {
        ArrayList<E> arrayList = new ArrayList<E>(tD2.getAddedSize());
        Iterator<? extends Integer> iterator = tD2.getAddedSubList().iterator();
        while (iterator.hasNext()) {
            int n2 = iterator.next();
            arrayList.add(this._getModelItem(n2));
        }
        return arrayList;
    }
}

