/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control;

import dev.protect.HH;
import dev.protect.tC;
import dev.protect.tM;
import dev.protect.tX;
import dev.protect.to;
import java.util.BitSet;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public abstract class SelectedCellsMap<T extends HH> {
    private final tM<T> selectedCells = to.a();
    private final tM<T> sortedSelectedCells = new tX<T>(this.selectedCells, (hH2, hH3) -> {
        int n2 = hH2.cV() - hH3.cV();
        return n2 == 0 ? hH2.getColumn() - hH3.getColumn() : n2;
    });
    private final Map<Integer, BitSet> selectedCellBitSetMap;

    public SelectedCellsMap(tC<T> tC2) {
        this.sortedSelectedCells.addListener(tC2);
        this.selectedCellBitSetMap = new TreeMap<Integer, BitSet>((n2, n3) -> n2.compareTo((Integer)n3));
    }

    public abstract boolean isCellSelectionEnabled();

    public int size() {
        return this.selectedCells.size();
    }

    public T get(int n2) {
        if (n2 < 0) {
            return null;
        }
        return (T)((HH)this.sortedSelectedCells.get(n2));
    }

    public void add(T t2) {
        BitSet bitSet;
        int n2 = ((HH)t2).cV();
        int n3 = ((HH)t2).getColumn();
        boolean bl2 = false;
        if (!this.selectedCellBitSetMap.containsKey(n2)) {
            bitSet = new BitSet();
            this.selectedCellBitSetMap.put(n2, bitSet);
            bl2 = true;
        } else {
            bitSet = this.selectedCellBitSetMap.get(n2);
        }
        boolean bl3 = this.isCellSelectionEnabled();
        if (bl3) {
            if (n3 >= 0) {
                boolean bl4 = bitSet.get(n3);
                if (!bl4) {
                    bitSet.set(n3);
                    this.selectedCells.add(t2);
                }
            } else if (!this.selectedCells.contains(t2)) {
                this.selectedCells.add(t2);
            }
        } else if (bl2) {
            if (n3 >= 0) {
                bitSet.set(n3);
            }
            this.selectedCells.add(t2);
        }
    }

    public void addAll(Collection<T> collection) {
        for (HH hH2 : collection) {
            BitSet bitSet;
            int n2 = hH2.cV();
            int n3 = hH2.getColumn();
            if (!this.selectedCellBitSetMap.containsKey(n2)) {
                bitSet = new BitSet();
                this.selectedCellBitSetMap.put(n2, bitSet);
            } else {
                bitSet = this.selectedCellBitSetMap.get(n2);
            }
            if (n3 < 0) continue;
            bitSet.set(n3);
        }
        this.selectedCells.addAll(collection);
    }

    public void setAll(Collection<T> collection) {
        this.selectedCellBitSetMap.clear();
        for (HH hH2 : collection) {
            BitSet bitSet;
            int n2 = hH2.cV();
            int n3 = hH2.getColumn();
            if (!this.selectedCellBitSetMap.containsKey(n2)) {
                bitSet = new BitSet();
                this.selectedCellBitSetMap.put(n2, bitSet);
            } else {
                bitSet = this.selectedCellBitSetMap.get(n2);
            }
            if (n3 < 0) continue;
            bitSet.set(n3);
        }
        this.selectedCells.setAll(collection);
    }

    public void remove(T t2) {
        int n2 = ((HH)t2).cV();
        int n3 = ((HH)t2).getColumn();
        if (this.selectedCellBitSetMap.containsKey(n2)) {
            BitSet bitSet = this.selectedCellBitSetMap.get(n2);
            if (n3 >= 0) {
                bitSet.clear(n3);
            }
            if (bitSet.isEmpty()) {
                this.selectedCellBitSetMap.remove(n2);
            }
        }
        this.selectedCells.remove(t2);
    }

    public void clear() {
        this.selectedCellBitSetMap.clear();
        this.selectedCells.clear();
    }

    public boolean isSelected(int n2, int n3) {
        if (n3 < 0) {
            return this.selectedCellBitSetMap.containsKey(n2);
        }
        return this.selectedCellBitSetMap.containsKey(n2) ? this.selectedCellBitSetMap.get(n2).get(n3) : false;
    }

    public int indexOf(T t2) {
        return this.sortedSelectedCells.indexOf(t2);
    }

    public boolean isEmpty() {
        return this.selectedCells.isEmpty();
    }

    public tM<T> getSelectedCells() {
        return this.selectedCells;
    }
}

