/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control;

import com.sun.javafx.scene.control.DatePickerContent;
import dev.protect.Dg;
import dev.protect.Di;
import dev.protect.Du;
import dev.protect.Sy;
import dev.protect.Yf;
import dev.protect.xq;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.chrono.Chronology;
import java.time.chrono.HijrahChronology;
import java.time.chrono.HijrahDate;
import java.time.chrono.IsoChronology;
import java.time.format.DecimalStyle;
import java.time.temporal.ChronoField;
import java.util.Locale;

public class DatePickerHijrahContent
extends DatePickerContent {
    private Du hijrahMonthYearLabel;

    public DatePickerHijrahContent(Di di2) {
        super(di2);
    }

    @Override
    protected Chronology getPrimaryChronology() {
        return IsoChronology.INSTANCE;
    }

    @Override
    protected Sy createMonthYearPane() {
        Sy sy2 = super.createMonthYearPane();
        this.hijrahMonthYearLabel = new Du();
        this.hijrahMonthYearLabel.getStyleClass().add("secondary-label");
        sy2.x(this.hijrahMonthYearLabel);
        Sy.setAlignment(this.hijrahMonthYearLabel, xq.d);
        return sy2;
    }

    @Override
    protected void updateMonthYearPane() {
        super.updateMonthYearPane();
        Locale locale = this.getLocale();
        HijrahChronology hijrahChronology = HijrahChronology.INSTANCE;
        long l2 = -1L;
        long l3 = -1L;
        String string = null;
        String string2 = null;
        String string3 = null;
        YearMonth yearMonth = (YearMonth)this.displayedYearMonthProperty().get();
        for (Dg dg2 : this.dayCells) {
            LocalDate localDate = this.dayCellDate(dg2);
            if (!yearMonth.equals(YearMonth.from(localDate))) continue;
            try {
                HijrahDate hijrahDate = hijrahChronology.date(localDate);
                long l4 = hijrahDate.getLong(ChronoField.MONTH_OF_YEAR);
                long l5 = hijrahDate.getLong(ChronoField.YEAR);
                if (string3 != null && l4 == l2) continue;
                String string4 = this.monthFormatter.withLocale(locale).withChronology(hijrahChronology).withDecimalStyle(DecimalStyle.of(locale)).format(hijrahDate);
                String string5 = this.yearFormatter.withLocale(locale).withChronology(hijrahChronology).withDecimalStyle(DecimalStyle.of(locale)).format(hijrahDate);
                if (string3 == null) {
                    l2 = l4;
                    l3 = l5;
                    string = string4;
                    string2 = string5;
                    string3 = string + " " + string2;
                    continue;
                }
                if (l5 > l3) {
                    string3 = string + " " + string2 + " - " + string4 + " " + string5;
                    break;
                }
                string3 = string + " - " + string4 + " " + string2;
                break;
            }
            catch (DateTimeException dateTimeException) {
            }
        }
        this.hijrahMonthYearLabel.setText(string3);
    }

    @Override
    protected void createDayCells() {
        super.createDayCells();
        for (Dg dg2 : this.dayCells) {
            Yf yf2 = new Yf();
            dg2.getProperties().put("DateCell.secondaryText", yf2);
        }
    }

    @Override
    public void updateDayCells() {
        super.updateDayCells();
        Locale locale = this.getLocale();
        HijrahChronology hijrahChronology = HijrahChronology.INSTANCE;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        boolean bl2 = false;
        for (Dg dg2 : this.dayCells) {
            Yf yf2 = (Yf)dg2.getProperties().get("DateCell.secondaryText");
            dg2.getStyleClass().add("hijrah-day-cell");
            yf2.getStyleClass().setAll((String[])new String[]{"text", "secondary-text"});
            try {
                HijrahDate hijrahDate = hijrahChronology.date(this.dayCellDate(dg2));
                String string = this.dayCellFormatter.withLocale(locale).withChronology(hijrahChronology).withDecimalStyle(DecimalStyle.of(locale)).format(hijrahDate);
                yf2.setText(string);
                dg2.requestLayout();
            }
            catch (DateTimeException dateTimeException) {
                yf2.setText(" ");
                dg2.setDisable(true);
            }
        }
    }
}

