/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.control.DatePickerContent$1;
import com.sun.javafx.scene.control.skin.Utils;
import com.sun.javafx.scene.control.skin.resources.ControlResources;
import com.sun.javafx.scene.traversal.Direction;
import dev.protect.Ah;
import dev.protect.BT;
import dev.protect.Dg;
import dev.protect.Di;
import dev.protect.Du;
import dev.protect.RT;
import dev.protect.RW;
import dev.protect.RY;
import dev.protect.SF;
import dev.protect.SK;
import dev.protect.SZ;
import dev.protect.Sy;
import dev.protect.TS;
import dev.protect.Ut;
import dev.protect.po;
import dev.protect.rU;
import dev.protect.sG;
import dev.protect.sP;
import dev.protect.tb;
import dev.protect.td;
import dev.protect.wW;
import dev.protect.yD;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.Chronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DecimalStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.ValueRange;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class DatePickerContent
extends Ut {
    protected Di datePicker;
    private BT backMonthButton;
    private BT forwardMonthButton;
    private BT backYearButton;
    private BT forwardYearButton;
    private Du monthLabel;
    private Du yearLabel;
    protected SK gridPane;
    private int daysPerWeek;
    private List<Dg> dayNameCells = new ArrayList<Dg>();
    private List<Dg> weekNumberCells = new ArrayList<Dg>();
    protected List<Dg> dayCells = new ArrayList<Dg>();
    private LocalDate[] dayCellDates;
    private Dg lastFocusedDayCell = null;
    final DateTimeFormatter monthFormatter = DateTimeFormatter.ofPattern("MMMM");
    final DateTimeFormatter monthFormatterSO = DateTimeFormatter.ofPattern("LLLL");
    final DateTimeFormatter yearFormatter = DateTimeFormatter.ofPattern("y");
    final DateTimeFormatter yearWithEraFormatter = DateTimeFormatter.ofPattern("GGGGy");
    final DateTimeFormatter weekNumberFormatter = DateTimeFormatter.ofPattern("w");
    final DateTimeFormatter weekDayNameFormatter = DateTimeFormatter.ofPattern("ccc");
    final DateTimeFormatter dayCellFormatter = DateTimeFormatter.ofPattern("d");
    private rU<YearMonth> displayedYearMonth = new sG<YearMonth>(this, "displayedYearMonth");

    static String getString(String string) {
        return ControlResources.getString("DatePicker." + string);
    }

    public DatePickerContent(Di di2) {
        Dg dg2;
        int n2;
        this.datePicker = di2;
        this.getStyleClass().add("date-picker-popup");
        this.daysPerWeek = this.getDaysPerWeek();
        Object object = (LocalDate)di2.x();
        this.displayedYearMonth.set(object != null ? YearMonth.from((TemporalAccessor)object) : YearMonth.now());
        this.displayedYearMonth.addListener((tb2, yearMonth, yearMonth2) -> this.updateValues());
        this.getChildren().add(this.createMonthYearPane());
        this.gridPane = new DatePickerContent$1(this, di2);
        this.gridPane.setFocusTraversable(true);
        this.gridPane.getStyleClass().add("calendar-grid");
        this.gridPane.setVgap(-1.0);
        this.gridPane.setHgap(-1.0);
        object = new td<yD>((tb2, yD2, yD3) -> {
            if (yD3 == this.gridPane) {
                if (yD2 instanceof Dg) {
                    NodeHelper.traverse(this.gridPane, Direction.PREVIOUS);
                } else if (this.lastFocusedDayCell != null) {
                    po.runLater(() -> this.lastFocusedDayCell.requestFocus());
                } else {
                    this.clearFocus();
                }
            }
        });
        this.gridPane.sceneProperty().addListener(new td<Ah>((arg_0, arg_1, arg_2) -> DatePickerContent.lambda$new$4((td)object, arg_0, arg_1, arg_2)));
        if (this.gridPane.getScene() != null) {
            this.gridPane.getScene().h().addListener((sP<yD>)object);
        }
        for (n2 = 0; n2 < this.daysPerWeek; ++n2) {
            dg2 = new Dg();
            dg2.getStyleClass().add("day-name-cell");
            this.dayNameCells.add(dg2);
        }
        for (n2 = 0; n2 < 6; ++n2) {
            dg2 = new Dg();
            dg2.getStyleClass().add("week-number-cell");
            this.weekNumberCells.add(dg2);
        }
        this.createDayCells();
        this.updateGrid();
        this.getChildren().add(this.gridPane);
        this.refresh();
        this.addEventHandler(RT.ar, rT2 -> {
            yD yD2 = this.getScene().e();
            if (yD2 instanceof Dg) {
                this.lastFocusedDayCell = (Dg)yD2;
            }
            if (rT2.getEventType() == RT.as) {
                switch (rT2.b()) {
                    case o: {
                        this.goToDate(LocalDate.now(), true);
                        rT2.consume();
                        break;
                    }
                    case l: {
                        if (PlatformUtil.isMac() && rT2.gY() || !PlatformUtil.isMac() && rT2.gW()) {
                            if (!this.backYearButton.isDisabled()) {
                                this.forward(-1, ChronoUnit.YEARS, true);
                            }
                        } else if (!this.backMonthButton.isDisabled()) {
                            this.forward(-1, ChronoUnit.MONTHS, true);
                        }
                        rT2.consume();
                        break;
                    }
                    case m: {
                        if (PlatformUtil.isMac() && rT2.gY() || !PlatformUtil.isMac() && rT2.gW()) {
                            if (!this.forwardYearButton.isDisabled()) {
                                this.forward(1, ChronoUnit.YEARS, true);
                            }
                        } else if (!this.forwardMonthButton.isDisabled()) {
                            this.forward(1, ChronoUnit.MONTHS, true);
                        }
                        rT2.consume();
                    }
                }
                yD2 = this.getScene().e();
                if (yD2 instanceof Dg) {
                    this.lastFocusedDayCell = (Dg)yD2;
                }
            }
            switch (rT2.b()) {
                case aI: 
                case aO: 
                case q: 
                case s: 
                case p: 
                case r: 
                case b: {
                    break;
                }
                case j: {
                    di2.hide();
                    rT2.consume();
                    break;
                }
                default: {
                    rT2.consume();
                }
            }
        });
    }

    public rU<YearMonth> displayedYearMonthProperty() {
        return this.displayedYearMonth;
    }

    protected Sy createMonthYearPane() {
        Sy sy2 = new Sy();
        sy2.getStyleClass().add("month-year-pane");
        SZ sZ2 = new SZ();
        sZ2.getStyleClass().add("spinner");
        this.backMonthButton = new BT();
        this.backMonthButton.getStyleClass().add("left-button");
        this.forwardMonthButton = new BT();
        this.forwardMonthButton.getStyleClass().add("right-button");
        TS tS2 = new TS();
        tS2.getStyleClass().add("left-arrow");
        tS2.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.backMonthButton.setGraphic(tS2);
        TS tS3 = new TS();
        tS3.getStyleClass().add("right-arrow");
        tS3.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.forwardMonthButton.setGraphic(tS3);
        this.backMonthButton.setOnAction(wS2 -> this.forward(-1, ChronoUnit.MONTHS, false));
        this.monthLabel = new Du();
        this.monthLabel.getStyleClass().add("spinner-label");
        this.monthLabel.fontProperty().addListener((tb2, xZ2, xZ3) -> this.updateMonthLabelWidth());
        this.forwardMonthButton.setOnAction(wS2 -> this.forward(1, ChronoUnit.MONTHS, false));
        sZ2.getChildren().addAll((yD[])new yD[]{this.backMonthButton, this.monthLabel, this.forwardMonthButton});
        sy2.y(sZ2);
        SZ sZ3 = new SZ();
        sZ3.getStyleClass().add("spinner");
        this.backYearButton = new BT();
        this.backYearButton.getStyleClass().add("left-button");
        this.forwardYearButton = new BT();
        this.forwardYearButton.getStyleClass().add("right-button");
        TS tS4 = new TS();
        tS4.getStyleClass().add("left-arrow");
        tS4.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.backYearButton.setGraphic(tS4);
        TS tS5 = new TS();
        tS5.getStyleClass().add("right-arrow");
        tS5.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.forwardYearButton.setGraphic(tS5);
        this.backYearButton.setOnAction(wS2 -> this.forward(-1, ChronoUnit.YEARS, false));
        this.yearLabel = new Du();
        this.yearLabel.getStyleClass().add("spinner-label");
        this.forwardYearButton.setOnAction(wS2 -> this.forward(1, ChronoUnit.YEARS, false));
        sZ3.getChildren().addAll((yD[])new yD[]{this.backYearButton, this.yearLabel, this.forwardYearButton});
        sZ3.setFillHeight(false);
        sy2.z(sZ3);
        return sy2;
    }

    private void refresh() {
        this.updateMonthLabelWidth();
        this.updateDayNameCells();
        this.updateValues();
    }

    public void updateValues() {
        this.updateWeeknumberDateCells();
        this.updateDayCells();
        this.updateMonthYearPane();
    }

    public void updateGrid() {
        int n2;
        this.gridPane.getColumnConstraints().clear();
        this.gridPane.getChildren().clear();
        int n3 = this.daysPerWeek + (this.datePicker.fk() ? 1 : 0);
        SF sF2 = new SF();
        sF2.aR(100.0);
        for (n2 = 0; n2 < n3; ++n2) {
            this.gridPane.getColumnConstraints().add(sF2);
        }
        for (n2 = 0; n2 < this.daysPerWeek; ++n2) {
            this.gridPane.add(this.dayNameCells.get(n2), n2 + n3 - this.daysPerWeek, 1);
        }
        if (this.datePicker.fk()) {
            for (n2 = 0; n2 < 6; ++n2) {
                this.gridPane.add(this.weekNumberCells.get(n2), 0, n2 + 2);
            }
        }
        for (n2 = 0; n2 < 6; ++n2) {
            for (int i2 = 0; i2 < this.daysPerWeek; ++i2) {
                this.gridPane.add(this.dayCells.get(n2 * this.daysPerWeek + i2), i2 + n3 - this.daysPerWeek, n2 + 2);
            }
        }
    }

    public void updateDayNameCells() {
        int n2 = WeekFields.of(this.getLocale()).getFirstDayOfWeek().getValue();
        LocalDate localDate = LocalDate.of(2009, 7, 12 + n2);
        for (int i2 = 0; i2 < this.daysPerWeek; ++i2) {
            String string = this.weekDayNameFormatter.withLocale(this.getLocale()).format(localDate.plus(i2, ChronoUnit.DAYS));
            this.dayNameCells.get(i2).setText(this.titleCaseWord(string));
        }
    }

    public void updateWeeknumberDateCells() {
        if (this.datePicker.fk()) {
            Locale locale = this.getLocale();
            LocalDate localDate = ((YearMonth)this.displayedYearMonth.get()).atDay(1);
            for (int i2 = 0; i2 < 6; ++i2) {
                LocalDate localDate2 = localDate.plus(i2, ChronoUnit.WEEKS);
                String string = this.weekNumberFormatter.withLocale(locale).withDecimalStyle(DecimalStyle.of(locale)).format(localDate2);
                this.weekNumberCells.get(i2).setText(string);
            }
        }
    }

    public void updateDayCells() {
        Locale locale = this.getLocale();
        Chronology chronology = this.getPrimaryChronology();
        int n2 = this.determineFirstOfMonthDayOfWeek();
        YearMonth yearMonth = (YearMonth)this.displayedYearMonth.get();
        YearMonth yearMonth2 = null;
        YearMonth yearMonth3 = null;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        for (int i2 = 0; i2 < 6 * this.daysPerWeek; ++i2) {
            Dg dg2 = this.dayCells.get(i2);
            dg2.getStyleClass().setAll((String[])new String[]{"cell", "date-cell", "day-cell"});
            dg2.setDisable(false);
            dg2.setStyle(null);
            dg2.setGraphic(null);
            dg2.setTooltip(null);
            try {
                LocalDate localDate;
                if (n3 == -1) {
                    n3 = yearMonth.lengthOfMonth();
                }
                YearMonth yearMonth4 = yearMonth;
                int n6 = i2 - n2 + 1;
                if (i2 < n2) {
                    if (yearMonth2 == null) {
                        yearMonth2 = yearMonth.minusMonths(1L);
                        n4 = yearMonth2.lengthOfMonth();
                    }
                    yearMonth4 = yearMonth2;
                    n6 = i2 + n4 - n2 + 1;
                    dg2.getStyleClass().add("previous-month");
                } else if (i2 >= n2 + n3) {
                    if (yearMonth3 == null) {
                        yearMonth3 = yearMonth.plusMonths(1L);
                        n5 = yearMonth3.lengthOfMonth();
                    }
                    yearMonth4 = yearMonth3;
                    n6 = i2 - n3 - n2 + 1;
                    dg2.getStyleClass().add("next-month");
                }
                this.dayCellDates[i2] = localDate = yearMonth4.atDay(n6);
                ChronoLocalDate chronoLocalDate = chronology.date(localDate);
                dg2.setDisable(false);
                if (this.isToday(localDate)) {
                    dg2.getStyleClass().add("today");
                }
                if (localDate.equals(this.datePicker.x())) {
                    dg2.getStyleClass().add("selected");
                }
                String string = this.dayCellFormatter.withLocale(locale).withChronology(chronology).withDecimalStyle(DecimalStyle.of(locale)).format(chronoLocalDate);
                dg2.setText(string);
                dg2.PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_(localDate, false);
                continue;
            }
            catch (DateTimeException dateTimeException) {
                dg2.setText(" ");
                dg2.setDisable(true);
            }
        }
    }

    private int getDaysPerWeek() {
        ValueRange valueRange = this.getPrimaryChronology().range(ChronoField.DAY_OF_WEEK);
        return (int)(valueRange.getMaximum() - valueRange.getMinimum() + 1L);
    }

    private int getMonthsPerYear() {
        ValueRange valueRange = this.getPrimaryChronology().range(ChronoField.MONTH_OF_YEAR);
        return (int)(valueRange.getMaximum() - valueRange.getMinimum() + 1L);
    }

    private void updateMonthLabelWidth() {
        if (this.monthLabel != null) {
            int n2 = this.getMonthsPerYear();
            double d2 = 0.0;
            for (int i2 = 0; i2 < n2; ++i2) {
                YearMonth yearMonth = ((YearMonth)this.displayedYearMonth.get()).withMonth(i2 + 1);
                String string = this.monthFormatterSO.withLocale(this.getLocale()).format(yearMonth);
                if (Character.isDigit(string.charAt(0))) {
                    string = this.monthFormatter.withLocale(this.getLocale()).format(yearMonth);
                }
                d2 = Math.max(d2, Utils.computeTextWidth(this.monthLabel.getFont(), string, 0.0));
            }
            this.monthLabel.setMinWidth(d2);
        }
    }

    protected void updateMonthYearPane() {
        LocalDate localDate;
        Chronology chronology;
        YearMonth yearMonth = (YearMonth)this.displayedYearMonth.get();
        String string = this.formatMonth(yearMonth);
        this.monthLabel.setText(string);
        string = this.formatYear(yearMonth);
        this.yearLabel.setText(string);
        double d2 = Utils.computeTextWidth(this.yearLabel.getFont(), string, 0.0);
        if (d2 > this.yearLabel.getMinWidth()) {
            this.yearLabel.setMinWidth(d2);
        }
        this.backMonthButton.setDisable(!this.isValidDate(chronology = this.datePicker.PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_(), localDate = yearMonth.atDay(1), -1, ChronoUnit.DAYS));
        this.forwardMonthButton.setDisable(!this.isValidDate(chronology, localDate, 1, ChronoUnit.MONTHS));
        this.backYearButton.setDisable(!this.isValidDate(chronology, localDate, -1, ChronoUnit.YEARS));
        this.forwardYearButton.setDisable(!this.isValidDate(chronology, localDate, 1, ChronoUnit.YEARS));
    }

    private String formatMonth(YearMonth yearMonth) {
        Chronology chronology = this.getPrimaryChronology();
        try {
            ChronoLocalDate chronoLocalDate = chronology.date(yearMonth.atDay(1));
            String string = this.monthFormatterSO.withLocale(this.getLocale()).withChronology(chronology).format(chronoLocalDate);
            if (Character.isDigit(string.charAt(0))) {
                string = this.monthFormatter.withLocale(this.getLocale()).withChronology(chronology).format(chronoLocalDate);
            }
            return this.titleCaseWord(string);
        }
        catch (DateTimeException dateTimeException) {
            return "";
        }
    }

    private String formatYear(YearMonth yearMonth) {
        Chronology chronology = this.getPrimaryChronology();
        try {
            DateTimeFormatter dateTimeFormatter = this.yearFormatter;
            ChronoLocalDate chronoLocalDate = chronology.date(yearMonth.atDay(1));
            int n2 = chronoLocalDate.getEra().getValue();
            int n3 = chronology.eras().size();
            if (n3 == 2 && n2 == 0 || n3 > 2) {
                dateTimeFormatter = this.yearWithEraFormatter;
            }
            String string = dateTimeFormatter.withLocale(this.getLocale()).withChronology(chronology).withDecimalStyle(DecimalStyle.of(this.getLocale())).format(chronoLocalDate);
            return string;
        }
        catch (DateTimeException dateTimeException) {
            return "";
        }
    }

    private String titleCaseWord(String object) {
        int n2;
        if (((String)object).length() > 0 && !Character.isTitleCase(n2 = ((String)object).codePointAt(0))) {
            object = new String(new int[]{Character.toTitleCase(n2)}, 0, 1) + ((String)object).substring(Character.offsetByCodePoints((CharSequence)object, 0, 1));
        }
        return object;
    }

    private int determineFirstOfMonthDayOfWeek() {
        int n2 = WeekFields.of(this.getLocale()).getFirstDayOfWeek().getValue();
        int n3 = ((YearMonth)this.displayedYearMonth.get()).atDay(1).getDayOfWeek().getValue() - n2;
        if (n3 < 0) {
            n3 += this.daysPerWeek;
        }
        return n3;
    }

    private boolean isToday(LocalDate localDate) {
        return localDate.equals(LocalDate.now());
    }

    protected LocalDate dayCellDate(Dg dg2) {
        assert (this.dayCellDates != null);
        return this.dayCellDates[this.dayCells.indexOf(dg2)];
    }

    public void goToDayCell(Dg dg2, int n2, ChronoUnit chronoUnit, boolean bl2) {
        this.goToDate(this.dayCellDate(dg2).plus(n2, chronoUnit), bl2);
    }

    protected void forward(int n2, ChronoUnit chronoUnit, boolean bl2) {
        YearMonth yearMonth = (YearMonth)this.displayedYearMonth.get();
        Dg dg2 = this.lastFocusedDayCell;
        if (dg2 == null || !this.dayCellDate(dg2).getMonth().equals(yearMonth.getMonth())) {
            dg2 = this.findDayCellForDate(yearMonth.atDay(1));
        }
        this.goToDayCell(dg2, n2, chronoUnit, bl2);
    }

    public void goToDate(LocalDate localDate, boolean bl2) {
        if (this.isValidDate(this.datePicker.PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_(), localDate)) {
            this.displayedYearMonth.set(YearMonth.from(localDate));
            if (bl2) {
                this.findDayCellForDate(localDate).requestFocus();
            }
        }
    }

    public void selectDayCell(Dg dg2) {
        this.datePicker.m(this.dayCellDate(dg2));
        this.datePicker.hide();
    }

    private Dg findDayCellForDate(LocalDate localDate) {
        for (int i2 = 0; i2 < this.dayCellDates.length; ++i2) {
            if (!localDate.equals(this.dayCellDates[i2])) continue;
            return this.dayCells.get(i2);
        }
        return this.dayCells.get(this.dayCells.size() / 2 + 1);
    }

    public void clearFocus() {
        LocalDate localDate = (LocalDate)this.datePicker.x();
        if (localDate == null) {
            localDate = LocalDate.now();
        }
        if (YearMonth.from(localDate).equals(this.displayedYearMonth.get())) {
            this.goToDate(localDate, true);
        } else {
            this.backMonthButton.requestFocus();
        }
        if (this.backMonthButton.getWidth() == 0.0) {
            this.backMonthButton.requestLayout();
            this.forwardMonthButton.requestLayout();
            this.backYearButton.requestLayout();
            this.forwardYearButton.requestLayout();
        }
    }

    protected void createDayCells() {
        wW<RY> wW2 = rY2 -> {
            if (rY2.PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_() != RW.a) {
                return;
            }
            Dg dg2 = (Dg)rY2.getSource();
            this.selectDayCell(dg2);
            this.lastFocusedDayCell = dg2;
        };
        for (int i2 = 0; i2 < 6; ++i2) {
            for (int i3 = 0; i3 < this.daysPerWeek; ++i3) {
                Dg dg2 = this.createDayCell();
                dg2.addEventHandler(RY.aF, wW2);
                this.dayCells.add(dg2);
            }
        }
        this.dayCellDates = new LocalDate[6 * this.daysPerWeek];
    }

    private Dg createDayCell() {
        Dg dg2 = null;
        if (this.datePicker.a() != null) {
            dg2 = this.datePicker.a().call(this.datePicker);
        }
        if (dg2 == null) {
            dg2 = new Dg();
        }
        return dg2;
    }

    protected Locale getLocale() {
        return Locale.getDefault(Locale.Category.FORMAT);
    }

    protected Chronology getPrimaryChronology() {
        return this.datePicker.PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_PROTECT_();
    }

    protected boolean isValidDate(Chronology chronology, LocalDate localDate, int n2, ChronoUnit chronoUnit) {
        if (localDate != null) {
            try {
                return this.isValidDate(chronology, localDate.plus(n2, chronoUnit));
            }
            catch (DateTimeException dateTimeException) {
                // empty catch block
            }
        }
        return false;
    }

    protected boolean isValidDate(Chronology chronology, LocalDate localDate) {
        try {
            if (localDate != null) {
                chronology.date(localDate);
            }
            return true;
        }
        catch (DateTimeException dateTimeException) {
            return false;
        }
    }

    private static /* synthetic */ void lambda$new$4(td td2, tb tb2, Ah ah2, Ah ah3) {
        if (ah2 != null) {
            ah2.h().removeListener(td2);
        }
        if (ah3 != null) {
            po.runLater(() -> ah3.h().addListener(td2));
        }
    }
}

