/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.reflect;

import com.sun.javafx.reflect.MethodUtil$1;
import com.sun.javafx.reflect.MethodUtil$Signature;
import com.sun.javafx.reflect.ReflectUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;

public final class MethodUtil
extends SecureClassLoader {
    private static final String MISC_PKG = "com.sun.javafx.reflect.";
    private static final String TRAMPOLINE = "com.sun.javafx.reflect.Trampoline";
    private static final Method bounce = MethodUtil.getTrampoline();

    private MethodUtil() {
    }

    public static Method getMethod(Class<?> clazz, String string, Class<?>[] classArray) {
        ReflectUtil.checkPackageAccess(clazz);
        return clazz.getMethod(string, classArray);
    }

    public static Method[] getMethods(Class<?> clazz) {
        ReflectUtil.checkPackageAccess(clazz);
        return clazz.getMethods();
    }

    static Method[] getPublicMethods(Class<?> clazz) {
        boolean bl2;
        if (System.getSecurityManager() == null) {
            return clazz.getMethods();
        }
        HashMap<MethodUtil$Signature, Method> hashMap = new HashMap<MethodUtil$Signature, Method>();
        while (clazz != null && !(bl2 = MethodUtil.getInternalPublicMethods(clazz, hashMap))) {
            MethodUtil.getInterfaceMethods(clazz, hashMap);
            clazz = clazz.getSuperclass();
        }
        return hashMap.values().toArray(new Method[hashMap.size()]);
    }

    private static void getInterfaceMethods(Class<?> clazz, Map<MethodUtil$Signature, Method> map) {
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            Class<?> clazz2 = classArray[i2];
            boolean bl2 = MethodUtil.getInternalPublicMethods(clazz2, map);
            if (bl2) continue;
            MethodUtil.getInterfaceMethods(clazz2, map);
        }
    }

    private static boolean getInternalPublicMethods(Class<?> clazz, Map<MethodUtil$Signature, Method> map) {
        Class<?> clazz2;
        int n2;
        Method[] methodArray = null;
        try {
            if (!Modifier.isPublic(clazz.getModifiers())) {
                return false;
            }
            if (!ReflectUtil.isPackageAccessible(clazz)) {
                return false;
            }
            methodArray = clazz.getMethods();
        }
        catch (SecurityException securityException) {
            return false;
        }
        boolean bl2 = true;
        for (n2 = 0; n2 < methodArray.length; ++n2) {
            clazz2 = methodArray[n2].getDeclaringClass();
            if (Modifier.isPublic(clazz2.getModifiers())) continue;
            bl2 = false;
            break;
        }
        if (bl2) {
            for (n2 = 0; n2 < methodArray.length; ++n2) {
                MethodUtil.addMethod(map, methodArray[n2]);
            }
        } else {
            for (n2 = 0; n2 < methodArray.length; ++n2) {
                clazz2 = methodArray[n2].getDeclaringClass();
                if (!clazz.equals(clazz2)) continue;
                MethodUtil.addMethod(map, methodArray[n2]);
            }
        }
        return bl2;
    }

    private static void addMethod(Map<MethodUtil$Signature, Method> map, Method method) {
        Method method2;
        MethodUtil$Signature methodUtil$Signature = new MethodUtil$Signature(method);
        if (!map.containsKey(methodUtil$Signature)) {
            map.put(methodUtil$Signature, method);
        } else if (!method.getDeclaringClass().isInterface() && (method2 = map.get(methodUtil$Signature)).getDeclaringClass().isInterface()) {
            map.put(methodUtil$Signature, method);
        }
    }

    public static Module getTrampolineModule() {
        return bounce.getDeclaringClass().getModule();
    }

    public static Object invoke(Method method, Object object, Object[] objectArray) {
        try {
            return bounce.invoke(null, method, object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof InvocationTargetException) {
                throw (InvocationTargetException)throwable;
            }
            if (throwable instanceof IllegalAccessException) {
                throw (IllegalAccessException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new Error("Unexpected invocation error", throwable);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error("Unexpected invocation error", illegalAccessException);
        }
    }

    private static Method getTrampoline() {
        try {
            return AccessController.doPrivileged(new MethodUtil$1());
        }
        catch (Exception exception) {
            throw new InternalError("bouncer cannot be found", exception);
        }
    }

    @Override
    protected synchronized Class<?> loadClass(String string, boolean bl2) {
        ReflectUtil.checkPackageAccess(string);
        Class<?> clazz = this.findLoadedClass(string);
        if (clazz == null) {
            try {
                clazz = this.findClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (clazz == null) {
                clazz = this.getParent().loadClass(string);
            }
        }
        if (bl2) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    @Override
    protected Class<?> findClass(String string) {
        block9: {
            Class<?> clazz;
            block10: {
                if (!string.startsWith(MISC_PKG)) {
                    throw new ClassNotFoundException(string);
                }
                String string2 = string.replace('.', '/').concat(".class");
                InputStream inputStream = MethodUtil.class.getModule().getResourceAsStream(string2);
                if (inputStream == null) break block9;
                InputStream inputStream2 = inputStream;
                try {
                    byte[] byArray = inputStream.readAllBytes();
                    clazz = this.defineClass(string, byArray);
                    if (inputStream2 == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream2 != null) {
                            try {
                                inputStream2.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        throw new ClassNotFoundException(string, iOException);
                    }
                }
                inputStream2.close();
            }
            return clazz;
        }
        throw new ClassNotFoundException(string);
    }

    private Class<?> defineClass(String string, byte[] byArray) {
        CodeSource codeSource = new CodeSource(null, (Certificate[])null);
        if (!string.equals(TRAMPOLINE)) {
            throw new IOException("MethodUtil: bad name " + string);
        }
        return this.defineClass(string, byArray, 0, byArray.length, codeSource);
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection permissionCollection = super.getPermissions(codeSource);
        permissionCollection.add(new AllPermission());
        return permissionCollection;
    }

    private static Class<?> getTrampolineClass() {
        try {
            return Class.forName(TRAMPOLINE, true, new MethodUtil());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

