/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.media;

import com.sun.glass.ui.Screen;
import com.sun.javafx.media.PrismMediaFrameHandler$PrismFrameBuffer;
import com.sun.javafx.media.PrismMediaFrameHandler$TextureMapEntry;
import com.sun.javafx.tk.RenderJob;
import com.sun.javafx.tk.Toolkit;
import com.sun.media.jfxmedia.control.VideoDataBuffer;
import com.sun.prism.Graphics;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.ResourceFactory;
import com.sun.prism.ResourceFactoryListener;
import com.sun.prism.Texture;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;

public class PrismMediaFrameHandler
implements ResourceFactoryListener {
    private final Map<Screen, PrismMediaFrameHandler$TextureMapEntry> textures = new WeakHashMap<Screen, PrismMediaFrameHandler$TextureMapEntry>(1);
    private static Map<Object, PrismMediaFrameHandler> handlers;
    private WeakReference<ResourceFactory> registeredWithFactory = null;
    private final RenderJob releaseRenderJob = new RenderJob(() -> this.releaseData());

    public static synchronized PrismMediaFrameHandler getHandler(Object object) {
        PrismMediaFrameHandler prismMediaFrameHandler;
        if (object == null) {
            throw new IllegalArgumentException("provider must be non-null");
        }
        if (handlers == null) {
            handlers = new WeakHashMap<Object, PrismMediaFrameHandler>(1);
        }
        if ((prismMediaFrameHandler = handlers.get(object)) == null) {
            prismMediaFrameHandler = new PrismMediaFrameHandler(object);
            handlers.put(object, prismMediaFrameHandler);
        }
        return prismMediaFrameHandler;
    }

    private PrismMediaFrameHandler(Object object) {
    }

    public Texture getTexture(Graphics graphics, VideoDataBuffer videoDataBuffer) {
        Screen screen = graphics.getAssociatedScreen();
        PrismMediaFrameHandler$TextureMapEntry prismMediaFrameHandler$TextureMapEntry = this.textures.get(screen);
        if (null == videoDataBuffer) {
            if (this.textures.containsKey(screen)) {
                this.textures.remove(screen);
            }
            return null;
        }
        if (null == prismMediaFrameHandler$TextureMapEntry) {
            prismMediaFrameHandler$TextureMapEntry = new PrismMediaFrameHandler$TextureMapEntry();
            this.textures.put(screen, prismMediaFrameHandler$TextureMapEntry);
        }
        if (prismMediaFrameHandler$TextureMapEntry.texture != null) {
            prismMediaFrameHandler$TextureMapEntry.texture.lock();
            if (prismMediaFrameHandler$TextureMapEntry.texture.isSurfaceLost()) {
                prismMediaFrameHandler$TextureMapEntry.texture = null;
            }
        }
        if (null == prismMediaFrameHandler$TextureMapEntry.texture || prismMediaFrameHandler$TextureMapEntry.lastFrameTime != videoDataBuffer.getTimestamp()) {
            this.updateTexture(graphics, videoDataBuffer, prismMediaFrameHandler$TextureMapEntry);
        }
        return prismMediaFrameHandler$TextureMapEntry.texture;
    }

    private void updateTexture(Graphics graphics, VideoDataBuffer videoDataBuffer, PrismMediaFrameHandler$TextureMapEntry prismMediaFrameHandler$TextureMapEntry) {
        Screen screen = graphics.getAssociatedScreen();
        if (prismMediaFrameHandler$TextureMapEntry.texture != null && (prismMediaFrameHandler$TextureMapEntry.encodedWidth != videoDataBuffer.getEncodedWidth() || prismMediaFrameHandler$TextureMapEntry.encodedHeight != videoDataBuffer.getEncodedHeight())) {
            prismMediaFrameHandler$TextureMapEntry.texture.dispose();
            prismMediaFrameHandler$TextureMapEntry.texture = null;
        }
        PrismMediaFrameHandler$PrismFrameBuffer prismMediaFrameHandler$PrismFrameBuffer = new PrismMediaFrameHandler$PrismFrameBuffer(this, videoDataBuffer);
        if (prismMediaFrameHandler$TextureMapEntry.texture == null) {
            ResourceFactory resourceFactory = GraphicsPipeline.getDefaultResourceFactory();
            if (this.registeredWithFactory == null || this.registeredWithFactory.get() != resourceFactory) {
                resourceFactory.addFactoryListener(this);
                this.registeredWithFactory = new WeakReference<ResourceFactory>(resourceFactory);
            }
            prismMediaFrameHandler$TextureMapEntry.texture = GraphicsPipeline.getPipeline().getResourceFactory(screen).createTexture(prismMediaFrameHandler$PrismFrameBuffer);
            prismMediaFrameHandler$TextureMapEntry.encodedWidth = videoDataBuffer.getEncodedWidth();
            prismMediaFrameHandler$TextureMapEntry.encodedHeight = videoDataBuffer.getEncodedHeight();
        }
        if (prismMediaFrameHandler$TextureMapEntry.texture != null) {
            prismMediaFrameHandler$TextureMapEntry.texture.update(prismMediaFrameHandler$PrismFrameBuffer, false);
        }
        prismMediaFrameHandler$TextureMapEntry.lastFrameTime = videoDataBuffer.getTimestamp();
    }

    private void releaseData() {
        for (PrismMediaFrameHandler$TextureMapEntry prismMediaFrameHandler$TextureMapEntry : this.textures.values()) {
            if (prismMediaFrameHandler$TextureMapEntry == null || prismMediaFrameHandler$TextureMapEntry.texture == null) continue;
            prismMediaFrameHandler$TextureMapEntry.texture.dispose();
        }
        this.textures.clear();
    }

    public void releaseTextures() {
        Toolkit toolkit = Toolkit.getToolkit();
        toolkit.addRenderJob(this.releaseRenderJob);
    }

    @Override
    public void factoryReset() {
        this.releaseData();
    }

    @Override
    public void factoryReleased() {
        this.releaseData();
    }
}

