/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.logging;

import com.sun.javafx.logging.Logger;
import com.sun.javafx.logging.PrintLogger$1;
import com.sun.javafx.logging.PrintLogger$Counter;
import com.sun.javafx.logging.PrintLogger$PulseData;
import com.sun.javafx.logging.PrintLogger$ThreadLocalData;
import com.sun.javafx.logging.PulseLogger;
import java.security.AccessController;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

class PrintLogger
extends Logger {
    private static long THRESHOLD = AccessController.doPrivileged(() -> Integer.getInteger("javafx.pulseLogger.threshold", 17)).intValue();
    private static final int EXIT_ON_PULSE = AccessController.doPrivileged(() -> Integer.getInteger("javafx.pulseLogger.exitOnPulse", 0));
    private int pulseCount = 1;
    private static final int INTER_PULSE_DATA = -1;
    private volatile int wrapCount = 0;
    private volatile PrintLogger$PulseData fxData;
    private volatile PrintLogger$PulseData renderData;
    private long lastPulseStartTime;
    private Thread fxThread;
    private final ThreadLocal<PrintLogger$ThreadLocalData> phaseData = new PrintLogger$1(this);
    private PrintLogger$PulseData head = new PrintLogger$PulseData(this);
    private PrintLogger$PulseData tail;
    private AtomicInteger active;
    private static final int AVAILABLE = 0;
    private static final int INCOMPLETE = 1;
    private static final int COMPLETE = 2;

    private PrintLogger() {
        this.head.next = this.tail = new PrintLogger$PulseData(this);
        this.active = new AtomicInteger(0);
    }

    public static Logger createInstance() {
        boolean bl2 = PulseLogger.isPulseLoggingRequested();
        if (bl2) {
            return new PrintLogger();
        }
        return null;
    }

    private PrintLogger$PulseData allocate(int n2) {
        PrintLogger$PulseData printLogger$PulseData;
        if (this.head != this.tail && this.head.state == 0) {
            printLogger$PulseData = this.head;
            this.head = this.head.next;
            printLogger$PulseData.next = null;
        } else {
            printLogger$PulseData = new PrintLogger$PulseData(this);
        }
        this.tail.next = printLogger$PulseData;
        this.tail = printLogger$PulseData;
        printLogger$PulseData.init(n2);
        return printLogger$PulseData;
    }

    @Override
    public void pulseStart() {
        if (this.fxThread == null) {
            this.fxThread = Thread.currentThread();
        }
        if (this.fxData != null) {
            this.fxData.state = 2;
            if (this.active.incrementAndGet() == 1) {
                this.fxData.printAndReset();
                this.active.decrementAndGet();
            }
        }
        this.fxData = this.allocate(this.pulseCount++);
        if (this.lastPulseStartTime > 0L) {
            this.fxData.interval = (this.fxData.startTime - this.lastPulseStartTime) / 1000000L;
        }
        this.lastPulseStartTime = this.fxData.startTime;
    }

    @Override
    public void renderStart() {
        this.newPhase(null);
        this.fxData.pushedRender = true;
        this.renderData = this.fxData;
        this.active.incrementAndGet();
    }

    @Override
    public void pulseEnd() {
        if (this.fxData != null && !this.fxData.pushedRender) {
            this.fxData.state = 2;
            if (this.active.incrementAndGet() == 1) {
                this.fxData.printAndReset();
                this.active.decrementAndGet();
            }
        }
        this.fxData = null;
    }

    @Override
    public void renderEnd() {
        this.newPhase(null);
        this.renderData.state = 2;
        while (true) {
            this.renderData.printAndReset();
            if (this.active.decrementAndGet() == 0) break;
            this.renderData = this.renderData.next;
        }
        this.renderData = null;
    }

    @Override
    public void addMessage(String string) {
        PrintLogger$PulseData printLogger$PulseData;
        if (this.fxThread == null || Thread.currentThread() == this.fxThread) {
            if (this.fxData == null) {
                this.fxData = this.allocate(-1);
            }
            printLogger$PulseData = this.fxData;
        } else {
            printLogger$PulseData = this.renderData;
        }
        if (printLogger$PulseData == null) {
            return;
        }
        printLogger$PulseData.message.append("T").append(Thread.currentThread().getId()).append(" : ").append(string).append("\n");
    }

    @Override
    public void incrementCounter(String string) {
        PrintLogger$PulseData printLogger$PulseData;
        if (this.fxThread == null || Thread.currentThread() == this.fxThread) {
            if (this.fxData == null) {
                this.fxData = this.allocate(-1);
            }
            printLogger$PulseData = this.fxData;
        } else {
            printLogger$PulseData = this.renderData;
        }
        if (printLogger$PulseData == null) {
            return;
        }
        Map<String, PrintLogger$Counter> map = printLogger$PulseData.counters;
        PrintLogger$Counter printLogger$Counter = map.get(string);
        if (printLogger$Counter == null) {
            printLogger$Counter = new PrintLogger$Counter();
            map.put(string, printLogger$Counter);
        }
        ++printLogger$Counter.value;
    }

    @Override
    public void newPhase(String string) {
        long l2 = System.nanoTime();
        PrintLogger$ThreadLocalData printLogger$ThreadLocalData = this.phaseData.get();
        if (printLogger$ThreadLocalData.phaseName != null) {
            PrintLogger$PulseData printLogger$PulseData;
            PrintLogger$PulseData printLogger$PulseData2 = printLogger$PulseData = Thread.currentThread() == this.fxThread ? this.fxData : this.renderData;
            if (printLogger$PulseData != null) {
                printLogger$PulseData.message.append("T").append(Thread.currentThread().getId()).append(" (").append((printLogger$ThreadLocalData.phaseStart - printLogger$PulseData.startTime) / 1000000L).append(" +").append((l2 - printLogger$ThreadLocalData.phaseStart) / 1000000L).append("ms): ").append(printLogger$ThreadLocalData.phaseName).append("\n");
            }
        }
        printLogger$ThreadLocalData.phaseName = string;
        printLogger$ThreadLocalData.phaseStart = l2;
    }
}

