/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.logging;

import com.sun.javafx.logging.PrintLogger;
import com.sun.javafx.logging.PrintLogger$Counter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class PrintLogger$PulseData {
    PrintLogger$PulseData next;
    volatile int state = 0;
    long startTime;
    long interval;
    int pulseCount;
    boolean pushedRender;
    StringBuffer message = new StringBuffer();
    Map<String, PrintLogger$Counter> counters = new ConcurrentHashMap<String, PrintLogger$Counter>();
    final /* synthetic */ PrintLogger this$0;

    private PrintLogger$PulseData(PrintLogger printLogger) {
        this.this$0 = printLogger;
    }

    void init(int n2) {
        this.state = 1;
        this.pulseCount = n2;
        this.startTime = System.nanoTime();
        this.interval = 0L;
        this.pushedRender = false;
    }

    void printAndReset() {
        long l2 = System.nanoTime();
        long l3 = (l2 - this.startTime) / 1000000L;
        if (this.state != 2) {
            System.err.println("\nWARNING: logging incomplete state");
        }
        if (l3 <= PrintLogger.THRESHOLD) {
            if (this.pulseCount != -1) {
                System.err.print((this.this$0.wrapCount++ % 10 == 0 ? "\n[" : "[") + this.pulseCount + " " + this.interval + "ms:" + l3 + "ms]");
            }
        } else {
            if (this.pulseCount == -1) {
                System.err.println("\n\nINTER PULSE LOG DATA");
            } else {
                System.err.print("\n\nPULSE: " + this.pulseCount + " [" + this.interval + "ms:" + l3 + "ms]");
                if (!this.pushedRender) {
                    System.err.print(" Required No Rendering");
                }
                System.err.println();
            }
            System.err.print(this.message);
            if (!this.counters.isEmpty()) {
                System.err.println("Counters:");
                ArrayList<Map.Entry<String, PrintLogger$Counter>> arrayList = new ArrayList<Map.Entry<String, PrintLogger$Counter>>(this.counters.entrySet());
                Collections.sort(arrayList, (entry, entry2) -> ((String)entry.getKey()).compareTo((String)entry2.getKey()));
                for (Map.Entry entry3 : arrayList) {
                    System.err.println("\t" + (String)entry3.getKey() + ": " + ((PrintLogger$Counter)entry3.getValue()).value);
                }
            }
            this.this$0.wrapCount = 0;
        }
        this.message.setLength(0);
        this.counters.clear();
        this.state = 0;
        if (PrintLogger.EXIT_ON_PULSE > 0 && this.pulseCount >= PrintLogger.EXIT_ON_PULSE) {
            System.err.println("Exiting after pulse #" + this.pulseCount);
            System.exit(0);
        }
    }
}

