/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.image.impl;

import com.sun.javafx.image.AlphaType;
import com.sun.javafx.image.BytePixelAccessor;
import com.sun.javafx.image.PixelUtils;
import java.nio.ByteBuffer;

class ByteGrayAlpha$Accessor
implements BytePixelAccessor {
    static final BytePixelAccessor nonpremul = new ByteGrayAlpha$Accessor(false);
    static final BytePixelAccessor premul = new ByteGrayAlpha$Accessor(true);
    private boolean isPremult;

    private ByteGrayAlpha$Accessor(boolean bl2) {
        this.isPremult = bl2;
    }

    @Override
    public AlphaType getAlphaType() {
        return this.isPremult ? AlphaType.PREMULTIPLIED : AlphaType.NONPREMULTIPLIED;
    }

    @Override
    public int getNumElements() {
        return 2;
    }

    @Override
    public int getArgb(byte[] byArray, int n2) {
        int n3 = byArray[n2] & 0xFF;
        int n4 = byArray[n2 + 1] & 0xFF;
        if (this.isPremult) {
            n3 = PixelUtils.PreToNonPre(n3, n4);
        }
        return n4 << 24 | n3 << 16 | n3 << 8 | n3;
    }

    @Override
    public int getArgbPre(byte[] byArray, int n2) {
        int n3 = byArray[n2] & 0xFF;
        int n4 = byArray[n2 + 1] & 0xFF;
        if (!this.isPremult) {
            n3 = PixelUtils.NonPretoPre(n3, n4);
        }
        return n4 << 24 | n3 << 16 | n3 << 8 | n3;
    }

    @Override
    public int getArgb(ByteBuffer byteBuffer, int n2) {
        int n3 = byteBuffer.get(n2) & 0xFF;
        int n4 = byteBuffer.get(n2 + 1) & 0xFF;
        if (this.isPremult) {
            n3 = PixelUtils.PreToNonPre(n3, n4);
        }
        return n4 << 24 | n3 << 16 | n3 << 8 | n3;
    }

    @Override
    public int getArgbPre(ByteBuffer byteBuffer, int n2) {
        int n3 = byteBuffer.get(n2) & 0xFF;
        int n4 = byteBuffer.get(n2 + 1) & 0xFF;
        if (!this.isPremult) {
            n3 = PixelUtils.NonPretoPre(n3, n4);
        }
        return n4 << 24 | n3 << 16 | n3 << 8 | n3;
    }

    @Override
    public void setArgb(byte[] byArray, int n2, int n3) {
        int n4 = PixelUtils.RgbToGray(n3);
        int n5 = n3 >>> 24;
        if (this.isPremult) {
            n4 = PixelUtils.NonPretoPre(n4, n5);
        }
        byArray[n2] = (byte)n4;
        byArray[n2 + 1] = (byte)n5;
    }

    @Override
    public void setArgbPre(byte[] byArray, int n2, int n3) {
        int n4 = PixelUtils.RgbToGray(n3);
        int n5 = n3 >>> 24;
        if (!this.isPremult) {
            n4 = PixelUtils.PreToNonPre(n4, n5);
        }
        byArray[n2] = (byte)n4;
        byArray[n2 + 1] = (byte)n5;
    }

    @Override
    public void setArgb(ByteBuffer byteBuffer, int n2, int n3) {
        int n4 = PixelUtils.RgbToGray(n3);
        int n5 = n3 >>> 24;
        if (this.isPremult) {
            n4 = PixelUtils.NonPretoPre(n4, n5);
        }
        byteBuffer.put(n2, (byte)n4);
        byteBuffer.put(n2 + 1, (byte)n5);
    }

    @Override
    public void setArgbPre(ByteBuffer byteBuffer, int n2, int n3) {
        int n4 = PixelUtils.RgbToGray(n3);
        int n5 = n3 >>> 24;
        if (!this.isPremult) {
            n4 = PixelUtils.PreToNonPre(n4, n5);
        }
        byteBuffer.put(n2, (byte)n4);
        byteBuffer.put(n2 + 1, (byte)n5);
    }
}

