/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.DirtyRegionContainer;
import com.sun.javafx.geom.DirtyRegionPool$PoolItem;
import java.util.Deque;
import java.util.LinkedList;

public final class DirtyRegionPool {
    private static final int POOL_SIZE_MIN = 4;
    private static final int EXPIRATION_TIME = 3000;
    private static final int COUNT_BETWEEN_EXPIRATION_CHECK = 90;
    private final int containerSize;
    private int clearCounter = 90;
    private final Deque<DirtyRegionContainer> fixed;
    private final Deque<DirtyRegionPool$PoolItem> unlocked;
    private final Deque<DirtyRegionPool$PoolItem> locked;

    public DirtyRegionPool(int n2) {
        this.containerSize = n2;
        this.fixed = new LinkedList<DirtyRegionContainer>();
        this.unlocked = new LinkedList<DirtyRegionPool$PoolItem>();
        this.locked = new LinkedList<DirtyRegionPool$PoolItem>();
        for (int i2 = 0; i2 < 4; ++i2) {
            this.fixed.add(new DirtyRegionContainer(n2));
        }
    }

    public DirtyRegionContainer checkOut() {
        this.clearExpired();
        if (!this.fixed.isEmpty()) {
            return this.fixed.pop();
        }
        if (!this.unlocked.isEmpty()) {
            DirtyRegionPool$PoolItem dirtyRegionPool$PoolItem = this.unlocked.pop();
            this.locked.push(dirtyRegionPool$PoolItem);
            return dirtyRegionPool$PoolItem.container;
        }
        DirtyRegionContainer dirtyRegionContainer = new DirtyRegionContainer(this.containerSize);
        this.locked.push(new DirtyRegionPool$PoolItem(this, null, -1L));
        return dirtyRegionContainer;
    }

    public void checkIn(DirtyRegionContainer dirtyRegionContainer) {
        dirtyRegionContainer.reset();
        if (this.locked.isEmpty()) {
            this.fixed.push(dirtyRegionContainer);
        } else {
            DirtyRegionPool$PoolItem dirtyRegionPool$PoolItem = this.locked.pop();
            dirtyRegionPool$PoolItem.container = dirtyRegionContainer;
            dirtyRegionPool$PoolItem.timeStamp = System.currentTimeMillis();
            this.unlocked.push(dirtyRegionPool$PoolItem);
        }
    }

    private void clearExpired() {
        if (this.unlocked.isEmpty()) {
            return;
        }
        if (this.clearCounter-- == 0) {
            this.clearCounter = 90;
            DirtyRegionPool$PoolItem dirtyRegionPool$PoolItem = this.unlocked.peekLast();
            long l2 = System.currentTimeMillis();
            while (dirtyRegionPool$PoolItem != null && dirtyRegionPool$PoolItem.timeStamp + 3000L < l2) {
                this.unlocked.removeLast();
                dirtyRegionPool$PoolItem = this.unlocked.peekLast();
            }
        }
    }
}

