/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.fxml.expression;

import com.sun.javafx.fxml.BeanAdapter;
import com.sun.javafx.fxml.expression.Expression;
import com.sun.javafx.fxml.expression.ExpressionValue$KeyPathMonitor;
import com.sun.javafx.fxml.expression.KeyPath;
import dev.protect.pv;
import dev.protect.sP;
import dev.protect.tc;
import java.util.ArrayList;
import java.util.List;

public class ExpressionValue
extends tc<Object> {
    private Object namespace;
    private Expression expression;
    private Class<?> type;
    private ArrayList<ExpressionValue$KeyPathMonitor> argumentMonitors;
    private int listenerCount = 0;

    public ExpressionValue(Object object, Expression expression, Class<?> clazz) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (expression == null) {
            throw new NullPointerException();
        }
        if (clazz == null) {
            throw new NullPointerException();
        }
        this.namespace = object;
        this.expression = expression;
        this.type = clazz;
        List<KeyPath> list = expression.getArguments();
        this.argumentMonitors = new ArrayList(list.size());
        for (KeyPath keyPath : list) {
            this.argumentMonitors.add(new ExpressionValue$KeyPathMonitor(this, keyPath.iterator()));
        }
    }

    @Override
    public Object getValue() {
        return BeanAdapter.coerce(this.expression.evaluate(this.namespace), this.type);
    }

    @Override
    public void addListener(pv pv2) {
        if (this.listenerCount == 0) {
            this.monitorArguments();
        }
        super.addListener(pv2);
        ++this.listenerCount;
    }

    @Override
    public void removeListener(pv pv2) {
        super.removeListener(pv2);
        --this.listenerCount;
        if (this.listenerCount == 0) {
            this.unmonitorArguments();
        }
    }

    @Override
    public void addListener(sP<? super Object> sP2) {
        if (this.listenerCount == 0) {
            this.monitorArguments();
        }
        super.addListener(sP2);
        ++this.listenerCount;
    }

    @Override
    public void removeListener(sP<? super Object> sP2) {
        super.removeListener(sP2);
        --this.listenerCount;
        if (this.listenerCount == 0) {
            this.unmonitorArguments();
        }
    }

    private void monitorArguments() {
        for (ExpressionValue$KeyPathMonitor expressionValue$KeyPathMonitor : this.argumentMonitors) {
            expressionValue$KeyPathMonitor.monitor(this.namespace);
        }
    }

    private void unmonitorArguments() {
        for (ExpressionValue$KeyPathMonitor expressionValue$KeyPathMonitor : this.argumentMonitors) {
            expressionValue$KeyPathMonitor.unmonitor();
        }
    }

    static /* synthetic */ void access$000(ExpressionValue expressionValue) {
        expressionValue.fireValueChangedEvent();
    }

    static /* synthetic */ void access$100(ExpressionValue expressionValue) {
        expressionValue.fireValueChangedEvent();
    }

    static /* synthetic */ void access$200(ExpressionValue expressionValue) {
        expressionValue.fireValueChangedEvent();
    }
}

