/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.fxml.expression;

import com.sun.javafx.fxml.BeanAdapter;
import com.sun.javafx.fxml.expression.BinaryExpression;
import com.sun.javafx.fxml.expression.Expression$Parser;
import com.sun.javafx.fxml.expression.KeyPath;
import com.sun.javafx.fxml.expression.LiteralExpression;
import com.sun.javafx.fxml.expression.UnaryExpression;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class Expression<T> {
    private static final String NULL_KEYWORD = "null";
    private static final String TRUE_KEYWORD = "true";
    private static final String FALSE_KEYWORD = "false";

    public abstract T evaluate(Object var1);

    public abstract void update(Object var1, T var2);

    public abstract boolean isDefined(Object var1);

    public abstract boolean isLValue();

    public List<KeyPath> getArguments() {
        ArrayList<KeyPath> arrayList = new ArrayList<KeyPath>();
        this.getArguments(arrayList);
        return arrayList;
    }

    protected abstract void getArguments(List<KeyPath> var1);

    public static <T> T get(Object object, KeyPath keyPath) {
        if (keyPath == null) {
            throw new NullPointerException();
        }
        return Expression.get(object, keyPath.iterator());
    }

    private static <T> T get(Object object, Iterator<String> iterator) {
        if (iterator == null) {
            throw new NullPointerException();
        }
        Object object2 = iterator.hasNext() ? Expression.get(Expression.get(object, iterator.next()), iterator) : object;
        return (T)object2;
    }

    public static <T> T get(Object object, String string) {
        T t2;
        if (string == null) {
            throw new NullPointerException();
        }
        if (object instanceof List) {
            List list = (List)object;
            t2 = (T)list.get(Integer.parseInt(string));
        } else if (object != null) {
            Map map = object instanceof Map ? (Map)object : new BeanAdapter(object);
            t2 = (T)map.get(string);
        } else {
            t2 = null;
        }
        return t2;
    }

    public static void set(Object object, KeyPath keyPath, Object object2) {
        if (keyPath == null) {
            throw new NullPointerException();
        }
        Expression.set(object, keyPath.iterator(), object2);
    }

    private static void set(Object object, Iterator<String> iterator, Object object2) {
        if (iterator == null) {
            throw new NullPointerException();
        }
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException();
        }
        String string = iterator.next();
        if (iterator.hasNext()) {
            Expression.set(Expression.get(object, string), iterator, object2);
        } else {
            Expression.set(object, string, object2);
        }
    }

    public static void set(Object object, String string, Object object2) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (object instanceof List) {
            List list = (List)object;
            list.set(Integer.parseInt(string), object2);
        } else if (object != null) {
            Map map = object instanceof Map ? (Map)object : new BeanAdapter(object);
            map.put(string, object2);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public static boolean isDefined(Object object, KeyPath keyPath) {
        if (keyPath == null) {
            throw new NullPointerException();
        }
        return Expression.isDefined(object, keyPath.iterator());
    }

    private static boolean isDefined(Object object, Iterator<String> iterator) {
        if (iterator == null) {
            throw new NullPointerException();
        }
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException();
        }
        String string = iterator.next();
        boolean bl2 = iterator.hasNext() ? Expression.isDefined(Expression.get(object, string), iterator) : Expression.isDefined(object, string);
        return bl2;
    }

    public static boolean isDefined(Object object, String string) {
        boolean bl2;
        if (string == null) {
            throw new NullPointerException();
        }
        if (object instanceof List) {
            List list = (List)object;
            bl2 = Integer.parseInt(string) < list.size();
        } else if (object != null) {
            Map map = object instanceof Map ? (Map)object : new BeanAdapter(object);
            bl2 = map.containsKey(string);
        } else {
            bl2 = false;
        }
        return bl2;
    }

    public static BinaryExpression add(Expression expression, Expression expression2) {
        return new BinaryExpression<Object, Object>(expression, expression2, (object, object2) -> {
            Object object3;
            if (object instanceof String || object2 instanceof String) {
                object3 = object.toString().concat(object2.toString());
            } else {
                Number number = (Number)object;
                Number number2 = (Number)object2;
                if (number instanceof Double || number2 instanceof Double) {
                    object3 = number.doubleValue() + number2.doubleValue();
                } else if (number instanceof Float || number2 instanceof Float) {
                    object3 = Float.valueOf(number.floatValue() + number2.floatValue());
                } else if (number instanceof Long || number2 instanceof Long) {
                    object3 = number.longValue() + number2.longValue();
                } else if (number instanceof Integer || number2 instanceof Integer) {
                    object3 = number.intValue() + number2.intValue();
                } else if (number instanceof Short || number2 instanceof Short) {
                    object3 = number.shortValue() + number2.shortValue();
                } else if (number instanceof Byte || number2 instanceof Byte) {
                    object3 = number.byteValue() + number2.byteValue();
                } else {
                    throw new UnsupportedOperationException();
                }
            }
            return object3;
        });
    }

    public static BinaryExpression add(Expression expression, Object object) {
        return Expression.add(expression, new LiteralExpression<Object>(object));
    }

    public static BinaryExpression add(Object object, Expression expression) {
        return Expression.add(new LiteralExpression<Object>(object), expression);
    }

    public static BinaryExpression add(Object object, Object object2) {
        return Expression.add(new LiteralExpression<Object>(object), new LiteralExpression<Object>(object2));
    }

    public static BinaryExpression subtract(Expression expression, Expression expression2) {
        return new BinaryExpression<Number, Number>(expression, expression2, (number, number2) -> {
            Number number3;
            if (number instanceof Double || number2 instanceof Double) {
                number3 = number.doubleValue() - number2.doubleValue();
            } else if (number instanceof Float || number2 instanceof Float) {
                number3 = Float.valueOf(number.floatValue() - number2.floatValue());
            } else if (number instanceof Long || number2 instanceof Long) {
                number3 = number.longValue() - number2.longValue();
            } else if (number instanceof Integer || number2 instanceof Integer) {
                number3 = number.intValue() - number2.intValue();
            } else if (number instanceof Short || number2 instanceof Short) {
                number3 = number.shortValue() - number2.shortValue();
            } else if (number instanceof Byte || number2 instanceof Byte) {
                number3 = number.byteValue() - number2.byteValue();
            } else {
                throw new UnsupportedOperationException();
            }
            return number3;
        });
    }

    public static BinaryExpression subtract(Expression expression, Number number) {
        return Expression.subtract(expression, new LiteralExpression<Number>(number));
    }

    public static BinaryExpression subtract(Number number, Expression expression) {
        return Expression.subtract(new LiteralExpression<Number>(number), expression);
    }

    public static BinaryExpression subtract(Number number, Number number2) {
        return Expression.subtract(new LiteralExpression<Number>(number), new LiteralExpression<Number>(number2));
    }

    public static BinaryExpression multiply(Expression expression, Expression expression2) {
        return new BinaryExpression<Number, Number>(expression, expression2, (number, number2) -> {
            Number number3;
            if (number instanceof Double || number2 instanceof Double) {
                number3 = number.doubleValue() * number2.doubleValue();
            } else if (number instanceof Float || number2 instanceof Float) {
                number3 = Float.valueOf(number.floatValue() * number2.floatValue());
            } else if (number instanceof Long || number2 instanceof Long) {
                number3 = number.longValue() * number2.longValue();
            } else if (number instanceof Integer || number2 instanceof Integer) {
                number3 = number.intValue() * number2.intValue();
            } else if (number instanceof Short || number2 instanceof Short) {
                number3 = number.shortValue() * number2.shortValue();
            } else if (number instanceof Byte || number2 instanceof Byte) {
                number3 = number.byteValue() * number2.byteValue();
            } else {
                throw new UnsupportedOperationException();
            }
            return number3;
        });
    }

    public static BinaryExpression multiply(Expression expression, Number number) {
        return Expression.multiply(expression, new LiteralExpression<Number>(number));
    }

    public static BinaryExpression multiply(Number number, Expression expression) {
        return Expression.multiply(new LiteralExpression<Number>(number), expression);
    }

    public static BinaryExpression multiply(Number number, Number number2) {
        return Expression.multiply(new LiteralExpression<Number>(number), new LiteralExpression<Number>(number2));
    }

    public static BinaryExpression divide(Expression expression, Expression expression2) {
        return new BinaryExpression<Number, Number>(expression, expression2, (number, number2) -> {
            Number number3;
            if (number instanceof Double || number2 instanceof Double) {
                number3 = number.doubleValue() / number2.doubleValue();
            } else if (number instanceof Float || number2 instanceof Float) {
                number3 = Float.valueOf(number.floatValue() / number2.floatValue());
            } else if (number instanceof Long || number2 instanceof Long) {
                number3 = number.longValue() / number2.longValue();
            } else if (number instanceof Integer || number2 instanceof Integer) {
                number3 = number.intValue() / number2.intValue();
            } else if (number instanceof Short || number2 instanceof Short) {
                number3 = number.shortValue() / number2.shortValue();
            } else if (number instanceof Byte || number2 instanceof Byte) {
                number3 = number.byteValue() / number2.byteValue();
            } else {
                throw new UnsupportedOperationException();
            }
            return number3;
        });
    }

    public static BinaryExpression divide(Expression expression, Number number) {
        return Expression.divide(expression, new LiteralExpression<Number>(number));
    }

    public static BinaryExpression divide(Number number, Expression<Number> expression) {
        return Expression.divide(new LiteralExpression<Number>(number), expression);
    }

    public static BinaryExpression divide(Number number, Number number2) {
        return Expression.divide(new LiteralExpression<Number>(number), new LiteralExpression<Number>(number2));
    }

    public static BinaryExpression modulo(Expression expression, Expression expression2) {
        return new BinaryExpression<Number, Number>(expression, expression2, (number, number2) -> {
            Number number3;
            if (number instanceof Double || number2 instanceof Double) {
                number3 = number.doubleValue() % number2.doubleValue();
            } else if (number instanceof Float || number2 instanceof Float) {
                number3 = Float.valueOf(number.floatValue() % number2.floatValue());
            } else if (number instanceof Long || number2 instanceof Long) {
                number3 = number.longValue() % number2.longValue();
            } else if (number instanceof Integer || number2 instanceof Integer) {
                number3 = number.intValue() % number2.intValue();
            } else if (number instanceof Short || number2 instanceof Short) {
                number3 = number.shortValue() % number2.shortValue();
            } else if (number instanceof Byte || number2 instanceof Byte) {
                number3 = number.byteValue() % number2.byteValue();
            } else {
                throw new UnsupportedOperationException();
            }
            return number3;
        });
    }

    public static BinaryExpression modulo(Expression<Number> expression, Number number) {
        return Expression.modulo(expression, new LiteralExpression<Number>(number));
    }

    public static BinaryExpression modulo(Number number, Expression<Number> expression) {
        return Expression.modulo(new LiteralExpression<Number>(number), expression);
    }

    public static BinaryExpression modulo(Number number, Number number2) {
        return Expression.modulo(new LiteralExpression<Number>(number), new LiteralExpression<Number>(number2));
    }

    public static BinaryExpression equalTo(Expression expression, Expression expression2) {
        return new BinaryExpression<Comparable, Boolean>(expression, expression2, (comparable, comparable2) -> comparable.compareTo(comparable2) == 0);
    }

    public static BinaryExpression equalTo(Expression expression, Object object) {
        return Expression.equalTo(expression, new LiteralExpression<Object>(object));
    }

    public static BinaryExpression equalTo(Object object, Expression expression) {
        return Expression.equalTo(new LiteralExpression<Object>(object), expression);
    }

    public static BinaryExpression equalTo(Object object, Object object2) {
        return Expression.equalTo(new LiteralExpression<Object>(object), new LiteralExpression<Object>(object2));
    }

    public static BinaryExpression notEqualTo(Expression expression, Expression expression2) {
        return new BinaryExpression<Comparable, Boolean>(expression, expression2, (comparable, comparable2) -> comparable.compareTo(comparable2) != 0);
    }

    public static BinaryExpression notEqualTo(Expression expression, Object object) {
        return Expression.notEqualTo(expression, new LiteralExpression<Object>(object));
    }

    public static BinaryExpression notEqualTo(Object object, Expression expression) {
        return Expression.notEqualTo(new LiteralExpression<Object>(object), expression);
    }

    public static BinaryExpression notEqualTo(Object object, Object object2) {
        return Expression.notEqualTo(new LiteralExpression<Object>(object), new LiteralExpression<Object>(object2));
    }

    public static BinaryExpression greaterThan(Expression expression, Expression expression2) {
        return new BinaryExpression<Comparable, Boolean>(expression, expression2, (comparable, comparable2) -> comparable.compareTo(comparable2) > 0);
    }

    public static BinaryExpression greaterThan(Expression expression, Object object) {
        return Expression.greaterThan(expression, new LiteralExpression<Object>(object));
    }

    public static BinaryExpression greaterThan(Object object, Expression expression) {
        return Expression.greaterThan(new LiteralExpression<Object>(object), expression);
    }

    public static BinaryExpression greaterThan(Object object, Object object2) {
        return Expression.greaterThan(new LiteralExpression<Object>(object), new LiteralExpression<Object>(object2));
    }

    public static BinaryExpression greaterThanOrEqualTo(Expression expression, Expression expression2) {
        return new BinaryExpression<Comparable, Boolean>(expression, expression2, (comparable, comparable2) -> comparable.compareTo(comparable2) >= 0);
    }

    public static BinaryExpression greaterThanOrEqualTo(Expression expression, Object object) {
        return Expression.greaterThanOrEqualTo(expression, new LiteralExpression<Object>(object));
    }

    public static BinaryExpression greaterThanOrEqualTo(Object object, Expression expression) {
        return Expression.greaterThanOrEqualTo(new LiteralExpression<Object>(object), expression);
    }

    public static BinaryExpression greaterThanOrEqualTo(Object object, Object object2) {
        return Expression.greaterThanOrEqualTo(new LiteralExpression<Object>(object), new LiteralExpression<Object>(object2));
    }

    public static BinaryExpression lessThan(Expression expression, Expression expression2) {
        return new BinaryExpression<Comparable, Boolean>(expression, expression2, (comparable, comparable2) -> comparable.compareTo(comparable2) < 0);
    }

    public static BinaryExpression lessThan(Expression expression, Object object) {
        return Expression.lessThan(expression, new LiteralExpression<Object>(object));
    }

    public static BinaryExpression lessThan(Object object, Expression expression) {
        return Expression.lessThan(new LiteralExpression<Object>(object), expression);
    }

    public static BinaryExpression lessThan(Object object, Object object2) {
        return Expression.lessThan(new LiteralExpression<Object>(object), new LiteralExpression<Object>(object2));
    }

    public static BinaryExpression lessThanOrEqualTo(Expression expression, Expression expression2) {
        return new BinaryExpression<Comparable, Boolean>(expression, expression2, (comparable, comparable2) -> comparable.compareTo(comparable2) <= 0);
    }

    public static BinaryExpression lessThanOrEqualTo(Expression expression, Object object) {
        return Expression.lessThanOrEqualTo(expression, new LiteralExpression<Object>(object));
    }

    public static BinaryExpression lessThanOrEqualTo(Object object, Expression expression) {
        return Expression.lessThanOrEqualTo(new LiteralExpression<Object>(object), expression);
    }

    public static BinaryExpression lessThanOrEqualTo(Object object, Object object2) {
        return Expression.lessThanOrEqualTo(new LiteralExpression<Object>(object), new LiteralExpression<Object>(object2));
    }

    public static BinaryExpression and(Expression expression, Expression expression2) {
        return new BinaryExpression<Boolean, Boolean>(expression, expression2, (bl2, bl3) -> bl2 != false && bl3 != false);
    }

    public static BinaryExpression and(Expression expression, Boolean bl2) {
        return Expression.and(expression, new LiteralExpression<Boolean>(bl2));
    }

    public static BinaryExpression and(Boolean bl2, Expression expression) {
        return Expression.and(new LiteralExpression<Boolean>(bl2), expression);
    }

    public static BinaryExpression and(Boolean bl2, Boolean bl3) {
        return Expression.and(new LiteralExpression<Boolean>(bl2), new LiteralExpression<Boolean>(bl3));
    }

    public static BinaryExpression or(Expression expression, Expression expression2) {
        return new BinaryExpression<Boolean, Boolean>(expression, expression2, (bl2, bl3) -> bl2 != false || bl3 != false);
    }

    public static BinaryExpression or(Expression expression, Boolean bl2) {
        return Expression.or(expression, new LiteralExpression<Boolean>(bl2));
    }

    public static BinaryExpression or(Boolean bl2, Expression expression) {
        return Expression.or(new LiteralExpression<Boolean>(bl2), expression);
    }

    public static BinaryExpression or(Boolean bl2, Boolean bl3) {
        return Expression.or(new LiteralExpression<Boolean>(bl2), new LiteralExpression<Boolean>(bl3));
    }

    public static UnaryExpression negate(Expression expression) {
        return new UnaryExpression<Number, Number>(expression, number -> {
            Class<?> clazz = number.getClass();
            if (clazz == Byte.class) {
                return (int)(-number.byteValue());
            }
            if (clazz == Short.class) {
                return (int)(-number.shortValue());
            }
            if (clazz == Integer.class) {
                return -number.intValue();
            }
            if (clazz == Long.class) {
                return -number.longValue();
            }
            if (clazz == Float.class) {
                return Float.valueOf(-number.floatValue());
            }
            if (clazz == Double.class) {
                return -number.doubleValue();
            }
            throw new UnsupportedOperationException();
        });
    }

    public static UnaryExpression negate(Number number) {
        return Expression.negate(new LiteralExpression<Number>(number));
    }

    public static UnaryExpression not(Expression expression) {
        return new UnaryExpression<Boolean, Boolean>(expression, bl2 -> bl2 == false);
    }

    public static UnaryExpression not(Boolean bl2) {
        return Expression.not(new LiteralExpression<Boolean>(bl2));
    }

    public static Expression valueOf(String string) {
        Expression expression;
        if (string == null) {
            throw new NullPointerException();
        }
        Expression$Parser expression$Parser = new Expression$Parser();
        try {
            expression = expression$Parser.parse(new StringReader(string));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return expression;
    }
}

