/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.fxml.expression;

import com.sun.javafx.fxml.expression.Expression;
import com.sun.javafx.fxml.expression.Expression$Parser$Token;
import com.sun.javafx.fxml.expression.Expression$Parser$TokenType;
import com.sun.javafx.fxml.expression.KeyPath;
import com.sun.javafx.fxml.expression.LiteralExpression;
import com.sun.javafx.fxml.expression.Operator;
import com.sun.javafx.fxml.expression.VariableExpression;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.LinkedList;

class Expression$Parser {
    private int c = -1;
    private char[] pushbackBuffer = new char[6];
    private static final int PUSHBACK_BUFFER_SIZE = 6;

    private Expression$Parser() {
    }

    public Expression parse(Reader reader) {
        LinkedList<Expression$Parser$Token> linkedList = this.tokenize(new PushbackReader(reader, 6));
        LinkedList<LiteralExpression<Object>> linkedList2 = new LinkedList<LiteralExpression<Object>>();
        for (Expression$Parser$Token expression$Parser$Token : linkedList) {
            Expression expression;
            block0 : switch (expression$Parser$Token.type) {
                case LITERAL: {
                    expression = new LiteralExpression<Object>(expression$Parser$Token.value);
                    break;
                }
                case VARIABLE: {
                    expression = new VariableExpression((KeyPath)expression$Parser$Token.value);
                    break;
                }
                case FUNCTION: {
                    expression = null;
                    break;
                }
                case UNARY_OPERATOR: {
                    Operator operator = (Operator)((Object)expression$Parser$Token.value);
                    Expression expression2 = (Expression)linkedList2.pop();
                    switch (operator) {
                        case NEGATE: {
                            expression = Expression.negate(expression2);
                            break block0;
                        }
                        case NOT: {
                            expression = Expression.not(expression2);
                            break block0;
                        }
                    }
                    throw new UnsupportedOperationException();
                }
                case BINARY_OPERATOR: {
                    Operator operator = (Operator)((Object)expression$Parser$Token.value);
                    Expression expression2 = (Expression)linkedList2.pop();
                    Expression expression3 = (Expression)linkedList2.pop();
                    switch (operator) {
                        case ADD: {
                            expression = Expression.add(expression3, expression2);
                            break block0;
                        }
                        case SUBTRACT: {
                            expression = Expression.subtract(expression3, expression2);
                            break block0;
                        }
                        case MULTIPLY: {
                            expression = Expression.multiply(expression3, expression2);
                            break block0;
                        }
                        case DIVIDE: {
                            expression = Expression.divide(expression3, expression2);
                            break block0;
                        }
                        case MODULO: {
                            expression = Expression.modulo(expression3, expression2);
                            break block0;
                        }
                        case GREATER_THAN: {
                            expression = Expression.greaterThan(expression3, expression2);
                            break block0;
                        }
                        case GREATER_THAN_OR_EQUAL_TO: {
                            expression = Expression.greaterThanOrEqualTo(expression3, expression2);
                            break block0;
                        }
                        case LESS_THAN: {
                            expression = Expression.lessThan(expression3, expression2);
                            break block0;
                        }
                        case LESS_THAN_OR_EQUAL_TO: {
                            expression = Expression.lessThanOrEqualTo(expression3, expression2);
                            break block0;
                        }
                        case EQUAL_TO: {
                            expression = Expression.equalTo(expression3, expression2);
                            break block0;
                        }
                        case NOT_EQUAL_TO: {
                            expression = Expression.notEqualTo(expression3, expression2);
                            break block0;
                        }
                        case AND: {
                            expression = Expression.and(expression3, expression2);
                            break block0;
                        }
                        case OR: {
                            expression = Expression.or(expression3, expression2);
                            break block0;
                        }
                    }
                    throw new UnsupportedOperationException();
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            linkedList2.push((LiteralExpression<Object>)expression);
        }
        if (linkedList2.size() != 1) {
            throw new IllegalArgumentException("Invalid expression.");
        }
        return (Expression)linkedList2.peek();
    }

    private LinkedList<Expression$Parser$Token> tokenize(PushbackReader pushbackReader) {
        LinkedList<Expression$Parser$Token> linkedList = new LinkedList<Expression$Parser$Token>();
        LinkedList<Expression$Parser$Token> linkedList2 = new LinkedList<Expression$Parser$Token>();
        this.c = pushbackReader.read();
        boolean bl2 = true;
        while (this.c != -1) {
            Expression$Parser$Token expression$Parser$Token;
            block63: {
                boolean bl3;
                block70: {
                    block69: {
                        block68: {
                            block67: {
                                block66: {
                                    block65: {
                                        Comparable<Long> comparable;
                                        int n2;
                                        block64: {
                                            block62: {
                                                while (this.c != -1 && Character.isWhitespace(this.c)) {
                                                    this.c = pushbackReader.read();
                                                }
                                                if (this.c == -1) continue;
                                                if (this.c != 110) break block62;
                                                if (this.readKeyword(pushbackReader, "null")) {
                                                    expression$Parser$Token = new Expression$Parser$Token(Expression$Parser$TokenType.LITERAL, null);
                                                } else {
                                                    expression$Parser$Token = new Expression$Parser$Token(Expression$Parser$TokenType.VARIABLE, KeyPath.parse(pushbackReader));
                                                    this.c = pushbackReader.read();
                                                }
                                                break block63;
                                            }
                                            if (this.c != 34 && this.c != 39) break block64;
                                            StringBuilder stringBuilder = new StringBuilder();
                                            n2 = this.c;
                                            this.c = pushbackReader.read();
                                            while (this.c != -1 && this.c != n2) {
                                                if (!Character.isISOControl(this.c)) {
                                                    if (this.c == 92) {
                                                        this.c = pushbackReader.read();
                                                        if (this.c == 98) {
                                                            this.c = 8;
                                                        } else if (this.c == 102) {
                                                            this.c = 12;
                                                        } else if (this.c == 110) {
                                                            this.c = 10;
                                                        } else if (this.c == 114) {
                                                            this.c = 13;
                                                        } else if (this.c == 116) {
                                                            this.c = 9;
                                                        } else if (this.c == 117) {
                                                            comparable = new StringBuilder();
                                                            while (((StringBuilder)comparable).length() < 4) {
                                                                this.c = pushbackReader.read();
                                                                ((StringBuilder)comparable).append((char)this.c);
                                                            }
                                                            String string = ((StringBuilder)comparable).toString();
                                                            this.c = (char)Integer.parseInt(string, 16);
                                                        } else if (this.c != 92 && this.c != 47 && this.c != 34 && this.c != 39 && this.c != n2) {
                                                            throw new IllegalArgumentException("Unsupported escape sequence.");
                                                        }
                                                    }
                                                    stringBuilder.append((char)this.c);
                                                }
                                                this.c = pushbackReader.read();
                                            }
                                            if (this.c != n2) {
                                                throw new IllegalArgumentException("Unterminated string.");
                                            }
                                            this.c = pushbackReader.read();
                                            expression$Parser$Token = new Expression$Parser$Token(Expression$Parser$TokenType.LITERAL, stringBuilder.toString());
                                            break block63;
                                        }
                                        if (!Character.isDigit(this.c)) break block65;
                                        StringBuilder stringBuilder = new StringBuilder();
                                        n2 = 1;
                                        while (this.c != -1 && (Character.isDigit(this.c) || this.c == 46 || this.c == 101 || this.c == 69)) {
                                            stringBuilder.append((char)this.c);
                                            n2 &= this.c != 46 ? 1 : 0;
                                            this.c = pushbackReader.read();
                                        }
                                        comparable = n2 != 0 ? (Number)Long.parseLong(stringBuilder.toString()) : (Number)Double.parseDouble(stringBuilder.toString());
                                        expression$Parser$Token = new Expression$Parser$Token(Expression$Parser$TokenType.LITERAL, comparable);
                                        break block63;
                                    }
                                    if (this.c != 116) break block66;
                                    if (this.readKeyword(pushbackReader, "true")) {
                                        expression$Parser$Token = new Expression$Parser$Token(Expression$Parser$TokenType.LITERAL, true);
                                    } else {
                                        expression$Parser$Token = new Expression$Parser$Token(Expression$Parser$TokenType.VARIABLE, KeyPath.parse(pushbackReader));
                                        this.c = pushbackReader.read();
                                    }
                                    break block63;
                                }
                                if (this.c != 102) break block67;
                                if (this.readKeyword(pushbackReader, "false")) {
                                    expression$Parser$Token = new Expression$Parser$Token(Expression$Parser$TokenType.LITERAL, false);
                                } else {
                                    expression$Parser$Token = new Expression$Parser$Token(Expression$Parser$TokenType.VARIABLE, KeyPath.parse(pushbackReader));
                                    this.c = pushbackReader.read();
                                }
                                break block63;
                            }
                            if (!Character.isJavaIdentifierStart(this.c)) break block68;
                            pushbackReader.unread(this.c);
                            expression$Parser$Token = new Expression$Parser$Token(Expression$Parser$TokenType.VARIABLE, KeyPath.parse(pushbackReader));
                            this.c = pushbackReader.read();
                            break block63;
                        }
                        bl3 = true;
                        if (!bl2) break block69;
                        switch (this.c) {
                            case 45: {
                                expression$Parser$Token = new Expression$Parser$Token(Expression$Parser$TokenType.UNARY_OPERATOR, (Object)Operator.NEGATE);
                                break block70;
                            }
                            case 33: {
                                expression$Parser$Token = new Expression$Parser$Token(Expression$Parser$TokenType.UNARY_OPERATOR, (Object)Operator.NOT);
                                break block70;
                            }
                            case 40: {
                                expression$Parser$Token = new Expression$Parser$Token(Expression$Parser$TokenType.BEGIN_GROUP, null);
                                break block70;
                            }
                            default: {
                                throw new IllegalArgumentException("Unexpected character in expression.");
                            }
                        }
                    }
                    switch (this.c) {
                        case 43: {
                            expression$Parser$Token = new Expression$Parser$Token(Expression$Parser$TokenType.BINARY_OPERATOR, (Object)Operator.ADD);
                            break;
                        }
                        case 45: {
                            expression$Parser$Token = new Expression$Parser$Token(Expression$Parser$TokenType.BINARY_OPERATOR, (Object)Operator.SUBTRACT);
                            break;
                        }
                        case 42: {
                            expression$Parser$Token = new Expression$Parser$Token(Expression$Parser$TokenType.BINARY_OPERATOR, (Object)Operator.MULTIPLY);
                            break;
                        }
                        case 47: {
                            expression$Parser$Token = new Expression$Parser$Token(Expression$Parser$TokenType.BINARY_OPERATOR, (Object)Operator.DIVIDE);
                            break;
                        }
                        case 37: {
                            expression$Parser$Token = new Expression$Parser$Token(Expression$Parser$TokenType.BINARY_OPERATOR, (Object)Operator.MODULO);
                            break;
                        }
                        case 61: {
                            this.c = pushbackReader.read();
                            if (this.c == 61) {
                                expression$Parser$Token = new Expression$Parser$Token(Expression$Parser$TokenType.BINARY_OPERATOR, (Object)Operator.EQUAL_TO);
                                break;
                            }
                            throw new IllegalArgumentException("Unexpected character in expression.");
                        }
                        case 33: {
                            this.c = pushbackReader.read();
                            if (this.c == 61) {
                                expression$Parser$Token = new Expression$Parser$Token(Expression$Parser$TokenType.BINARY_OPERATOR, (Object)Operator.NOT_EQUAL_TO);
                                break;
                            }
                            throw new IllegalArgumentException("Unexpected character in expression.");
                        }
                        case 62: {
                            this.c = pushbackReader.read();
                            if (this.c == 61) {
                                expression$Parser$Token = new Expression$Parser$Token(Expression$Parser$TokenType.BINARY_OPERATOR, (Object)Operator.GREATER_THAN_OR_EQUAL_TO);
                                break;
                            }
                            bl3 = false;
                            expression$Parser$Token = new Expression$Parser$Token(Expression$Parser$TokenType.BINARY_OPERATOR, (Object)Operator.GREATER_THAN);
                            break;
                        }
                        case 60: {
                            this.c = pushbackReader.read();
                            if (this.c == 61) {
                                expression$Parser$Token = new Expression$Parser$Token(Expression$Parser$TokenType.BINARY_OPERATOR, (Object)Operator.LESS_THAN_OR_EQUAL_TO);
                                break;
                            }
                            bl3 = false;
                            expression$Parser$Token = new Expression$Parser$Token(Expression$Parser$TokenType.BINARY_OPERATOR, (Object)Operator.LESS_THAN);
                            break;
                        }
                        case 38: {
                            this.c = pushbackReader.read();
                            if (this.c == 38) {
                                expression$Parser$Token = new Expression$Parser$Token(Expression$Parser$TokenType.BINARY_OPERATOR, (Object)Operator.AND);
                                break;
                            }
                            throw new IllegalArgumentException("Unexpected character in expression.");
                        }
                        case 124: {
                            this.c = pushbackReader.read();
                            if (this.c == 124) {
                                expression$Parser$Token = new Expression$Parser$Token(Expression$Parser$TokenType.BINARY_OPERATOR, (Object)Operator.OR);
                                break;
                            }
                            throw new IllegalArgumentException("Unexpected character in expression.");
                        }
                        case 41: {
                            expression$Parser$Token = new Expression$Parser$Token(Expression$Parser$TokenType.END_GROUP, null);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unexpected character in expression.");
                        }
                    }
                }
                if (bl3) {
                    this.c = pushbackReader.read();
                }
            }
            switch (expression$Parser$Token.type) {
                case LITERAL: 
                case VARIABLE: {
                    linkedList.add(expression$Parser$Token);
                    break;
                }
                case UNARY_OPERATOR: 
                case BINARY_OPERATOR: {
                    int n3 = ((Operator)((Object)expression$Parser$Token.value)).getPriority();
                    while (!linkedList2.isEmpty() && ((Expression$Parser$Token)linkedList2.peek()).type != Expression$Parser$TokenType.BEGIN_GROUP && ((Operator)((Object)((Expression$Parser$Token)linkedList2.peek()).value)).getPriority() >= n3 && ((Operator)((Object)((Expression$Parser$Token)linkedList2.peek()).value)).getPriority() != 6) {
                        linkedList.add((Expression$Parser$Token)linkedList2.pop());
                    }
                    linkedList2.push(expression$Parser$Token);
                    break;
                }
                case BEGIN_GROUP: {
                    linkedList2.push(expression$Parser$Token);
                    break;
                }
                case END_GROUP: {
                    Expression$Parser$Token expression$Parser$Token2 = (Expression$Parser$Token)linkedList2.pop();
                    while (expression$Parser$Token2.type != Expression$Parser$TokenType.BEGIN_GROUP) {
                        linkedList.add(expression$Parser$Token2);
                        expression$Parser$Token2 = (Expression$Parser$Token)linkedList2.pop();
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            bl2 = expression$Parser$Token.type != Expression$Parser$TokenType.LITERAL && expression$Parser$Token.type != Expression$Parser$TokenType.VARIABLE && expression$Parser$Token.type != Expression$Parser$TokenType.END_GROUP;
        }
        while (!linkedList2.isEmpty()) {
            linkedList.add((Expression$Parser$Token)linkedList2.pop());
        }
        return linkedList;
    }

    private boolean readKeyword(PushbackReader pushbackReader, String string) {
        boolean bl2;
        int n2;
        int n3 = string.length();
        for (n2 = 0; this.c != -1 && n2 < n3; ++n2) {
            this.pushbackBuffer[n2] = (char)this.c;
            if (string.charAt(n2) != this.c) break;
            this.c = pushbackReader.read();
        }
        if (n2 < n3) {
            pushbackReader.unread(this.pushbackBuffer, 0, n2 + 1);
            bl2 = false;
        } else {
            bl2 = true;
        }
        return bl2;
    }
}

