/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.fxml.builder;

import com.sun.javafx.fxml.BeanAdapter;
import com.sun.javafx.fxml.builder.ProxyBuilder$AnnotationValue;
import com.sun.javafx.fxml.builder.ProxyBuilder$ArrayListWrapper;
import com.sun.javafx.fxml.builder.ProxyBuilder$Getter;
import com.sun.javafx.fxml.builder.ProxyBuilder$Property;
import com.sun.javafx.fxml.builder.ProxyBuilder$Setter;
import com.sun.javafx.reflect.ConstructorUtil;
import com.sun.javafx.reflect.ReflectUtil;
import dev.protect.pw;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ProxyBuilder<T>
extends AbstractMap<String, Object> {
    private Class<?> type;
    private final Map<Constructor, Map<String, ProxyBuilder$AnnotationValue>> constructorsMap;
    private final Map<String, ProxyBuilder$Property> propertiesMap;
    private final Set<Constructor> constructors;
    private Set<String> propertyNames;
    private boolean hasDefaultConstructor = false;
    private Constructor defaultConstructor;
    private static final String SETTER_PREFIX = "set";
    private static final String GETTER_PREFIX = "get";
    private final Comparator<Constructor> constructorComparator = (constructor, constructor2) -> {
        int n2 = constructor.getParameterCount();
        int n3 = constructor2.getParameterCount();
        int n4 = Math.min(n2, n3);
        for (int i2 = 0; i2 < n4; ++i2) {
            Class<?> clazz;
            Class<?> clazz2 = constructor.getParameterTypes()[i2];
            if (clazz2.equals(clazz = constructor2.getParameterTypes()[i2])) continue;
            if (clazz2.equals(Integer.TYPE) && clazz.equals(Double.TYPE)) {
                return -1;
            }
            if (clazz2.equals(Double.TYPE) && clazz.equals(Integer.TYPE)) {
                return 1;
            }
            return clazz2.getCanonicalName().compareTo(clazz.getCanonicalName());
        }
        return n2 - n3;
    };
    private final Map<String, Object> userValues = new HashMap<String, Object>();
    private final Map<String, Object> containers = new HashMap<String, Object>();
    private static final Map<Class<?>, Object> DEFAULTS_MAP = new HashMap(9);

    public ProxyBuilder(Class<?> clazz) {
        Constructor<?>[] constructorArray;
        this.type = clazz;
        this.constructorsMap = new HashMap<Constructor, Map<String, ProxyBuilder$AnnotationValue>>();
        for (Constructor<?> constructor3 : constructorArray = ConstructorUtil.getConstructors(this.type)) {
            Class<?>[] classArray = constructor3.getParameterTypes();
            Annotation[][] annotationArray = constructor3.getParameterAnnotations();
            if (classArray.length == 0) {
                this.hasDefaultConstructor = true;
                this.defaultConstructor = constructor3;
                continue;
            }
            int n2 = 0;
            boolean bl2 = true;
            LinkedHashMap<String, ProxyBuilder$AnnotationValue> linkedHashMap = new LinkedHashMap<String, ProxyBuilder$AnnotationValue>();
            for (Class<?> clazz2 : classArray) {
                pw pw2 = null;
                for (Annotation annotation : annotationArray[n2]) {
                    if (!(annotation instanceof pw)) continue;
                    pw2 = (pw)annotation;
                    break;
                }
                if (pw2 == null) {
                    bl2 = false;
                    break;
                }
                ProxyBuilder$AnnotationValue proxyBuilder$AnnotationValue = new ProxyBuilder$AnnotationValue(pw2.value(), pw2.af(), clazz2);
                linkedHashMap.put(pw2.value(), proxyBuilder$AnnotationValue);
                ++n2;
            }
            if (!bl2) continue;
            this.constructorsMap.put(constructor3, linkedHashMap);
        }
        if (!this.hasDefaultConstructor && this.constructorsMap.isEmpty()) {
            throw new RuntimeException("Cannot create instance of " + this.type.getCanonicalName() + " the constructor is not properly annotated.");
        }
        this.constructors = new TreeSet<Constructor>(this.constructorComparator);
        this.constructors.addAll(this.constructorsMap.keySet());
        this.propertiesMap = this.scanForSetters();
    }

    @Override
    public Object put(String string, Object object) {
        this.userValues.put(string, object);
        return null;
    }

    private Object getTemporaryContainer(String string) {
        Object object = this.containers.get(string);
        if (object == null && (object = this.getReadOnlyProperty(string)) != null) {
            this.containers.put(string, object);
        }
        return object;
    }

    private Object getReadOnlyProperty(String string) {
        return new ProxyBuilder$ArrayListWrapper();
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.getTemporaryContainer(object.toString()) != null;
    }

    @Override
    public boolean containsValue(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object get(Object object) {
        return this.getTemporaryContainer(object.toString());
    }

    public T build() {
        Set<Object> set;
        Object object2 = null;
        for (Map.Entry<String, Object> object3 : this.containers.entrySet()) {
            this.put(object3.getKey(), object3.getValue());
        }
        this.propertyNames = this.userValues.keySet();
        for (Constructor constructor : this.constructors) {
            set = this.getArgumentNames(constructor);
            if (!this.propertyNames.equals(set) || (object2 = this.createObjectWithExactArguments(constructor, set)) == null) continue;
            return (T)object2;
        }
        Set<String> set2 = this.propertiesMap.keySet();
        if (set2.containsAll(this.propertyNames) && this.hasDefaultConstructor && (object2 = this.createObjectFromDefaultConstructor()) != null) {
            return (T)object2;
        }
        HashSet<String> hashSet = new HashSet<String>(this.propertyNames);
        hashSet.retainAll(set2);
        set = this.chooseBestConstructors(set2);
        for (Constructor constructor : set) {
            object2 = this.createObjectFromConstructor(constructor, hashSet);
            if (object2 == null) continue;
            return (T)object2;
        }
        if (object2 == null) {
            throw new RuntimeException("Cannot create instance of " + this.type.getCanonicalName() + " with given set of properties: " + this.userValues.keySet().toString());
        }
        return (T)object2;
    }

    private Set<Constructor> chooseBestConstructors(Set<String> set) {
        HashSet<String> hashSet = new HashSet<String>(this.propertyNames);
        hashSet.removeAll(set);
        HashSet<String> hashSet2 = new HashSet<String>(this.propertyNames);
        hashSet2.retainAll(set);
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MAX_VALUE;
        TreeSet<Constructor> treeSet = new TreeSet<Constructor>(this.constructorComparator);
        Set set2 = null;
        for (Constructor constructor : this.constructors) {
            Set<String> set3 = this.getArgumentNames(constructor);
            if (!set3.containsAll(hashSet)) continue;
            HashSet<String> hashSet3 = new HashSet<String>(set3);
            hashSet3.removeAll(this.propertyNames);
            HashSet<String> hashSet4 = new HashSet<String>(hashSet2);
            hashSet4.removeAll(set3);
            int n4 = hashSet3.size();
            if (n2 == n4 && n3 == hashSet4.size()) {
                treeSet.add(constructor);
            }
            if (n2 <= n4 && (n2 != n4 || n3 <= hashSet4.size())) continue;
            n2 = n4;
            n3 = hashSet4.size();
            treeSet.clear();
            treeSet.add(constructor);
        }
        if (set2 != null && !set2.isEmpty()) {
            throw new RuntimeException("Cannot create instance of " + this.type.getCanonicalName() + " no constructor contains all properties specified in FXML.");
        }
        return treeSet;
    }

    private Set<String> getArgumentNames(Constructor constructor) {
        Map<String, ProxyBuilder$AnnotationValue> map = this.constructorsMap.get(constructor);
        Set<String> set = null;
        if (map != null) {
            set = map.keySet();
        }
        return set;
    }

    private Object createObjectFromDefaultConstructor() {
        Object object = null;
        try {
            object = this.createInstance(this.defaultConstructor, new Object[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        for (String string : this.propertyNames) {
            try {
                ProxyBuilder$Property proxyBuilder$Property = this.propertiesMap.get(string);
                proxyBuilder$Property.invoke(object, this.getUserValue(string, proxyBuilder$Property.getType()));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return object;
    }

    private Object createObjectFromConstructor(Constructor constructor, Set<String> set) {
        Object object;
        Object object2 = null;
        Map<String, ProxyBuilder$AnnotationValue> map = this.constructorsMap.get(constructor);
        Object[] objectArray = new Object[map.size()];
        int n2 = 0;
        HashSet<String> hashSet = new HashSet<String>(set);
        for (ProxyBuilder$AnnotationValue object3 : map.values()) {
            object = this.getUserValue(object3.getName(), object3.getType());
            if (object != null) {
                try {
                    objectArray[n2] = BeanAdapter.coerce(object, object3.getType());
                }
                catch (Exception exception) {
                    return null;
                }
            } else if (!object3.getDefaultValue().isEmpty()) {
                try {
                    objectArray[n2] = BeanAdapter.coerce(object3.getDefaultValue(), object3.getType());
                }
                catch (Exception exception) {
                    return null;
                }
            } else {
                objectArray[n2] = ProxyBuilder.getDefaultValue(object3.getType());
            }
            hashSet.remove(object3.getName());
            ++n2;
        }
        try {
            object2 = this.createInstance(constructor, objectArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (object2 != null) {
            for (String string : hashSet) {
                try {
                    object = this.propertiesMap.get(string);
                    ((ProxyBuilder$Property)object).invoke(object2, this.getUserValue(string, ((ProxyBuilder$Property)object).getType()));
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }
        return object2;
    }

    private Object getUserValue(String string, Class<?> clazz) {
        Object object = this.userValues.get(string);
        if (object == null) {
            return null;
        }
        if (clazz.isAssignableFrom(object.getClass())) {
            return object;
        }
        if (clazz.isArray()) {
            try {
                return ProxyBuilder.convertListToArray(object, clazz);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        if (ProxyBuilder$ArrayListWrapper.class.equals(object.getClass())) {
            List list = (List)object;
            return list.get(0);
        }
        return object;
    }

    private Object createObjectWithExactArguments(Constructor constructor, Set<String> set) {
        Object object = null;
        Object[] objectArray = new Object[set.size()];
        Map<String, ProxyBuilder$AnnotationValue> map = this.constructorsMap.get(constructor);
        int n2 = 0;
        for (String string : set) {
            Class<?> clazz = map.get(string).getType();
            Object object2 = this.getUserValue(string, clazz);
            try {
                objectArray[n2++] = BeanAdapter.coerce(object2, clazz);
            }
            catch (Exception exception) {
                return null;
            }
        }
        try {
            object = this.createInstance(constructor, objectArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    private Object createInstance(Constructor constructor, Object[] objectArray) {
        Object var3_3 = null;
        ReflectUtil.checkPackageAccess(this.type);
        var3_3 = constructor.newInstance(objectArray);
        return var3_3;
    }

    private Map<String, ProxyBuilder$Property> scanForSetters() {
        HashMap<String, ProxyBuilder$Property> hashMap = new HashMap<String, ProxyBuilder$Property>();
        HashMap<String, LinkedList<Method>> hashMap2 = ProxyBuilder.getClassMethodCache(this.type);
        for (String string : hashMap2.keySet()) {
            Class<?>[] classArray;
            Class<?> clazz;
            List list;
            Object object;
            if (string.startsWith(SETTER_PREFIX) && string.length() > SETTER_PREFIX.length()) {
                object = string.substring(SETTER_PREFIX.length());
                object = Character.toLowerCase(((String)object).charAt(0)) + ((String)object).substring(1);
                list = (List)hashMap2.get(string);
                for (Method method : list) {
                    clazz = method.getReturnType();
                    classArray = method.getParameterTypes();
                    if (!clazz.equals(Void.TYPE) || classArray.length != 1) continue;
                    hashMap.put((String)object, new ProxyBuilder$Setter(method, classArray[0]));
                }
            }
            if (!string.startsWith(GETTER_PREFIX) || string.length() <= GETTER_PREFIX.length()) continue;
            object = string.substring(GETTER_PREFIX.length());
            object = Character.toLowerCase(((String)object).charAt(0)) + ((String)object).substring(1);
            list = (List)hashMap2.get(string);
            for (Method method : list) {
                clazz = method.getReturnType();
                classArray = method.getParameterTypes();
                if (!Collection.class.isAssignableFrom(clazz) || classArray.length != 0) continue;
                hashMap.put((String)object, new ProxyBuilder$Getter(method, clazz));
            }
        }
        return hashMap;
    }

    private static HashMap<String, LinkedList<Method>> getClassMethodCache(Class<?> clazz) {
        Method[] methodArray;
        HashMap<String, LinkedList<Method>> hashMap = new HashMap<String, LinkedList<Method>>();
        ReflectUtil.checkPackageAccess(clazz);
        for (Method method : methodArray = clazz.getMethods()) {
            int n2 = method.getModifiers();
            if (!Modifier.isPublic(n2) || Modifier.isStatic(n2)) continue;
            String string = method.getName();
            LinkedList<Method> linkedList = hashMap.get(string);
            if (linkedList == null) {
                linkedList = new LinkedList();
                hashMap.put(string, linkedList);
            }
            linkedList.add(method);
        }
        return hashMap;
    }

    private static Object[] convertListToArray(Object object, Class<?> clazz) {
        Class<?> clazz2 = clazz.getComponentType();
        List list = BeanAdapter.coerce(object, List.class);
        return list.toArray((Object[])Array.newInstance(clazz2, 0));
    }

    private static Object getDefaultValue(Class clazz) {
        return DEFAULTS_MAP.get(clazz);
    }

    static {
        DEFAULTS_MAP.put(Byte.TYPE, (byte)0);
        DEFAULTS_MAP.put(Short.TYPE, (short)0);
        DEFAULTS_MAP.put(Integer.TYPE, 0);
        DEFAULTS_MAP.put(Long.TYPE, 0L);
        DEFAULTS_MAP.put(Float.TYPE, Float.valueOf(0.0f));
        DEFAULTS_MAP.put(Double.TYPE, 0.0);
        DEFAULTS_MAP.put(Character.TYPE, Character.valueOf('\u0000'));
        DEFAULTS_MAP.put(Boolean.TYPE, false);
        DEFAULTS_MAP.put(Object.class, null);
    }
}

