/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font;

import com.sun.javafx.font.FontFileReader;
import com.sun.javafx.font.FontFileReader$Buffer;
import com.sun.javafx.font.FontFileWriter;
import com.sun.javafx.font.WoffDecoder$WoffDirectoryEntry;
import com.sun.javafx.font.WoffDecoder$WoffHeader;
import java.util.Arrays;
import java.util.zip.Inflater;

class WoffDecoder
extends FontFileWriter {
    WoffDecoder$WoffHeader woffHeader;
    WoffDecoder$WoffDirectoryEntry[] woffTableDirectory;

    public void decode(FontFileReader fontFileReader) {
        fontFileReader.reset();
        this.initWoffTables(fontFileReader);
        if (this.woffHeader == null || this.woffTableDirectory == null) {
            throw new Exception("WoffDecoder: failure reading header");
        }
        int n2 = this.woffHeader.flavor;
        if (n2 != 65536 && n2 != 1953658213 && n2 != 0x4F54544F) {
            throw new Exception("WoffDecoder: invalid flavor");
        }
        short s2 = this.woffHeader.numTables;
        this.setLength(this.woffHeader.totalSfntSize);
        this.writeHeader(n2, s2);
        Arrays.sort(this.woffTableDirectory, (woffDecoder$WoffDirectoryEntry, woffDecoder$WoffDirectoryEntry2) -> woffDecoder$WoffDirectoryEntry.offset - woffDecoder$WoffDirectoryEntry2.offset);
        Inflater inflater = new Inflater();
        int n3 = 12 + s2 * 16;
        for (int i2 = 0; i2 < this.woffTableDirectory.length; ++i2) {
            WoffDecoder$WoffDirectoryEntry woffDecoder$WoffDirectoryEntry3 = this.woffTableDirectory[i2];
            this.writeDirectoryEntry(woffDecoder$WoffDirectoryEntry3.index, woffDecoder$WoffDirectoryEntry3.tag, woffDecoder$WoffDirectoryEntry3.origChecksum, n3, woffDecoder$WoffDirectoryEntry3.origLength);
            FontFileReader$Buffer fontFileReader$Buffer = fontFileReader.readBlock(woffDecoder$WoffDirectoryEntry3.offset, woffDecoder$WoffDirectoryEntry3.comLength);
            byte[] byArray = new byte[woffDecoder$WoffDirectoryEntry3.comLength];
            fontFileReader$Buffer.get(0, byArray, 0, woffDecoder$WoffDirectoryEntry3.comLength);
            if (woffDecoder$WoffDirectoryEntry3.comLength != woffDecoder$WoffDirectoryEntry3.origLength) {
                inflater.setInput(byArray);
                byte[] byArray2 = new byte[woffDecoder$WoffDirectoryEntry3.origLength];
                int n4 = inflater.inflate(byArray2);
                if (n4 != woffDecoder$WoffDirectoryEntry3.origLength) {
                    throw new Exception("WoffDecoder: failure expanding table");
                }
                inflater.reset();
                byArray = byArray2;
            }
            this.seek(n3);
            this.writeBytes(byArray);
            n3 += woffDecoder$WoffDirectoryEntry3.origLength + 3 & 0xFFFFFFFC;
        }
        inflater.end();
    }

    void initWoffTables(FontFileReader fontFileReader) {
        long l2 = fontFileReader.getLength();
        if (l2 < 44L) {
            throw new Exception("WoffDecoder: invalid filesize");
        }
        FontFileReader$Buffer fontFileReader$Buffer = fontFileReader.readBlock(0, 44);
        WoffDecoder$WoffHeader woffDecoder$WoffHeader = new WoffDecoder$WoffHeader(fontFileReader$Buffer);
        int n2 = woffDecoder$WoffHeader.numTables;
        if (woffDecoder$WoffHeader.signature != 2001684038) {
            throw new Exception("WoffDecoder: invalid signature");
        }
        if (woffDecoder$WoffHeader.reserved != 0) {
            throw new Exception("WoffDecoder: invalid reserved != 0");
        }
        if (l2 < (long)(44 + n2 * 20)) {
            throw new Exception("WoffDecoder: invalid filesize");
        }
        WoffDecoder$WoffDirectoryEntry[] woffDecoder$WoffDirectoryEntryArray = new WoffDecoder$WoffDirectoryEntry[n2];
        int n3 = 44 + n2 * 20;
        int n4 = 12 + n2 * 16;
        fontFileReader$Buffer = fontFileReader.readBlock(44, n2 * 20);
        int n5 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            WoffDecoder$WoffDirectoryEntry woffDecoder$WoffDirectoryEntry;
            woffDecoder$WoffDirectoryEntryArray[i2] = woffDecoder$WoffDirectoryEntry = new WoffDecoder$WoffDirectoryEntry(fontFileReader$Buffer, i2);
            if (woffDecoder$WoffDirectoryEntry.tag <= n5) {
                throw new Exception("WoffDecoder: table directory not ordered by tag");
            }
            int n6 = woffDecoder$WoffDirectoryEntry.offset;
            int n7 = woffDecoder$WoffDirectoryEntry.offset + woffDecoder$WoffDirectoryEntry.comLength;
            if (n3 > n6 || (long)n6 > l2) {
                throw new Exception("WoffDecoder: invalid table offset");
            }
            if (n6 > n7 || (long)n7 > l2) {
                throw new Exception("WoffDecoder: invalid table offset");
            }
            if (woffDecoder$WoffDirectoryEntry.comLength > woffDecoder$WoffDirectoryEntry.origLength) {
                throw new Exception("WoffDecoder: invalid compressed length");
            }
            if ((n4 += woffDecoder$WoffDirectoryEntry.origLength + 3 & 0xFFFFFFFC) <= woffDecoder$WoffHeader.totalSfntSize) continue;
            throw new Exception("WoffDecoder: invalid totalSfntSize");
        }
        if (n4 != woffDecoder$WoffHeader.totalSfntSize) {
            throw new Exception("WoffDecoder: invalid totalSfntSize");
        }
        this.woffHeader = woffDecoder$WoffHeader;
        this.woffTableDirectory = woffDecoder$WoffDirectoryEntryArray;
    }
}

