/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font;

import com.sun.javafx.font.FontFactory;
import com.sun.javafx.font.Metrics;
import com.sun.javafx.font.PGFont;
import com.sun.javafx.font.PrismFontFactory;
import com.sun.javafx.font.PrismFontUtils;
import com.sun.javafx.scene.text.FontHelper;
import com.sun.javafx.tk.FontLoader;
import com.sun.javafx.tk.FontMetrics;
import dev.protect.XZ;
import dev.protect.Yb;
import dev.protect.Yd;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public class PrismFontLoader
extends FontLoader {
    private static PrismFontLoader theInstance = new PrismFontLoader();
    private boolean embeddedFontsLoaded = false;
    FontFactory installedFontFactory = null;

    public static PrismFontLoader getInstance() {
        return theInstance;
    }

    Properties loadEmbeddedFontDefinitions() {
        Properties properties = new Properties();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            return properties;
        }
        URL uRL = classLoader.getResource("META-INF/fonts.mf");
        if (uRL == null) {
            return properties;
        }
        try (InputStream inputStream = uRL.openStream();){
            properties.load(inputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return properties;
    }

    private void loadEmbeddedFonts() {
        if (!this.embeddedFontsLoaded) {
            FontFactory fontFactory = this.getFontFactoryFromPipeline();
            if (!fontFactory.hasPermission()) {
                this.embeddedFontsLoaded = true;
                return;
            }
            Properties properties = this.loadEmbeddedFontDefinitions();
            Enumeration<Object> enumeration = properties.keys();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                if (!string2.startsWith("/")) continue;
                string2 = string2.substring(1);
                try {
                    InputStream inputStream = classLoader.getResourceAsStream(string2);
                    try {
                        fontFactory.loadEmbeddedFont(string, inputStream, 0.0f, true, false);
                    }
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
                catch (Exception exception) {}
            }
            this.embeddedFontsLoaded = true;
        }
    }

    private XZ[] createFonts(PGFont[] pGFontArray) {
        if (pGFontArray == null || pGFontArray.length == 0) {
            return null;
        }
        XZ[] xZArray = new XZ[pGFontArray.length];
        for (int i2 = 0; i2 < pGFontArray.length; ++i2) {
            xZArray[i2] = this.createFont(pGFontArray[i2]);
        }
        return xZArray;
    }

    @Override
    public XZ[] loadFont(InputStream inputStream, double d2, boolean bl2) {
        FontFactory fontFactory = this.getFontFactoryFromPipeline();
        PGFont[] pGFontArray = fontFactory.loadEmbeddedFont(null, inputStream, (float)d2, true, bl2);
        return this.createFonts(pGFontArray);
    }

    @Override
    public XZ[] loadFont(String string, double d2, boolean bl2) {
        FontFactory fontFactory = this.getFontFactoryFromPipeline();
        PGFont[] pGFontArray = fontFactory.loadEmbeddedFont(null, string, (float)d2, true, bl2);
        return this.createFonts(pGFontArray);
    }

    private XZ createFont(PGFont pGFont) {
        return FontHelper.nativeFont(pGFont, pGFont.getName(), pGFont.getFamilyName(), pGFont.getStyleName(), pGFont.getSize());
    }

    @Override
    public List<String> getFamilies() {
        this.loadEmbeddedFonts();
        return Arrays.asList(this.getFontFactoryFromPipeline().getFontFamilyNames());
    }

    @Override
    public List<String> getFontNames() {
        this.loadEmbeddedFonts();
        return Arrays.asList(this.getFontFactoryFromPipeline().getFontFullNames());
    }

    @Override
    public List<String> getFontNames(String string) {
        this.loadEmbeddedFonts();
        return Arrays.asList(this.getFontFactoryFromPipeline().getFontFullNames(string));
    }

    @Override
    public XZ font(String string, Yd yd2, Yb yb2, float f2) {
        FontFactory fontFactory = this.getFontFactoryFromPipeline();
        if (!this.embeddedFontsLoaded && !fontFactory.isPlatformFont(string)) {
            this.loadEmbeddedFonts();
        }
        boolean bl2 = yd2 != null && yd2.ordinal() >= Yd.f.ordinal();
        boolean bl3 = yb2 == Yb.a;
        PGFont pGFont = fontFactory.createFont(string, bl2, bl3, f2);
        XZ xZ2 = FontHelper.nativeFont(pGFont, pGFont.getName(), pGFont.getFamilyName(), pGFont.getStyleName(), f2);
        return xZ2;
    }

    @Override
    public void loadFont(XZ xZ2) {
        FontFactory fontFactory = this.getFontFactoryFromPipeline();
        String string = xZ2.aD();
        if (!this.embeddedFontsLoaded && !fontFactory.isPlatformFont(string)) {
            this.loadEmbeddedFonts();
        }
        PGFont pGFont = fontFactory.createFont(string, (float)xZ2.gc());
        String string2 = pGFont.getName();
        String string3 = pGFont.getFamilyName();
        String string4 = pGFont.getStyleName();
        FontHelper.setNativeFont(xZ2, pGFont, string2, string3, string4);
    }

    @Override
    public FontMetrics getFontMetrics(XZ xZ2) {
        if (xZ2 != null) {
            PGFont pGFont = (PGFont)FontHelper.getNativeFont(xZ2);
            Metrics metrics = PrismFontUtils.getFontMetrics(pGFont);
            float f2 = -metrics.getAscent();
            float f3 = -metrics.getAscent();
            float f4 = metrics.getXHeight();
            float f5 = metrics.getDescent();
            float f6 = metrics.getDescent();
            float f7 = metrics.getLineGap();
            return FontMetrics.createFontMetrics(f2, f3, f4, f5, f6, f7, xZ2);
        }
        return null;
    }

    @Override
    public float getCharWidth(char c2, XZ xZ2) {
        PGFont pGFont = (PGFont)FontHelper.getNativeFont(xZ2);
        return (float)PrismFontUtils.getCharWidth(pGFont, c2);
    }

    @Override
    public float getSystemFontSize() {
        return PrismFontFactory.getSystemFontSize();
    }

    private FontFactory getFontFactoryFromPipeline() {
        if (this.installedFontFactory != null) {
            return this.installedFontFactory;
        }
        try {
            Class<?> clazz = Class.forName("com.sun.prism.GraphicsPipeline");
            Method method = clazz.getMethod("getPipeline", null);
            Object object = method.invoke(null, new Object[0]);
            Method method2 = clazz.getMethod("getFontFactory", null);
            Object object2 = method2.invoke(object, new Object[0]);
            this.installedFontFactory = (FontFactory)object2;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.installedFontFactory;
    }
}

