/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font;

import com.sun.javafx.font.FontConfigManager$EmbeddedFontSupport;
import com.sun.javafx.font.FontConfigManager$FcCompFont;
import com.sun.javafx.font.FontConfigManager$FontConfigFont;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

class FontConfigManager {
    static boolean debugFonts = false;
    static boolean useFontConfig = true;
    static boolean fontConfigFailed = false;
    static boolean useEmbeddedFontSupport = false;
    private static final String[] fontConfigNames;
    private static FontConfigManager$FcCompFont[] fontConfigFonts;
    private static String defaultFontFile;

    private FontConfigManager() {
    }

    private static String[] getFontConfigNames() {
        return fontConfigNames;
    }

    private static String getFCLocaleStr() {
        Locale locale = Locale.getDefault();
        Object object = locale.getLanguage();
        String string = locale.getCountry();
        if (!string.equals("")) {
            object = (String)object + "-" + string;
        }
        return object;
    }

    private static native boolean getFontConfig(String var0, FontConfigManager$FcCompFont[] var1, boolean var2);

    private static synchronized void initFontConfigLogFonts() {
        int n2;
        int n3;
        if (fontConfigFonts != null || fontConfigFailed) {
            return;
        }
        long l2 = 0L;
        if (debugFonts) {
            l2 = System.nanoTime();
        }
        String[] stringArray = FontConfigManager.getFontConfigNames();
        FontConfigManager$FcCompFont[] fontConfigManager$FcCompFontArray = new FontConfigManager$FcCompFont[stringArray.length];
        for (n3 = 0; n3 < fontConfigManager$FcCompFontArray.length; ++n3) {
            fontConfigManager$FcCompFontArray[n3] = new FontConfigManager$FcCompFont();
            fontConfigManager$FcCompFontArray[n3].fcName = stringArray[n3];
            int n4 = fontConfigManager$FcCompFontArray[n3].fcName.indexOf(58);
            fontConfigManager$FcCompFontArray[n3].fcFamily = fontConfigManager$FcCompFontArray[n3].fcName.substring(0, n4);
            fontConfigManager$FcCompFontArray[n3].style = n3 % 4;
        }
        n3 = 0;
        if (useFontConfig) {
            n3 = FontConfigManager.getFontConfig(FontConfigManager.getFCLocaleStr(), fontConfigManager$FcCompFontArray, true) ? 1 : 0;
        } else if (debugFonts) {
            System.err.println("Not using FontConfig");
        }
        if (useEmbeddedFontSupport || n3 == 0) {
            FontConfigManager$EmbeddedFontSupport.initLogicalFonts(fontConfigManager$FcCompFontArray);
        }
        FontConfigManager$FontConfigFont fontConfigManager$FontConfigFont = null;
        for (n2 = 0; n2 < fontConfigManager$FcCompFontArray.length; ++n2) {
            FontConfigManager$FcCompFont fontConfigManager$FcCompFont = fontConfigManager$FcCompFontArray[n2];
            if (fontConfigManager$FcCompFont.firstFont == null) {
                if (debugFonts) {
                    System.err.println("Fontconfig returned no font for " + fontConfigManager$FcCompFontArray[n2].fcName);
                }
                fontConfigFailed = true;
                continue;
            }
            if (fontConfigManager$FontConfigFont != null) continue;
            fontConfigManager$FontConfigFont = fontConfigManager$FcCompFont.firstFont;
            defaultFontFile = fontConfigManager$FontConfigFont.fontFile;
        }
        if (fontConfigManager$FontConfigFont == null) {
            fontConfigFailed = true;
            System.err.println("Error: JavaFX detected no fonts! Please refer to release notes for proper font configuration");
            return;
        }
        if (fontConfigFailed) {
            for (n2 = 0; n2 < fontConfigManager$FcCompFontArray.length; ++n2) {
                if (fontConfigManager$FcCompFontArray[n2].firstFont != null) continue;
                fontConfigManager$FcCompFontArray[n2].firstFont = fontConfigManager$FontConfigFont;
            }
        }
        fontConfigFonts = fontConfigManager$FcCompFontArray;
        if (debugFonts) {
            long l3 = System.nanoTime();
            System.err.println("Time spent accessing fontconfig=" + (l3 - l2) / 1000000L + "ms.");
            for (int i2 = 0; i2 < fontConfigFonts.length; ++i2) {
                FontConfigManager$FcCompFont fontConfigManager$FcCompFont = fontConfigFonts[i2];
                System.err.println("FC font " + fontConfigManager$FcCompFont.fcName + " maps to " + fontConfigManager$FcCompFont.firstFont.fullName + " in file " + fontConfigManager$FcCompFont.firstFont.fontFile);
                if (fontConfigManager$FcCompFont.allFonts == null) continue;
                for (int i3 = 0; i3 < fontConfigManager$FcCompFont.allFonts.length; ++i3) {
                    FontConfigManager$FontConfigFont fontConfigManager$FontConfigFont2 = fontConfigManager$FcCompFont.allFonts[i3];
                    System.err.println(" " + i3 + ") Family=" + fontConfigManager$FontConfigFont2.familyName + ", Style=" + fontConfigManager$FontConfigFont2.styleStr + ", Fullname=" + fontConfigManager$FontConfigFont2.fullName + ", File=" + fontConfigManager$FontConfigFont2.fontFile);
                }
            }
        }
    }

    private static native boolean populateMapsNative(HashMap<String, String> var0, HashMap<String, String> var1, HashMap<String, ArrayList<String>> var2, Locale var3);

    public static void populateMaps(HashMap<String, String> hashMap, HashMap<String, String> hashMap2, HashMap<String, ArrayList<String>> hashMap3, Locale locale) {
        boolean bl2 = false;
        if (useFontConfig && !fontConfigFailed) {
            bl2 = FontConfigManager.populateMapsNative(hashMap, hashMap2, hashMap3, locale);
        }
        if (fontConfigFailed || useEmbeddedFontSupport || !bl2) {
            FontConfigManager$EmbeddedFontSupport.populateMaps(hashMap, hashMap2, hashMap3, locale);
        }
    }

    private static String mapFxToFcLogicalFamilyName(String string) {
        if (string.equals("serif")) {
            return "serif";
        }
        if (string.equals("monospaced")) {
            return "monospace";
        }
        return "sans";
    }

    public static FontConfigManager$FcCompFont getFontConfigFont(String string, boolean bl2, boolean bl3) {
        int n2;
        FontConfigManager.initFontConfigLogFonts();
        if (fontConfigFonts == null) {
            return null;
        }
        String string2 = FontConfigManager.mapFxToFcLogicalFamilyName(string.toLowerCase());
        int n3 = n2 = bl2 ? 1 : 0;
        if (bl3) {
            n2 += 2;
        }
        FontConfigManager$FcCompFont fontConfigManager$FcCompFont = null;
        for (int i2 = 0; i2 < fontConfigFonts.length; ++i2) {
            if (!string2.equals(FontConfigManager.fontConfigFonts[i2].fcFamily) || n2 != FontConfigManager.fontConfigFonts[i2].style) continue;
            fontConfigManager$FcCompFont = fontConfigFonts[i2];
            break;
        }
        if (fontConfigManager$FcCompFont == null) {
            fontConfigManager$FcCompFont = fontConfigFonts[0];
        }
        if (debugFonts) {
            System.err.println("FC name=" + string2 + " style=" + n2 + " uses " + fontConfigManager$FcCompFont.firstFont.fullName + " in file: " + fontConfigManager$FcCompFont.firstFont.fontFile);
        }
        return fontConfigManager$FcCompFont;
    }

    public static String getDefaultFontPath() {
        if (fontConfigFonts == null && !fontConfigFailed) {
            FontConfigManager.getFontConfigFont("System", false, false);
        }
        return defaultFontFile;
    }

    public static ArrayList<String> getFileNames(FontConfigManager$FcCompFont fontConfigManager$FcCompFont, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (fontConfigManager$FcCompFont.allFonts != null) {
            int n2;
            for (int i2 = n2 = bl2 ? 1 : 0; i2 < fontConfigManager$FcCompFont.allFonts.length; ++i2) {
                arrayList.add(fontConfigManager$FcCompFont.allFonts[i2].fontFile);
            }
        }
        return arrayList;
    }

    public static ArrayList<String> getFontNames(FontConfigManager$FcCompFont fontConfigManager$FcCompFont, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (fontConfigManager$FcCompFont.allFonts != null) {
            int n2;
            for (int i2 = n2 = bl2 ? 1 : 0; i2 < fontConfigManager$FcCompFont.allFonts.length; ++i2) {
                arrayList.add(fontConfigManager$FcCompFont.allFonts[i2].fullName);
            }
        }
        return arrayList;
    }

    static {
        Void void_ = AccessController.doPrivileged(() -> {
            String string = System.getProperty("prism.debugfonts", "");
            debugFonts = "true".equals(string);
            String string2 = System.getProperty("prism.useFontConfig", "true");
            useFontConfig = "true".equals(string2);
            String string3 = System.getProperty("prism.embeddedfonts", "");
            useEmbeddedFontSupport = "true".equals(string3);
            return null;
        });
        fontConfigNames = new String[]{"sans:regular:roman", "sans:bold:roman", "sans:regular:italic", "sans:bold:italic", "serif:regular:roman", "serif:bold:roman", "serif:regular:italic", "serif:bold:italic", "monospace:regular:roman", "monospace:bold:roman", "monospace:regular:italic", "monospace:bold:italic"};
    }
}

